# 设计一个评论系统


如果一个公司规模比较大的话，或者，有多个产品都需要评论功能，可以设计一个评论中台系统，给各个业务线提供能力。


> 评论系统中台能力建设，可以对接不同业务的评论模块，业务接入以appId为唯一标识，进行数据隔离区分；

并且将appId全部配置化，业务接入通过简单的配置申请就可接入评论中台，接口实现有rpc和http两种方式；


## 详细结构图

![](https://oscimg.oschina.net/oscnet/up-3e80041072b992ec56521f17f521f98e0d4.png)



## 评论发布的时序图


> **评论要经过审核流程才可以发布状态**


![](https://oscimg.oschina.net/oscnet/up-103290758f483ec0f41f593f6bf2a9b9516.png)


## 评论相关的功能点


- 点赞/点踩
- 加精
- 发布/上下架
- 置顶/置底
- 被回复
- 支持图片/视频评论
- 检索
- 关评 （业务关评/评论关评，评论中台只需要关注评论关评就可以，至于业务关评，由具体的业务系统决定）
- 投诉
- 审核
- 屏蔽


## 表结构设计

评论相关表主要设计思路以appId进行**分表**处理

> **这里需要注意的一点，需要预估评论的数量，做好大数据量分库分表的设计。**

例如内容评论表：comment_content, 活动评论表：comment_activity;

共有信息表公用同一个张表；

### 评论主表

```java

1	id	自增id	
2	appId	业务id	
3	commentId	评论Id	接入ID生成器
4	moduleType	模块类别	用户自定义，appId下面的子模块
5	contentId	内容/活动Id	
6	userId	评论用户Id	
7	commentInfo	评论内容	
8	status	评论状态	
9	parentId	父级评论Id	
10	rootId	一级评论Id	
11	replyFlag	是否回复	
12	replyUserId	被回复人userid	指向性需求
13	replyNum	被评论数量	
14	hotStatus	是否热评	
15	goodStatus	是否加精	
16	topStatus	是否置顶	
17	imagesInfo	图片链接	
18	videosInfo	视频链接	
19	location	地域信息	
20	goodTime	加精时间	
21	topTime	置顶时间	
22	bottomStatus	置底	
23	closeStatus	关评	
24	likeCount	点赞次数	
25	dislikeCount	点踩次数	
26	reportCount	举报次数	
27	createTime	创建时间	
28	updateTime	更新时间	
29	shareCount	分享次数	
30	extra	额外字段
```


### 用户评论埋点/记录

```java
1	id	自增id	
3	commentId	评论Id	
4	userId	用户Id	
5	opsType	操作类型	点赞/评论
6	status	状态	0：取消点赞，1：点赞
7	createTime	创建时间	
```



