<p data-nodeid="1521" class="">在并发编程中有两个重要的概念：<strong data-nodeid="1579">线程和锁</strong>，多线程是一把双刃剑，它在提高程序性能的同时，也带来了编码的复杂性，对开发者的要求也提高了一个档次。而锁的出现就是为了保障多线程在同时操作一组资源时的数据一致性，当我们给资源加上锁之后，只有拥有此锁的线程才能操作此资源，而其他线程只能排队等待使用此锁。当然，在所有的面试中也都少不了关于“锁”方面的相关问题。</p>
<p data-nodeid="1937" class="">我们本课时的面试题是，如何手动模拟一个死锁？谈谈你对锁的理解。</p>


<h3 data-nodeid="1523">典型回答</h3>
<p data-nodeid="1524">死锁是指两个线程同时占用两个资源，又在彼此等待对方释放锁资源，如下图所示：<br>
<img src="https://s0.lgstatic.com/i/image3/M01/7D/29/Cgq2xl59tsKAQ8wtAAA5YT3tSNk931.png" alt="" data-nodeid="1585"></p>
<p data-nodeid="1525">死锁的代码演示如下：</p>
<pre class="lang-java" data-nodeid="1526"><code data-language="java"><span class="hljs-keyword">import</span>&nbsp;java.util.concurrent.TimeUnit;

<span class="hljs-keyword">public</span>&nbsp;<span class="hljs-class"><span class="hljs-keyword">class</span>&nbsp;<span class="hljs-title">LockExample</span>&nbsp;</span>{
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-function"><span class="hljs-keyword">public</span>&nbsp;<span class="hljs-keyword">static</span>&nbsp;<span class="hljs-keyword">void</span>&nbsp;<span class="hljs-title">main</span><span class="hljs-params">(String[]&nbsp;args)</span>&nbsp;</span>{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;deadLock();&nbsp;<span class="hljs-comment">//&nbsp;死锁</span>
&nbsp;&nbsp;&nbsp;&nbsp;}

&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">/**
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;*&nbsp;死锁
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;*/</span>
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-function"><span class="hljs-keyword">private</span>&nbsp;<span class="hljs-keyword">static</span>&nbsp;<span class="hljs-keyword">void</span>&nbsp;<span class="hljs-title">deadLock</span><span class="hljs-params">()</span>&nbsp;</span>{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Object&nbsp;lock1&nbsp;=&nbsp;<span class="hljs-keyword">new</span>&nbsp;Object();
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Object&nbsp;lock2&nbsp;=&nbsp;<span class="hljs-keyword">new</span>&nbsp;Object();
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">//&nbsp;线程一拥有&nbsp;lock1&nbsp;试图获取&nbsp;lock2</span>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">new</span>&nbsp;Thread(()&nbsp;-&gt;&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">synchronized</span>&nbsp;(lock1)&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;System.out.println(<span class="hljs-string">"获取&nbsp;lock1&nbsp;成功"</span>);
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">try</span>&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;TimeUnit.SECONDS.sleep(<span class="hljs-number">3</span>);
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}&nbsp;<span class="hljs-keyword">catch</span>&nbsp;(InterruptedException&nbsp;e)&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;e.printStackTrace();
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">//&nbsp;试图获取锁&nbsp;lock2</span>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">synchronized</span>&nbsp;(lock2)&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;System.out.println(Thread.currentThread().getName());
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}).start();
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">//&nbsp;线程二拥有&nbsp;lock2&nbsp;试图获取&nbsp;lock1</span>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">new</span>&nbsp;Thread(()&nbsp;-&gt;&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">synchronized</span>&nbsp;(lock2)&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;System.out.println(<span class="hljs-string">"获取&nbsp;lock2&nbsp;成功"</span>);
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">try</span>&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;TimeUnit.SECONDS.sleep(<span class="hljs-number">3</span>);
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}&nbsp;<span class="hljs-keyword">catch</span>&nbsp;(InterruptedException&nbsp;e)&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;e.printStackTrace();
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">//&nbsp;试图获取锁&nbsp;lock1</span>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">synchronized</span>&nbsp;(lock1)&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;System.out.println(Thread.currentThread().getName());
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}).start();
&nbsp;&nbsp;&nbsp;&nbsp;}
}
</code></pre>
<p data-nodeid="1527">以上程序执行结果如下：</p>
<pre class="lang-java" data-nodeid="1528"><code data-language="java">获取&nbsp;lock1&nbsp;成功
获取&nbsp;lock2&nbsp;成功
</code></pre>
<p data-nodeid="1529">可以看出当我们使用线程一拥有锁 lock1 的同时试图获取 lock2，而线程二在拥有 lock2 的同时试图获取 lock1，这样就会造成彼此都在等待对方释放资源，于是就形成了<strong data-nodeid="1593">死锁</strong>。</p>
<p data-nodeid="3327" class="">锁是指在并发编程中，当有多个线程同时操作一个资源时，为了保证数据操作的正确性，我们需要让多线程排队一个一个地操作此资源，而这个过程就是给资源加锁和释放锁的过程，就好像去公共厕所一样，必须一个一个排队使用，并且在使用时需要锁门和开门一样。</p>





<h3 data-nodeid="1531">考点分析</h3>
<p data-nodeid="4737" class="">锁的概念不止出现在 Java 语言中，比如<strong data-nodeid="4743">乐观锁和悲观锁</strong>其实很早就存在于数据库中了。锁的概念其实不难理解，但要真正地了解锁的原理和实现过程，才能打动面试官。</p>





<p data-nodeid="1533">和锁相关的面试问题，还有以下几个：</p>
<ul data-nodeid="1534">
<li data-nodeid="1535">
<p data-nodeid="1536">什么是乐观锁和悲观锁？它们的应用都有哪些？乐观锁有什么问题？</p>
</li>
<li data-nodeid="1537">
<p data-nodeid="1538">什么是可重入锁？用代码如何实现？它的实现原理是什么？</p>
</li>
<li data-nodeid="1539">
<p data-nodeid="1540">什么是共享锁和独占锁？</p>
</li>
</ul>
<h3 data-nodeid="1541">知识扩展</h3>
<h4 data-nodeid="1542">1. 悲观锁和乐观锁</h4>
<p data-nodeid="1543">悲观锁指的是数据对外界的修改采取保守策略，它认为线程很容易会把数据修改掉，因此在整个数据被修改的过程中都会采取锁定状态，直到一个线程使用完，其他线程才可以继续使用。</p>
<p data-nodeid="1544">我们来看一下悲观锁的实现流程，以 synchronized 为例，代码如下：</p>
<pre class="lang-java" data-nodeid="1545"><code data-language="java"><span class="hljs-keyword">public</span>&nbsp;<span class="hljs-class"><span class="hljs-keyword">class</span>&nbsp;<span class="hljs-title">LockExample</span>&nbsp;</span>{
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-function"><span class="hljs-keyword">public</span>&nbsp;<span class="hljs-keyword">static</span>&nbsp;<span class="hljs-keyword">void</span>&nbsp;<span class="hljs-title">main</span><span class="hljs-params">(String[]&nbsp;args)</span>&nbsp;</span>{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">synchronized</span>&nbsp;(LockExample.class)&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;System.out.println("lock");
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}
&nbsp;&nbsp;&nbsp;&nbsp;}
}
</code></pre>
<p data-nodeid="1546">我们使用反编译工具查到的结果如下：</p>
<pre class="lang-java" data-nodeid="1547"><code data-language="java">Compiled&nbsp;from&nbsp;"LockExample.java"
public&nbsp;class&nbsp;com.lagou.interview.ext.LockExample&nbsp;{
&nbsp;&nbsp;public&nbsp;com.lagou.interview.ext.LockExample();
&nbsp;&nbsp;&nbsp;&nbsp;Code:
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0:&nbsp;aload_0
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1:&nbsp;invokespecial&nbsp;#1&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;//&nbsp;Method&nbsp;java/lang/Object."&lt;init&gt;":()V
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;4:&nbsp;return
&nbsp;
&nbsp;&nbsp;public&nbsp;static&nbsp;void&nbsp;main(java.lang.String[]);
&nbsp;&nbsp;&nbsp;&nbsp;Code:
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0:&nbsp;ldc&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;#2&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;//&nbsp;class&nbsp;com/lagou/interview/ext/LockExample
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;2:&nbsp;dup
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;3:&nbsp;astore_1
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;4:&nbsp;monitorenter&nbsp;//&nbsp;加锁
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;5:&nbsp;getstatic&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;#3&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;//&nbsp;Field&nbsp;java/lang/System.out:Ljava/io/PrintStream;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;8:&nbsp;ldc&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;#4&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;//&nbsp;String&nbsp;lock
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;10:&nbsp;invokevirtual&nbsp;#5&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;//&nbsp;Method&nbsp;java/io/PrintStream.println:(Ljava/lang/String;)V
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;13:&nbsp;aload_1
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;14:&nbsp;monitorexit&nbsp;//&nbsp;释放锁
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;15:&nbsp;goto&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;23
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;18:&nbsp;astore_2
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;19:&nbsp;aload_1
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;20:&nbsp;monitorexit
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;21:&nbsp;aload_2
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;22:&nbsp;athrow
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;23:&nbsp;return
&nbsp;&nbsp;&nbsp;&nbsp;Exception&nbsp;table:
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;from&nbsp;&nbsp;&nbsp;&nbsp;to&nbsp;&nbsp;target&nbsp;type
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;5&nbsp;&nbsp;&nbsp;&nbsp;15&nbsp;&nbsp;&nbsp;&nbsp;18&nbsp;&nbsp;&nbsp;any
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;18&nbsp;&nbsp;&nbsp;&nbsp;21&nbsp;&nbsp;&nbsp;&nbsp;18&nbsp;&nbsp;&nbsp;any
}
</code></pre>
<p data-nodeid="1548">可以看出被 synchronized 修饰的代码块，在执行之前先使用 monitorenter 指令加锁，然后在执行结束之后再使用 monitorexit 指令释放锁资源，在整个执行期间此代码都是锁定的状态，这就是<strong data-nodeid="1618">典型悲观锁的实现流程</strong>。</p>
<p data-nodeid="1549">乐观锁和悲观锁的概念恰好相反，乐观锁认为一般情况下数据在修改时不会出现冲突，所以在数据访问之前不会加锁，只是在数据提交更改时，才会对数据进行检测。</p>
<p data-nodeid="1550">Java 中的乐观锁大部分都是通过 CAS（Compare And Swap，比较并交换）操作实现的，CAS 是一个多线程同步的原子指令，CAS 操作包含三个重要的信息，即内存位置、预期原值和新值。如果内存位置的值和预期的原值相等的话，那么就可以把该位置的值更新为新值，否则不做任何修改。</p>
<p data-nodeid="1551">CAS 可能会造成 ABA 的问题，ABA 问题指的是，线程拿到了最初的预期原值 A，然而在将要进行 CAS 的时候，被其他线程抢占了执行权，把此值从 A 变成了 B，然后其他线程又把此值从 B 变成了 A，然而此时的 A 值已经并非原来的 A 值了，但最初的线程并不知道这个情况，在它进行 CAS 的时候，只对比了预期原值为 A 就进行了修改，这就造成了 ABA 的问题。</p>
<p data-nodeid="1552">以警匪剧为例，假如某人把装了 100W 现金的箱子放在了家里，几分钟之后要拿它去赎人，然而在趁他不注意的时候，进来了一个小偷，用空箱子换走了装满钱的箱子，当某人进来之后看到箱子还是一模一样的，他会以为这就是原来的箱子，就拿着它去赎人了，这种情况肯定有问题，因为箱子已经是空的了，这就是 ABA 的问题。</p>
<p data-nodeid="1553">ABA 的常见处理方式是添加版本号，每次修改之后更新版本号，拿上面的例子来说，假如每次移动箱子之后，箱子的位置就会发生变化，而这个变化的位置就相当于“版本号”，当某人进来之后发现箱子的位置发生了变化就知道有人动了手脚，就会放弃原有的计划，这样就解决了 ABA 的问题。</p>
<p data-nodeid="1554">JDK 在 1.5 时提供了 AtomicStampedReference 类也可以解决 ABA 的问题，此类维护了一个“版本号” Stamp，每次在比较时不止比较当前值还比较版本号，这样就解决了 ABA 的问题。</p>
<p data-nodeid="1555">相关源码如下：</p>
<pre class="lang-java" data-nodeid="1556"><code data-language="java"><span class="hljs-keyword">public</span>&nbsp;<span class="hljs-class"><span class="hljs-keyword">class</span>&nbsp;<span class="hljs-title">AtomicStampedReference</span>&lt;<span class="hljs-title">V</span>&gt;&nbsp;</span>{
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">private</span>&nbsp;<span class="hljs-keyword">static</span>&nbsp;<span class="hljs-class"><span class="hljs-keyword">class</span>&nbsp;<span class="hljs-title">Pair</span>&lt;<span class="hljs-title">T</span>&gt;&nbsp;</span>{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">final</span>&nbsp;T&nbsp;reference;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">final</span>&nbsp;<span class="hljs-keyword">int</span>&nbsp;stamp;&nbsp;<span class="hljs-comment">//&nbsp;“版本号”</span>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-function"><span class="hljs-keyword">private</span>&nbsp;<span class="hljs-title">Pair</span><span class="hljs-params">(T&nbsp;reference,&nbsp;<span class="hljs-keyword">int</span>&nbsp;stamp)</span>&nbsp;</span>{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">this</span>.reference&nbsp;=&nbsp;reference;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">this</span>.stamp&nbsp;=&nbsp;stamp;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">static</span>&nbsp;&lt;T&gt;&nbsp;<span class="hljs-function">Pair&lt;T&gt;&nbsp;<span class="hljs-title">of</span><span class="hljs-params">(T&nbsp;reference,&nbsp;<span class="hljs-keyword">int</span>&nbsp;stamp)</span>&nbsp;</span>{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">return</span>&nbsp;<span class="hljs-keyword">new</span>&nbsp;Pair&lt;T&gt;(reference,&nbsp;stamp);
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}
&nbsp;&nbsp;&nbsp;&nbsp;}
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">//&nbsp;比较并设置</span>
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-function"><span class="hljs-keyword">public</span>&nbsp;<span class="hljs-keyword">boolean</span>&nbsp;<span class="hljs-title">compareAndSet</span><span class="hljs-params">(V&nbsp;&nbsp;&nbsp;expectedReference,
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;V&nbsp;&nbsp;&nbsp;newReference,
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">int</span>&nbsp;expectedStamp,&nbsp;//&nbsp;原版本号
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">int</span>&nbsp;newStamp)</span>&nbsp;</span>{&nbsp;<span class="hljs-comment">//&nbsp;新版本号</span>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Pair&lt;V&gt;&nbsp;current&nbsp;=&nbsp;pair;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">return</span>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;expectedReference&nbsp;==&nbsp;current.reference&nbsp;&amp;&amp;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;expectedStamp&nbsp;==&nbsp;current.stamp&nbsp;&amp;&amp;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;((newReference&nbsp;==&nbsp;current.reference&nbsp;&amp;&amp;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;newStamp&nbsp;==&nbsp;current.stamp)&nbsp;||
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;casPair(current,&nbsp;Pair.of(newReference,&nbsp;newStamp)));
&nbsp;&nbsp;&nbsp;&nbsp;}
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">//.......省略其他源码</span>
}
</code></pre>
<p data-nodeid="1557">可以看出它在修改时会进行原值比较和版本号比较，当比较成功之后会修改值并修改版本号。</p>
<blockquote data-nodeid="1558">
<p data-nodeid="1559">小贴士：乐观锁有一个优点，它在提交的时候才进行锁定的，因此不会造成死锁。</p>
</blockquote>
<h4 data-nodeid="1560">2. 可重入锁</h4>
<p data-nodeid="1561">可重入锁也叫<strong data-nodeid="1636">递归锁</strong>，指的是同一个线程，如果外面的函数拥有此锁之后，内层的函数也可以继续获取该锁。在 Java 语言中 ReentrantLock 和 synchronized 都是可重入锁。</p>
<p data-nodeid="1562">下面我们用 synchronized 来演示一下什么是可重入锁，代码如下：</p>
<pre class="lang-java" data-nodeid="1563"><code data-language="java"><span class="hljs-keyword">public</span>&nbsp;<span class="hljs-class"><span class="hljs-keyword">class</span>&nbsp;<span class="hljs-title">LockExample</span>&nbsp;</span>{
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-function"><span class="hljs-keyword">public</span>&nbsp;<span class="hljs-keyword">static</span>&nbsp;<span class="hljs-keyword">void</span>&nbsp;<span class="hljs-title">main</span><span class="hljs-params">(String[]&nbsp;args)</span>&nbsp;</span>{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;reentrantA();&nbsp;<span class="hljs-comment">//&nbsp;可重入锁</span>
&nbsp;&nbsp;&nbsp;&nbsp;}
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">/**
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;*&nbsp;可重入锁&nbsp;A&nbsp;方法
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;*/</span>
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-function"><span class="hljs-keyword">private</span>&nbsp;<span class="hljs-keyword">synchronized</span>&nbsp;<span class="hljs-keyword">static</span>&nbsp;<span class="hljs-keyword">void</span>&nbsp;<span class="hljs-title">reentrantA</span><span class="hljs-params">()</span>&nbsp;</span>{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;System.out.println(Thread.currentThread().getName()&nbsp;+&nbsp;<span class="hljs-string">"：执行&nbsp;reentrantA"</span>);
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;reentrantB();
&nbsp;&nbsp;&nbsp;&nbsp;}
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">/**
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;*&nbsp;可重入锁&nbsp;B&nbsp;方法
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;*/</span>
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-function"><span class="hljs-keyword">private</span>&nbsp;<span class="hljs-keyword">synchronized</span>&nbsp;<span class="hljs-keyword">static</span>&nbsp;<span class="hljs-keyword">void</span>&nbsp;<span class="hljs-title">reentrantB</span><span class="hljs-params">()</span>&nbsp;</span>{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;System.out.println(Thread.currentThread().getName()&nbsp;+&nbsp;<span class="hljs-string">"：执行&nbsp;reentrantB"</span>);
&nbsp;&nbsp;&nbsp;&nbsp;}
}
</code></pre>
<p data-nodeid="1564">以上代码的执行结果如下：</p>
<pre class="lang-java" data-nodeid="1565"><code data-language="java">main：执行&nbsp;reentrantA
main：执行&nbsp;reentrantB
</code></pre>
<p data-nodeid="1566">从结果可以看出 reentrantA 方法和 reentrantB 方法的执行线程都是“main” ，我们调用了 reentrantA 方法，它的方法中嵌套了 reentrantB，如果 synchronized 是不可重入的话，那么线程会被一直堵塞。</p>
<p data-nodeid="1567">可重入锁的实现原理，是在锁内部存储了一个线程标识，用于判断当前的锁属于哪个线程，并且锁的内部维护了一个计数器，当锁空闲时此计数器的值为 0，当被线程占用和重入时分别加 1，当锁被释放时计数器减 1，直到减到 0 时表示此锁为空闲状态。</p>
<h4 data-nodeid="1568">3. 共享锁和独占锁</h4>
<p data-nodeid="1569" class="">只能被单线程持有的锁叫<strong data-nodeid="1653">独占锁</strong>，可以被多线程持有的锁叫<strong data-nodeid="1654">共享锁</strong>。</p>
<p data-nodeid="1570">独占锁指的是在任何时候最多只能有一个线程持有该锁，比如 synchronized 就是独占锁，而 ReadWriteLock 读写锁允许同一时间内有多个线程进行读操作，它就属于共享锁。</p>
<p data-nodeid="1571">独占锁可以理解为悲观锁，当每次访问资源时都要加上互斥锁，而共享锁可以理解为乐观锁，它放宽了加锁的条件，允许多线程同时访问该资源。</p>
<h3 data-nodeid="1572">小结</h3>
<p data-nodeid="1573" class="">本课时我们讲了悲观锁和乐观锁，其中悲观锁的典型应用为 synchronized，它的特性为独占式互斥锁；而乐观锁相比于悲观锁而言，拥有更好的性能，但乐观锁可能会导致 ABA 的问题，常见的解决方案是添加版本号来防止 ABA 问题的发生。同时，还讲了可重入锁，在 Java 中，synchronized 和 ReentrantLock 都是可重入锁。最后，讲了独占锁和共享锁，其中独占锁可以理解为悲观锁，而共享锁可以理解为乐观锁。</p>

---

### 精选评论

##### **兴：
> 我对共享锁和排它锁有不同理解<div><span style="font-size: 16px; -webkit-tap-highlight-color: rgba(26, 26, 26, 0.301961); -webkit-text-size-adjust: auto; caret-color: rgb(34, 34, 34); color: rgb(34, 34, 34); font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun;">共享锁，又称为读锁，获得共享锁之后，可以查看但无法修改和删除数据。</span><br style="font-size: 16px; -webkit-tap-highlight-color: rgba(26, 26, 26, 0.301961); -webkit-text-size-adjust: auto; -webkit-overflow-scrolling: touch; box-sizing: border-box; caret-color: rgb(34, 34, 34); color: rgb(34, 34, 34); font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun;"><span style="font-size: 16px; -webkit-tap-highlight-color: rgba(26, 26, 26, 0.301961); -webkit-text-size-adjust: auto; caret-color: rgb(34, 34, 34); color: rgb(34, 34, 34); font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif, SimHei, SimSun;">排他锁，又称为写锁、独占锁。获准排他锁后，既能读数据，又能修改数据</span><br></div>

##### **天：
> ABA用前妻结了一次婚又离了再回来复婚更贴切😅😛

##### **皓：
> 乐观锁防止ABA问题的话，数据库里只比较版本号就好了，为什么java里cas的同时还要比较版本号？

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 版本号的实现机制有很多种，可以在数据库层面去实现也可以在 Java 代码中实现，采取任意一种都是可以的。

##### **永：
> 明白了，因为乐观锁并没有对共享资源加锁，只是cas

##### **永：
> 老师，为什么乐观锁在提交时进行锁定，就不会造成死锁了呀，死锁有四个必要条件，他破坏了哪个呢

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 乐观锁不是互斥的哦

##### **彪：
> 好文，今天终于明白了什么叫可重入锁了。一直知道可重入锁这个词语，并不知道啥叫可重入锁的背后的意思。

##### *超：
> 老师，有个问题不太明白，cas既然是原子操作，为什么在a线程取到期望值之后没有比较，而被b线程抢占了执行权，我理解的原子操作，在执行过程中不会受任何的干扰，不知道哪里理解不太对，还请老师指点

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; CAS 保证了原子性，但存在 ABA 的问题。可以理解为原子操作只能保证一个步骤执行的完整性，但ABA问题是组合操作，所以会存在问题。

##### **龙：
> 可重入锁那个例子没看懂，单线程顺序执行，怎么就说明他是可重入的

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 可重入锁指的就是一个线程可以“重入”

##### *鸟：
> 讲解生动形象！日常催更！

 ###### &nbsp;&nbsp;&nbsp; 编辑回复：
> &nbsp;&nbsp;&nbsp; 已反馈给老师哦，后面会加快更新节奏。

##### **用户7139：
> 第五课说的是Reentrantlock 基于AQS

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 是

