---
title: 快速重传/快速恢复
toc: true
date: 2021-07-04 16:33:35
tags: TCP
categories: [Computer Network, TCP]
---

# 快速重传和快速恢复

## 快速重传

>d 为何会接收到以个失序数据段？ 


- 若报文丢失，将会产生连续的失序ACK段 
- 若网络路径与设备导致数据段失序，将会产生少量的失序ACK段
- 若报文重复，将会产生少量的失序ACK段

<img src="https://oscimg.oschina.net/oscnet/up-eaadaebd682089bdd3919de4f0d232749dc.png" width=450 height= 520>

- 当发送端发送pkt0是正常的，由于滑动窗口为满，发送方可以继续发送pkt1，pkt2；
- 加入pkt1发生了丢包，虽然pkt2接收端接收成功了，但是没有pkt1的数据段，接收端还是发送ACK1的确认报文；
- 在没有「快速重传」的情况下，发送端需要等到RTO之后，才可以重新发送pkt1
- 重传成功之后，接收端其实收到了pkt2之前的所有数据段，所以发送ACK3的确认报文
> 这种需要等待RTO才可以重传的方式效率是比较低的，因此需要快速重传来进行优化；

## 快速重传和累积确认

<img src="https://oscimg.oschina.net/oscnet/up-9da669c35316aafb318674d3364ea07d72d.png" width=450 height=520>

当发送方连续发送pkt3，pkt4，pkt5，pkt6四个数据端，但是pkt5在网络中丢包了，那后面发送的pkt6，pkt7，pkt8的确认报文都返回ACK5，希望发送方吃昂传pkt5的数据段；这个时候，发送方收到连续3个相同的确认报文，便立即重新发送pkt5的数据段；

> 接收方:

- 当接收到一个失序数据段时，立刻发送它所期待的缺口 ACK 序列号
- 当接收到填充失序缺口的数据段时，立刻发 送它所期待的下一个 ACK 序列号

> 发送方

- 当接收到3个重复的失序 ACK 段(4个相同的失序ACK段)时，不再等待重传定时器的触发，立刻基于快速重传机制重发报文段


当pkt5重新发送并被接收端接收之后，接收端发送ACK9的确认报文，而不是再分别发送ACK6，ACK7，ACK8，这个称谓「 **<font color=red>累计确认</font>** 」。



## 快速恢复

> 快速重传下一定要进入慢启动吗?

接受端收到重复ACK，意味着网络仍在流动，而如果要重新进入慢启动，会导致网络突然减少数据流，拥塞窗口恢复初始窗口，所以，「**在快速恢复下发生丢包的场景下**」，应该使用快速恢复，简单的讲，就是将慢启动阈值设置成当前拥塞窗口的一半，而拥塞窗口也适当放低，而不是一下字恢复到初始窗口大小；


<img src="https://oscimg.oschina.net/oscnet/up-4a7f76cb315a13d1d905f2bfb3a376db087.png" >

快速恢复的流程如上图👆所示！

> 快速恢复的具体操作：

- 将 ssthresh 设置为当前拥塞窗口 cwnd 的一半，设当前 cwnd 为 ssthresh 加上 3*MSS
- 每收到一个重复 ACK，cwnd 增加 1 个 MSS
- 当新数据 ACK 到达后，设置 cwnd 为 ssthresh

