---
title: 二分查找（迭代&递归）
toc: true
date: 2021-09-27 17:00:45
tags:
- Leetcode
- 二分
categories: [Leetcode, 二分]
---

https://leetcode-cn.com/problems/binary-search/

## 1. 二分查找

给定一个 n 个元素有序的（升序）整型数组 nums 和一个目标值 target  ，写一个函数搜索 nums 中的 target，如果目标值存在返回下标，否则返回 -1。

### 示例 1:

输入: `nums = [-1,0,3,5,9,12], target = 9`
输出: 4
解释: 9 出现在 nums 中并且下标为 4

### 示例 2:

输入: `nums = [-1,0,3,5,9,12], target = 2`
输出: -1
解释: 2 不存在 nums 中因此返回 -1


提示：

> 你可以假设 nums 中的所有元素是不重复的。
> n 将在 [1, 10000]之间。
> nums 的每个元素都将在 [-9999, 9999]之间。

![image-20210927170614830](https://xcu-oss.oss-cn-beijing.aliyuncs.com/image/gao/image-20210927170614830.png)

### 递归写法

```java
class Solution {
    public int search(int[] nums, int target) {
      	// 注意边界
        return find(0, nums.length - 1, target, nums);
    }

    public int find(int left, int right, int target, int[] nums) {
        if (left <= right) {
          	// 注意mid取值的写法，避免越界异常
            int mid = (right - left) / 2 + left;
            if (nums[mid] == target) {
                return mid;
            }

            if (nums[mid] > target) {
                return find(left, mid - 1, target, nums);
            }

            if (nums[mid] < target) {
                return find(mid + 1, right, target, nums);
            }
        }
        return -1;
    }

}
```



### 迭代写法

```java
class Solution {
    public int search(int[] nums, int target) {
        int left = 0;
        int right = nums.length - 1;
        while(left <= right) {
            int mid = (right - left) / 2 + left;
            if (nums[mid] == target) {
                return mid;
            }

            if (nums[mid] > target) {
                right = mid - 1;
            }

            if (nums[mid] < target) {
                left = mid + 1;
            }

        }
        return -1;
    }
}
```





## 2. 查找第一个错误版本

[leetcode278]( https://leetcode-cn.com/problems/first-bad-version/)

你是产品经理，目前正在带领一个团队开发新的产品。不幸的是，你的产品的最新版本没有通过质量检测。由于每个版本都是基于之前的版本开发的，所以错误的版本之后的所有版本都是错的。

假设你有 n 个版本 [1, 2, ..., n]，你想找出导致之后所有版本出错的第一个错误的版本。

你可以通过调用 bool isBadVersion(version) 接口来判断版本号 version 是否在单元测试中出错。实现一个函数来查找第一个错误的版本。你应该尽量减少对调用 API 的次数。

### 示例 1：

```
输入：n = 5, bad = 4
输出：4
解释：
调用 isBadVersion(3) -> false 
调用 isBadVersion(5) -> true 
调用 isBadVersion(4) -> true
所以，4 是第一个错误的版本。
```

### 迭代写法

```java

public class Solution extends VersionControl {
    public int firstBadVersion(int n) {
        int left = 1;
        int right = n;
        while (left <= right) {
            int mid = (right - left) / 2 + left;
            if (isBadVersion(mid)) {
                right = mid - 1;
            }else {
                left = mid + 1;
            }
        }
        return left;
    }
}
```





## 3. [搜索插入位置](https://leetcode-cn.com/problems/search-insert-position/)

Leetcode 35

给定一个排序数组和一个目标值，在数组中找到目标值，并返回其索引。如果目标值不存在于数组中，返回它将会被按顺序插入的位置。

请必须使用时间复杂度为 O(log n) 的算法。

### 递归写法

```java
class Solution {
    public int searchInsert(int[] nums, int target) {
        int left = 0;
        int right = nums.length - 1;
        while (left <= right) {
            int mid = (right - left) / 2 + left;
            if (nums[mid] == target) {
                return mid;
            }

            if (nums[mid] > target) {
                right = mid - 1;
            }

            if (nums[mid] < target) {
                left = mid + 1;
            }
        }

        return left;
    }
}
```

