# 基本概念和结构

## ReentrantLock 简介
ReentrantLock是Java中的一个可重入锁，实现了Lock接口，提供了比synchronized更灵活的锁机制。   

它允许一个线程多次获取同一个锁，主要通过一个内部的同步器（AbstractQueuedSynchronizer，简称AQS）来实现。
## 内部同步器（AQS）基础

AQS是ReentrantLock的核心底层实现。它维护了一个等待队列（CLH队列），用于存储等待获取锁的线程。  

CLH队列是一个双向链表，每个节点代表一个等待线程。队列头节点表示当前持有锁的线程，后续节点则是等待锁的线程。

## 锁状态的维护
AQS使用一个volatile修饰的int变量（state）来表示锁的状态。在ReentrantLock中，state的值表示锁被线程重入的次数。  

当state = 0时，表示锁未被占用；当state > 0时，表示锁被某个线程占用，并且state的值就是该线程重入锁的次数。

# 公平锁与非公平锁实现差异

## 公平锁（Fair Lock）原理：

### 锁获取规则
在公平锁的实现中，线程获取锁时会先检查等待队列。如果等待队列中有其他线程在等待，那么当前线程会乖乖地排到队列的尾部，按照先来后到的顺序获取锁。这保证了锁的获取是公平的，不会出现插队的情况。

### 底层代码实现细节
当一个线程调用ReentrantLock的lock方法（公平锁模式）时，会调用AQS内部的acquire方法。这个方法首先会尝试通过tryAcquire方法获取锁，如果锁未被占用或者当前线程已经持有该锁（可重入特性），则获取成功。如果获取失败，就会将当前线程封装成一个节点，添加到等待队列的尾部，然后通过acquireQueued方法让线程在队列中自旋等待获取锁。

## 非公平锁（Non - fair Lock）原理：
### 锁获取规则

非公平锁在获取锁时不会考虑等待队列中的线程。当一个线程调用lock方法时，它会首先尝试直接获取锁，如果此时锁恰好是空闲的，那么这个线程就能立即获取锁，而不管等待队列中是否有其他等待线程。只有当锁已经被占用时，它才会和公平锁一样，将自己添加到等待队列中等待。这种方式可能会导致某些线程 “插队” 获取锁，提高了一定的性能，但牺牲了公平性。

### 底层代码实现细节
在非公平锁模式下，lock方法调用AQS的compareAndSetState方法（通过CAS操作）来尝试直接获取锁。如果获取成功，就表示当前线程获取到了锁。如果获取失败，同样会将自己添加到等待队列中，后续的等待和公平锁类似，通过acquireQueued方法在队列中自旋等待获取锁。

# 可重入性原理

## 可重入的定义和意义

可重入性是指一个线程可以多次获取同一个锁而不会被阻塞。这在递归调用或者嵌套调用包含锁操作的方法时非常有用。例如，一个方法中调用了另一个同样使用ReentrantLock保护的方法，在同一个线程中执行时，不会因为锁的原因而导致死锁。

## 实现机制

当一个线程已经持有ReentrantLock时，再次调用lock方法，ReentrantLock通过检查当前线程是否为锁的持有者以及AQS中的state变量来实现可重入。如果是当前线程已经持有锁，state变量会自增，表示锁的重入次数增加。当线程释放锁时，state变量会递减，直到state = 0时，锁才真正被释放，其他线程才有机会获取该锁。

# 锁的释放过程
## 释放操作的主要步骤

当线程完成对共享资源的访问，需要释放ReentrantLock时，会调用unlock方法。这个方法会调用AQS的release方法，release方法首先会尝试通过tryRelease方法来释放锁。

## 唤醒等待线程

在tryRelease方法中，如果state变量递减后的值为0，表示锁已经完全被释放，此时会通过unparkSuccessor方法唤醒等待队列中的下一个线程。被唤醒的线程会再次尝试获取锁，从而保证了锁的正常流转和共享资源的有序访问。