---
title: Java并发编程系列合集
toc: true
date: 2021-08-02 11:22:49
tags: 多线程
categories:
---

## Lock框架继承关系图

<img src="https://xcu-oss.oss-cn-beijing.aliyuncs.com/image/gao/image-20210802193933121.png" alt="image-20210802193933121"  />



## 知识清单

- Java多线程与并发基础
- [Java内存模型](https://geekibli.github.io/wiki/Java%E5%86%85%E5%AD%98%E6%A8%A1%E5%9E%8B/)
- [深入理解同步锁-synchronized关键字](https://geekibli.github.io/wiki/Java-synchronized%E5%85%B3%E9%94%AE%E5%AD%97%E5%89%96%E6%9E%90/)
- [synchronized实现原理概述](https://geekibli.github.io/wiki/Java-synchronzied%E5%BA%95%E5%B1%82%E5%8E%9F%E7%90%86/)
- [深入理解volatile关键字](https://geekibli.github.io/wiki/Java%E5%B9%B6%E5%8F%91%E7%BC%96%E7%A8%8B-%E6%B7%B1%E5%85%A5%E7%90%86%E8%A7%A3volatile/)
- 深入理解final关键字
- [深入理解并发编程之Blocking Queue](https://geekibli.github.io/wiki/Java%E5%B9%B6%E5%8F%91%E7%BC%96%E7%A8%8B%E4%B9%8BBlocking-Queue/)
- [深入理解并发编程之AQS](https://geekibli.github.io/wiki/Java%E5%B9%B6%E5%8F%91%E7%BC%96%E7%A8%8B%E4%B9%8BAQS%E5%BA%95%E5%B1%82%E5%AE%9E%E7%8E%B0%E4%B8%8E%E5%8E%9F%E7%90%86/)
- [深入理解ReentrantLock应用及实现](https://geekibli.github.io/wiki/Java%E5%B9%B6%E5%8F%91%E7%BC%96%E7%A8%8B%E4%B9%8B%E6%B7%B1%E5%85%A5%E7%90%86%E8%A7%A3ReetrantLock/)
- [深入Condition机制的底层原理](https://geekibli.github.io/wiki/Java%E5%B9%B6%E5%8F%91%E7%BC%96%E7%A8%8B%E4%B9%8BCondition%E6%9C%BA%E5%88%B6%E5%BA%95%E5%B1%82/)
- [Java多线程之中断机制](https://geekibli.github.io/wiki/Java%E5%B9%B6%E5%8F%91%E7%BC%96%E7%A8%8B%E4%B9%8B%E4%B8%AD%E6%96%AD%E6%9C%BA%E5%88%B6/)
- [深入理解并发容器之concurrentHashMap](https://geekibli.github.io/wiki/Java%E5%B9%B6%E5%8F%91%E7%BC%96%E7%A8%8B%E4%B9%8BConcurrentHashMap%E5%AE%9E%E7%8E%B0%E5%8E%9F%E7%90%86/)
- [深入理解并发编程之ThreadLocal](https://geekibli.github.io/wiki/Java%E5%A4%9A%E7%BA%BF%E7%A8%8B%E4%B9%8BThreadLocal/)
- 深入理解Atomic底层及原理
- [如何构建一个安全可用的线程池](https://geekibli.github.io/wiki/Java%E7%BA%BF%E7%A8%8B%E6%B1%A0/)
- [JUC-CountDownLatch](https://geekibli.github.io/wiki/Java%E5%B9%B6%E5%8F%91%E7%BC%96%E7%A8%8B%E4%B9%8BCountDownLatch%E5%B7%A5%E5%85%B7/)
- JUC-CyclicBarrier
- LockSupport工具
- 并发编程之Unsafe类

## 学习文档

https://www.codercc.com/backend/basic/juc/

https://segmentfault.com/a/1190000015558984

https://www.pdai.tech/md/java/thread/java-thread-x-juc-overview.html

https://github.com/AobingJava/JavaFamily

https://dayarch.top/categories/Coding/Java-Concurrency/

http://tutorials.jenkov.com/java-concurrency/blocking-queues.html

