---
title: 分布式-秒杀系统设计
toc: true
date: 2021-07-29 11:03:58
tags: 分布式
categories:
---


# 秒杀系统的挑战

## 高并发
秒杀活动的特点就是短时间内聚集大量请求瞬时到达服务端，此时数据库已经无法支撑如此大数据量的请求了。单个的数据库QPS仅有几百，你可能会想，那我是不是可以部署一个数据库集群呢，在数据库集群前使用Nginx分发，将负载平均分摊到每一个数据库不就可以了吗。
这种方式一定程度上是可以的，但是国内真正的互联网大厂肯定不是这样做的，在高并发的情况下完全可以使用内存操作来代替访问数据库，比如Redis集群。在网络带宽允许的情况下，Redis的集群的系统吞吐量肯定和数据库集群不是一个量级的，这里要查几十倍几百倍。
## 超卖
超卖最直接的后果就是可能会对公司造成直接的经济损失。防止超卖是秒杀系统必须要保证的一点。超卖的解决办法就是加锁，保证在高并发的情况下库存可以正常的正确的扣减。
## 恶意请求
### 产品层策略
秒杀器一般下单和购买及其迅速，根据购买记录可以甄别出一部分。可以通过校验码达到一定的方法，这就要求校验码足够安全，不被破解，采用的方式有：秒杀专用验证码，电视公布验证码，秒杀答题。
### 前端控制
除此之外前段可以添加点击次数限制，点击一定次数之后，将按钮置灰色，或者在js层级进行控制，用户看到的是每次都点击成功了，但是仅仅发起一次服务端请求；
### 后端控制
- 添加消息队列，消息执行一定数量时，队列后续的消息不在执行
- 后端架构按照模块拆分，用户不同的请求分散转发到各个模块的服务器，负载均衡
- 数据库分库分表（分片策略）和redis集群
- 升级服务器带宽，压力测试，保证系统吞吐量
- 过载保护，限流，请求拒绝和服务降级

## 链接加盐
链接加盐一定程度上可以保护恶意攻击，比如下单接口，如果暴露之后，就会存在恶意攻击，一个用户下了几百个单的情况或者一个IP下了很多单子，类似与黄牛抢票之后再去售卖。


# 秒杀系统架构图（参考）
<img src='https://oscimg.oschina.net/oscnet/up-a6fa908f7ee0f098a7a7eb4965dd282124b.png'>


# 参考资料
[ 敖丙带你设计【秒杀系统】](https://mp.weixin.qq.com/s/KWb3POodisbOEsQVblsoGw)  
[《吊打面试官》系列-秒杀系统设计](https://mp.weixin.qq.com/s/z2S1EjWQDwKm5Ud36IenNw)
[这是我读过写得最好的【秒杀系统架构】分析与实战！](https://cloud.tencent.com/developer/article/1520361)
[这一次，彻底弄懂“秒杀系统”](https://www.infoq.cn/article/ypqschsrdsk8bv5nhny4)