# 9.Aware相关

[bilibili](https://www.bilibili.com/video/BV1P44y1N7QG?p=26&vd_source=3ff1db20d26ee8426355e893ae553d51)

Aware 接口用户注入一些于容器相关的信息

a. BeanNAmeAware 注入 bean 的名字    

b. BeanFactoryAware 注入beanFactory容器

c. ApplicationContextAware 注入ApplicationContext 容器

d. EmbeddedValueResoulverAware ${}

## 9.1 先看一下BeanNameAware的作用

```java
public class MyBean implements BeanNameAware {
		
  // 初始化之前调用
    @Override
    public void setBeanName(String s) {
        System.out.println("bean name : {} " + s);
        System.out.println("bean  {} " + this.getClass().getName());
    }
}
```



```java
public class A06Application {

    public static void main(String[] args) {

        /**
         * 1. Aware 接口用户注入一些于容器相关的信息
         * 比如
         *  a. BeanNAmeAware 注入 bean 的名字
         *  b. BeanFactoryAware 注入beanFactory容器
         *  c. ApplicationContextAware 注入ApplicationContext 容器
         *  d. EmbeddedValueResoulverAware ${}
         */

        GenericApplicationContext context = new GenericApplicationContext();
        context.registerBean("mybean?",  MyBean.class);

        context.refresh();
        context.close();

    }
}
```

运行结果：

```
bean name : {} mybean?
bean  {} com.example.testspring.a06.MyBean
```



## 9.2 ApplicationContextAware注入容器

```
public class MyBean implements BeanNameAware , ApplicationContextAware {

    // 初始化之前调用
    @Override
    public void setBeanName(String s) {
        System.out.println("bean name : {} " + s);
        System.out.println("bean  {} " + this.getClass().getName());
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        System.out.println("applicationContext name : {} " + applicationContext);
    }
}
```

**执行结果**

```
bean name : {} mybean?
bean  {} com.example.testspring.a06.MyBean
applicationContext name : {} org.springframework.context.support.GenericApplicationContext@21588809, started on Sun Jan 29 21:12:58 CST 2023
```





## 9.3 InitializingBean初始化方法



```java
public class MyBean implements BeanNameAware , ApplicationContextAware , InitializingBean {

    // 初始化之前调用
    @Override
    public void setBeanName(String s) {
        System.out.println("bean name : {} " + s);
        System.out.println("bean  {} " + this.getClass().getName());
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        System.out.println("applicationContext name : {} " + applicationContext);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        System.out.println("执行InitializingBean。。。。。");
    }
}
```

**执行结果**

```java
bean name : {} mybean?
bean  {} com.example.testspring.a06.MyBean
applicationContext name : {} org.springframework.context.support.GenericApplicationContext@21588809, started on Sun Jan 29 21:14:28 CST 2023
执行InitializingBean。。。。。
```



## 9.4 Aware接口存在的意义

以上b c d的功能使用@Autowired也可以实现，但是为什么还存在以上bcd呢 Aware接口呢？

简单的说：

1. @Autowired的解析使用的是bean后置处理器，属于**扩展**功能
2. 而Aware 接口是属于**内置**功能，不加任何修饰，Spring就能识别到

某些场景下，扩展功能会失效，但是，Aware不会



```java
public class MyBean implements BeanNameAware , ApplicationContextAware , InitializingBean {

    // 初始化之前调用
    @Override
    public void setBeanName(String s) {
        System.out.println("bean name : {} " + s);
        System.out.println("bean  {} " + this.getClass().getName());
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        System.out.println("applicationContext name : {} " + applicationContext);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        System.out.println("执行InitializingBean。。。。。");
    }

    @Autowired
    public void aaa(ApplicationContext applicationContext) {
        System.out.println(" @Autowired ApplicationContext : " + applicationContext);
    }

    @PostConstruct
    public void init(){
        System.out.println("PostConstruct#init 。。。。。");
    }
}
```

执行结果：

```
bean name : {} mybean?
bean  {} com.example.testspring.a06.MyBean
applicationContext name : {} org.springframework.context.support.GenericApplicationContext@21588809, started on Sun Jan 29 21:23:15 CST 2023
执行InitializingBean。。。。。
```

**为什么没有生效？**

GenericApplicationContext没有添加对应的后置处理器

```java
context.registerBean(AutowiredAnnotationBeanPostProcessor.class);
context.registerBean(CommonAnnotationBeanPostProcessor.class);
```

**再执行一遍：**

```java
 @Autowired ApplicationContext : org.springframework.context.support.GenericApplicationContext@21588809, started on Sun Jan 29 21:25:47 CST 2023
bean name : {} mybean?
bean  {} com.example.testspring.a06.MyBean
applicationContext name : {} org.springframework.context.support.GenericApplicationContext@21588809, started on Sun Jan 29 21:25:47 CST 2023
PostConstruct#init 。。。。。
执行InitializingBean。。。。。
```



## 9.5 添加后置处理器，@Autowired和  @PostConstruct 依旧不起作用的场景

















