
# Spring Framework 系列


## 大致目录

1.课前准备
2.Spring特性总览
3.Spring版本特性
4.Spring模块化设计
5.Spring对Java语言特性运用
6.Spring对JDK API实践
7.Spring对Java EE API整合
8.Spring编程模型
9.Spring核心价值
10.面试题精选


## 版本准备

- JDK:Oracle JDK 8
- Spring Framework:5.2.2.RELEASE 
- Maven:3.2



## 2.Spring功能特性

这部分主要分为5大块。

### 2.1 核心特性


- IoC容器(loC Container)
- Spring事件(Events) 
- 资源管理（Resources) 
- 国际化(18n)
- 校验(Validation)
- 数据绑定(Data Binding) 
- 类型转换(Type Conversion)
- Spring表达式(Spring Express Language)
- 面向切面编程（AOP)



### 2.2 数据存储

- JDBC （jdbcTemplate）
- 事务抽象(Transactions)
- DAO支持(DAO Support)
- O/R映射(O/R Mapping).
- XML编列(XML Marshalling) 有点类似于java的序列化和反序列化



### 2.3 Web技术

- Veb Servlet技术栈
	- Spring MVC
	- WebSocket
	- SockJS

- Veb Reactive技术栈
	- Spring WebFlux
	- WebClient （异步回调）
	- WebSocket


### 2.4 技术整合


- 远程调用(Remoting) （一般是同步的调用方式）
- Java消息服务(JMS)（一般是异步的调用方式）
- Java连接架构（JCA)
- Java管理扩展(JMX)
- Java邮件客户端(Email)
- 本地任务(Tasks)
- 本地调度(Scheduling)
- 缓存抽象(Caching)
- Spring测试(Testing)


### 2.5 测试Test

- 模拟对象(Mock Objects)
- TestContext框架(TestContext Framework)
- Spring MVC测试(Spring MVC Test)
- Web测试客户端(WebTestClient)









