# Spring 依赖注入的方式


依赖注入是Spring协调不同Bean实例之间的合作而提供的一种工作机制，在确保Bean实例之间合作的同时，并能保持每个Bean的相对独立性。

## 基于构造函数注入

构造函数注入就是通过Bean类的构造方法，将bean所依赖的对象注入。构造函数的参数一般就是依赖项，spring容器会根据bean中指定的构造函数来决定调用哪个构造。

## 基于set方法的注入

将bean所依赖的对象通过设置函数注入，bean需要为注入的依赖对象提供设置方法。


## 基于自动装配的注入

Spring IOC容器会基于反射查看bean定义的类，当spring容器发现bean被设置为自动装配的 **by type** 模式后，他会根据参数类型在Spring容器中查找于参数类型相同的被依赖bean对象，如果已经创建，则会把被依赖的对象自动注入到bean中，如果没有创建，则不会注入。

注入的过程中需要借助Bean提供的设置方法来完成，否则注入失败。

## 基于注解的依赖注入

Spring主要提供了@Autowired和@Resource注解模式。

### Autowired

默认按照类型装配（这个注解时Spring的），默认情况下必须要求依赖对象必须存在，如果要允许null值，可以设置他的required属性为false。
如果我们想要使用名称装配可以结合@Qulifier注解进行使用。


### Resource装配顺序

1. 如果同时制定了name和type。则spring上下文中找到唯一匹配的bean进行装配，找不到则抛出异常。
2. 如果指定了name，则从上下文中查找名称（ id）匹配的bean进行装配，找不到则抛出异常
3. 如果制定了type，则从上下文中找到类型匹配的唯一bean进行装配，找不到或者找到多个，都会抛出异常




