---
title: 一条sql是如何执行的
toc: true
date: 2021-12-06 18:35:29
tags: MySQL
categories:
---


# 一条sql到底是怎么执行的？

这个问题等同于： **请将一下mysql的基础架构**

## MySQL的逻辑架构

我们经常说，看一个事儿千万不 要直接陷入细节里，你应该先鸟瞰其全貌，这样能够帮助你从高维度理解问题。同样，对于 MySQL的学习也是这样。平时我们使用数据库，看到的通常都是一个整体。比如，你有个最简 单的表，表里只有一个ID字段，在执行下面这个查询语句时:

```sql
mysql> select * from T where ID=10;
```



我们看到的只是输入一条语句，返回一个结果，却不知道这条语句在MySQL内部的执行过程。

所以今天我想和你一起把MySQL拆解一下，看看里面都有哪些“零件”，希望借由这个拆解过程， 让你对MySQL有更深入的理解。这样当我们碰到MySQL的一些异常或者问题时，就能够直戳本 质，更为快速地定位并解决问题。

下面我给出的是MySQL的基本架构示意图，从中你可以清楚地看到SQL语句在MySQL的各个功 能模块中的执行过程。

![MySQL的逻辑架构图](https://oscimg.oschina.net/oscnet/up-661c52fa2ca85182e119823265a003d152b.png)



大体来说，MySQL可以分为**Server层**和**存储引擎层**两部分。

Server层包括**连接器**、**查询缓存**、**分析器**、**优化器**、**执行器**等，涵盖MySQL的大多数核心服务 功能，以及所有的内置函数(如日期、时间、数学和加密函数等)，所有跨存储引擎的功能都在 这一层实现，比如存储过程、触发器、视图等。

而存储引擎层负责数据的存储和提取。其架构模式是插件式的，支持InnoDB、MyISAM、 Memory等多个存储引擎。现在最常用的存储引擎是InnoDB，它从MySQL 5.5.5版本开始成为了 默认存储引擎。

也就是说，你执行create table建表的时候，如果不指定引擎类型，默认使用的就是InnoDB。不 过，你也可以通过指定存储引擎的类型来选择别的引擎，比如在create table语句中使用 `engine=memory`, 来指定使用内存引擎创建表。不同存储引擎的表数据存取方式不同，支持的功 能也不同，在后面的文章中，我们会讨论到引擎的选择。

从图中不难看出，不同的存储引擎共用一个Server层 ，也就是从连接器到执行器的部分。你可 以先对每个组件的名字有个印象，接下来我会结合开头提到的那条SQL语句，带你走一遍整个执 行流程，依次看下每个组件的作用。



## 连接器

第一步，你会先连接到这个数据库上，这时候接待你的就是连接器。连接器负责跟客户端建立连 接、获取权限、维持和管理连接。连接命令一般是这么写的:

```sql
mysql -h$ip -P$port -u$user -p
```

输完命令之后，你就需要在交互对话里面输入密码。虽然密码也可以直接跟在-p后面写在命令行 中，但这样可能会导致你的密码泄露。如果你连的是生产服务器，强烈建议你不要这么做。

连接命令中的mysql是客户端工具，用来跟服务端建立连接。在完成经典的TCP握手后，连接器 就要开始认证你的身份，这个时候用的就是你输入的用户名和密码。

- 如果用户名或密码不对，你就会收到一个"Access denied for user"的错误，然后客户端程序 结束执行。
- 如果用户名密码认证通过，连接器会到权限表里面查出你拥有的权限。之后，这个连接里面 的权限判断逻辑，都将依赖于此时读到的权限。

这就意味着，一个用户成功建立连接后，即使你用管理员账号对这个用户的权限做了修改，也不会影响已经存在连接的权限。**修改完成后，只有再新建的连接才会使用新的权限设置**。

连接完成后，如果你没有后续的动作，这个连接就处于空闲状态，你可以在show processlist命 令中看到它。文本中这个图是show processlist的结果，其中的Command列显示为“Sleep”的这 一行，就表示现在系统里面有一个空闲连接。

![](https://oscimg.oschina.net/oscnet/up-2a647e124a6b81400ac56c8602d08803a29.png)

客户端如果太长时间没动静，连接器就会自动将它断开。这个时间是由参数`wait_timeout`控制 的，**默认值是8小时。**

如果在连接被断开之后，客户端再次发送请求的话，就会收到一个错误提醒: `Lost connection to MySQL server during query`。这时候如果你要继续，就需要重连，然后再执行请求了。

数据库里面，长连接是指连接成功后，如果客户端持续有请求，则一直使用同一个连接。短连接 则是指每次执行完很少的几次查询就断开连接，下次查询再重新建立一个。

建立连接的过程通常是比较复杂的，<font color=blue>所以我建议你在使用中要尽量减少建立连接的动作，也就是尽量使用长连接。</font>

但是全部使用长连接后，你可能会发现，有些时候MySQL占用内存涨得特别快，这是因为 MySQL在执行过程中临时使用的内存是管理在连接对象里面的。这些资源会在连接断开的时候才释放。所以如果长连接累积下来，可能导致内存占用太大，被系统强行杀掉(OOM)，从现 象看就是MySQL异常重启了。

怎么解决这个问题呢?你可以考虑以下两种方案。

- 定期断开长连接。使用一段时间，或者程序里面判断执行过一个占用内存的大查询后，断开 连接，之后要查询再重连。

- 如果你用的是MySQL5.7或更新版本，可以在每次执行一个比较大的操作后，通过执行 mysql_reset_connection来重新初始化连接资源。这个过程不需要重连和重新做权限验证， 但是会将连接恢复到刚刚创建完时的状态。



## 查询缓存

连接建立完成后，你就可以执行select语句了。执行逻辑就会来到第二步**:查询缓存。**

MySQL拿到一个查询请求后，会先到查询缓存看看，之前是不是执行过这条语句。之前执行过 的语句及其结果可能会以key-value对的形式，被直接缓存在内存中。key是查询的语句，value是 查询的结果。如果你的查询能够直接在这个缓存中找到key，那么这个value就会被直接返回给客 户端。

如果语句不在查询缓存中，就会继续后面的执行阶段。执行完成后，执行结果会被存入查询缓存 中。你可以看到，如果查询命中缓存，MySQL不需要执行后面的复杂操作，就可以直接返回结 果，这个效率会很高。

<font color=blue>但是大多数情况下我会建议你不要使用查询缓存，为什么呢? 因为查询缓存往往弊大于利。</font>

> 查询缓存的失效非常频繁，只要有对一个表的更新，这个表上所有的查询缓存都会被清空。因此 很可能你费劲地把结果存起来，还没使用呢，就被一个更新全清空了。对于更新压力大的数据库 来说，查询缓存的命中率会非常低。除非你的业务就是有一张静态表，很长时间才会更新一次。 比如，一个系统配置表，那这张表上的查询才适合使用查询缓存。

好在MySQL也提供了这种“按需使用”的方式。你可以将参数`query_cache_type`设置成 `DEMAND`，这样对于默认的SQL语句都不使用查询缓存。而对于你确定要使用查询缓存的语 句，可以用SQL_CACHE显式指定，像下面这个语句一样:

```sql
mysql> select SQL_CACHE * from T where ID=10;
```

<font color=red>需要注意的是，MySQL 8.0版本直接将查询缓存的整块功能删掉了，也就是说8.0开始彻底没有 这个功能了。</font>



## 分析器

如果没有命中查询缓存，就要开始真正执行语句了。首先，<font color=blue>MySQL需要知道你要做什么</font>，因此需要对SQL语句做解析。

分析器先会做“词法分析”。你输入的是由多个字符串和空格组成的一条SQL语句，MySQL需要识 别出里面的字符串分别是什么，代表什么。

MySQL从你输入的"select"这个关键字识别出来，这是一个查询语句。它也要把字符串“T”识别 成“表名T”，把字符串“ID”识别成“列ID”。

做完了这些识别以后，就要做“语法分析”。根据词法分析的结果，语法分析器会根据语法规则， 判断你输入的这个SQL语句是否满足MySQL语法。

如果你的语句不对，就会收到`“You have an error in your SQL syntax”`的错误提醒，比如下面这个 语句select少打了开头的字母“s”。

![](https://oscimg.oschina.net/oscnet/up-4b5816275605cf38dcea5964ab23bfc1e16.png)

<font color=red>一般语法错误会提示第一个出现错误的位置，所以你要关注的是紧接“use near”的内容。</font>



## 优化器

经过了分析器，MySQL就知道你要做什么了。在开始执行之前，还要先经过优化器的处理。

优化器是在表里面有多个索引的时候，决定使用哪个索引;或者在一个语句有多表关联(join)的时候，决定各个表的连接顺序。比如你执行下面这样的语句，这个语句是执行两个表的join:

```sql
mysql> select * from t1 join t2 using(ID)  where t1.c=10 and t2.d=20;
```

- 既可以先从表t1里面取出c=10的记录的ID值，再根据ID值关联到表t2，再判断t2里面d的值是 否等于20。
- 也可以先从表t2里面取出d=20的记录的ID值，再根据ID值关联到t1，再判断t1里面c的值是否 等于10。

这两种执行方法的逻辑结果是一样的，但是执行的效率会有不同，而优化器的作用就是决定选择使用哪一个方案。

优化器阶段完成后，这个语句的执行方案就确定下来了，然后进入执行器阶段。如果你还有一些 疑问，比如优化器是怎么选择索引的，有没有可能选择错等等，在后面的文章中单独展开说明优化器的内容。



## 执行器

<font color=blue>MySQL通过分析器知道了你要做什么，通过优化器知道了该怎么做，于是就进入了执行器阶 段，开始执行语句。</font>

开始执行的时候，要先判断一下你对这个表T有没有执行查询的权限，如果没有，就会返回没有 权限的错误，如下所示。

```
mysql> select * from T where ID=10;

ERROR 1142 (42000): SELECT command denied to user 'b'@'localhost' for table 'T'
```

如果有权限，就打开表继续执行。打开表的时候，执行器就会根据表的引擎定义，去使用**这个引擎**提供的接口。

比如我们这个例子中的表T中，ID字段没有索引，那么执行器的执行流程是这样的:

- 调用InnoDB引擎接口取这个表的第一行，判断ID值是不是10，如果不是则跳过，如果是则将这行存在结果集中;
- 调用引擎接口取“下一行”，重复相同的判断逻辑，直到取到这个表的最后一行。
- 执行器将上述遍历过程中所有满足条件的行组成的记录集作为结果集返回给客户端。

至此，这个语句就执行完成了。 对于有索引的表，执行的逻辑也差不多。

第一次调用的是“取满足条件的第一行”这个接口，之后循环取“满足条件的下一行”这个接口，这些接口都是引擎中已经定义好的。 你会在数据库的慢查询日志中看到一个rows_examined的字段，表示这个语句执行过程中扫描了多少行。

这个值就是在执行器每次调用引擎获取数据行的时候累加的。**在有些场景下，执行器调用一次，在引擎内部则扫描了多行，因此引擎扫描行数跟 rows_examined并不是完全相同的**。我们后面会专门有一篇文章来讲存储引擎的内部机制， 里面会有详细的说明。





## 问题

我给你留一个问题吧，如果表T中没有字段k，而你执行了这个语句 select * from T where k=1, 那 肯定是会报“不存在这个列”的错误: 	`“Unknown column ‘k’ in ‘where clause’”`。你觉得这个错误是 在我们上面提到的哪个阶段报出来的呢?



