---
title: "MySQL中的锁\U0001F512"
toc: true
date: 2021-08-19 15:17:31
tags: MySQL
categories:
---





乐观锁和悲观锁

### 表锁和行锁

> **表锁**： 开销小，加锁快；不会出现死锁；锁定力度大，发生锁冲突概率高，并发度最低

表锁按照数据操作可以分成两种：

- 表读锁（Table Read Lock）
- 表写锁（Table Write Lock

读读不阻塞：当前用户在读数据，其他的用户也在读数据，不会加锁

读写阻塞：当前用户在读数据，其他的用户**不能修改当前用户读的数据**，会加锁！

写写阻塞：当前用户在修改数据，其他的用户**不能修改当前用户正在修改的数据**，会加锁！



> **行锁**： 开销大，加锁慢；会出现死锁；锁定粒度小，发生锁冲突的概率低，并发度高

InnoDB实现了以下**两种**类型的行锁。

- 共享锁（S锁）：允许一个事务去读一行，阻止其他事务获得相同数据集的排他锁。
- 也叫做**读锁**：读锁是**共享**的，多个客户可以**同时读取同一个**资源，但**不允许其他客户修改**。

- 排他锁（X锁)：允许获得排他锁的事务更新数据，阻止其他事务取得相同数据集的共享读锁和排他写锁。
- 也叫做**写锁**：写锁是排他的，**写锁会阻塞其他的写锁和读锁**。



另外，**为了允许行锁和表锁共存，实现多粒度锁机制**，InnoDB还有两种内部使用的意向锁（Intention Locks），这两种意向锁都是**表锁**：

- 意向共享锁（IS）：事务打算给数据行加行共享锁，事务在给一个数据行加共享锁前必须先取得该表的IS锁。
- 意向排他锁（IX）：事务打算给数据行加行排他锁，事务在给一个数据行加排他锁前必须先取得该表的IX锁。
- 意向锁也是数据库隐式帮我们做了，**不需要程序员操心**！



⚠️ **InnoDB行锁和表锁都支持**！<font color=red>**MyISAM只支持表锁**！</font>

### innoDB什么时候会使用到行锁？

InnoDB只有通过**索引条件**检索数据**才使用行级锁**，否则，InnoDB将使用**表锁**



# 参考资料

[数据库两大神器【索引和锁】](https://mp.weixin.qq.com/s?__biz=MzI4Njg5MDA5NA==&mid=2247484721&idx=1&sn=410dea1863ba823bec802769e1e6fe8a&chksm=ebd74430dca0cd265a9a91dcb2059e368f43a25f3de578c9dbb105e1fba0947e1fd0b9c2f4ef&token=1676899695&lang=zh_CN###rd)

[基于数据表乐观锁实现分布式锁](https://geekibli.github.io/wiki/mysql%E4%B9%90%E8%A7%82%E9%94%81%E5%AE%9E%E7%8E%B0%E5%88%86%E5%B8%83%E5%BC%8F%E9%94%81/)

