---
title: MySQL-存储引擎
toc: true
date: 2021-08-25 14:19:10
tags: MySQL
categories:
---

# 存储引擎

**MySQL支持很多种存储引擎 👇**

<img src="https://xcu-oss.oss-cn-beijing.aliyuncs.com/image/gao/image-20210825143434715.png" style="zoom:50%;" />

<font color=blue> **有一个面试题：存储引擎是数据库级别的还是数据表级别的？**</font>

看上图应该就知道了吧！ **数据表**级别的

## InnoDB

InnoDB 是 MySQL 默认的事务型存储引擎，只要在需要它不支持的特性时，才考虑使用其他存储引擎。

InnoDB 采用 **MVCC 来支持高并发**，并且实现了四个标准隔离级别(未提交读、提交读、可重复读、可串行化)。其默认级别时可重复读（REPEATABLE READ），在可重复读级别下，通过 MVCC + Next-Key Locking 防止幻读。

主索引是**聚簇索引**，在索引中保存了数据，从而避免直接读取磁盘，因此对主键查询有很高的性能。

InnoDB 内部做了很多优化，包括从磁盘读取数据时采用的**可预测性读**（局部性原理），能够自动在内存中创建 hash 索引以加速读操作的自适应哈希索引，以及能够加速插入操作的插入缓冲区等。

InnoDB 支持真正的在线热备份，MySQL 其他的存储引擎不支持在线热备份，要获取一致性视图需要停止对所有表的写入，而在读写混合的场景中，停止写入可能也意味着停止读取。

支持行级锁，间隙锁。



## MyISAM

设计简单，数据以紧密格式存储。对于只读数据，或者表比较小、可以容忍修复操作，则依然可以使用它。

提供了大量的特性，包括**压缩表、空间数据索引**等。

不支持事务。

不支持行级锁，只能对整张表加锁，读取时会对需要读到的所有表加共享锁，写入时则对表加排它锁。但在表有读取操作的同时，也可以往表中插入新的记录，这被称为并发插入（CONCURRENT INSERT）。

可以手工或者自动执行检查和修复操作，但是和事务恢复以及崩溃恢复不同，可能导致一些数据丢失，而且修复操作是非常慢的。

如果指定了 DELAY_KEY_WRITE 选项，在每次修改执行完成时，不会立即将修改的索引数据写入磁盘，而是会写到内存中的键缓冲区，只有在清理键缓冲区或者关闭表的时候才会将对应的索引块写入磁盘。这种方式可以极大的提升写入性能，但是在数据库或者主机崩溃时会造成索引损坏，需要执行修复操作。



### InnoDB 和 MyISAM 的比较

- 事务：InnoDB 是事务型的，可以使用 Commit 和 Rollback 语句。
- 并发：MyISAM 只支持表级锁，而 InnoDB 还支持行级锁。
- 外键：InnoDB 支持外键。
- 备份：InnoDB 支持在线热备份。
- 崩溃恢复：MyISAM 崩溃后发生损坏的概率比 InnoDB 高很多，而且恢复的速度也更慢。
- 索引：InnoDB支持聚簇索引，MyISAM支持非聚簇索引
- 其它特性：MyISAM 支持压缩表和空间数据索引。



![image-20210825144111190](https://xcu-oss.oss-cn-beijing.aliyuncs.com/image/gao/image-20210825144111190.png)



由上图可以看出，InnoDB的叶子节点存储的是数据，而MyISAM的叶子节点存放的是数据所在的地址。

InnoDB是通过B+树结构对主键创建索引，然后叶子节点中存储记录，如果没有主键，则会选择一个唯一键，如果也没有唯一键，则会自动生成一个6位数的row_id作为主键

如果创建索引的键是其他字段，那么叶子节点中存储的是该记录的主键，通过主键索引找到对应的记录，此过程称之为回表。


