# JVM-类加载机制

## 1. 类加载机制具体流程

<img src="https://xcu-oss.oss-cn-beijing.aliyuncs.com/image/gao/image-20210730171153387.png" alt="image-20210730171153387" style="zoom:67%;" />

Java 的类加载过程可以分为 5 个阶段：载入、验证、准备、解析和初始化。这 5 个阶段一般是顺序发生的，但在动态绑定的情况下，解析阶段发生在初始化阶段之后。

### 1.1 Loading（载入）

>  JVM 在该阶段的主要目的是将字节码从不同的数据源（可能是 class 文件、也可能是 jar 包，甚至网络）转化为二进制字节流加载到内存中，并生成一个代表该类的 java.lang.Class 对象。

1. 通过一个类的全限定名来获取定义次类的二进制流(ZIP 包、网络、运算生成、JSP 生成、数据库读取)。
2. 将这个字节流所代表的静态存储结构转化为方法区的运行时数据结构。
3. 在内存中生成一个代表这个类的 java.lang.Class 对象，作为方法去这个类的各种数据的访问入口。

**数组类的特殊性**：`数组类本身不通过类加载器创建，它是由 Java 虚拟机直接创建的`。但数组类与类加载器仍然有很密切的关系，因为数组类的元素类型最终是要靠类加载器去创建的，数组创建过程如下：

1. 如果数组的组件类型是引用类型，那就递归采用类加载加载。
2. 如果数组的组件类型不是引用类型，Java 虚拟机会把数组标记为引导类加载器关联。
3. 数组类的可见性与他的组件类型的可见性一致，如果组件类型不是引用类型，那数组类的可见性将默认为 public。

内存中实例的 java.lang.Class 对象存在方法区中。作为程序访问方法区中这些类型数据的外部接口。
加载阶段与连接阶段的部分内容是交叉进行的，但是开始时间保持先后顺序。

java agent发生在加载环节，用来增强字节码。

### 1.2 Verification（验证）

JVM 会在该阶段对二进制字节流进行校验，只有符合 JVM 字节码规范的才能被 JVM 正确执行。该阶段是保证 JVM 安全的重要屏障，下面是一些主要的检查。

##### 1.2.1 文件格式验证

1. 是否以魔数 0xCAFEBABE 开头
2. 主、次版本号是否在当前虚拟机处理范围之内
3. 常量池的常量是否有不被支持常量的类型（检查常量 tag 标志）
4. 指向常量的各种索引值中是否有指向不存在的常量或不符合类型的常量
5. CONSTANT_Utf8_info 型的常量中是否有不符合 UTF8 编码的数据
6. Class 文件中各个部分集文件本身是否有被删除的附加的其他信息
7. ……

只有通过这个阶段的验证后，字节流才会进入内存的方法区进行存储，所以后面 3 个验证阶段全部是基于方法区的存储结构进行的，不再直接操作字节流。

##### 1.2.2 元数据验证

1. 这个类是否有父类（除 java.lang.Object 之外）
2. 这个类的父类是否继承了不允许被继承的类（final 修饰的类）
3. 如果这个类不是抽象类，是否实现了其父类或接口之中要求实现的所有方法
4. 类中的字段、方法是否与父类产生矛盾（覆盖父类 final 字段、出现不符合规范的重载）

这一阶段主要是对类的元数据信息进行语义校验，保证不存在不符合 Java 语言规范的元数据信息。

##### 1.2.3 字节码验证

1. 保证任意时刻操作数栈的数据类型与指令代码序列都鞥配合工作（不会出现按照 long 类型读一个 int 型数据）
2. 保证跳转指令不会跳转到方法体以外的字节码指令上
3. 保证方法体中的类型转换是有效的（子类对象赋值给父类数据类型是安全的，反过来不合法的）
4. ……

这是整个验证过程中最复杂的一个阶段，主要目的是通过数据流和控制流分析，确定程序语义是合法的、符合逻辑的。这个阶段对类的方法体进行校验分析，保证校验类的方法在运行时不会做出危害虚拟机安全的事件。

##### 1.2.4 符号引用验证

1. 符号引用中通过字符创描述的全限定名是否能找到对应的类
2. 在指定类中是否存在符方法的字段描述符以及简单名称所描述的方法和字段
3. 符号引用中的类、字段、方法的访问性（private、protected、public、default）是否可被当前类访问
4. ……

最后一个阶段的校验发生在迅疾将符号引用转化为直接引用的时候，这个转化动作将在连接的第三阶段——解析阶段中发生。符号引用验证可以看做是对类自身以外（常量池中的各种符号引用）的信息进行匹配性校验，还有以上提及的内容。
符号引用的目的是确保解析动作能正常执行，如果无法通过符号引用验证将抛出一个 java.lang.IncompatibleClass.ChangeError 异常的子类。如 java.lang.IllegalAccessError、java.lang.NoSuchFieldError、java.lang.NoSuchMethodError 等。

### 1.3 Preparation（准备）

##### 1.3.1 设置默认值

JVM 会在该阶段对类变量（也称为静态变量，static 关键字修饰的）分配内存并初始化（对应数据类型的默认初始值，如 0、0L、null、false 等）。

也就是说，假如有这样一段代码：

```java
public String chenmo = "沉默";
public static String wanger = "王二";
public static final String cmower = "沉默王二";
```

chenmo 不会被分配内存，而 wanger 会；但 wanger 的初始值不是“王二”而是 null。

需要注意的是，static final 修饰的变量被称作为常量，和类变量不同。常量一旦赋值就不会改变了，所以 cmower 在准备阶段的值为“沉默王二”而不是 null。

##### 1.3.2 各种类型默认值

<img src="https://xcu-oss.oss-cn-beijing.aliyuncs.com/image/gao/image-20210730170747559.png" alt="image-20210730170747559" style="zoom:33%;" />

### 1.4 Resolution（解析）

该阶段将常量池中的符号引用转化为直接引用。

`**符号引用**` : 以一组符号（任何形式的字面量，只要在使用时能够无歧义的定位到目标即可）来描述所引用的目标。

`**直接引用**` : 直接引用可以使直接指向目标的指针、相对偏移量或是一个能间接定位到目标的句柄。直接引用和迅疾的内存布局实现有关

在编译时，Java 类并不知道所引用的类的实际地址，因此只能使用符号引用来代替。比如 com.Wanger 类引用了 com.Chenmo 类，编译时 Wanger 类并不知道 Chenmo 类的实际内存地址，因此只能使用符号 com.Chenmo。

直接引用通过对符号引用进行解析，找到引用的实际内存地址。

### 1.5 Initialization（初始化）

该阶段是类加载过程的最后一步。在准备阶段，类变量已经被赋过默认初始值，而在初始化阶段，类变量将被赋值为代码期望赋的值。换句话说，初始化阶段是执行类构造器方法的过程。

oh，no，上面这段话说得很抽象，不好理解，对不对，我来举个例子。

`String cmower = new String("沉默王二");`
上面这段代码使用了 new 关键字来实例化一个字符串对象，那么这时候，就会调用 String 类的构造方法对 cmower 进行实例化。

<font color=blue>**面试题，什么时候后触发初始化**</font>

1、创建类的实例的时候，new一个对象

2、访问某个类或接口的静态变量，或者对该静态变量赋值

3、调用类的静态方法

4、反射

5、初始化某个类的子类，则其父类也会被初始化

6、Java虚拟机启动时被标记为启动类的类

## 2. 双亲委派机制

聊完类加载过程，就不得不聊聊类加载器。

### 2.1 什么是类加载

<img src="https://xcu-oss.oss-cn-beijing.aliyuncs.com/image/gao/image-20210730171408574.png" alt="image-20210730171408574" style="zoom:50%;" />

一般来说，Java 程序员并不需要直接同类加载器进行交互。JVM 默认的行为就已经足够满足大多数情况的需求了。不过，如果遇到了需要和类加载器进行交互的情况，而对类加载器的机制又不是很了解的话，就不得不花大量的时间去调试 
ClassNotFoundException 和 NoClassDefFoundError 等异常。

***对于任意一个类，都需要由它的类加载器和这个类本身一同确定其在 JVM 中的唯一性。也就是说，如果两个类的加载器不同，即使两个类来源于同一个字节码文件，那这两个类就必定不相等（比如两个类的 Class 对象不 equals）。***

站在程序员的角度来看，Java 类加载器可以分为三种。

1）**启动类加载器**（Bootstrap Class-Loader），加载 jre/lib 包下面的 jar 文件，比如说常见的 rt.jar。

2）**扩展类加载器**（Extension or Ext Class-Loader），加载 jre/lib/ext 包下面的 jar 文件。

3）**应用类加载器**（Application or App Clas-Loader），根据程序的类路径（classpath）来加载 Java 类。

来来来，通过一段简单的代码了解下。

```java
public class Test {

    public static void main(String[] args) {
        ClassLoader loader = Test.class.getClassLoader();
        while (loader != null) {
            System.out.println(loader.toString());
            loader = loader.getParent();
        }
    }

}
```
每个 Java 类都维护着一个指向定义它的类加载器的引用，通过 类名.class.getClassLoader() 可以获取到此引用；然后通过 loader.getParent() 可以获取类加载器的上层类加载器。

这段代码的输出结果如下：

sun.misc.Launcher$AppClassLoader@73d16e93
sun.misc.Launcher$ExtClassLoader@15db9742
第一行输出为 Test 的类加载器，即应用类加载器，它是 sun.misc.Launcher$AppClassLoader 类的实例；第二行输出为扩展类加载器，是 sun.misc.Launcher$ExtClassLoader 类的实例。那启动类加载器呢？

按理说，扩展类加载器的上层类加载器是启动类加载器，但在我这个版本的 JDK 中， 扩展类加载器的 getParent() 返回 null。所以没有输出。

### 2.2 双亲委派的意义

使用双亲委派模型，Java类随着它的加载器一起具备了一种带有优先级的层次关系，通过这种层次模型，可以避免类的重复加载，也可以避免核心类被不同的类加载器加载到内存中造成冲突和混乱，从而保证了Java核心库的安全。

## 3. 类加载的应用

https://juejin.cn/post/6931972267609948167

- 类加载
- 热部署
- 加密保护
- 依赖冲突

## 4. 双亲委派如何破坏

线程上下文加载器

https://enfangzhong.github.io/2019/12/17/%E6%B7%B1%E5%85%A5%E7%90%86%E8%A7%A3Java%E8%99%9A%E6%8B%9F%E6%9C%BA%E4%B9%8B%E7%A0%B4%E5%9D%8F%E5%8F%8C%E4%BA%B2%E5%A7%94%E6%B4%BE%E5%8A%A0%E8%BD%BD%E6%9C%BA%E5%88%B6/

https://www.cnblogs.com/joemsu/p/9310226.html#_caption_2



## 5、类卸载发生在什么时候

同时满足一下三种情况 👇

1、该类的所有实例都已经被回收，也就是说堆中不存在该类的任何实例

2、加载该类的ClassLoader已经被回收

3、该类对应的java.lang.Class对象没有任何地方被引用，无法在任何地方通过反射访问类的方法

