

## 1 前言
由于现在微服务很流行，越来越多企业采用了SpringCloud微服务架构，而SpringBoot则是快速构建微服务项目的利器。于是**源码笔记**以此为切入点，将SpringBoot作为我们源码分析的第一个开源项目，之后还会对更多开源项目进行源码分析。要进行源码分析，笔者结合自身经历来跟大家聊聊**我们为什么要学习源码**这个话题，大家一起探讨学习。

我们程序员在开发代码时每天都在使用别人写好的框架，无论你是在使用Spring生态的Spring核心，SpringMVC,SpringBoot和SpringCloud等框架，还是在使用阿里系的Dubbo,RocketMQ,Seata,Druid等中间件框架，亦或你是搞大数据的，在使用Apache组织的Zookeeper,Hadoop,Hive,Spark等大数据组件框架，这些开源框架都给我们的项目编码带来了极大的方便，促进了我们的开发效率。是的，这些都是开源大神们帮我们造好的轮子，我们直接使用即可，而且用起来很少出bug，因为这些框架一般都是经过考验的才能流行起来。

可能大部分人会认为，这些轮子都已经造好了，我们直接用即可。是的，这些开源框架对我们使用来说是透明的，它们就像一个个黑盒子。至于这些黑盒里面装的是什么东西，里面是怎样构造的，如果没有去探究这些黑盒的话，我们无从得知。但是，我们做开发的天天跟这些黑盒打交道，难道你就没有一种强烈的欲望想知道这些黑盒里面装的是什么东西，黑盒里面是怎样构造的么？难道你就不想知道我们天天使用的黑盒子里面的原理么？

**那么今天就跟小伙伴们聊聊“我们为什么要学习开源框架源码？学习开源框架源码对我们有用吗？”这个话题。**
## 2 我们为什么要学习源码？花那么多时间去学习源码值得么？
可能有些同学会问：我们为什么要去学习源码？花那么多时间去学习源码值得么？

对于这个问题，应该很多小伙伴在没读源码前深有感触。当时应该就是这种观念，反正开源框架一些外面的大牛帮我们封装好了，自己开箱即用即可，管它里面黑盒机制是啥。应该很多小伙伴也是这种观念，导致自己在开发项目时若遇到bug时一筹莫展，百度了很多解决方案都无效，故而浪费了很多时间。于是才会决心钻研一些常用框架的源码。可见，**没必要学习源码的观念**是可能是最错误的观念吧，个人观点（仅供参考）。

**我们学习源码无非有以下几个原因：**

**1）开发项目需求需要**

一方面，通常我们在开发项目的时候，遇到Bug是再正常不过的事情。比如某个工作项目采用了Spring生态系列的框架比如SpringBoot,SpringCloud等，当出现问题时自己要会解决，如果我们不懂框架里面的黑盒机制，当出现问题我们肯定会一头雾水，不知如何着手解决开源框架出现的问题，此时我们肯定会去百度，但百度的文章质量参差不齐，最坏的结果可能就是我们根据百度的解决方案，一个一个去试了，但仍然没有解决问题。这就是对框架黑盒机制不熟悉的原因导致的。

另一方面，我们在开发项目的时候，有时候开源框架不能完全符合我们的业务需求，此时我们需要对开源框架进行扩展甚至是改造，比如我们正在使用dubbo框架，若dubbo自带负载均衡策略不能满足我们的业务需求，此时我们是不是得要对dubbo的负载均衡策略进行替换或扩展。幸好，dubbo提供了SPI接口给我们即插即用，此时我们不用研究dubbo里面的黑盒也可以做到替换现有的负载均衡策略。那假如有一天，我们要对某个开源项目进行改造呢？此时是不是也需要我们知道开源框架的黑盒机制，若不懂框架黑盒原理，此时我们是无法下手的。

由于项目开发需要的以上原因，所以我们平时有空时就要多学习源码，多探究里面的黑盒机制，**磨刀不误砍柴工**。

这个就是典型的项目开发需求驱动我们不得不去研究开源框架的源码机制的原因吧。

**2）对技术饱含热爱，不断深入学习黑盒机制**

是的，除了项目需求开发需要去研究源码外，应该很多小伙伴都是出于对技术的追求去研究开源框架源码。他们为了不断提高自己的编码能力，去不断学习外面大牛们的优秀作品。是的，大家都知道，**闭门造车可以说是造不出名车的**，此时，我们必须去学习大牛们优秀的开源作品，学习他们是怎么面向对象编程的，学习他们是如何熟练运用设计模式的，学习他们是怎样设计接口的等等，真的有太多需要我们学习了。如果我们走的是技术路线，对技术还有更高的追求，学习源码可以说是我们绕不过去的路。因此，行动起来吧，源码搞起来，我们只有不断学习源码，以后再阅读其他项目的源码时才会游刃有余。

**3）有些人学习源码，可能是为了面试**

当然，有些人学习源码，可能是为了面试。因为现在很多面试若面试官稍微问难一点的问题都会涉及源码，往往很多人就是对源码不熟悉而挂掉。因为一部分小伙伴往往就是为了面试才去学习源码，但是往往这种为了面试才去学习源码的方式效果没有前面的项目驱动方式和技术追求方式的效果那么好（个人观点，不喜勿喷）。因为，有些同学为了面试，通常都是短期突击源码，为了某个面试问题而背诵一些答案，因为死记硬背的居多，所以这种方式往往深入不了源码的精髓。当然，不管出于什么目的学习源码都理应鼓励，因为毕竟去学习源码了肯定就会有提高，就踏出了与众不同的一步。

## 3 学习源码，我们能得到什么？

是的，既然我们花费了那么多时间去学习源码，去研究源码？我们的收益有多少，我们究竟能得到多少回到回报呢？可以先肯定的回答，当然有很大的回报。前面也说过，学习开源框架源码能帮助我们解决项目遇到的bug，扩展我们的项目需求；通过学习源码，学习开源大牛们是如何运用设计模式的，然后运用到我们开发的项目中，使我们的项目的模块更易于扩展；通过学习源码，我们能编码更高效。为什么呢？如果我们对某个开源项目源码很熟悉，那么我们就可以对这个项目的源码信手拈来应用到自己项目中，不是么？总之学习源码好处多多，这也是成为大牛们的必经之路吧，只有学习和借鉴别人优秀的作品，自己才能造出更优秀的作品。说到这点，不得不说下RocketMQ，RocketMQ是阿里的一款优秀的开源中间件，RocketMQ之所以性能高吞吐，抗得住阿里双十一的考验，其正是很多方面借鉴了Kafka的设计；此外，记得Dubbo的一个缓冲类也是借鉴了Netty的ByteBuf类。

是吧，要造出一些优秀的作品，必须去学习借鉴别人的优秀作品。

## 4 要想不被淘汰，必须学习源码

最后要说的是，要想不被淘汰，我们必须学习源码。

现在程序员越来越多，可以说竞争尤其激烈。如果我们想不被淘汰，则我们时刻要保持竞争力，那么必然要时刻学习，终生学习，**生而有涯而学无涯**。因为CRUD大家都会，要提高自己的技术能力，此时学习开源项目的源码就尤为关键了。**如果我们不想成为CRUD工程师，还有更高的技术追求，那么我们就要有更高的要求**。当然，学习开源项目源码的目的是借鉴大牛们的优秀作品，最终要学以致用。另外，个人观点：**学习源码是提高自己编码能力的最好方式**。
>**如果我们走的是技术路线而非管理路线，若还有更高的技术追求，那么学习源码是我们绕不过去的砍。
真的，学习源码实在是太重要了。**

只要我们还有更高的技术追求，或许你想成为技术大牛，但是学习源码是成为大牛的必经之路。不是每个人都能成为大牛，但不学源码就肯定成为不了大牛，因为学习源码是提高自己的最好方式，不论何时，学习源码都不会晚，共勉！
>**Are u ready?**

----------------------------------------------------------------------------------------
**原创不易，帮忙Star一下呗**！
