/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world;

import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.toclient.BiomeSyncPacket;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.chunkio.ChunkIOExecutor;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;

public class WorldUtil {
    private static final MethodHandle getBiomeShortHandle;

    public static void setBiome(World world, int x, int z, BiomeGenBase biome) {
        Chunk chunk = world.func_72938_d(x, z);
        if (Loader.isModLoaded((String)"endlessids")) {
            short[] array = WorldUtil.getBiomeShortArray(chunk);
            array[(z & 0xF) << 4 | x & 0xF] = (short)biome.field_76756_M;
        } else {
            chunk.func_76605_m()[(z & 0xF) << 4 | x & 0xF] = (byte)(biome.field_76756_M & 0xFF);
        }
        chunk.field_76643_l = true;
    }

    public static void syncBiomeChange(World world, int x, int z) {
        Chunk chunk = world.func_72938_d(x, z);
        if (Loader.isModLoaded((String)"endlessids")) {
            PacketDispatcher.wrapper.sendToAllAround(new BiomeSyncPacket(x >> 4, z >> 4, WorldUtil.getBiomeShortArray(chunk)), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)x, 128.0, (double)z, 1024.0));
        } else {
            PacketDispatcher.wrapper.sendToAllAround(new BiomeSyncPacket(x >> 4, z >> 4, chunk.func_76605_m()), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)x, 128.0, (double)z, 1024.0));
        }
    }

    public static void syncBiomeChangeBlock(World world, int x, int z) {
        Chunk chunk = world.func_72938_d(x, z);
        if (Loader.isModLoaded((String)"endlessids")) {
            short biome = WorldUtil.getBiomeShortArray(chunk)[(z & 0xF) << 4 | x & 0xF];
            PacketDispatcher.wrapper.sendToAllAround(new BiomeSyncPacket(x, z, biome), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)x, 128.0, (double)z, 1024.0));
        } else {
            byte biome = chunk.func_76605_m()[(z & 0xF) << 4 | x & 0xF];
            PacketDispatcher.wrapper.sendToAllAround(new BiomeSyncPacket(x, z, biome), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)x, 128.0, (double)z, 1024.0));
        }
    }

    public static void syncBiomeChange(World world, Chunk chunk) {
        ChunkCoordIntPair coord = chunk.func_76632_l();
        if (Loader.isModLoaded((String)"endlessids")) {
            PacketDispatcher.wrapper.sendToAllAround(new BiomeSyncPacket(coord.field_77276_a, coord.field_77275_b, WorldUtil.getBiomeShortArray(chunk)), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)coord.func_77273_a(), 128.0, (double)coord.func_77274_b(), 1024.0));
        } else {
            PacketDispatcher.wrapper.sendToAllAround(new BiomeSyncPacket(coord.field_77276_a, coord.field_77275_b, chunk.func_76605_m()), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)coord.func_77273_a(), 128.0, (double)coord.func_77274_b(), 1024.0));
        }
    }

    public static short[] getBiomeShortArray(Chunk chunk) {
        try {
            return getBiomeShortHandle.invokeExact(chunk);
        }
        catch (Throwable ex) {
            throw new AssertionError();
        }
    }

    public static void loadAndSpawnEntityInWorld(Entity entity) {
        World world = entity.field_70170_p;
        int chunkX = MathHelper.func_76128_c((double)(entity.field_70165_t / 16.0));
        int chunkZ = MathHelper.func_76128_c((double)(entity.field_70161_v / 16.0));
        int loadRadius = 2;
        for (int k = chunkX - loadRadius; k <= chunkX + loadRadius; ++k) {
            for (int l = chunkZ - loadRadius; l <= chunkZ + loadRadius; ++l) {
                world.func_72964_e(k, l);
            }
        }
        if (!world.field_72996_f.contains(entity) && !MinecraftForge.EVENT_BUS.post((Event)new EntityJoinWorldEvent(entity, world))) {
            world.func_72964_e(chunkX, chunkZ).func_76612_a(entity);
            world.field_72996_f.add(entity);
            world.func_72923_a(entity);
        }
    }

    public static Chunk provideChunk(WorldServer world, int chunkX, int chunkZ) {
        try {
            ChunkProviderServer provider = world.field_73059_b;
            Chunk chunk = (Chunk)provider.field_73244_f.func_76164_a(ChunkCoordIntPair.func_77272_a((int)chunkX, (int)chunkZ));
            if (chunk != null) {
                return chunk;
            }
            return WorldUtil.loadChunk(world, provider, chunkX, chunkZ);
        }
        catch (Throwable x) {
            return null;
        }
    }

    private static Chunk loadChunk(WorldServer world, ChunkProviderServer provider, int chunkX, int chunkZ) {
        long chunkCoord = ChunkCoordIntPair.func_77272_a((int)chunkX, (int)chunkZ);
        provider.field_73248_b.remove(chunkCoord);
        Chunk chunk = (Chunk)provider.field_73244_f.func_76164_a(chunkCoord);
        AnvilChunkLoader loader = null;
        if (provider.field_73247_e instanceof AnvilChunkLoader) {
            loader = (AnvilChunkLoader)provider.field_73247_e;
        }
        if (chunk == null && loader != null && loader.chunkExists((World)world, chunkX, chunkZ)) {
            chunk = ChunkIOExecutor.syncChunkLoad((World)world, (AnvilChunkLoader)loader, (ChunkProviderServer)provider, (int)chunkX, (int)chunkZ);
        }
        return chunk;
    }

    static {
        if (Loader.isModLoaded((String)"endlessids")) {
            try {
                MethodHandles.Lookup lookup = MethodHandles.publicLookup();
                MethodType methodType = MethodType.methodType(short[].class);
                getBiomeShortHandle = lookup.findVirtual(Chunk.class, "getBiomeShortArray", methodType);
            }
            catch (Exception e) {
                throw new AssertionError();
            }
        } else {
            getBiomeShortHandle = null;
        }
    }
}

