/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.network;

import com.hbm.interfaces.NotableComments;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.tileentity.network.RequestNetwork;
import com.hbm.util.HashedSet;
import com.hbm.util.ParticleUtil;
import com.hbm.util.fauxpointtwelve.BlockPos;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;

@NotableComments
public abstract class TileEntityRequestNetwork
extends TileEntityLoadedBase {
    public HashedSet<RequestNetwork.PathNode> reachableNodes = new HashedSet();
    public HashedSet<RequestNetwork.PathNode> knownNodes = new HashedSet();
    public static final int maxRange = 24;

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 20L == 0L) {
            BlockPos pos = this.getCoord();
            RequestNetwork.PathNode newNode = this.createNode(pos);
            newNode.active = !this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            TileEntityRequestNetwork.push(this.field_145850_b, newNode);
            Iterator it = this.knownNodes.iterator();
            HashedSet<RequestNetwork.PathNode> localNodes = TileEntityRequestNetwork.getAllLocalNodes(this.field_145850_b, this.field_145851_c, this.field_145849_e, 2);
            localNodes.remove(pos);
            while (it.hasNext()) {
                RequestNetwork.PathNode node = (RequestNetwork.PathNode)it.next();
                if (localNodes.contains(node)) continue;
                this.reachableNodes.remove(node);
                it.remove();
            }
            for (RequestNetwork.PathNode known : this.knownNodes) {
                if (!this.reachableNodes.contains(known)) continue;
                ParticleUtil.spawnDroneLine(this.field_145850_b, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (double)(known.pos.getX() - pos.getX()) / 2.0, (double)(known.pos.getY() - pos.getY()) / 2.0, (double)(known.pos.getZ() - pos.getZ()) / 2.0, this.reachableNodes.contains(known) ? 65280 : 0xFF0000);
            }
            for (RequestNetwork.PathNode known : this.knownNodes) {
                if (!TileEntityRequestNetwork.hasPath(this.field_145850_b, pos, known.pos)) {
                    this.reachableNodes.remove(known);
                    continue;
                }
                this.reachableNodes.add(known);
            }
            int newNodeLimit = 5;
            for (RequestNetwork.PathNode node : localNodes) {
                if (!TileEntityRequestNetwork.areNodesConnectable(node, newNode)) continue;
                if (!this.knownNodes.contains(node) && !node.equals(pos)) {
                    --newNodeLimit;
                    this.knownNodes.add(node);
                    if (TileEntityRequestNetwork.hasPath(this.field_145850_b, pos, node.pos)) {
                        this.reachableNodes.add(node);
                    }
                }
                if (newNodeLimit > 0) continue;
                break;
            }
        }
    }

    public static boolean areNodesConnectable(RequestNetwork.PathNode node1, RequestNetwork.PathNode node2) {
        return node1.torchWaypoint || node2.torchWaypoint;
    }

    public abstract RequestNetwork.PathNode createNode(BlockPos var1);

    public BlockPos getCoord() {
        return new BlockPos(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasPath(World world, BlockPos pos1, BlockPos pos2) {
        Vec3 vec2;
        Vec3 vec1 = Vec3.func_72443_a((double)((double)pos1.getX() + 0.5), (double)((double)pos1.getY() + 0.5), (double)((double)pos1.getZ() + 0.5));
        Vec3 vec3 = vec1.func_72444_a(vec2 = Vec3.func_72443_a((double)((double)pos2.getX() + 0.5), (double)((double)pos2.getY() + 0.5), (double)((double)pos2.getZ() + 0.5)));
        if (vec3.func_72433_c() > 24.0) {
            return false;
        }
        MovingObjectPosition mop0 = world.func_147447_a(vec1, vec2, false, true, false);
        MovingObjectPosition mop2 = world.func_147447_a(vec2, vec1, false, true, false);
        if (mop0 != null) {
            MovingObjectPosition.MovingObjectType cfr_ignored_0 = mop0.field_72313_a;
            if (mop0.field_72313_a != MovingObjectPosition.MovingObjectType.MISS) return false;
        }
        if (mop2 == null) return true;
        MovingObjectPosition.MovingObjectType cfr_ignored_1 = mop2.field_72313_a;
        if (mop2.field_72313_a != MovingObjectPosition.MovingObjectType.MISS) return false;
        return true;
    }

    public static void push(World world, RequestNetwork.PathNode node) {
        ChunkCoordIntPair chunkPos;
        HashedSet<RequestNetwork.PathNode> posList;
        HashMap<Object, HashedSet<RequestNetwork.PathNode>> coordMap = RequestNetwork.activeWaypoints.get(world);
        if (coordMap == null) {
            coordMap = new HashMap();
            RequestNetwork.activeWaypoints.put(world, coordMap);
        }
        if ((posList = coordMap.get(chunkPos = new ChunkCoordIntPair(node.pos.getX() >> 4, node.pos.getZ() >> 4))) == null) {
            posList = new HashedSet();
            coordMap.put(chunkPos, posList);
        }
        posList.add(node);
    }

    public static HashedSet<RequestNetwork.PathNode> getAllLocalNodes(World world, int x, int z, int range) {
        HashedSet<RequestNetwork.PathNode> nodes = new HashedSet<RequestNetwork.PathNode>();
        HashedSet pos = new HashedSet();
        x >>= 4;
        z >>= 4;
        HashMap<ChunkCoordIntPair, HashedSet<RequestNetwork.PathNode>> coordMap = RequestNetwork.activeWaypoints.get(world);
        if (coordMap == null) {
            return nodes;
        }
        for (int i = -range; i <= range; ++i) {
            for (int j = -range; j <= range; ++j) {
                HashedSet<RequestNetwork.PathNode> nodeList = coordMap.get(new ChunkCoordIntPair(x + i, z + j));
                if (nodeList == null) continue;
                for (RequestNetwork.PathNode node : nodeList) {
                    if (pos.contains(node.pos)) continue;
                    nodes.add(node);
                }
            }
        }
        return nodes;
    }
}

