/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.rbmk;

import com.hbm.config.GeneralConfig;
import com.hbm.main.MainRegistry;
import com.hbm.util.GameRuleHelper;
import com.hbm.util.Tuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;

public class RBMKDials {
    public static HashMap<RBMKKeys, List<Tuple.Pair<World, Object>>> gameRules = new HashMap();

    public static void createDials(World world) {
        RBMKDials.createDials(world, false);
    }

    public static void createDials(World world, boolean forceRecreate) {
        GameRules rules = world.func_82736_K();
        for (RBMKKeys key : RBMKKeys.values()) {
            gameRules.put(key, new ArrayList());
        }
        RBMKDials.refresh(world);
        if (!rules.func_82766_b(RBMKKeys.KEY_SAVE_DIALS.keyString) || forceRecreate) {
            for (RBMKKeys key : RBMKKeys.values()) {
                rules.func_82764_b(key.keyString, String.valueOf(key.defValue));
            }
        }
    }

    public static void refresh(World world) {
        ArrayList<Tuple.Pair<World, Object>> toRemove = new ArrayList<Tuple.Pair<World, Object>>();
        for (List<Tuple.Pair<World, Object>> values : gameRules.values()) {
            for (Tuple.Pair<World, Object> pair : values) {
                if (pair.key != world) continue;
                toRemove.add(pair);
            }
            for (Tuple.Pair<Object, Object> pair : toRemove) {
                values.remove(pair);
            }
            toRemove.clear();
        }
        gameRules.get((Object)RBMKKeys.KEY_PASSIVE_COOLING).add(new Tuple.Pair<World, Double>(world, GameRuleHelper.getDoubleMinimum(world, RBMKKeys.KEY_PASSIVE_COOLING, 0.0)));
        gameRules.get((Object)RBMKKeys.KEY_COLUMN_HEAT_FLOW).add(new Tuple.Pair<World, Double>(world, GameRuleHelper.getClampedDouble(world, RBMKKeys.KEY_COLUMN_HEAT_FLOW, 0.0, 1.0)));
        gameRules.get((Object)RBMKKeys.KEY_FUEL_DIFFUSION_MOD).add(new Tuple.Pair<World, Double>(world, GameRuleHelper.getDoubleMinimum(world, RBMKKeys.KEY_FUEL_DIFFUSION_MOD, 0.0)));
        gameRules.get((Object)RBMKKeys.KEY_HEAT_PROVISION).add(new Tuple.Pair<World, Double>(world, GameRuleHelper.getClampedDouble(world, RBMKKeys.KEY_HEAT_PROVISION, 0.0, 1.0)));
        gameRules.get((Object)RBMKKeys.KEY_COLUMN_HEIGHT).add(new Tuple.Pair<World, Integer>(world, GameRuleHelper.getClampedInt(world, RBMKKeys.KEY_COLUMN_HEIGHT, 2, 16) - 1));
        gameRules.get((Object)RBMKKeys.KEY_PERMANENT_SCRAP).add(new Tuple.Pair<World, Boolean>(world, world.func_82736_K().func_82766_b(RBMKKeys.KEY_PERMANENT_SCRAP.keyString)));
        gameRules.get((Object)RBMKKeys.KEY_BOILER_HEAT_CONSUMPTION).add(new Tuple.Pair<World, Double>(world, GameRuleHelper.getDoubleMinimum(world, RBMKKeys.KEY_BOILER_HEAT_CONSUMPTION, 0.0)));
        gameRules.get((Object)RBMKKeys.KEY_CONTROL_SPEED_MOD).add(new Tuple.Pair<World, Double>(world, GameRuleHelper.getDoubleMinimum(world, RBMKKeys.KEY_CONTROL_SPEED_MOD, 0.0)));
        gameRules.get((Object)RBMKKeys.KEY_REACTIVITY_MOD).add(new Tuple.Pair<World, Double>(world, GameRuleHelper.getDoubleMinimum(world, RBMKKeys.KEY_REACTIVITY_MOD, 0.0)));
        gameRules.get((Object)RBMKKeys.KEY_OUTGASSER_MOD).add(new Tuple.Pair<World, Double>(world, GameRuleHelper.getDoubleMinimum(world, RBMKKeys.KEY_OUTGASSER_MOD, 0.0)));
        gameRules.get((Object)RBMKKeys.KEY_SURGE_MOD).add(new Tuple.Pair<World, Double>(world, GameRuleHelper.getDoubleMinimum(world, RBMKKeys.KEY_SURGE_MOD, 0.0)));
        gameRules.get((Object)RBMKKeys.KEY_FLUX_RANGE).add(new Tuple.Pair<World, Integer>(world, GameRuleHelper.getClampedInt(world, RBMKKeys.KEY_FLUX_RANGE, 1, 100)));
        gameRules.get((Object)RBMKKeys.KEY_REASIM_RANGE).add(new Tuple.Pair<World, Integer>(world, GameRuleHelper.getClampedInt(world, RBMKKeys.KEY_REASIM_RANGE, 1, 100)));
        gameRules.get((Object)RBMKKeys.KEY_REASIM_COUNT).add(new Tuple.Pair<World, Integer>(world, GameRuleHelper.getClampedInt(world, RBMKKeys.KEY_REASIM_COUNT, 1, 24)));
        gameRules.get((Object)RBMKKeys.KEY_REASIM_MOD).add(new Tuple.Pair<World, Double>(world, GameRuleHelper.getDoubleMinimum(world, RBMKKeys.KEY_REASIM_MOD, 0.0)));
        gameRules.get((Object)RBMKKeys.KEY_REASIM_BOILERS).add(new Tuple.Pair<World, Boolean>(world, world.func_82736_K().func_82766_b(RBMKKeys.KEY_REASIM_BOILERS.keyString) || GeneralConfig.enable528ReasimBoilers));
        gameRules.get((Object)RBMKKeys.KEY_REASIM_BOILER_SPEED).add(new Tuple.Pair<World, Double>(world, GameRuleHelper.getClampedDouble(world, RBMKKeys.KEY_REASIM_BOILER_SPEED, 0.0, 1.0)));
        gameRules.get((Object)RBMKKeys.KEY_DISABLE_MELTDOWNS).add(new Tuple.Pair<World, Boolean>(world, world.func_82736_K().func_82766_b(RBMKKeys.KEY_DISABLE_MELTDOWNS.keyString)));
        gameRules.get((Object)RBMKKeys.KEY_ENABLE_MELTDOWN_OVERPRESSURE).add(new Tuple.Pair<World, Boolean>(world, world.func_82736_K().func_82766_b(RBMKKeys.KEY_ENABLE_MELTDOWN_OVERPRESSURE.keyString)));
        gameRules.get((Object)RBMKKeys.KEY_MODERATOR_EFFICIENCY).add(new Tuple.Pair<World, Double>(world, GameRuleHelper.getClampedDouble(world, RBMKKeys.KEY_MODERATOR_EFFICIENCY, 0.0, 1.0)));
        gameRules.get((Object)RBMKKeys.KEY_ABSORBER_EFFICIENCY).add(new Tuple.Pair<World, Double>(world, GameRuleHelper.getClampedDouble(world, RBMKKeys.KEY_ABSORBER_EFFICIENCY, 0.0, 1.0)));
        gameRules.get((Object)RBMKKeys.KEY_REFLECTOR_EFFICIENCY).add(new Tuple.Pair<World, Double>(world, GameRuleHelper.getClampedDouble(world, RBMKKeys.KEY_REFLECTOR_EFFICIENCY, 0.0, 1.0)));
        gameRules.get((Object)RBMKKeys.KEY_DISABLE_DEPLETION).add(new Tuple.Pair<World, Boolean>(world, world.func_82736_K().func_82766_b(RBMKKeys.KEY_DISABLE_DEPLETION.keyString)));
        gameRules.get((Object)RBMKKeys.KEY_DISABLE_XENON).add(new Tuple.Pair<World, Boolean>(world, world.func_82736_K().func_82766_b(RBMKKeys.KEY_DISABLE_XENON.keyString)));
    }

    public static Object getGameRule(World world, RBMKKeys rule) {
        if (world.field_72995_K) {
            MainRegistry.logger.error("Attempted to grab cached gamerules on client side, returning default value.");
            MainRegistry.logger.error("Gamerule: {}, Default Value: {}.", new Object[]{rule.keyString, rule.defValue.toString()});
            return rule.defValue;
        }
        return RBMKDials.getGameRule(world, rule, false);
    }

    public static Object getGameRule(World world, RBMKKeys rule, boolean isIteration) {
        ArrayList<Tuple.Pair<World, Object>> rulesList = new ArrayList<Tuple.Pair<World, Object>>();
        for (Tuple.Pair<World, Object> rulePair : gameRules.get((Object)rule)) {
            if (rulePair.key != world) continue;
            rulesList.add(rulePair);
        }
        if (rulesList.isEmpty()) {
            if (isIteration) {
                throw new NullPointerException("Cannot find gamerule for dial " + rule.keyString + " after creation.");
            }
            world.func_82736_K().func_82764_b(rule.keyString, rule.defValue.toString());
            RBMKDials.refresh(world);
            return RBMKDials.getGameRule(world, rule, true);
        }
        if (rulesList.size() > 1) {
            MainRegistry.logger.warn("Duplicate values for gamerules detected! Found {} rules for gamerule {}", new Object[]{rulesList.size(), rule.keyString});
        }
        return ((Tuple.Pair)rulesList.get((int)0)).value;
    }

    public static double getPassiveCooling(World world) {
        return (Double)RBMKDials.getGameRule(world, RBMKKeys.KEY_PASSIVE_COOLING);
    }

    public static double getColumnHeatFlow(World world) {
        return (Double)RBMKDials.getGameRule(world, RBMKKeys.KEY_COLUMN_HEAT_FLOW);
    }

    public static double getFuelDiffusionMod(World world) {
        return (Double)RBMKDials.getGameRule(world, RBMKKeys.KEY_FUEL_DIFFUSION_MOD);
    }

    public static double getFuelHeatProvision(World world) {
        return (Double)RBMKDials.getGameRule(world, RBMKKeys.KEY_HEAT_PROVISION);
    }

    public static int getColumnHeight(World world) {
        return (Integer)RBMKDials.getGameRule(world, RBMKKeys.KEY_COLUMN_HEIGHT);
    }

    public static boolean getPermaScrap(World world) {
        return (Boolean)RBMKDials.getGameRule(world, RBMKKeys.KEY_PERMANENT_SCRAP);
    }

    public static double getBoilerHeatConsumption(World world) {
        return (Double)RBMKDials.getGameRule(world, RBMKKeys.KEY_BOILER_HEAT_CONSUMPTION);
    }

    public static double getControlSpeed(World world) {
        return (Double)RBMKDials.getGameRule(world, RBMKKeys.KEY_CONTROL_SPEED_MOD);
    }

    public static double getReactivityMod(World world) {
        return (Double)RBMKDials.getGameRule(world, RBMKKeys.KEY_REACTIVITY_MOD);
    }

    public static double getOutgasserMod(World world) {
        return (Double)RBMKDials.getGameRule(world, RBMKKeys.KEY_OUTGASSER_MOD);
    }

    public static double getSurgeMod(World world) {
        if (world.field_72995_K) {
            return GameRuleHelper.getDoubleMinimum(world, RBMKKeys.KEY_PASSIVE_COOLING, 0.0);
        }
        return (Double)RBMKDials.getGameRule(world, RBMKKeys.KEY_SURGE_MOD);
    }

    public static int getFluxRange(World world) {
        return (Integer)RBMKDials.getGameRule(world, RBMKKeys.KEY_FLUX_RANGE);
    }

    public static int getReaSimRange(World world) {
        return (Integer)RBMKDials.getGameRule(world, RBMKKeys.KEY_REASIM_RANGE);
    }

    public static int getReaSimCount(World world) {
        return (Integer)RBMKDials.getGameRule(world, RBMKKeys.KEY_REASIM_COUNT);
    }

    public static double getReaSimOutputMod(World world) {
        return (Double)RBMKDials.getGameRule(world, RBMKKeys.KEY_REASIM_MOD);
    }

    public static boolean getReasimBoilers(World world) {
        return (Boolean)RBMKDials.getGameRule(world, RBMKKeys.KEY_REASIM_BOILERS);
    }

    public static double getReaSimBoilerSpeed(World world) {
        return (Double)RBMKDials.getGameRule(world, RBMKKeys.KEY_REASIM_BOILER_SPEED);
    }

    public static boolean getMeltdownsDisabled(World world) {
        return (Boolean)RBMKDials.getGameRule(world, RBMKKeys.KEY_DISABLE_MELTDOWNS);
    }

    public static boolean getOverpressure(World world) {
        return (Boolean)RBMKDials.getGameRule(world, RBMKKeys.KEY_ENABLE_MELTDOWN_OVERPRESSURE);
    }

    public static double getModeratorEfficiency(World world) {
        return (Double)RBMKDials.getGameRule(world, RBMKKeys.KEY_MODERATOR_EFFICIENCY);
    }

    public static double getAbsorberEfficiency(World world) {
        return (Double)RBMKDials.getGameRule(world, RBMKKeys.KEY_ABSORBER_EFFICIENCY);
    }

    public static double getReflectorEfficiency(World world) {
        return (Double)RBMKDials.getGameRule(world, RBMKKeys.KEY_REFLECTOR_EFFICIENCY);
    }

    public static boolean getDepletion(World world) {
        return (Boolean)RBMKDials.getGameRule(world, RBMKKeys.KEY_DISABLE_DEPLETION) == false;
    }

    public static boolean getXenon(World world) {
        return (Boolean)RBMKDials.getGameRule(world, RBMKKeys.KEY_DISABLE_XENON) == false;
    }

    public static enum RBMKKeys {
        KEY_SAVE_DIALS("dialSaveDials", true),
        KEY_PASSIVE_COOLING("dialPassiveCooling", 1.0),
        KEY_COLUMN_HEAT_FLOW("dialColumnHeatFlow", 0.2),
        KEY_FUEL_DIFFUSION_MOD("dialDiffusionMod", 1.0),
        KEY_HEAT_PROVISION("dialHeatProvision", 0.2),
        KEY_COLUMN_HEIGHT("dialColumnHeight", 4),
        KEY_PERMANENT_SCRAP("dialEnablePermaScrap", true),
        KEY_BOILER_HEAT_CONSUMPTION("dialBoilerHeatConsumption", 0.1),
        KEY_CONTROL_SPEED_MOD("dialControlSpeed", 1.0),
        KEY_REACTIVITY_MOD("dialReactivityMod", 1.0),
        KEY_OUTGASSER_MOD("dialOutgasserSpeedMod", 1.0),
        KEY_SURGE_MOD("dialControlSurgeMod", 1.0),
        KEY_FLUX_RANGE("dialFluxRange", 5),
        KEY_REASIM_RANGE("dialReasimRange", 10),
        KEY_REASIM_COUNT("dialReasimCount", 6),
        KEY_REASIM_MOD("dialReasimOutputMod", 1.0),
        KEY_REASIM_BOILERS("dialReasimBoilers", false),
        KEY_REASIM_BOILER_SPEED("dialReasimBoilerSpeed", 0.05),
        KEY_DISABLE_MELTDOWNS("dialDisableMeltdowns", false),
        KEY_ENABLE_MELTDOWN_OVERPRESSURE("dialEnableMeltdownOverpressure", false),
        KEY_MODERATOR_EFFICIENCY("dialModeratorEfficiency", 1.0),
        KEY_ABSORBER_EFFICIENCY("dialAbsorberEfficiency", 1.0),
        KEY_REFLECTOR_EFFICIENCY("dialReflectorEfficiency", 1.0),
        KEY_DISABLE_DEPLETION("dialDisableDepletion", false),
        KEY_DISABLE_XENON("dialDisableXenon", false);

        public final String keyString;
        public final Object defValue;

        private RBMKKeys(String key, Object def) {
            this.keyString = key;
            this.defValue = def;
        }
    }
}

