/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluidmk2.IFluidStandardTransceiverMK2;
import com.hbm.blocks.ModBlocks;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.UpgradeManagerNT;
import com.hbm.inventory.container.ContainerMachineChemicalFactory;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIMachineChemicalFactory;
import com.hbm.inventory.recipes.ChemicalPlantRecipes;
import com.hbm.inventory.recipes.loader.GenericRecipe;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.module.machine.ModuleMachineChemplant;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.IUpgradeInfoProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.TileEntityProxyDyn;
import com.hbm.util.BobMathUtil;
import com.hbm.util.fauxpointtwelve.DirPos;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineChemicalFactory
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IFluidStandardTransceiverMK2,
IUpgradeInfoProvider,
IControlReceiver,
IGUIProvider,
TileEntityProxyDyn.IProxyDelegateProvider {
    public FluidTank[] allTanks;
    public FluidTank[] inputTanks;
    public FluidTank[] outputTanks;
    public FluidTank water;
    public FluidTank lps;
    public long power;
    public long maxPower = 1000000L;
    public boolean[] didProcess = new boolean[4];
    public boolean frame = false;
    public int anim;
    public int prevAnim;
    private AudioWrapper audio;
    public ModuleMachineChemplant[] chemplantModule;
    public UpgradeManagerNT upgradeManager = new UpgradeManagerNT(this);
    protected DelegateChemicalFactoy delegate = new DelegateChemicalFactoy();
    AxisAlignedBB bb = null;
    public DirPos[] coolantLine;

    public TileEntityMachineChemicalFactory() {
        super(32);
        int i;
        this.inputTanks = new FluidTank[12];
        this.outputTanks = new FluidTank[12];
        for (i = 0; i < 12; ++i) {
            this.inputTanks[i] = new FluidTank(Fluids.NONE, 24000);
            this.outputTanks[i] = new FluidTank(Fluids.NONE, 24000);
        }
        this.water = new FluidTank(Fluids.WATER, 4000);
        this.lps = new FluidTank(Fluids.SPENTSTEAM, 4000);
        this.allTanks = new FluidTank[this.inputTanks.length + this.outputTanks.length + 2];
        for (i = 0; i < this.inputTanks.length; ++i) {
            this.allTanks[i] = this.inputTanks[i];
        }
        for (i = 0; i < this.outputTanks.length; ++i) {
            this.allTanks[i + this.inputTanks.length] = this.outputTanks[i];
        }
        this.allTanks[this.allTanks.length - 2] = this.water;
        this.allTanks[this.allTanks.length - 1] = this.lps;
        this.chemplantModule = new ModuleMachineChemplant[4];
        for (i = 0; i < 4; ++i) {
            this.chemplantModule[i] = new ModuleMachineChemplant(i, this, this.slots).itemInput(5 + i * 7, 6 + i * 7, 7 + i * 7).itemOutput(8 + i * 7, 9 + i * 7, 10 + i * 7).fluidInput(this.inputTanks[0 + i * 3], this.inputTanks[1 + i * 3], this.inputTanks[2 + i * 3]).fluidOutput(this.outputTanks[0 + i * 3], this.outputTanks[1 + i * 3], this.outputTanks[2 + i * 3]);
        }
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        if (i >= 8 && i <= 10) {
            return true;
        }
        if (i >= 15 && i <= 17) {
            return true;
        }
        if (i >= 22 && i <= 24) {
            return true;
        }
        if (i >= 29 && i <= 31) {
            return true;
        }
        for (int k = 0; k < 4; ++k) {
            if (!this.chemplantModule[k].isSlotClogged(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        int i;
        if (slot == 0) {
            return true;
        }
        for (i = 0; i < 4; ++i) {
            if (slot != 4 + i * 7 || stack.func_77973_b() != ModItems.blueprints) continue;
            return true;
        }
        if (slot >= 1 && slot <= 3 && stack.func_77973_b() instanceof ItemMachineUpgrade) {
            return true;
        }
        for (i = 0; i < 4; ++i) {
            if (!this.chemplantModule[i].isItemValid(slot, stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 19, 20, 21, 22, 23, 24, 26, 27, 28, 29, 30, 31};
    }

    @Override
    public String getName() {
        return "container.machineChemicalFactory";
    }

    @Override
    public void func_145845_h() {
        if (this.maxPower <= 0L) {
            this.maxPower = 10000000L;
        }
        if (!this.field_145850_b.field_72995_K) {
            long nextMaxPower = 0L;
            for (int i = 0; i < 4; ++i) {
                GenericRecipe recipe = (GenericRecipe)ChemicalPlantRecipes.INSTANCE.recipeNameMap.get(this.chemplantModule[i].recipe);
                if (recipe == null) continue;
                nextMaxPower += recipe.power * 100L;
            }
            this.maxPower = nextMaxPower;
            this.maxPower = BobMathUtil.max(this.power, this.maxPower, 1000000L);
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, this.maxPower);
            this.upgradeManager.checkSlots(this.slots, 1, 3);
            for (DirPos pos : this.getConPos()) {
                this.trySubscribe(this.field_145850_b, pos);
                for (FluidTank tank : this.inputTanks) {
                    if (tank.getTankType() == Fluids.NONE) continue;
                    this.trySubscribe(tank.getTankType(), this.field_145850_b, pos);
                }
                for (FluidTank tank : this.outputTanks) {
                    if (tank.getFill() <= 0) continue;
                    this.tryProvide(tank, this.field_145850_b, pos);
                }
            }
            for (DirPos pos : this.getCoolPos()) {
                this.delegate.trySubscribe(this.field_145850_b, pos);
                this.delegate.trySubscribe(this.water.getTankType(), this.field_145850_b, pos);
                this.delegate.tryProvide(this.lps, this.field_145850_b, pos);
            }
            double speed = 1.0;
            double pow = 1.0;
            speed += (double)Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED), 3) / 3.0;
            speed += (double)Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.OVERDRIVE), 3);
            pow -= (double)Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER), 3) * 0.25;
            pow += (double)Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED), 3) * 1.0;
            pow += (double)Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.OVERDRIVE), 3) * 10.0 / 3.0;
            boolean markDirty = false;
            for (int i = 0; i < 4; ++i) {
                this.chemplantModule[i].update(speed * 2.0, pow * 2.0, this.canCool(), this.slots[4 + i * 7]);
                this.didProcess[i] = this.chemplantModule[i].didProcess;
                markDirty |= this.chemplantModule[i].markDirty;
                if (!this.chemplantModule[i].didProcess) continue;
                this.water.setFill(this.water.getFill() - 100);
                this.lps.setFill(this.lps.getFill() + 100);
            }
            for (FluidTank in : this.inputTanks) {
                if (in.getTankType() == Fluids.NONE) continue;
                for (FluidTank out : this.outputTanks) {
                    int toMove;
                    if (out.getTankType() == Fluids.NONE || out.getTankType() != in.getTankType() || (toMove = BobMathUtil.min(in.getMaxFill() - in.getFill(), out.getFill(), 50)) <= 0) continue;
                    in.setFill(in.getFill() + toMove);
                    out.setFill(out.getFill() - toMove);
                }
            }
            if (markDirty) {
                this.func_70296_d();
            }
            this.networkPackNT(100);
        } else {
            boolean didSomething;
            this.prevAnim = this.anim;
            boolean bl = didSomething = this.didProcess[0] || this.didProcess[1] || this.didProcess[2] || this.didProcess[3];
            if (didSomething) {
                ++this.anim;
            }
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                boolean bl2 = this.frame = !this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 3, this.field_145849_e).isAir((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d + 3, this.field_145849_e);
            }
            if (didSomething && MainRegistry.proxy.me().func_70011_f((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e) < 50.0) {
                if (this.audio == null) {
                    this.audio = this.createAudioLoop();
                    this.audio.startSound();
                } else if (!this.audio.isPlaying()) {
                    this.audio = this.rebootAudio(this.audio);
                }
                this.audio.keepAlive();
                this.audio.updateVolume(this.getVolume(1.0f));
            } else if (this.audio != null) {
                this.audio.stopSound();
                this.audio = null;
            }
        }
    }

    @Override
    public AudioWrapper createAudioLoop() {
        return MainRegistry.proxy.getLoopedSound("hbm:block.chemicalPlant", this.field_145851_c, this.field_145848_d, this.field_145849_e, 1.0f, 15.0f, 1.0f, 20);
    }

    @Override
    public void onChunkUnload() {
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public boolean canCool() {
        return this.water.getFill() >= 100 && this.lps.getFill() <= this.lps.getMaxFill() - 100;
    }

    public DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c + 3, this.field_145848_d, this.field_145849_e - 2, Library.POS_X), new DirPos(this.field_145851_c + 3, this.field_145848_d, this.field_145849_e + 0, Library.POS_X), new DirPos(this.field_145851_c + 3, this.field_145848_d, this.field_145849_e + 2, Library.POS_X), new DirPos(this.field_145851_c - 3, this.field_145848_d, this.field_145849_e - 2, Library.NEG_X), new DirPos(this.field_145851_c - 3, this.field_145848_d, this.field_145849_e + 0, Library.NEG_X), new DirPos(this.field_145851_c - 3, this.field_145848_d, this.field_145849_e + 2, Library.NEG_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e + 3, Library.POS_Z), new DirPos(this.field_145851_c + 0, this.field_145848_d, this.field_145849_e + 3, Library.POS_Z), new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e + 3, Library.POS_Z), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e - 3, Library.NEG_Z), new DirPos(this.field_145851_c + 0, this.field_145848_d, this.field_145849_e - 3, Library.NEG_Z), new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e - 3, Library.NEG_Z), new DirPos(this.field_145851_c + dir.offsetX * 2 + rot.offsetX * 2, this.field_145848_d + 3, this.field_145849_e + dir.offsetZ * 2 + rot.offsetZ * 2, Library.POS_Y), new DirPos(this.field_145851_c + dir.offsetX * 1 + rot.offsetX * 2, this.field_145848_d + 3, this.field_145849_e + dir.offsetZ * 1 + rot.offsetZ * 2, Library.POS_Y), new DirPos(this.field_145851_c + dir.offsetX * 0 + rot.offsetX * 2, this.field_145848_d + 3, this.field_145849_e + dir.offsetZ * 0 + rot.offsetZ * 2, Library.POS_Y), new DirPos(this.field_145851_c - dir.offsetX * 1 + rot.offsetX * 2, this.field_145848_d + 3, this.field_145849_e - dir.offsetZ * 1 + rot.offsetZ * 2, Library.POS_Y), new DirPos(this.field_145851_c - dir.offsetX * 2 + rot.offsetX * 2, this.field_145848_d + 3, this.field_145849_e - dir.offsetZ * 2 + rot.offsetZ * 2, Library.POS_Y), new DirPos(this.field_145851_c + dir.offsetX * 2 - rot.offsetX * 2, this.field_145848_d + 3, this.field_145849_e + dir.offsetZ * 2 - rot.offsetZ * 2, Library.POS_Y), new DirPos(this.field_145851_c + dir.offsetX * 1 - rot.offsetX * 2, this.field_145848_d + 3, this.field_145849_e + dir.offsetZ * 1 - rot.offsetZ * 2, Library.POS_Y), new DirPos(this.field_145851_c + dir.offsetX * 0 - rot.offsetX * 2, this.field_145848_d + 3, this.field_145849_e + dir.offsetZ * 0 - rot.offsetZ * 2, Library.POS_Y), new DirPos(this.field_145851_c - dir.offsetX * 1 - rot.offsetX * 2, this.field_145848_d + 3, this.field_145849_e - dir.offsetZ * 1 - rot.offsetZ * 2, Library.POS_Y), new DirPos(this.field_145851_c - dir.offsetX * 2 - rot.offsetX * 2, this.field_145848_d + 3, this.field_145849_e - dir.offsetZ * 2 - rot.offsetZ * 2, Library.POS_Y), new DirPos(this.field_145851_c + dir.offsetX + rot.offsetX * 3, this.field_145848_d, this.field_145849_e + dir.offsetZ + rot.offsetZ * 3, rot), new DirPos(this.field_145851_c - dir.offsetX + rot.offsetX * 3, this.field_145848_d, this.field_145849_e - dir.offsetZ + rot.offsetZ * 3, rot), new DirPos(this.field_145851_c + dir.offsetX - rot.offsetX * 3, this.field_145848_d, this.field_145849_e + dir.offsetZ - rot.offsetZ * 3, rot.getOpposite()), new DirPos(this.field_145851_c - dir.offsetX - rot.offsetX * 3, this.field_145848_d, this.field_145849_e - dir.offsetZ - rot.offsetZ * 3, rot.getOpposite())};
    }

    public DirPos[] getCoolPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c + rot.offsetX + dir.offsetX * 3, this.field_145848_d, this.field_145849_e + rot.offsetZ + dir.offsetZ * 3, dir), new DirPos(this.field_145851_c - rot.offsetX + dir.offsetX * 3, this.field_145848_d, this.field_145849_e - rot.offsetZ + dir.offsetZ * 3, dir), new DirPos(this.field_145851_c + rot.offsetX - dir.offsetX * 3, this.field_145848_d, this.field_145849_e + rot.offsetZ - dir.offsetZ * 3, dir.getOpposite()), new DirPos(this.field_145851_c - rot.offsetX - dir.offsetX * 3, this.field_145848_d, this.field_145849_e - rot.offsetZ - dir.offsetZ * 3, dir.getOpposite())};
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void serialize(ByteBuf buf) {
        void var2_6;
        super.serialize(buf);
        for (FluidTank tank : this.inputTanks) {
            tank.serialize(buf);
        }
        for (FluidTank tank : this.outputTanks) {
            tank.serialize(buf);
        }
        this.water.serialize(buf);
        this.lps.serialize(buf);
        buf.writeLong(this.power);
        buf.writeLong(this.maxPower);
        for (boolean b : this.didProcess) {
            buf.writeBoolean(b);
        }
        boolean bl = false;
        while (var2_6 < 4) {
            this.chemplantModule[var2_6].serialize(buf);
            ++var2_6;
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        int i;
        super.deserialize(buf);
        for (FluidTank tank : this.inputTanks) {
            tank.deserialize(buf);
        }
        for (FluidTank tank : this.outputTanks) {
            tank.deserialize(buf);
        }
        this.water.deserialize(buf);
        this.lps.deserialize(buf);
        this.power = buf.readLong();
        this.maxPower = buf.readLong();
        for (i = 0; i < 4; ++i) {
            this.didProcess[i] = buf.readBoolean();
        }
        for (i = 0; i < 4; ++i) {
            this.chemplantModule[i].deserialize(buf);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        int i;
        super.func_145839_a(nbt);
        for (i = 0; i < this.inputTanks.length; ++i) {
            this.inputTanks[i].readFromNBT(nbt, "i" + i);
        }
        for (i = 0; i < this.outputTanks.length; ++i) {
            this.outputTanks[i].readFromNBT(nbt, "o" + i);
        }
        this.water.readFromNBT(nbt, "w");
        this.lps.readFromNBT(nbt, "s");
        this.power = nbt.func_74763_f("power");
        this.maxPower = nbt.func_74763_f("maxPower");
        for (i = 0; i < 4; ++i) {
            this.chemplantModule[i].readFromNBT(nbt);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        int i;
        super.func_145841_b(nbt);
        for (i = 0; i < this.inputTanks.length; ++i) {
            this.inputTanks[i].writeToNBT(nbt, "i" + i);
        }
        for (i = 0; i < this.outputTanks.length; ++i) {
            this.outputTanks[i].writeToNBT(nbt, "o" + i);
        }
        this.water.writeToNBT(nbt, "w");
        this.lps.writeToNBT(nbt, "s");
        nbt.func_74772_a("power", this.power);
        nbt.func_74772_a("maxPower", this.maxPower);
        for (i = 0; i < 4; ++i) {
            this.chemplantModule[i].writeToNBT(nbt);
        }
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return this.maxPower;
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return this.inputTanks;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return this.outputTanks;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.allTanks;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineChemicalFactory(player.field_71071_by, (IInventory)this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineChemicalFactory(player.field_71071_by, this);
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return this.func_70300_a(player);
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("index") && data.func_74764_b("selection")) {
            int index = data.func_74762_e("index");
            String selection = data.func_74779_i("selection");
            if (index >= 0 && index < 4) {
                this.chemplantModule[index].recipe = selection;
                this.markChanged();
            }
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 2), (double)this.field_145848_d, (double)(this.field_145849_e - 2), (double)(this.field_145851_c + 3), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 3));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public boolean canProvideInfo(ItemMachineUpgrade.UpgradeType type, int level, boolean extendedInfo) {
        return type == ItemMachineUpgrade.UpgradeType.SPEED || type == ItemMachineUpgrade.UpgradeType.POWER || type == ItemMachineUpgrade.UpgradeType.OVERDRIVE;
    }

    @Override
    public void provideInfo(ItemMachineUpgrade.UpgradeType type, int level, List<String> info, boolean extendedInfo) {
        info.add(IUpgradeInfoProvider.getStandardLabel(ModBlocks.machine_chemical_factory));
        if (type == ItemMachineUpgrade.UpgradeType.SPEED) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.speed", "+" + level * 100 / 3 + "%"));
            info.add(EnumChatFormatting.RED + I18nUtil.resolveKey("upgrade.consumption", "+" + level * 50 + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.POWER) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.consumption", "-" + level * 25 + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.OVERDRIVE) {
            info.add((BobMathUtil.getBlink() ? EnumChatFormatting.RED : EnumChatFormatting.DARK_GRAY) + "YES");
        }
    }

    @Override
    public HashMap<ItemMachineUpgrade.UpgradeType, Integer> getValidUpgrades() {
        HashMap<ItemMachineUpgrade.UpgradeType, Integer> upgrades = new HashMap<ItemMachineUpgrade.UpgradeType, Integer>();
        upgrades.put(ItemMachineUpgrade.UpgradeType.SPEED, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.POWER, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.OVERDRIVE, 3);
        return upgrades;
    }

    @Override
    public Object getDelegateForPosition(int x, int y, int z) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        if (this.coolantLine == null) {
            this.coolantLine = new DirPos[]{new DirPos(this.field_145851_c + rot.offsetX + dir.offsetX * 2, this.field_145848_d, this.field_145849_e + rot.offsetZ + dir.offsetZ * 2, dir), new DirPos(this.field_145851_c - rot.offsetX + dir.offsetX * 2, this.field_145848_d, this.field_145849_e - rot.offsetZ + dir.offsetZ * 2, dir), new DirPos(this.field_145851_c + rot.offsetX - dir.offsetX * 2, this.field_145848_d, this.field_145849_e + rot.offsetZ - dir.offsetZ * 2, dir.getOpposite()), new DirPos(this.field_145851_c - rot.offsetX - dir.offsetX * 2, this.field_145848_d, this.field_145849_e - rot.offsetZ - dir.offsetZ * 2, dir.getOpposite())};
        }
        for (DirPos pos : this.coolantLine) {
            if (!pos.compare(x, y, z)) continue;
            return this.delegate;
        }
        return null;
    }

    public class DelegateChemicalFactoy
    implements IEnergyReceiverMK2,
    IFluidStandardTransceiverMK2 {
        @Override
        public long getPower() {
            return TileEntityMachineChemicalFactory.this.getPower();
        }

        @Override
        public void setPower(long power) {
            TileEntityMachineChemicalFactory.this.setPower(power);
        }

        @Override
        public long getMaxPower() {
            return TileEntityMachineChemicalFactory.this.getMaxPower();
        }

        @Override
        public boolean isLoaded() {
            return TileEntityMachineChemicalFactory.this.isLoaded();
        }

        @Override
        public FluidTank[] getReceivingTanks() {
            return new FluidTank[]{TileEntityMachineChemicalFactory.this.water};
        }

        @Override
        public FluidTank[] getSendingTanks() {
            return new FluidTank[]{TileEntityMachineChemicalFactory.this.lps};
        }

        @Override
        public FluidTank[] getAllTanks() {
            return TileEntityMachineChemicalFactory.this.getAllTanks();
        }
    }
}

