/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.container.ContainerMachineAmmoPress;
import com.hbm.inventory.gui.GUIMachineAmmoPress;
import com.hbm.inventory.recipes.AmmoPressRecipes;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileEntityMachineAmmoPress
extends TileEntityMachineBase
implements IControlReceiver,
IGUIProvider {
    public int selectedRecipe = -1;
    public AnimationState animState = AnimationState.LIFTING;
    public int playAnimation = 0;
    public float prevLift = 0.0f;
    public float lift = 0.0f;
    public float prevPress = 0.0f;
    public float press = 0.0f;
    public static boolean recipeLock = false;
    public int[] access = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    AxisAlignedBB bb = null;

    public TileEntityMachineAmmoPress() {
        super(10);
    }

    @Override
    public String getName() {
        return "container.machineAmmoPress";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.playAnimation > 0) {
                --this.playAnimation;
            }
            this.performRecipe();
            this.networkPackNT(25);
        } else {
            this.prevLift = this.lift;
            this.prevPress = this.press;
            if (this.playAnimation > 0 || this.lift > 0.0f) {
                switch (this.animState) {
                    case LIFTING: {
                        this.lift += 0.025f;
                        if (!(this.lift >= 1.0f)) break;
                        this.lift = 1.0f;
                        this.animState = AnimationState.PRESSING;
                        break;
                    }
                    case PRESSING: {
                        this.press += 0.05f;
                        if (!(this.press >= 1.0f)) break;
                        this.press = 1.0f;
                        this.animState = AnimationState.RETRACTING;
                        break;
                    }
                    case RETRACTING: {
                        this.press -= 0.05f;
                        if (!(this.press <= 0.0f)) break;
                        this.press = 0.0f;
                        this.animState = AnimationState.LOWERING;
                        break;
                    }
                    case LOWERING: {
                        this.lift -= 0.025f;
                        if (!(this.lift <= 0.0f)) break;
                        this.lift = 0.0f;
                        this.animState = AnimationState.LIFTING;
                    }
                }
            }
        }
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        super.func_70299_a(slot, stack);
    }

    public void performRecipe() {
        if (this.selectedRecipe < 0 || this.selectedRecipe >= AmmoPressRecipes.recipes.size()) {
            return;
        }
        AmmoPressRecipes.AmmoPressRecipe recipe = AmmoPressRecipes.recipes.get(this.selectedRecipe);
        if (this.slots[9] != null) {
            if (this.slots[9].func_77973_b() != recipe.output.func_77973_b()) {
                return;
            }
            if (this.slots[9].func_77960_j() != recipe.output.func_77960_j()) {
                return;
            }
            if (this.slots[9].field_77994_a + recipe.output.field_77994_a > this.slots[9].func_77976_d()) {
                return;
            }
        }
        if (this.hasIngredients(recipe)) {
            this.produceAmmo(recipe);
            this.performRecipe();
        }
    }

    public boolean hasIngredients(AmmoPressRecipes.AmmoPressRecipe recipe) {
        for (int i = 0; i < 9; ++i) {
            if (recipe.input[i] == null && this.slots[i] == null) continue;
            if (recipe.input[i] != null && this.slots[i] == null) {
                return false;
            }
            if (recipe.input[i] == null && this.slots[i] != null) {
                return false;
            }
            if (recipe.input[i].matchesRecipe(this.slots[i], false)) continue;
            return false;
        }
        return true;
    }

    protected void produceAmmo(AmmoPressRecipes.AmmoPressRecipe recipe) {
        for (int i = 0; i < 9; ++i) {
            if (recipe.input[i] == null) continue;
            this.func_70298_a(i, recipe.input[i].stacksize);
        }
        if (this.slots[9] == null) {
            this.slots[9] = recipe.output.func_77946_l();
        } else {
            this.slots[9].field_77994_a += recipe.output.field_77994_a;
        }
        this.playAnimation = 40;
    }

    @Override
    public int[] func_94128_d(int side) {
        return this.access;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack stack, int j) {
        return i == 9;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot > 8) {
            return false;
        }
        if (this.selectedRecipe < 0 || this.selectedRecipe >= AmmoPressRecipes.recipes.size()) {
            return false;
        }
        AmmoPressRecipes.AmmoPressRecipe recipe = AmmoPressRecipes.recipes.get(this.selectedRecipe);
        if (recipe.input[slot] == null) {
            return false;
        }
        return recipe.input[slot].matchesRecipe(stack, true);
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeInt(this.selectedRecipe);
        buf.writeInt(this.playAnimation);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.selectedRecipe = buf.readInt();
        this.playAnimation = buf.readInt();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.selectedRecipe = nbt.func_74762_e("recipe");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("recipe", this.selectedRecipe);
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return this.func_70300_a(player);
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        int newRecipe = data.func_74762_e("selection");
        this.selectedRecipe = newRecipe == this.selectedRecipe ? -1 : newRecipe;
        this.func_70296_d();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineAmmoPress(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineAmmoPress(player.field_71071_by, this);
    }

    public static enum AnimationState {
        LIFTING,
        PRESSING,
        RETRACTING,
        LOWERING;

    }
}

