/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.tileentity;

import com.hbm.blocks.ModBlocks;
import com.hbm.main.ResourceManager;
import com.hbm.render.item.ItemRenderBase;
import com.hbm.render.tileentity.IItemRendererProvider;
import com.hbm.tileentity.machine.TileEntityMachineHTR3;
import com.hbm.util.BobMathUtil;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderHTR3
extends TileEntitySpecialRenderer
implements IItemRendererProvider {
    public void func_147500_a(TileEntity tile, double x, double y, double z, float interp) {
        if (!(tile instanceof TileEntityMachineHTR3)) {
            return;
        }
        TileEntityMachineHTR3 rocket = (TileEntityMachineHTR3)tile;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y - 3.0), (double)(z + 0.5));
        GL11.glEnable((int)2884);
        GL11.glEnable((int)2896);
        GL11.glShadeModel((int)7425);
        switch (tile.func_145832_p() - 10) {
            case 3: {
                GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 5: {
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 2: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 4: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        double t = rocket.lastTime + (rocket.time - rocket.lastTime) * (double)interp;
        double swayTimer = t / 3.0 % (Math.PI * 4);
        double sway = (Math.sin(swayTimer) + Math.sin(swayTimer * 2.0) + Math.sin(swayTimer * 4.0) + 2.23255) * 0.5;
        double bellTimer = t / 5.0 % (Math.PI * 4);
        double h = (Math.sin(bellTimer + Math.PI) + Math.sin(bellTimer * 1.5)) / 1.90596;
        double v = (Math.sin(bellTimer) + Math.sin(bellTimer * 1.5)) / 1.90596;
        double pistonTimer = t / 5.0 % (Math.PI * 2);
        double piston = BobMathUtil.sps(pistonTimer);
        double rotorTimer = t / 5.0 % 50.26548245743669;
        double rotor = (BobMathUtil.sps(rotorTimer) + rotorTimer / 2.0 - 1.0) / 25.1327412287;
        double turbine = t % 100.0 / 100.0;
        this.func_147499_a(ResourceManager.lpw2_tex);
        ResourceManager.htr3.renderPart("Center");
        ResourceManager.htr3.renderOnly(new String[]{"PipeL1", "PipeL2", "PipeR1", "PipeR2"});
        RenderHTR3.renderMainAssembly(sway, h, v, piston, rotor, turbine);
        double coverTimer = t / 5.0 % (Math.PI * 4);
        double cover = (Math.sin(coverTimer) + Math.sin(coverTimer * 2.0) + Math.sin(coverTimer * 4.0)) * 0.5;
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)(-cover * 0.125));
        ResourceManager.htr3.renderOnly(new String[]{"CoverTop", "CoverBottom"});
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)3.5);
        GL11.glScaled((double)1.0, (double)1.0, (double)((3.0 + cover * 0.125) / 3.0));
        GL11.glTranslated((double)0.0, (double)0.0, (double)-3.5);
        ResourceManager.htr3.renderOnly(new String[]{"SuspensionBottom", "SuspensionTop"});
        GL11.glPopMatrix();
        GL11.glShadeModel((int)7424);
        GL11.glPopMatrix();
    }

    public static void renderMainAssembly(double sway, double h, double v, double piston, double rotor, double turbine) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)(-sway * 0.125));
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)(piston * 0.375 + 0.375));
        ResourceManager.htr3.renderPart("Piston");
        GL11.glPopMatrix();
        RenderHTR3.renderBell(h, v);
        GL11.glPopMatrix();
        RenderHTR3.renderShroud(h, v);
    }

    public static void renderBell(double h, double v) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)3.5, (double)-1.0);
        double magnitude = 2.0;
        GL11.glRotated((double)(v * magnitude), (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)(h * magnitude), (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)-3.5, (double)1.0);
        ResourceManager.htr3.renderPart("Engine");
        GL11.glPopMatrix();
    }

    public static void renderShroud(double h, double v) {
        double magnitude = 0.125;
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)(-h * magnitude), (double)0.0);
        ResourceManager.htr3.renderPart("ShroudH");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)(v * magnitude), (double)0.0, (double)0.0);
        ResourceManager.htr3.renderPart("ShroudV");
        GL11.glPopMatrix();
    }

    @Override
    public Item getItemForRenderer() {
        return Item.func_150898_a((Block)ModBlocks.machine_htr3);
    }

    @Override
    public IItemRenderer getRenderer() {
        return new ItemRenderBase(){

            @Override
            public void renderInventory() {
                GL11.glTranslated((double)0.0, (double)-3.0, (double)0.0);
                GL11.glScaled((double)2.5, (double)2.5, (double)2.5);
            }

            @Override
            public void renderCommon() {
                GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
                GL11.glShadeModel((int)7425);
                RenderHTR3.this.func_147499_a(ResourceManager.lpw2_tex);
                ResourceManager.htr3.renderAllExcept(new String[]{"ExhaustVacuum"});
                GL11.glShadeModel((int)7424);
            }
        };
    }
}

