/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.main;

import com.hbm.handler.ThreeInts;
import com.hbm.main.MainRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.common.ForgeChunkManager;

public class ChunkLoaderManager {
    private static final String DATA_NAME = "ChunkData";

    public static void loadTicket(World world, ForgeChunkManager.Ticket ticket) {
        ChunkWorldSavedData savedData = ChunkLoaderManager.getSavedData(world, ticket);
        for (ChunkCoordIntPair chunk : savedData.chunksForcedBy.values()) {
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)chunk);
        }
    }

    private static ChunkWorldSavedData getSavedData(World world) {
        return ChunkLoaderManager.getSavedData(world, null);
    }

    private static ChunkWorldSavedData getSavedData(World world, ForgeChunkManager.Ticket ticket) {
        ChunkWorldSavedData savedData = (ChunkWorldSavedData)world.perWorldStorage.func_75742_a(ChunkWorldSavedData.class, DATA_NAME);
        if (savedData == null) {
            world.perWorldStorage.func_75745_a(DATA_NAME, (WorldSavedData)new ChunkWorldSavedData(DATA_NAME));
            savedData = (ChunkWorldSavedData)world.perWorldStorage.func_75742_a(ChunkWorldSavedData.class, DATA_NAME);
        }
        if (savedData.ticket == null) {
            if (ticket == null) {
                ticket = ForgeChunkManager.requestTicket((Object)MainRegistry.instance, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
            }
            savedData.ticket = ticket;
        }
        return savedData;
    }

    public static void forceChunk(World world, int x, int y, int z) {
        ChunkLoaderManager.forceChunk(world, x, y, z, ChunkLoaderManager.getChunkPosition(x, z));
    }

    public static void forceChunk(World world, int x, int y, int z, ChunkCoordIntPair chunk) {
        ChunkWorldSavedData savedData = ChunkLoaderManager.getSavedData(world);
        savedData.chunksForcedBy.put(new ThreeInts(x, y, z), chunk);
        savedData.func_76185_a();
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)savedData.ticket, (ChunkCoordIntPair)chunk);
    }

    public static void unforceChunk(World world, int x, int y, int z) {
        ChunkLoaderManager.unforceChunk(world, x, y, z, ChunkLoaderManager.getChunkPosition(x, z));
    }

    public static void unforceChunk(World world, int x, int y, int z, ChunkCoordIntPair chunk) {
        ChunkWorldSavedData savedData = ChunkLoaderManager.getSavedData(world);
        savedData.chunksForcedBy.remove(new ThreeInts(x, y, z));
        savedData.func_76185_a();
        if (!savedData.chunksForcedBy.containsValue(chunk)) {
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)savedData.ticket, (ChunkCoordIntPair)chunk);
        }
    }

    private static ChunkCoordIntPair getChunkPosition(int x, int z) {
        return new ChunkCoordIntPair(x >> 4, z >> 4);
    }

    public static class ChunkWorldSavedData
    extends WorldSavedData {
        public Map<ThreeInts, ChunkCoordIntPair> chunksForcedBy = new HashMap<ThreeInts, ChunkCoordIntPair>();
        public ForgeChunkManager.Ticket ticket;

        public ChunkWorldSavedData(String name) {
            super(name);
        }

        public void func_76184_a(NBTTagCompound nbt) {
            this.chunksForcedBy = new HashMap<ThreeInts, ChunkCoordIntPair>();
            NBTTagList list = nbt.func_150295_c("chunks", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                ThreeInts coords = new ThreeInts(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
                ChunkCoordIntPair chunk = new ChunkCoordIntPair(tag.func_74762_e("cx"), tag.func_74762_e("cz"));
                this.chunksForcedBy.put(coords, chunk);
            }
        }

        public void func_76187_b(NBTTagCompound nbt) {
            NBTTagList list = new NBTTagList();
            for (Map.Entry<ThreeInts, ChunkCoordIntPair> entry : this.chunksForcedBy.entrySet()) {
                ThreeInts coords = entry.getKey();
                ChunkCoordIntPair chunk = entry.getValue();
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("x", coords.x);
                tag.func_74768_a("y", coords.y);
                tag.func_74768_a("z", coords.z);
                tag.func_74768_a("cx", chunk.field_77276_a);
                tag.func_74768_a("cz", chunk.field_77275_b);
                list.func_74742_a((NBTBase)tag);
            }
            nbt.func_74782_a("chunks", (NBTBase)list);
        }
    }
}

