/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.recipes.loader.SerializableRecipe;
import com.hbm.items.machine.ItemFluidIcon;
import com.hbm.util.Tuple;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class AlkylationRecipes
extends SerializableRecipe {
    private static HashMap<FluidType, Tuple.Triplet<FluidStack, FluidStack, FluidStack>> recipes = new HashMap();

    @Override
    public void registerDefaults() {
        recipes.put(Fluids.CHLOROMETHANE, new Tuple.Triplet<FluidStack, FluidStack, FluidStack>(new FluidStack(Fluids.NONE, 0), new FluidStack(Fluids.UNSATURATEDS, 75), new FluidStack(Fluids.CHLORINE, 25)));
        recipes.put(Fluids.UNSATURATEDS, new Tuple.Triplet<FluidStack, FluidStack, FluidStack>(new FluidStack(Fluids.NONE, 0), new FluidStack(Fluids.AROMATICS, 70), new FluidStack(Fluids.PETROLEUM, 30)));
        recipes.put(Fluids.AROMATICS, new Tuple.Triplet<FluidStack, FluidStack, FluidStack>(new FluidStack(Fluids.RADIOSOLVENT, 40), new FluidStack(Fluids.XYLENE, 100), new FluidStack(Fluids.CHLORINE, 10)));
        recipes.put(Fluids.PETROLEUM, new Tuple.Triplet<FluidStack, FluidStack, FluidStack>(new FluidStack(Fluids.SULFURIC_ACID, 50), new FluidStack(Fluids.LIGHTOIL, 50), new FluidStack(Fluids.PEROXIDE, 20)));
        recipes.put(Fluids.XYLENE, new Tuple.Triplet<FluidStack, FluidStack, FluidStack>(new FluidStack(Fluids.CCL, 60), new FluidStack(Fluids.REFORMGAS, 100), new FluidStack(Fluids.CHLOROMETHANE, 50)));
        recipes.put(Fluids.CHLOROETHANE, new Tuple.Triplet<FluidStack, FluidStack, FluidStack>(new FluidStack(Fluids.UNSATURATEDS, 60), new FluidStack(Fluids.CBENZ, 70), new FluidStack(Fluids.CHLOROMETHANE, 10)));
    }

    public static Tuple.Triplet<FluidStack, FluidStack, FluidStack> getOutput(FluidType type) {
        return recipes.get(type);
    }

    public static HashMap<Object, Object[]> getRecipes() {
        HashMap<Object, Object[]> map = new HashMap<Object, Object[]>();
        for (Map.Entry<FluidType, Tuple.Triplet<FluidStack, FluidStack, FluidStack>> recipe : recipes.entrySet()) {
            ItemStack[] itemStackArray;
            if (recipe.getValue().getX().type == Fluids.NONE) {
                ItemStack[] itemStackArray2 = new ItemStack[1];
                itemStackArray = itemStackArray2;
                itemStackArray2[0] = ItemFluidIcon.make(recipe.getKey(), 1000);
            } else {
                ItemStack[] itemStackArray3 = new ItemStack[2];
                itemStackArray3[0] = ItemFluidIcon.make(recipe.getKey(), 1000);
                itemStackArray = itemStackArray3;
                itemStackArray3[1] = ItemFluidIcon.make(recipe.getValue().getX().type, recipe.getValue().getX().fill * 10);
            }
            ItemStack[] inputs = itemStackArray;
            map.put(inputs, new ItemStack[]{ItemFluidIcon.make(recipe.getValue().getY().type, recipe.getValue().getY().fill * 10), ItemFluidIcon.make(recipe.getValue().getZ().type, recipe.getValue().getZ().fill * 10)});
        }
        return map;
    }

    @Override
    public String getFileName() {
        return "hbmAlkylation.json";
    }

    @Override
    public Object getRecipeObject() {
        return recipes;
    }

    @Override
    public void readRecipe(JsonElement recipe) {
        JsonObject obj = (JsonObject)recipe;
        FluidType input = Fluids.fromName(obj.get("input").getAsString());
        FluidStack acid = AlkylationRecipes.readFluidStack(obj.get("acid").getAsJsonArray());
        FluidStack output1 = AlkylationRecipes.readFluidStack(obj.get("output1").getAsJsonArray());
        FluidStack output2 = AlkylationRecipes.readFluidStack(obj.get("output2").getAsJsonArray());
        recipes.put(input, new Tuple.Triplet<FluidStack, FluidStack, FluidStack>(acid, output1, output2));
    }

    @Override
    public void writeRecipe(Object recipe, JsonWriter writer) throws IOException {
        Map.Entry rec = (Map.Entry)recipe;
        writer.name("input").value(((FluidType)rec.getKey()).getName());
        writer.name("acid");
        AlkylationRecipes.writeFluidStack((FluidStack)((Tuple.Triplet)rec.getValue()).getX(), writer);
        writer.name("output1");
        AlkylationRecipes.writeFluidStack((FluidStack)((Tuple.Triplet)rec.getValue()).getY(), writer);
        writer.name("output2");
        AlkylationRecipes.writeFluidStack((FluidStack)((Tuple.Triplet)rec.getValue()).getZ(), writer);
    }

    @Override
    public void deleteRecipes() {
        recipes.clear();
    }
}

