/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.material;

import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.material.MaterialShapes;
import com.hbm.inventory.material.NTMMaterial;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemScraps;
import com.hbm.util.ItemStackUtil;
import com.hbm.util.i18n.I18nUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class Mats {
    public static List<NTMMaterial> orderedList = new ArrayList<NTMMaterial>();
    public static HashMap<String, MaterialShapes> prefixByName = new HashMap();
    public static HashMap<Integer, NTMMaterial> matById = new HashMap();
    public static HashMap<String, NTMMaterial> matByName = new HashMap();
    public static HashMap<RecipesCommon.ComparableStack, List<MaterialStack>> materialEntries = new HashMap();
    public static HashMap<String, List<MaterialStack>> materialOreEntries = new HashMap();
    public static final int _VS = 0;
    public static final int _AS = 30;
    public static final int _ES = 20000;
    public static final int _EX = 24000;
    public static final NTMMaterial MAT_WOOD = Mats.makeNonSmeltable(3, OreDictManager.WOOD, 9004839, 2629131, 9004839).setAutogen(MaterialShapes.STOCK, MaterialShapes.GRIP).n();
    public static final NTMMaterial MAT_IVORY = Mats.makeNonSmeltable(4, OreDictManager.BONE, 0xFFFEEE, 7960688, 15592394).setAutogen(MaterialShapes.GRIP).n();
    public static final NTMMaterial MAT_STONE = Mats.makeSmeltable(0, Mats.df("Stone"), 0x7F7F7F, 0x353535, 5058339).n();
    public static final NTMMaterial MAT_CARBON = Mats.makeAdditive(699, OreDictManager.CARBON, 0x363636, 197379, 0x404040).setAutogen(MaterialShapes.WIRE, MaterialShapes.BLOCK).n();
    public static final NTMMaterial MAT_COAL = Mats.makeNonSmeltable(600, OreDictManager.COAL, 0x363636, 197379, 0x404040).setConversion(MAT_CARBON, 2, 1).setAutogen(MaterialShapes.FRAGMENT).n();
    public static final NTMMaterial MAT_LIGNITE = Mats.makeNonSmeltable(601, OreDictManager.LIGNITE, 5516559, 2495752, 4663571).setConversion(MAT_CARBON, 3, 1).setAutogen(MaterialShapes.FRAGMENT).n();
    public static final NTMMaterial MAT_COALCOKE = Mats.make(610, OreDictManager.COALCOKE).setConversion(MAT_CARBON, 4, 3).n();
    public static final NTMMaterial MAT_PETCOKE = Mats.make(611, OreDictManager.PETCOKE).setConversion(MAT_CARBON, 4, 3).n();
    public static final NTMMaterial MAT_LIGCOKE = Mats.make(612, OreDictManager.LIGCOKE).setConversion(MAT_CARBON, 4, 3).n();
    public static final NTMMaterial MAT_GRAPHITE = Mats.make(620, OreDictManager.GRAPHITE).setConversion(MAT_CARBON, 1, 1).n();
    public static final NTMMaterial MAT_DIAMOND = Mats.makeNonSmeltable(1430, OreDictManager.DIAMOND, 0xFFFFFF, 1801067, 9237730).setConversion(MAT_CARBON, 1, 1).setAutogen(MaterialShapes.FRAGMENT).n();
    public static final NTMMaterial MAT_IRON = Mats.makeSmeltable(2600, OreDictManager.IRON, 0xFFFFFF, 0x353535, 16753241).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.DUST, MaterialShapes.PIPE, MaterialShapes.CASTPLATE, MaterialShapes.WELDEDPLATE, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_GOLD = Mats.makeSmeltable(7900, OreDictManager.GOLD, 0xFFFF8B, 12742144, 15259476).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.WIRE, MaterialShapes.NUGGET, MaterialShapes.DUST, MaterialShapes.DENSEWIRE, MaterialShapes.CASTPLATE, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_REDSTONE = Mats.makeSmeltable(1, OreDictManager.REDSTONE, 14886412, 7343622, 0xFF1000).setAutogen(MaterialShapes.FRAGMENT).n();
    public static final NTMMaterial MAT_OBSIDIAN = Mats.makeSmeltable(2, Mats.df("Obsidian"), 4006733).n();
    public static final NTMMaterial MAT_GLOWSTONE = Mats.makeNonSmeltable(5, OreDictManager.GLOWSTONE, 0xFFFF00, 0x535300, 0xFFFF00).setAutogen(MaterialShapes.FRAGMENT).n();
    public static final NTMMaterial MAT_HEMATITE = Mats.makeAdditive(2601, OreDictManager.HEMATITE, 14661550, 6240046, 7226941).m();
    public static final NTMMaterial MAT_WROUGHTIRON = Mats.makeSmeltable(2602, Mats.df("WroughtIron"), 16427913).m();
    public static final NTMMaterial MAT_PIGIRON = Mats.makeSmeltable(2603, Mats.df("PigIron"), 16747353).m();
    public static final NTMMaterial MAT_METEORICIRON = Mats.makeSmeltable(2604, Mats.df("MeteoricIron"), 7426887).m();
    public static final NTMMaterial MAT_MALACHITE = Mats.makeAdditive(2901, OreDictManager.MALACHITE, 10678472, 2256968, 6401927).m();
    public static final NTMMaterial MAT_BAUXITE = Mats.makeNonSmeltable(2902, OreDictManager.BAUXITE, 16038448, 11153930, 14833167).setAutogen(MaterialShapes.FRAGMENT).n();
    public static final NTMMaterial MAT_CRYOLITE = Mats.makeNonSmeltable(2903, OreDictManager.CRYOLITE, 13353636, 9138463, 9138202).setAutogen(MaterialShapes.FRAGMENT).n();
    public static final NTMMaterial MAT_CONGLOMERATE = Mats.makeAdditive(2993, OreDictManager.CONGLOMERATE, 0x797979, 0x797979, 0x797979).m();
    public static final NTMMaterial MAT_URANIUM = Mats.makeSmeltable(9200, OreDictManager.U, 12699581, 2830887, 10133910).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.DUST, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_U233 = Mats.makeSmeltable(9233, OreDictManager.U233, 12699581, 2830887, 10133910).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.DUST, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_U235 = Mats.makeSmeltable(9235, OreDictManager.U235, 12699581, 2830887, 10133910).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.DUST, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_U238 = Mats.makeSmeltable(9238, OreDictManager.U238, 12699581, 2830887, 10133910).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.DUST, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_THORIUM = Mats.makeSmeltable(9032, OreDictManager.TH232, 12550751, 0x1C0000, 12550751).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.DUST, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_PLUTONIUM = Mats.makeSmeltable(9400, OreDictManager.PU, 10134432, 0x111A17, 7897470).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.DUST, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_RGP = Mats.makeSmeltable(9401, OreDictManager.PURG, 10134432, 0x111A17, 7897470).setAutogen(MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_PU238 = Mats.makeSmeltable(9438, OreDictManager.PU238, 16759897, 16748075, 7897470).setAutogen(MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_PU239 = Mats.makeSmeltable(9439, OreDictManager.PU239, 10134432, 0x111A17, 7897470).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_PU240 = Mats.makeSmeltable(9440, OreDictManager.PU240, 10134432, 0x111A17, 7897470).setAutogen(MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_PU241 = Mats.makeSmeltable(9441, OreDictManager.PU241, 10134432, 0x111A17, 7897470).setAutogen(MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_RGA = Mats.makeSmeltable(9501, OreDictManager.AMRG, 13546425, 3808289, 9664123).setAutogen(MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_AM241 = Mats.makeSmeltable(9541, OreDictManager.AM241, 13546425, 3808289, 9664123).setAutogen(MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_AM242 = Mats.makeSmeltable(9542, OreDictManager.AM242, 13546425, 3808289, 9664123).setAutogen(MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_NEPTUNIUM = Mats.makeSmeltable(9337, OreDictManager.NP237, 10924710, 200451, 6582372).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.DUST, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_POLONIUM = Mats.makeSmeltable(8410, OreDictManager.PO210, 9865081, 4003081, 7429706).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.DUST, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_TECHNETIUM = Mats.makeSmeltable(4399, OreDictManager.TC99, 0xFAFFFF, 5729388, 13295583).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_RADIUM = Mats.makeSmeltable(8826, OreDictManager.RA226, 0xFCFCFC, 11386810, 15334134).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.DUST, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_ACTINIUM = Mats.makeSmeltable(8927, OreDictManager.AC227, 0xECE0E0, 0x221616, 0x958989).setAutogen(MaterialShapes.NUGGET, MaterialShapes.BILLET).m();
    public static final NTMMaterial MAT_CO60 = Mats.makeSmeltable(2760, OreDictManager.CO60, 12767726, 0x353554, 9401006).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.DUST).m();
    public static final NTMMaterial MAT_AU198 = Mats.makeSmeltable(7998, OreDictManager.AU198, 0xFFFF8B, 12742144, 15259476).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.DUST).m();
    public static final NTMMaterial MAT_PB209 = Mats.makeSmeltable(8209, OreDictManager.PB209, 11766420, 1180174, 8082269).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.DUST).m();
    public static final NTMMaterial MAT_SCHRABIDIUM = Mats.makeSmeltable(12626, OreDictManager.SA326, 0x32FFFF, 23644, 0x32FFFF).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.NUGGET, MaterialShapes.WIRE, MaterialShapes.BILLET, MaterialShapes.DUST, MaterialShapes.DENSEWIRE, MaterialShapes.PLATE, MaterialShapes.CASTPLATE, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_SOLINIUM = Mats.makeSmeltable(12627, OreDictManager.SA327, 10675936, 17213, 7517872).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_SCHRABIDATE = Mats.makeSmeltable(12600, OreDictManager.SBD, 7848151, 3735646, 6654388).setAutogen(MaterialShapes.DUST, MaterialShapes.DENSEWIRE, MaterialShapes.CASTPLATE, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_SCHRARANIUM = Mats.makeSmeltable(12601, OreDictManager.SRN, 2830887, 2830887, 2404268).setAutogen(MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_GHIORSIUM = Mats.makeSmeltable(12836, OreDictManager.GH336, 16052193, 2765574, 13026977).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_AUSTRALIUM = Mats.makeSmeltable(13800, OreDictManager.AUSTRALIUM, 0xFFFF00, 9657088, 0xFFFF00).setAutogen(MaterialShapes.FRAGMENT).m();
    public static final NTMMaterial MAT_TASMANITE = Mats.makeSmeltable(13895, OreDictManager.TASMANITE, 0xFFFF00, 9657088, 0xFFFF00).setAutogen(MaterialShapes.FRAGMENT).m();
    public static final NTMMaterial MAT_AYERITE = Mats.makeSmeltable(13851, OreDictManager.AYERITE, 0xFFFF00, 9657088, 0xFFFF00).setAutogen(MaterialShapes.FRAGMENT).m();
    public static final NTMMaterial MAT_TITANIUM = Mats.makeSmeltable(2200, OreDictManager.TI, 16249842, 5196875, 11116153).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.DUST, MaterialShapes.PLATE, MaterialShapes.DENSEWIRE, MaterialShapes.CASTPLATE, MaterialShapes.WELDEDPLATE, MaterialShapes.SHELL, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_COPPER = Mats.makeSmeltable(2900, OreDictManager.CU, 16632456, 6299149, 12682038).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.WIRE, MaterialShapes.DUST, MaterialShapes.PLATE, MaterialShapes.DENSEWIRE, MaterialShapes.CASTPLATE, MaterialShapes.WELDEDPLATE, MaterialShapes.SHELL, MaterialShapes.PIPE, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_TUNGSTEN = Mats.makeSmeltable(7400, OreDictManager.W, 0x868686, 0, 0x977474).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.WIRE, MaterialShapes.BOLT, MaterialShapes.DUST, MaterialShapes.DENSEWIRE, MaterialShapes.CASTPLATE, MaterialShapes.WELDEDPLATE, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_ALUMINIUM = Mats.makeSmeltable(1300, OreDictManager.AL, 0xFFFFFF, 3425616, 13678827).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.WIRE, MaterialShapes.DUST, MaterialShapes.PLATE, MaterialShapes.CASTPLATE, MaterialShapes.WELDEDPLATE, MaterialShapes.SHELL, MaterialShapes.PIPE, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_LEAD = Mats.makeSmeltable(8200, OreDictManager.PB, 10921650, 197391, 6579312).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.NUGGET, MaterialShapes.WIRE, MaterialShapes.BOLT, MaterialShapes.DUST, MaterialShapes.PLATE, MaterialShapes.CASTPLATE, MaterialShapes.PIPE, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_BISMUTH = Mats.makeSmeltable(8300, OreDictManager.BI, 11665663, 11665663, 11665663).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.DUST, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_ARSENIC = Mats.makeSmeltable(3300, OreDictManager.AS, 7125690, 0x242525, 0x558080).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.NUGGET).m();
    public static final NTMMaterial MAT_TANTALIUM = Mats.makeSmeltable(7300, OreDictManager.TA, 0xFFFFFF, 1908022, 11049844).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.FRAGMENT, MaterialShapes.NUGGET, MaterialShapes.DUST, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_NEODYMIUM = Mats.makeSmeltable(6000, OreDictManager.ND, 0xE6E6B6, 0x1C1C00, 0x8F8F5F).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.NUGGET, MaterialShapes.DUSTTINY, MaterialShapes.INGOT, MaterialShapes.DUST, MaterialShapes.DENSEWIRE, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_NIOBIUM = Mats.makeSmeltable(4100, OreDictManager.NB, 12021449, 3091778, 13989553).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.NUGGET, MaterialShapes.DUSTTINY, MaterialShapes.DUST, MaterialShapes.DENSEWIRE, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_BERYLLIUM = Mats.makeSmeltable(400, OreDictManager.BE, 11711142, 986883, 11441522).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.NUGGET, MaterialShapes.DUST, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_EMERALD = Mats.makeNonSmeltable(401, OreDictManager.EMERALD, 12255188, 14592, 1564002).setConversion(MAT_BERYLLIUM, 4, 3).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.DUST, MaterialShapes.GEM, MaterialShapes.BLOCK).n();
    public static final NTMMaterial MAT_COBALT = Mats.makeSmeltable(2700, OreDictManager.CO, 12767726, 0x353554, 9401006).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.NUGGET, MaterialShapes.DUSTTINY, MaterialShapes.BILLET, MaterialShapes.DUST, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_BORON = Mats.makeSmeltable(500, OreDictManager.B, 12437714, 2700350, 11367086).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.DUSTTINY, MaterialShapes.DUST, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_BORAX = Mats.makeSmeltable(501, OreDictManager.BORAX, 0xFFFFFF, 9727523, 16772294).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.INGOT, MaterialShapes.DUST).n();
    public static final NTMMaterial MAT_LANTHANIUM = Mats.makeSmeltable(5700, OreDictManager.LA, 13164768, 0x3B5353, 10598841).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_ZIRCONIUM = Mats.makeSmeltable(4000, OreDictManager.ZR, 14933182, 4077337, 11380360).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.NUGGET, MaterialShapes.WIRE, MaterialShapes.DUSTTINY, MaterialShapes.BILLET, MaterialShapes.DUST, MaterialShapes.CASTPLATE, MaterialShapes.WELDEDPLATE, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_SODIUM = Mats.makeSmeltable(1100, OreDictManager.NA, 13877150, 3824235, 8295571).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.INGOT, MaterialShapes.DUST).m();
    public static final NTMMaterial MAT_SODALITE = Mats.makeNonSmeltable(1101, OreDictManager.SODALITE, 14476790, 4794292, 9873382).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.GEM).n();
    public static final NTMMaterial MAT_STRONTIUM = Mats.makeSmeltable(3800, OreDictManager.SR, 15853754, 2563584, 13287827).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.INGOT, MaterialShapes.DUST).m();
    public static final NTMMaterial MAT_CALCIUM = Mats.makeSmeltable(2000, OreDictManager.CA, 13619110, 7634798, 12040068).setAutogen(MaterialShapes.DUST).m();
    public static final NTMMaterial MAT_LITHIUM = Mats.makeSmeltable(300, OreDictManager.LI, 0xFFFFFF, 0x818181, 0xD6D6D6).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.DUST, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_SULFUR = Mats.makeNonSmeltable(1600, OreDictManager.S, 16576128, 12427298, 15851368).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.DUST, MaterialShapes.BLOCK).n();
    public static final NTMMaterial MAT_KNO = Mats.makeNonSmeltable(700, OreDictManager.KNO, 0xD4D4D4, 0x969696, 0xC9C9C9).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.DUST, MaterialShapes.BLOCK).n();
    public static final NTMMaterial MAT_FLUORITE = Mats.makeNonSmeltable(900, OreDictManager.F, 0xFFFFFF, 11575698, 14801876).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.DUST, MaterialShapes.BLOCK).n();
    public static final NTMMaterial MAT_PHOSPHORUS = Mats.makeNonSmeltable(1500, OreDictManager.P_RED, 13304339, 0x600006, 12191253).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.DUST, MaterialShapes.BLOCK).n();
    public static final NTMMaterial MAT_PHOSPHORUS_W = Mats.makeNonSmeltable(1501, OreDictManager.P_WHITE, 16119277, 12893594, 12893594).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.DUST).n();
    public static final NTMMaterial MAT_CHLOROCALCITE = Mats.makeNonSmeltable(1701, OreDictManager.CHLOROCALCITE, 16246625, 4676422, 12106083).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.DUST).n();
    public static final NTMMaterial MAT_MOLYSITE = Mats.makeNonSmeltable(1702, OreDictManager.MOLYSITE, 16378235, 2190848, 13685348).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.DUST).n();
    public static final NTMMaterial MAT_CINNABAR = Mats.makeNonSmeltable(8001, OreDictManager.CINNABAR, 14184560, 0x993030, 12537422).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.GEM).n();
    public static final NTMMaterial MAT_CADMIUM = Mats.makeSmeltable(4800, OreDictManager.CD, 16775902, 0x350000, 11032064).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.DUST).m();
    public static final NTMMaterial MAT_SILICON = Mats.makeSmeltable(1400, OreDictManager.SI, 13752287, 1710653, 8883102).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.NUGGET, MaterialShapes.BILLET).m();
    public static final NTMMaterial MAT_ASBESTOS = Mats.makeSmeltable(1401, OreDictManager.ASBESTOS, 14211535, 6382168, 11580328).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.BLOCK).n();
    public static final NTMMaterial MAT_QUARTZ = Mats.makeNonSmeltable(1402, OreDictManager.NETHERQUARTZ, 16250354, 7298394, 16250354).setAutogen(MaterialShapes.FRAGMENT).n();
    public static final NTMMaterial MAT_OSMIRIDIUM = Mats.makeSmeltable(7699, OreDictManager.OSMIRIDIUM, 14410735, 7901630, 11320793).setAutogen(MaterialShapes.NUGGET, MaterialShapes.CASTPLATE, MaterialShapes.WELDEDPLATE).m();
    public static final NTMMaterial MAT_NICKEL = Mats.makeSmeltable(2800, OreDictManager.NI, 15258055, 8877422, 11441522).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.NUGGET, MaterialShapes.DUST, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_GALLIUM = Mats.makeSmeltable(3100, OreDictManager.GALLIUM, 5400703, 5400703, 5400703).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.NUGGET, MaterialShapes.DUST, MaterialShapes.DUSTTINY).m();
    public static final NTMMaterial MAT_ZINC = Mats.makeSmeltable(3000, OreDictManager.ZI, 14142426, 0x7A7277, 10984872).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.NUGGET, MaterialShapes.DUST, MaterialShapes.WIRE).m();
    public static final NTMMaterial MAT_BROMINE = Mats.makeNonSmeltable(3500, OreDictManager.BR, 16737323, 0x720000, 16737323).setAutogen(MaterialShapes.FRAGMENT).m();
    public static final NTMMaterial MAT_IODINE = Mats.makeNonSmeltable(5300, OreDictManager.I, 8030102, 4141129, 8030102).setAutogen(MaterialShapes.FRAGMENT).m();
    public static final NTMMaterial MAT_HAFNIUM = Mats.makeSmeltable(7200, OreDictManager.HAFNIUM, 16775367, 3020288, 16775367).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.DUST).m();
    public static final NTMMaterial MAT_IRIDIUM = Mats.makeSmeltable(7700, OreDictManager.IRIDIUM, 12112127, 12112127, 12112127).setAutogen(MaterialShapes.INGOT).m();
    public static final NTMMaterial MAT_STEEL = Mats.makeSmeltable(30, OreDictManager.STEEL, 0xAFAFAF, 986895, 0x4A4A4A).setAutogen(MaterialShapes.DUSTTINY, MaterialShapes.BOLT, MaterialShapes.WIRE, MaterialShapes.DUST, MaterialShapes.PLATE, MaterialShapes.CASTPLATE, MaterialShapes.WELDEDPLATE, MaterialShapes.SHELL, MaterialShapes.PIPE, MaterialShapes.BLOCK, MaterialShapes.LIGHTBARREL, MaterialShapes.HEAVYBARREL, MaterialShapes.LIGHTRECEIVER, MaterialShapes.GRIP).m();
    public static final NTMMaterial MAT_MINGRADE = Mats.makeSmeltable(31, OreDictManager.MINGRADE, 16759421, 11474688, 14961679).setAutogen(MaterialShapes.WIRE, MaterialShapes.DUST, MaterialShapes.DENSEWIRE, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_ALLOY = Mats.makeSmeltable(32, OreDictManager.ALLOY, 16745264, 0x700000, 16741144).setAutogen(MaterialShapes.WIRE, MaterialShapes.DUST, MaterialShapes.DENSEWIRE, MaterialShapes.PLATE, MaterialShapes.CASTPLATE, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_DURA = Mats.makeSmeltable(33, OreDictManager.DURA, 8562076, 403486, 4351580).setAutogen(MaterialShapes.BOLT, MaterialShapes.DUST, MaterialShapes.PLATE, MaterialShapes.CASTPLATE, MaterialShapes.PIPE, MaterialShapes.BLOCK, MaterialShapes.LIGHTBARREL, MaterialShapes.HEAVYBARREL, MaterialShapes.LIGHTRECEIVER, MaterialShapes.HEAVYRECEIVER, MaterialShapes.GRIP).m();
    public static final NTMMaterial MAT_DESH = Mats.makeSmeltable(42, OreDictManager.DESH, 0xFF6D6D, 0x720000, 0xF22929).setAutogen(MaterialShapes.DUST, MaterialShapes.CASTPLATE, MaterialShapes.BLOCK, MaterialShapes.LIGHTBARREL, MaterialShapes.HEAVYBARREL, MaterialShapes.LIGHTRECEIVER, MaterialShapes.STOCK, MaterialShapes.GRIP).m();
    public static final NTMMaterial MAT_STAR = Mats.makeSmeltable(35, OreDictManager.STAR, 0xCCCCEA, 0x11111A, 10855891).setAutogen(MaterialShapes.DUST, MaterialShapes.DENSEWIRE, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_FERRO = Mats.makeSmeltable(37, OreDictManager.FERRO, 12040137, 0x101022, 0x6B6B8B).setAutogen(MaterialShapes.CASTPLATE, MaterialShapes.HEAVYBARREL, MaterialShapes.HEAVYRECEIVER).m();
    public static final NTMMaterial MAT_TCALLOY = Mats.makeSmeltable(36, OreDictManager.TCALLOY, 0xD4D6D6, 0x323D3D, 10266278).setAutogen(MaterialShapes.DUST, MaterialShapes.CASTPLATE, MaterialShapes.WELDEDPLATE, MaterialShapes.LIGHTBARREL, MaterialShapes.HEAVYBARREL, MaterialShapes.LIGHTRECEIVER, MaterialShapes.HEAVYRECEIVER).m();
    public static final NTMMaterial MAT_CDALLOY = Mats.makeSmeltable(43, OreDictManager.CDALLOY, 16244623, 6308616, 16503656).setAutogen(MaterialShapes.CASTPLATE, MaterialShapes.WELDEDPLATE, MaterialShapes.LIGHTBARREL, MaterialShapes.HEAVYBARREL, MaterialShapes.LIGHTRECEIVER, MaterialShapes.HEAVYRECEIVER).m();
    public static final NTMMaterial MAT_BBRONZE = Mats.makeSmeltable(46, OreDictManager.BBRONZE, 14785129, 4739923, 9993573).setAutogen(MaterialShapes.CASTPLATE, MaterialShapes.LIGHTBARREL, MaterialShapes.LIGHTRECEIVER, MaterialShapes.HEAVYRECEIVER).m();
    public static final NTMMaterial MAT_ABRONZE = Mats.makeSmeltable(47, OreDictManager.ABRONZE, 14390370, 2110257, 7824461).setAutogen(MaterialShapes.CASTPLATE, MaterialShapes.LIGHTBARREL, MaterialShapes.LIGHTRECEIVER, MaterialShapes.HEAVYRECEIVER).m();
    public static final NTMMaterial MAT_BSCCO = Mats.makeSmeltable(48, OreDictManager.BSCCO, 7764977, 0, 6185664).setAutogen(MaterialShapes.DENSEWIRE).m();
    public static final NTMMaterial MAT_MAGTUNG = Mats.makeSmeltable(38, OreDictManager.MAGTUNG, 0x22A2A2, 986895, 0x22A2A2).setAutogen(MaterialShapes.WIRE, MaterialShapes.DUST, MaterialShapes.DENSEWIRE, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_CMB = Mats.makeSmeltable(39, OreDictManager.CMB, 7303092, 17, 7303092).setAutogen(MaterialShapes.DUST, MaterialShapes.PLATE, MaterialShapes.CASTPLATE, MaterialShapes.WELDEDPLATE, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_DNT = Mats.makeSmeltable(45, OreDictManager.DNT, 7701177, 1441806, 4543113).setAutogen(MaterialShapes.DUST, MaterialShapes.DENSEWIRE, MaterialShapes.BLOCK).m();
    public static final NTMMaterial MAT_FLUX = Mats.makeAdditive(40, Mats.df("Flux"), 15851707, 7299670, 14601389).setAutogen(MaterialShapes.DUST).n();
    public static final NTMMaterial MAT_SLAG = Mats.makeSmeltable(41, OreDictManager.SLAG, 5589312, 3418143, 7103842).setAutogen(MaterialShapes.INGOT, MaterialShapes.BLOCK).n();
    public static final NTMMaterial MAT_MUD = Mats.makeSmeltable(44, OreDictManager.MUD, 12367273, 4723219, 9861179).n();
    public static final NTMMaterial MAT_GUNMETAL = Mats.makeSmeltable(49, OreDictManager.GUNMETAL, 0xFFEF3F, 11351552, 16369196).setAutogen(MaterialShapes.LIGHTBARREL, MaterialShapes.HEAVYBARREL, MaterialShapes.LIGHTRECEIVER, MaterialShapes.HEAVYRECEIVER, MaterialShapes.MECHANISM, MaterialShapes.STOCK, MaterialShapes.GRIP).n();
    public static final NTMMaterial MAT_WEAPONSTEEL = Mats.makeSmeltable(50, OreDictManager.WEAPONSTEEL, 0xA0A0A0, 0, 0x808080).setAutogen(MaterialShapes.CASTPLATE, MaterialShapes.SHELL, MaterialShapes.LIGHTBARREL, MaterialShapes.HEAVYBARREL, MaterialShapes.LIGHTRECEIVER, MaterialShapes.HEAVYRECEIVER, MaterialShapes.MECHANISM, MaterialShapes.STOCK, MaterialShapes.GRIP).n();
    public static final NTMMaterial MAT_SATURN = Mats.makeSmeltable(34, OreDictManager.BIGMT, 3851482, 600108, 3187895).setAutogen(MaterialShapes.PLATE, MaterialShapes.CASTPLATE, MaterialShapes.SHELL, MaterialShapes.BLOCK, MaterialShapes.LIGHTBARREL, MaterialShapes.HEAVYBARREL, MaterialShapes.LIGHTRECEIVER, MaterialShapes.HEAVYRECEIVER, MaterialShapes.MECHANISM, MaterialShapes.STOCK, MaterialShapes.GRIP).m();
    public static final NTMMaterial MAT_GAAS = Mats.makeSmeltable(24000, OreDictManager.GAAS, 7293527, 7293527, 7293527).setAutogen(MaterialShapes.NUGGET, MaterialShapes.BILLET).m();
    public static final NTMMaterial MAT_STAINLESS = Mats.makeSmeltable(24001, OreDictManager.STAINLESS, 0xD8D8D8, 0x474747, 0x4A4A4A).setAutogen(MaterialShapes.PLATE, MaterialShapes.WELDEDPLATE, MaterialShapes.CASTPLATE).m();
    public static final NTMMaterial MAT_RICH_MAGMA = Mats.makeSmeltable(24002, OreDictManager.RICHMAGMA, 0x7F7F7F, 0x353555, 16736786).n();
    public static final NTMMaterial MAT_SEMTEX = Mats.makeNonSmeltable(24003, OreDictManager.SEMTEX, 15575592, 8543510, 15773840).setAutogen(MaterialShapes.FRAGMENT).n();
    public static final NTMMaterial MAT_RAREEARTH = Mats.makeNonSmeltable(20000, OreDictManager.RAREEARTH, 12697021, 3688006, 0x7B7F7F).setAutogen(MaterialShapes.FRAGMENT).n();
    public static final NTMMaterial MAT_POLYMER = Mats.makeNonSmeltable(20001, OreDictManager.POLYMER, 0x363636, 263172, 0x272727).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.STOCK, MaterialShapes.GRIP).n();
    public static final NTMMaterial MAT_BAKELITE = Mats.makeNonSmeltable(20002, OreDictManager.BAKELITE, 15892614, 2819592, 13187392).setAutogen(MaterialShapes.STOCK, MaterialShapes.GRIP).n();
    public static final NTMMaterial MAT_RUBBER = Mats.makeNonSmeltable(20003, OreDictManager.RUBBER, 8486773, 986371, 4934207).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.DUST, MaterialShapes.PIPE, MaterialShapes.GRIP).n();
    public static final NTMMaterial MAT_HARDPLASTIC = Mats.makeNonSmeltable(20004, OreDictManager.PC, 15591364, 9472615, 14801848).setAutogen(MaterialShapes.STOCK, MaterialShapes.GRIP).n();
    public static final NTMMaterial MAT_PVC = Mats.makeNonSmeltable(20005, OreDictManager.PVC, 0xFCFCFC, 0x9F9F9F, 0xF0F0F0).setAutogen(MaterialShapes.FRAGMENT, MaterialShapes.DUST, MaterialShapes.STOCK, MaterialShapes.GRIP).n();

    public static NTMMaterial makeSmeltable(int id, OreDictManager.DictFrame dict, int color) {
        return Mats.makeSmeltable(id, dict, color, color, color);
    }

    public static NTMMaterial make(int id, OreDictManager.DictFrame dict) {
        return new NTMMaterial(id, dict);
    }

    public static NTMMaterial makeSmeltable(int id, OreDictManager.DictFrame dict, int solidColorLight, int solidColorDark, int moltenColor) {
        return new NTMMaterial(id, dict).smeltable(NTMMaterial.SmeltingBehavior.SMELTABLE).setSolidColor(solidColorLight, solidColorDark).setMoltenColor(moltenColor);
    }

    public static NTMMaterial makeAdditive(int id, OreDictManager.DictFrame dict, int solidColorLight, int solidColorDark, int moltenColor) {
        return new NTMMaterial(id, dict).smeltable(NTMMaterial.SmeltingBehavior.ADDITIVE).setSolidColor(solidColorLight, solidColorDark).setMoltenColor(moltenColor);
    }

    public static NTMMaterial makeNonSmeltable(int id, OreDictManager.DictFrame dict, int solidColorLight, int solidColorDark, int moltenColor) {
        return new NTMMaterial(id, dict).smeltable(NTMMaterial.SmeltingBehavior.NOT_SMELTABLE).setSolidColor(solidColorLight, solidColorDark).setMoltenColor(moltenColor);
    }

    public static OreDictManager.DictFrame df(String string) {
        return new OreDictManager.DictFrame(string);
    }

    public static List<MaterialStack> getMaterialsFromItem(ItemStack stack) {
        List<MaterialStack> entries;
        ArrayList<MaterialStack> list = new ArrayList<MaterialStack>();
        List<String> names = ItemStackUtil.getOreDictNames(stack);
        if (!names.isEmpty()) {
            block0: for (String name : names) {
                List<MaterialStack> oreEntries = materialOreEntries.get(name);
                if (oreEntries != null) {
                    list.addAll(oreEntries);
                    break;
                }
                for (Map.Entry<String, MaterialShapes> prefixEntry : prefixByName.entrySet()) {
                    String materialName;
                    NTMMaterial material;
                    String prefix = prefixEntry.getKey();
                    if (!name.startsWith(prefix) || (material = matByName.get(materialName = name.substring(prefix.length()))) == null || material.smeltsInto.smeltable != NTMMaterial.SmeltingBehavior.SMELTABLE && material.smeltsInto.smeltable != NTMMaterial.SmeltingBehavior.ADDITIVE) continue;
                    list.add(new MaterialStack(material, prefixEntry.getValue().q(1)));
                    break block0;
                }
            }
        }
        if ((entries = materialEntries.get(new RecipesCommon.ComparableStack(stack).makeSingular())) != null) {
            entries.forEach(x -> {
                if (x != null) {
                    list.add((MaterialStack)x);
                }
            });
        }
        if (stack.func_77973_b() == ModItems.scraps) {
            list.add(ItemScraps.getMats(stack));
        }
        return list;
    }

    public static List<MaterialStack> getSmeltingMaterialsFromItem(ItemStack stack) {
        List<MaterialStack> baseMats = Mats.getMaterialsFromItem(stack);
        ArrayList<MaterialStack> smelting = new ArrayList<MaterialStack>();
        baseMats.forEach(x -> smelting.add(new MaterialStack(x.material.smeltsInto, x.amount * x.material.convOut / x.material.convIn)));
        return smelting;
    }

    public static String formatAmount(int amount, boolean showInMb) {
        if (showInMb) {
            return amount * 2 + "mB";
        }
        String format = "";
        int blocks = amount / MaterialShapes.BLOCK.q(1);
        int ingots = (amount -= MaterialShapes.BLOCK.q(blocks)) / MaterialShapes.INGOT.q(1);
        int nuggets = (amount -= MaterialShapes.INGOT.q(ingots)) / MaterialShapes.NUGGET.q(1);
        int quanta = amount -= MaterialShapes.NUGGET.q(nuggets);
        if (blocks > 0) {
            format = format + (blocks == 1 ? I18nUtil.resolveKey("matshape.block", blocks) : I18nUtil.resolveKey("matshape.blocks", blocks)) + " ";
        }
        if (ingots > 0) {
            format = format + (ingots == 1 ? I18nUtil.resolveKey("matshape.ingot", ingots) : I18nUtil.resolveKey("matshape.ingots", ingots)) + " ";
        }
        if (nuggets > 0) {
            format = format + (nuggets == 1 ? I18nUtil.resolveKey("matshape.nugget", nuggets) : I18nUtil.resolveKey("matshape.nuggets", nuggets)) + " ";
        }
        if (quanta > 0) {
            format = format + (quanta == 1 ? I18nUtil.resolveKey("matshape.quantum", quanta) : I18nUtil.resolveKey("matshape.quanta", quanta)) + " ";
        }
        return format.trim();
    }

    public static class MaterialStack {
        public final NTMMaterial material;
        public int amount;

        public MaterialStack(NTMMaterial material, int amount) {
            this.material = material;
            this.amount = amount;
        }

        public MaterialStack copy() {
            return new MaterialStack(this.material, this.amount);
        }
    }
}

