/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.neutron;

import com.hbm.handler.neutron.NeutronNode;
import com.hbm.handler.neutron.NeutronStream;
import com.hbm.handler.neutron.RBMKNeutronHandler;
import com.hbm.util.fauxpointtwelve.BlockPos;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.world.World;

public class NeutronNodeWorld {
    public static HashMap<World, StreamWorld> streamWorlds = new HashMap();

    public static NeutronNode getNode(World world, BlockPos pos) {
        StreamWorld streamWorld = streamWorlds.get(world);
        return streamWorld != null ? (NeutronNode)streamWorld.nodeCache.get(pos) : null;
    }

    public static void removeNode(World world, BlockPos pos) {
        StreamWorld streamWorld = streamWorlds.get(world);
        if (streamWorld == null) {
            return;
        }
        streamWorld.removeNode(pos);
    }

    public static StreamWorld getOrAddWorld(World world) {
        StreamWorld streamWorld = streamWorlds.get(world);
        if (streamWorld == null) {
            streamWorld = new StreamWorld();
            streamWorlds.put(world, streamWorld);
        }
        return streamWorld;
    }

    public static void removeAllWorlds() {
        streamWorlds.clear();
    }

    public static void removeEmptyWorlds() {
        streamWorlds.values().removeIf(streamWorld -> ((StreamWorld)streamWorld).streams.isEmpty());
    }

    public static class StreamWorld {
        private List<NeutronStream> streams;
        private HashMap<BlockPos, NeutronNode> nodeCache = new HashMap();

        public StreamWorld() {
            this.streams = new ArrayList<NeutronStream>();
        }

        public void runStreamInteractions(World world) {
            for (NeutronStream stream : this.streams) {
                stream.runStreamInteraction(world, this);
            }
        }

        public void addStream(NeutronStream stream) {
            this.streams.add(stream);
        }

        public void removeAllStreams() {
            this.streams.clear();
        }

        public void cleanNodes() {
            ArrayList<BlockPos> toRemove = new ArrayList<BlockPos>();
            for (NeutronNode cachedNode : this.nodeCache.values()) {
                if (cachedNode.type != NeutronStream.NeutronType.RBMK) continue;
                RBMKNeutronHandler.RBMKNeutronNode node = (RBMKNeutronHandler.RBMKNeutronNode)cachedNode;
                toRemove.addAll(node.checkNode(this));
            }
            for (BlockPos pos : toRemove) {
                this.nodeCache.remove(pos);
            }
        }

        public NeutronNode getNode(BlockPos pos) {
            return this.nodeCache.get(pos);
        }

        public void addNode(NeutronNode node) {
            this.nodeCache.put(node.pos, node);
        }

        public void removeNode(BlockPos pos) {
            this.nodeCache.remove(pos);
        }

        public void removeAllStreamsOfType(NeutronStream.NeutronType type) {
            this.streams.removeIf(stream -> stream.type == type);
        }
    }
}

