/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion;

import com.hbm.blocks.generic.DecoBlockAlt;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ExplosionFleija {
    public int posX;
    public int posY;
    public int posZ;
    public int lastposX = 0;
    public int lastposZ = 0;
    public int radius;
    public int radius2;
    public World worldObj;
    private int n = 1;
    private int nlimit;
    private int shell;
    private int leg;
    private int element;
    public float explosionCoefficient = 1.0f;
    public float explosionCoefficient2 = 1.0f;

    public void saveToNbt(NBTTagCompound nbt, String name) {
        nbt.func_74768_a(name + "posX", this.posX);
        nbt.func_74768_a(name + "posY", this.posY);
        nbt.func_74768_a(name + "posZ", this.posZ);
        nbt.func_74768_a(name + "lastposX", this.lastposX);
        nbt.func_74768_a(name + "lastposZ", this.lastposZ);
        nbt.func_74768_a(name + "radius", this.radius);
        nbt.func_74768_a(name + "radius2", this.radius2);
        nbt.func_74768_a(name + "n", this.n);
        nbt.func_74768_a(name + "nlimit", this.nlimit);
        nbt.func_74768_a(name + "shell", this.shell);
        nbt.func_74768_a(name + "leg", this.leg);
        nbt.func_74768_a(name + "element", this.element);
        nbt.func_74776_a(name + "explosionCoefficient", this.explosionCoefficient);
        nbt.func_74776_a(name + "explosionCoefficient2", this.explosionCoefficient2);
    }

    public void readFromNbt(NBTTagCompound nbt, String name) {
        this.posX = nbt.func_74762_e(name + "posX");
        this.posY = nbt.func_74762_e(name + "posY");
        this.posZ = nbt.func_74762_e(name + "posZ");
        this.lastposX = nbt.func_74762_e(name + "lastposX");
        this.lastposZ = nbt.func_74762_e(name + "lastposZ");
        this.radius = nbt.func_74762_e(name + "radius");
        this.radius2 = nbt.func_74762_e(name + "radius2");
        this.n = nbt.func_74762_e(name + "n");
        this.nlimit = nbt.func_74762_e(name + "nlimit");
        this.shell = nbt.func_74762_e(name + "shell");
        this.leg = nbt.func_74762_e(name + "leg");
        this.element = nbt.func_74762_e(name + "element");
        this.explosionCoefficient = nbt.func_74760_g(name + "explosionCoefficient");
        this.explosionCoefficient2 = nbt.func_74760_g(name + "explosionCoefficient2");
    }

    public ExplosionFleija(int x, int y, int z, World world, int rad, float coefficient, float coefficient2) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.worldObj = world;
        this.radius = rad;
        this.radius2 = this.radius * this.radius;
        this.explosionCoefficient = coefficient;
        this.explosionCoefficient2 = coefficient2;
        this.nlimit = this.radius2 * 4;
    }

    public boolean update() {
        this.breakColumn(this.lastposX, this.lastposZ);
        this.shell = (int)Math.floor((Math.sqrt(this.n) + 1.0) / 2.0);
        int shell2 = this.shell * 2;
        if (shell2 == 0) {
            return true;
        }
        this.leg = (int)Math.floor((this.n - (shell2 - 1) * (shell2 - 1)) / shell2);
        this.element = this.n - (shell2 - 1) * (shell2 - 1) - shell2 * this.leg - this.shell + 1;
        int n = this.leg == 0 ? this.shell : (this.leg == 1 ? -this.element : (this.lastposX = this.leg == 2 ? -this.shell : this.element));
        this.lastposZ = this.leg == 0 ? this.element : (this.leg == 1 ? this.shell : (this.leg == 2 ? -this.element : -this.shell));
        ++this.n;
        return this.n > this.nlimit;
    }

    private void breakColumn(int x, int z) {
        int dist = this.radius2 - (x * x + z * z);
        if (dist > 0) {
            dist = (int)Math.sqrt(dist);
            int y = (int)((float)dist / this.explosionCoefficient2);
            while ((float)y > (float)(-dist) / this.explosionCoefficient) {
                if (this.posY + y > 0 && !(this.worldObj.func_147439_a(this.posX + x, this.posY + y, this.posZ + z) instanceof DecoBlockAlt)) {
                    this.worldObj.func_147449_b(this.posX + x, this.posY + y, this.posZ + z, Blocks.field_150350_a);
                }
                --y;
            }
        }
    }
}

