/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.mob.ai;

import com.hbm.entity.projectile.EntityBulletBaseMK4;
import com.hbm.handler.CasingEjector;
import com.hbm.items.weapon.sedna.factory.XFactory12ga;
import com.hbm.items.weapon.sedna.factory.XFactoryRocket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.toclient.AuxParticlePacketNT;
import com.hbm.particle.SpentCasing;
import cpw.mods.fml.common.network.NetworkRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;

public class EntityAITankshell
extends EntityAIBase {
    private EntityCreature owner;
    private EntityLivingBase target;
    private int delay;
    private int timer;
    private int AttackDistance;
    private boolean artilleryMode;
    private int reloadTimer;
    private int reloadDelay;
    protected static CasingEjector ejector = new CasingEjector().setMotion(0.0, 0.6, -1.0).setAngleRange(0.1f, 0.1f);
    protected SpentCasing cachedCasingConfig = null;

    public EntityAITankshell(EntityCreature owner, boolean checkSight, boolean nearbyOnly, int delay, int switchAttackDistance, int reloadDelay) {
        this.owner = owner;
        this.delay = delay;
        this.timer = delay;
        this.AttackDistance = switchAttackDistance;
        this.artilleryMode = true;
        this.reloadTimer = reloadDelay;
        this.reloadDelay = reloadDelay;
    }

    public boolean func_75250_a() {
        EntityLivingBase entity = this.owner.func_70638_az();
        if (entity == null) {
            return false;
        }
        this.target = entity;
        double dist = Vec3.func_72443_a((double)(this.target.field_70165_t - this.owner.field_70165_t), (double)(this.target.field_70163_u - this.owner.field_70163_u), (double)(this.target.field_70161_v - this.owner.field_70161_v)).func_72433_c();
        this.artilleryMode = dist > (double)this.AttackDistance;
        return dist > 2.0 && dist < 50.0;
    }

    public boolean func_75253_b() {
        return this.func_75250_a() || !this.owner.func_70661_as().func_75500_f();
    }

    public void func_75246_d() {
        --this.timer;
        if (this.timer <= 0) {
            if (this.artilleryMode) {
                this.fireArtilleryShell();
            }
            this.timer = this.delay;
        }
        this.owner.field_70177_z = this.owner.field_70759_as;
    }

    protected CasingEjector getEjector() {
        return ejector;
    }

    protected Vec3 getCasingSpawnPos() {
        return Vec3.func_72443_a((double)this.owner.field_70165_t, (double)this.owner.field_70163_u, (double)this.owner.field_70161_v);
    }

    protected void spawnCasing() {
        this.cachedCasingConfig = new SpentCasing(SpentCasing.CasingType.SHOTGUN).setColor(15064320, 0x757575).setScale(10.0f).register("TankGa").setupSmoke(0.02f, 0.5, 60, 20).setMaxAge(60);
        if (this.cachedCasingConfig == null) {
            return;
        }
        CasingEjector ej = this.getEjector();
        Vec3 spawn = this.getCasingSpawnPos();
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("type", "casing");
        data.func_74776_a("pitch", 0.0f);
        data.func_74776_a("yaw", this.owner.field_70759_as);
        data.func_74757_a("crouched", false);
        data.func_74778_a("name", this.cachedCasingConfig.getName());
        if (ej != null) {
            data.func_74768_a("ej", ej.getId());
        }
        PacketDispatcher.wrapper.sendToAllAround(new AuxParticlePacketNT(data, spawn.field_72450_a, spawn.field_72448_b, spawn.field_72449_c), new NetworkRegistry.TargetPoint(this.owner.field_70170_p.field_73011_w.field_76574_g, this.owner.field_70165_t, this.owner.field_70163_u, this.owner.field_70161_v, 50.0));
        this.cachedCasingConfig = null;
    }

    private void fireArtilleryShell() {
        if (this.reloadTimer <= 0) {
            double xOffset = Math.cos(Math.toRadians(this.owner.field_70759_as)) * 0.0;
            double zOffset = Math.sin(Math.toRadians(this.owner.field_70759_as)) * 1.5;
            double yOffset = 10.0;
            double targetX = this.target.field_70165_t - (this.owner.field_70165_t + xOffset);
            double targetY = this.target.field_70163_u + (double)this.target.func_70047_e() - (this.owner.field_70163_u + yOffset);
            double targetZ = this.target.field_70161_v - (this.owner.field_70161_v + zOffset);
            double distance = Math.sqrt(targetX * targetX + targetY * targetY + targetZ * targetZ);
            targetX /= distance;
            targetY /= distance;
            targetZ /= distance;
            this.spawnCasing();
            if (distance > 30.0) {
                if (this.owner.func_110143_aJ() < 30.0f) {
                    EntityBulletBaseMK4 bullet = new EntityBulletBaseMK4((EntityLivingBase)this.owner, XFactoryRocket.rocket_qd[3], 4.0f, 0.01f, this.owner.field_70165_t, this.owner.field_70163_u + 3.0, this.owner.field_70161_v);
                    bullet.func_70107_b(this.owner.field_70165_t, this.owner.field_70163_u + 3.0, this.owner.field_70161_v);
                    bullet.field_70159_w = targetX * 0.5;
                    bullet.field_70179_y = targetZ * 0.5;
                    bullet.field_70181_x = targetY * 0.1;
                    this.owner.field_70170_p.func_72838_d((Entity)bullet);
                } else {
                    EntityBulletBaseMK4 bullet = new EntityBulletBaseMK4((EntityLivingBase)this.owner, XFactoryRocket.rocket_qd[1], 4.0f, 0.01f, this.owner.field_70165_t, this.owner.field_70163_u + 3.0, this.owner.field_70161_v);
                    bullet.func_70107_b(this.owner.field_70165_t, this.owner.field_70163_u + 3.0, this.owner.field_70161_v);
                    bullet.field_70159_w = targetX * 0.5;
                    bullet.field_70179_y = targetZ * 0.5;
                    bullet.field_70181_x = targetY * 0.1;
                    this.owner.field_70170_p.func_72838_d((Entity)bullet);
                }
            } else {
                for (int i = 0; i < 8; ++i) {
                    EntityBulletBaseMK4 bullet = new EntityBulletBaseMK4((EntityLivingBase)this.owner, XFactory12ga.g12_explosive, 4.0f, 0.01f, this.owner.field_70165_t, this.owner.field_70163_u + 3.0, this.owner.field_70161_v);
                    bullet.func_70107_b(this.owner.field_70165_t, this.owner.field_70163_u + 3.0, this.owner.field_70161_v);
                    bullet.field_70159_w = targetX * (0.2 + 0.5 * Math.random());
                    bullet.field_70179_y = targetZ * (0.2 + 0.5 * Math.random());
                    bullet.field_70181_x = targetY * 0.1;
                    this.owner.field_70170_p.func_72838_d((Entity)bullet);
                }
            }
            this.owner.field_70170_p.func_72908_a(this.owner.field_70165_t, this.owner.field_70163_u, this.owner.field_70161_v, "hbm:turret.jeremy_fire", 25.0f, 1.0f);
            this.reloadTimer = this.reloadDelay;
        } else {
            --this.reloadTimer;
        }
        if (this.reloadTimer == 20) {
            this.owner.field_70170_p.func_72908_a(this.owner.field_70165_t, this.owner.field_70163_u, this.owner.field_70161_v, "hbm:turret.jeremy_reload", 3.0f, 1.0f);
        }
    }
}

