/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim.noise;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.MapGenBase;

public class MapGenVNoise
extends MapGenBase {
    public Block fluidBlock;
    public Block surfBlock;
    public Block rockBlock;
    public int cellSize = 32;
    public double crackSize = 2.0;
    public int plateStartY = 55;
    public int plateThickness = 35;
    public double shapeExponent = 2.0;
    public BiomeGenBase applyToBiome;

    public void func_151539_a(IChunkProvider provider, World world, int chunkX, int chunkZ, Block[] blocks) {
        long seed = world.func_72905_C();
        int startX = chunkX * 16;
        int startZ = chunkZ * 16;
        for (int lx = 0; lx < 16; ++lx) {
            for (int lz = 0; lz < 16; ++lz) {
                BiomeGenBase biome;
                if (this.applyToBiome != null && (biome = world.func_72807_a(lx + chunkX * 16, lz + chunkZ * 16)) != this.applyToBiome) continue;
                int gx = startX + lx;
                int gz = startZ + lz;
                double d0 = Double.MAX_VALUE;
                double d1 = Double.MAX_VALUE;
                int cellX = gx / this.cellSize;
                int cellZ = gz / this.cellSize;
                for (int dx = -2; dx <= 2; ++dx) {
                    for (int dz = -2; dz <= 2; ++dz) {
                        double[] center = this.getCellCenter(cellX + dx, cellZ + dz, seed);
                        double dist = this.distance(gx, gz, center[0], center[1]);
                        if (dist < d0) {
                            d1 = d0;
                            d0 = dist;
                            continue;
                        }
                        if (!(dist < d1)) continue;
                        d1 = dist;
                    }
                }
                double edge = d1 - d0;
                if (!(edge > this.crackSize)) continue;
                double alpha = (edge - this.crackSize) / ((double)this.cellSize - this.crackSize);
                alpha = Math.max(0.0, Math.min(1.0, alpha));
                alpha = Math.pow(alpha, this.shapeExponent);
                int topY = this.plateStartY + (int)((double)this.plateThickness * alpha);
                for (int y = this.plateStartY; y < topY && y < 256; ++y) {
                    int index = (lx * 16 + lz) * 256 + y;
                    if (blocks[index] != Blocks.field_150350_a && blocks[index] != this.fluidBlock) continue;
                    blocks[index] = this.rockBlock;
                }
                if (topY <= this.plateStartY) continue;
                int topIndex = (lx * 16 + lz) * 256 + (topY - 1);
                blocks[topIndex] = this.surfBlock;
            }
        }
    }

    private double[] getCellCenter(int cellX, int cellZ, long worldSeed) {
        long hash = (long)cellX * 341873128712L + (long)cellZ * 132897987541L + worldSeed;
        Random rand = new Random(hash);
        double offsetX = (rand.nextDouble() - 0.5) * (double)this.cellSize;
        double offsetZ = (rand.nextDouble() - 0.5) * (double)this.cellSize;
        double centerX = (double)cellX * (double)this.cellSize + (double)this.cellSize / 2.0 + offsetX;
        double centerZ = (double)cellZ * (double)this.cellSize + (double)this.cellSize / 2.0 + offsetZ;
        return new double[]{centerX, centerZ};
    }

    private double distance(double x1, double z1, double x2, double z2) {
        double dx = x1 - x2;
        double dz = z1 - z2;
        return Math.sqrt(dx * dx + dz * dz);
    }
}

