/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim.noise;

import com.hbm.dim.noise.OctavePerlinNoiseSampler;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;

public class DoublePerlinNoiseSampler {
    private final double amplitude;
    private final OctavePerlinNoiseSampler firstSampler;
    private final OctavePerlinNoiseSampler secondSampler;

    public static DoublePerlinNoiseSampler create(Random random, int offset, double ... octaves) {
        ArrayList<Double> list = new ArrayList<Double>();
        for (double octave : octaves) {
            list.add(octave);
        }
        return new DoublePerlinNoiseSampler(random, offset, list);
    }

    public static DoublePerlinNoiseSampler create(Random random, int offset, List<Double> octaves) {
        return new DoublePerlinNoiseSampler(random, offset, octaves);
    }

    private DoublePerlinNoiseSampler(Random random, int offset, List<Double> octaves) {
        this.firstSampler = OctavePerlinNoiseSampler.create(random, offset, octaves);
        this.secondSampler = OctavePerlinNoiseSampler.create(random, offset, octaves);
        int i = Integer.MAX_VALUE;
        int j = Integer.MIN_VALUE;
        ListIterator<Double> doubleListIterator = octaves.listIterator();
        while (doubleListIterator.hasNext()) {
            int k = doubleListIterator.nextIndex();
            double d = doubleListIterator.next();
            if (d == 0.0) continue;
            i = Math.min(i, k);
            j = Math.max(j, k);
        }
        this.amplitude = 0.16666666666666666 / DoublePerlinNoiseSampler.createAmplitude(j - i);
    }

    private static double createAmplitude(int octaves) {
        return 0.1 * (1.0 + 1.0 / (double)(octaves + 1));
    }

    public double sample(double x, double y, double z) {
        double d = x * 1.0181268882175227;
        double e = y * 1.0181268882175227;
        double f = z * 1.0181268882175227;
        return (this.firstSampler.sample(x, y, z) + this.secondSampler.sample(d, e, f)) * this.amplitude;
    }
}

