/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.generic;

import com.hbm.world.gen.util.LogicBlockActions;
import com.hbm.world.gen.util.LogicBlockConditions;
import com.hbm.world.gen.util.LogicBlockInteractions;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class LogicBlock
extends BlockContainer {
    public LogicBlock() {
        super(Material.field_151576_e);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityLogicBlock();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityLogicBlock) {
            TileEntityLogicBlock logicBlock = (TileEntityLogicBlock)tile;
            if (logicBlock.disguise != null) {
                return logicBlock.disguise.func_149691_a(side, logicBlock.disguiseMeta);
            }
        }
        return super.func_149673_e(world, x, y, z, side);
    }

    public boolean func_149727_a(World worldIn, int x, int y, int z, EntityPlayer player, int side, float subX, float subY, float subZ) {
        TileEntity te = worldIn.func_147438_o(x, y, z);
        if (te instanceof TileEntityLogicBlock && ((TileEntityLogicBlock)te).interaction != null) {
            ((TileEntityLogicBlock)te).interaction.accept(new Object[]{worldIn, te, x, y, z, player, side, Float.valueOf(subX), Float.valueOf(subY), Float.valueOf(subZ)});
            return true;
        }
        return super.func_149727_a(worldIn, x, y, z, player, side, subX, subY, subZ);
    }

    public static class TileEntityLogicBlock
    extends TileEntity {
        public int phase = 0;
        public int timer = 0;
        public Block disguise;
        public int disguiseMeta;
        public String conditionID = "PLAYER_CUBE_5";
        public String actionID = "FODDER_WAVE";
        public String interactionID;
        public Function<TileEntityLogicBlock, Boolean> condition;
        public Consumer<TileEntityLogicBlock> action;
        public Consumer<Object[]> interaction;
        public EntityPlayer player;
        public ForgeDirection direction = ForgeDirection.UNKNOWN;

        public void func_145845_h() {
            if (!this.field_145850_b.field_72995_K) {
                if (this.action == null) {
                    this.action = LogicBlockActions.actions.get(this.actionID);
                }
                if (this.condition == null) {
                    this.condition = LogicBlockConditions.conditions.get(this.conditionID);
                }
                if (this.interaction == null && this.interactionID != null) {
                    this.interaction = LogicBlockInteractions.interactions.get(this.interactionID);
                }
                if (this.action == null || this.condition == null) {
                    this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, Blocks.field_150350_a);
                    return;
                }
                this.action.accept(this);
                if (this.condition.apply(this).booleanValue()) {
                    ++this.phase;
                    this.timer = 0;
                } else {
                    ++this.timer;
                }
            }
        }

        public void func_145841_b(NBTTagCompound nbt) {
            super.func_145841_b(nbt);
            nbt.func_74768_a("phase", this.phase);
            nbt.func_74778_a("actionID", this.actionID);
            nbt.func_74778_a("conditionID", this.conditionID);
            if (this.interactionID != null) {
                nbt.func_74778_a("interactionID", this.interactionID);
            }
            nbt.func_74768_a("direction", this.direction.ordinal());
            if (this.disguise != null) {
                nbt.func_74768_a("disguiseMeta", this.disguiseMeta);
                nbt.func_74778_a("disguise", GameRegistry.findUniqueIdentifierFor((Block)this.disguise).toString());
            }
        }

        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            this.phase = nbt.func_74762_e("phase");
            this.actionID = nbt.func_74779_i("actionID");
            this.conditionID = nbt.func_74779_i("conditionID");
            if (nbt.func_74764_b("interactionID")) {
                this.interactionID = nbt.func_74779_i("interactionID");
            }
            this.direction = ForgeDirection.getOrientation((int)nbt.func_74762_e("direction"));
            if (nbt.func_74764_b("disguise")) {
                this.disguiseMeta = nbt.func_74762_e("disguiseMeta");
                this.disguise = Block.func_149684_b((String)nbt.func_74779_i("disguise"));
            }
        }

        public Packet func_145844_m() {
            NBTTagCompound nbt = new NBTTagCompound();
            this.func_145841_b(nbt);
            return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
        }

        public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
            this.func_145839_a(pkt.func_148857_g());
        }
    }
}

