/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks;

import java.util.Random;
import net.minecraft.block.Block;

public class ModSoundType
extends Block.SoundType {
    protected final String placeSound;
    protected final String breakSound;
    protected final String stepSound;

    protected ModSoundType(String placeSound, String breakSound, String stepSound, float volume, float pitch) {
        super("", volume, pitch);
        this.placeSound = placeSound;
        this.breakSound = breakSound;
        this.stepSound = stepSound;
    }

    public ModEnvelopedSoundType enveloped() {
        return new ModEnvelopedSoundType(this.placeSound, this.breakSound, this.stepSound, this.field_150499_b, this.field_150500_c);
    }

    public ModEnvelopedSoundType enveloped(Random random) {
        return new ModEnvelopedSoundType(this.placeSound, this.breakSound, this.stepSound, this.field_150499_b, this.field_150500_c, random);
    }

    public String func_150496_b() {
        return this.placeSound;
    }

    public String func_150495_a() {
        return this.breakSound;
    }

    public String func_150498_e() {
        return this.stepSound;
    }

    public static ModSoundType mod(String soundName, float volume, float pitch) {
        return new ModSoundType(ModSoundType.modDig(soundName), ModSoundType.modDig(soundName), ModSoundType.modStep(soundName), volume, pitch);
    }

    public static ModSoundType customPlace(String soundName, String placeSound, float volume, float pitch) {
        return new ModSoundType(placeSound, ModSoundType.modDig(soundName), ModSoundType.modStep(soundName), volume, pitch);
    }

    public static ModSoundType customBreak(String soundName, String breakSound, float volume, float pitch) {
        return new ModSoundType(ModSoundType.modDig(soundName), breakSound, ModSoundType.modStep(soundName), volume, pitch);
    }

    public static ModSoundType customStep(String soundName, String stepSound, float volume, float pitch) {
        return new ModSoundType(ModSoundType.modDig(soundName), ModSoundType.modDig(soundName), stepSound, volume, pitch);
    }

    public static ModSoundType customDig(String soundName, String digSound, float volume, float pitch) {
        return new ModSoundType(digSound, digSound, ModSoundType.modStep(soundName), volume, pitch);
    }

    public static ModSoundType customPlace(Block.SoundType from, String placeSound, float volume, float pitch) {
        return new ModSoundType(placeSound, from.func_150495_a(), from.func_150498_e(), volume, pitch);
    }

    public static ModSoundType customBreak(Block.SoundType from, String breakSound, float volume, float pitch) {
        return new ModSoundType(from.func_150496_b(), breakSound, from.func_150498_e(), volume, pitch);
    }

    public static ModSoundType customStep(Block.SoundType from, String stepSound, float volume, float pitch) {
        return new ModSoundType(from.func_150496_b(), from.func_150495_a(), stepSound, volume, pitch);
    }

    public static ModSoundType customDig(Block.SoundType from, String dig, float volume, float pitch) {
        return new ModSoundType(dig, dig, from.func_150498_e(), volume, pitch);
    }

    public static ModSoundType placeBreakStep(String placeSound, String breakSound, String stepSound, float volume, float pitch) {
        return new ModSoundType(placeSound, breakSound, stepSound, volume, pitch);
    }

    private static String modDig(String soundName) {
        return "hbm:dig." + soundName;
    }

    private static String modStep(String soundName) {
        return "hbm:step." + soundName;
    }

    public static enum SubType {
        PLACE,
        BREAK,
        STEP;

    }

    public static class ModEnvelopedSoundType
    extends ModSoundType {
        private final Random random;
        private SubType probableSubType = SubType.PLACE;
        private Envelope volumeEnvelope = null;
        private Envelope pitchEnvelope = null;

        ModEnvelopedSoundType(String placeSound, String breakSound, String stepSound, float volume, float pitch, Random random) {
            super(placeSound, breakSound, stepSound, volume, pitch);
            this.random = random;
        }

        ModEnvelopedSoundType(String placeSound, String breakSound, String stepSound, float volume, float pitch) {
            this(placeSound, breakSound, stepSound, volume, pitch, new Random());
        }

        @Override
        public String func_150496_b() {
            this.probableSubType = SubType.PLACE;
            return super.func_150496_b();
        }

        @Override
        public String func_150495_a() {
            this.probableSubType = SubType.BREAK;
            return super.func_150495_a();
        }

        @Override
        public String func_150498_e() {
            this.probableSubType = SubType.STEP;
            return super.func_150498_e();
        }

        public ModEnvelopedSoundType volumeFunction(Envelope volumeEnvelope) {
            this.volumeEnvelope = volumeEnvelope;
            return this;
        }

        public ModEnvelopedSoundType pitchFunction(Envelope pitchEnvelope) {
            this.pitchEnvelope = pitchEnvelope;
            return this;
        }

        public float func_150497_c() {
            if (this.volumeEnvelope == null) {
                return super.func_150497_c();
            }
            return this.volumeEnvelope.compute(super.func_150497_c(), this.random, this.probableSubType);
        }

        public float func_150494_d() {
            if (this.pitchEnvelope == null) {
                return super.func_150494_d();
            }
            return this.pitchEnvelope.compute(super.func_150494_d(), this.random, this.probableSubType);
        }

        @FunctionalInterface
        public static interface Envelope {
            public float compute(float var1, Random var2, SubType var3);
        }
    }
}

