/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class EnchantmentUtil {
    public static void addEnchantment(ItemStack stack, Enchantment enchantment, int level) {
        stack.func_77966_a(enchantment, level);
    }

    public static void removeEnchantment(ItemStack stack, Enchantment enchantment) {
        int i;
        if (stack.func_77986_q() == null) {
            return;
        }
        for (i = 0; i < stack.func_77986_q().func_74745_c() && stack.func_77986_q().func_150305_b(i).func_74765_d("id") != enchantment.field_77352_x; ++i) {
        }
        if (i < stack.func_77986_q().func_74745_c()) {
            stack.func_77986_q().func_74744_a(i);
        }
        if (stack.func_77986_q().func_74745_c() == 0) {
            stack.func_77978_p().func_82580_o("ench");
        }
    }

    public static int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        if (stack.func_77986_q() == null) {
            return 0;
        }
        for (int i = 0; i < stack.func_77986_q().func_74745_c(); ++i) {
            if (stack.func_77986_q().func_150305_b(i).func_74765_d("id") != enchantment.field_77352_x) continue;
            return stack.func_77986_q().func_150305_b(i).func_74765_d("lvl");
        }
        return 0;
    }

    public static int xpBarCap(int level) {
        return level >= 30 ? 62 + (level - 30) * 7 : (level >= 15 ? 17 + (level - 15) * 3 : 17);
    }

    public static int getLevelForExperience(int xp) {
        int level = 0;
        int xpCap;
        while (xp >= (xpCap = EnchantmentUtil.xpBarCap(level))) {
            xp -= xpCap;
            ++level;
        }
        return level;
    }

    public static void addExperience(EntityPlayer player, int xp, boolean silent) {
        int j = Integer.MAX_VALUE - player.field_71067_cb;
        if (xp > j) {
            xp = j;
        }
        player.field_71106_cc += (float)xp / (float)player.func_71050_bK();
        player.field_71067_cb += xp;
        while (player.field_71106_cc >= 1.0f) {
            player.field_71106_cc = (player.field_71106_cc - 1.0f) * (float)player.func_71050_bK();
            if (silent) {
                EnchantmentUtil.addExperienceLevelSilent(player, 1);
            } else {
                player.func_82242_a(1);
            }
            player.field_71106_cc /= (float)player.func_71050_bK();
        }
    }

    public static void setExperience(EntityPlayer player, int xp) {
        player.field_71068_ca = 0;
        player.field_71106_cc = 0.0f;
        player.field_71067_cb = 0;
        EnchantmentUtil.addExperience(player, xp, true);
    }

    public static void addExperienceLevelSilent(EntityPlayer player, int level) {
        player.field_71068_ca += level;
        if (player.field_71068_ca < 0) {
            player.field_71068_ca = 0;
            player.field_71106_cc = 0.0f;
            player.field_71067_cb = 0;
        }
    }

    public static int getTotalExperience(EntityPlayer player) {
        int xp = 0;
        for (int i = 0; i < player.field_71068_ca; ++i) {
            xp += EnchantmentUtil.xpBarCap(i);
        }
        xp = (int)((float)xp + (float)EnchantmentUtil.xpBarCap(player.field_71068_ca) * player.field_71106_cc);
        return xp;
    }
}

