/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.blocks.ModBlocks;
import com.hbm.handler.threading.PacketThreading;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.UpgradeManagerNT;
import com.hbm.inventory.container.ContainerElectrolyserFluid;
import com.hbm.inventory.container.ContainerElectrolyserMetal;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIElectrolyserFluid;
import com.hbm.inventory.gui.GUIElectrolyserMetal;
import com.hbm.inventory.material.MaterialShapes;
import com.hbm.inventory.material.Mats;
import com.hbm.inventory.recipes.ElectrolyserFluidRecipes;
import com.hbm.inventory.recipes.ElectrolyserMetalRecipes;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.packet.toclient.AuxParticlePacketNT;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.IMetalCopiable;
import com.hbm.tileentity.IUpgradeInfoProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.BobMathUtil;
import com.hbm.util.CrucibleUtil;
import com.hbm.util.fauxpointtwelve.DirPos;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityElectrolyser
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IFluidStandardTransceiver,
IControlReceiver,
IGUIProvider,
IUpgradeInfoProvider,
IFluidCopiable,
IMetalCopiable {
    public long power;
    public static final long maxPower = 20000000L;
    public static final int usageOreBase = 10000;
    public static final int usageFluidBase = 10000;
    public int usageOre;
    public int usageFluid;
    public int progressFluid;
    public int processFluidTime = 100;
    public int progressOre;
    public int processOreTime = 600;
    public Mats.MaterialStack leftStack;
    public Mats.MaterialStack rightStack;
    public int maxMaterial = MaterialShapes.BLOCK.q(16);
    private int lastSelectedGUI = 0;
    public FluidTank[] tanks;
    public UpgradeManagerNT upgradeManager = new UpgradeManagerNT();
    AxisAlignedBB bb = null;

    public TileEntityElectrolyser() {
        super(21);
        this.tanks = new FluidTank[4];
        this.tanks[0] = new FluidTank(Fluids.WATER, 16000);
        this.tanks[1] = new FluidTank(Fluids.HYDROGEN, 16000);
        this.tanks[2] = new FluidTank(Fluids.OXYGEN, 16000);
        this.tanks[3] = new FluidTank(Fluids.NITRIC_ACID, 16000);
    }

    @Override
    public int[] func_94128_d(int meta) {
        return new int[]{11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        if (i == 14) {
            return ElectrolyserMetalRecipes.getRecipe(itemStack) != null;
        }
        return false;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return i != 14;
    }

    @Override
    public String getName() {
        return "container.machineElectrolyser";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            NBTTagCompound data;
            Mats.MaterialStack didPour;
            Vec3 impact;
            ArrayList<Mats.MaterialStack> toCast;
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, 20000000L);
            this.tanks[0].setType(3, 4, this.slots);
            this.tanks[0].loadTank(5, 6, this.slots);
            this.tanks[1].unloadTank(7, 8, this.slots);
            this.tanks[2].unloadTank(9, 10, this.slots);
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                for (DirPos pos : this.getConPos()) {
                    this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                    this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                    this.trySubscribe(this.tanks[3].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                    if (this.tanks[1].getFill() > 0) {
                        this.sendFluid(this.tanks[1], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                    }
                    if (this.tanks[2].getFill() <= 0) continue;
                    this.sendFluid(this.tanks[2], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                }
            }
            this.upgradeManager.checkSlots(this, this.slots, 1, 2);
            int speedLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED);
            int powerLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER);
            this.usageOre = 10000 - 10000 * powerLevel / 4 + 10000 * speedLevel;
            this.usageFluid = 10000 - 10000 * powerLevel / 4 + 10000 * speedLevel;
            for (int i = 0; i < this.getCycleCount(); ++i) {
                if (this.canProcessFluid()) {
                    ++this.progressFluid;
                    this.power -= (long)this.usageFluid;
                    if (this.progressFluid >= this.getDurationFluid()) {
                        this.processFluids();
                        this.progressFluid = 0;
                        this.markChanged();
                    }
                }
                if (!this.canProcessMetal()) continue;
                ++this.progressOre;
                this.power -= (long)this.usageOre;
                if (this.progressOre < this.getDurationMetal()) continue;
                this.processMetal();
                this.progressOre = 0;
                this.markChanged();
            }
            if (this.leftStack != null) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)).getOpposite();
                toCast = new ArrayList<Mats.MaterialStack>();
                toCast.add(this.leftStack);
                impact = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
                didPour = CrucibleUtil.pourFullStack(this.field_145850_b, (double)this.field_145851_c + 0.5 + (double)dir.offsetX * 5.875, (double)this.field_145848_d + 2.0, (double)this.field_145849_e + 0.5 + (double)dir.offsetZ * 5.875, 6.0, true, toCast, MaterialShapes.NUGGET.q(3) * Math.max(this.getCycleCount() * speedLevel, 1), impact);
                if (didPour != null) {
                    data = new NBTTagCompound();
                    data.func_74778_a("type", "foundry");
                    data.func_74768_a("color", didPour.material.moltenColor);
                    data.func_74774_a("dir", (byte)dir.ordinal());
                    data.func_74776_a("off", 0.625f);
                    data.func_74776_a("base", 0.625f);
                    data.func_74776_a("len", Math.max(1.0f, (float)this.field_145848_d - (float)(Math.ceil(impact.field_72448_b) - 0.875) + 2.0f));
                    PacketThreading.createAllAroundThreadedPacket(new AuxParticlePacketNT(data, (double)this.field_145851_c + 0.5 + (double)dir.offsetX * 5.875, this.field_145848_d + 2, (double)this.field_145849_e + 0.5 + (double)dir.offsetZ * 5.875), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 1), (double)this.field_145849_e + 0.5, 50.0));
                    if (this.leftStack.amount <= 0) {
                        this.leftStack = null;
                    }
                }
            }
            if (this.rightStack != null) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
                toCast = new ArrayList();
                toCast.add(this.rightStack);
                impact = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
                didPour = CrucibleUtil.pourFullStack(this.field_145850_b, (double)this.field_145851_c + 0.5 + (double)dir.offsetX * 5.875, (double)this.field_145848_d + 2.0, (double)this.field_145849_e + 0.5 + (double)dir.offsetZ * 5.875, 6.0, true, toCast, MaterialShapes.NUGGET.q(3) * Math.max(this.getCycleCount() * speedLevel, 1), impact);
                if (didPour != null) {
                    data = new NBTTagCompound();
                    data.func_74778_a("type", "foundry");
                    data.func_74768_a("color", didPour.material.moltenColor);
                    data.func_74774_a("dir", (byte)dir.ordinal());
                    data.func_74776_a("off", 0.625f);
                    data.func_74776_a("base", 0.625f);
                    data.func_74776_a("len", Math.max(1.0f, (float)this.field_145848_d - (float)(Math.ceil(impact.field_72448_b) - 0.875) + 2.0f));
                    PacketThreading.createAllAroundThreadedPacket(new AuxParticlePacketNT(data, (double)this.field_145851_c + 0.5 + (double)dir.offsetX * 5.875, this.field_145848_d + 2, (double)this.field_145849_e + 0.5 + (double)dir.offsetZ * 5.875), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 1), (double)this.field_145849_e + 0.5, 50.0));
                    if (this.rightStack.amount <= 0) {
                        this.rightStack = null;
                    }
                }
            }
            this.networkPackNT(50);
        }
    }

    public DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c - dir.offsetX * 6, this.field_145848_d, this.field_145849_e - dir.offsetZ * 6, dir.getOpposite()), new DirPos(this.field_145851_c - dir.offsetX * 6 + rot.offsetX, this.field_145848_d, this.field_145849_e - dir.offsetZ * 6 + rot.offsetZ, dir.getOpposite()), new DirPos(this.field_145851_c - dir.offsetX * 6 - rot.offsetX, this.field_145848_d, this.field_145849_e - dir.offsetZ * 6 - rot.offsetZ, dir.getOpposite()), new DirPos(this.field_145851_c + dir.offsetX * 6, this.field_145848_d, this.field_145849_e + dir.offsetZ * 6, dir), new DirPos(this.field_145851_c + dir.offsetX * 6 + rot.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ * 6 + rot.offsetZ, dir), new DirPos(this.field_145851_c + dir.offsetX * 6 - rot.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ * 6 - rot.offsetZ, dir)};
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        buf.writeInt(this.progressFluid);
        buf.writeInt(this.progressOre);
        buf.writeInt(this.usageOre);
        buf.writeInt(this.usageFluid);
        buf.writeInt(this.getDurationFluid());
        buf.writeInt(this.getDurationMetal());
        for (int i = 0; i < 4; ++i) {
            this.tanks[i].serialize(buf);
        }
        buf.writeBoolean(this.leftStack != null);
        buf.writeBoolean(this.rightStack != null);
        if (this.leftStack != null) {
            buf.writeInt(this.leftStack.material.id);
            buf.writeInt(this.leftStack.amount);
        }
        if (this.rightStack != null) {
            buf.writeInt(this.rightStack.material.id);
            buf.writeInt(this.rightStack.amount);
        }
        buf.writeInt(this.lastSelectedGUI);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        this.progressFluid = buf.readInt();
        this.progressOre = buf.readInt();
        this.usageOre = buf.readInt();
        this.usageFluid = buf.readInt();
        this.processFluidTime = buf.readInt();
        this.processOreTime = buf.readInt();
        for (int i = 0; i < 4; ++i) {
            this.tanks[i].deserialize(buf);
        }
        boolean left = buf.readBoolean();
        boolean right = buf.readBoolean();
        this.leftStack = left ? new Mats.MaterialStack(Mats.matById.get(buf.readInt()), buf.readInt()) : null;
        this.rightStack = right ? new Mats.MaterialStack(Mats.matById.get(buf.readInt()), buf.readInt()) : null;
        this.lastSelectedGUI = buf.readInt();
    }

    public boolean canProcessFluid() {
        if (this.power < (long)this.usageFluid) {
            return false;
        }
        ElectrolyserFluidRecipes.ElectrolysisRecipe recipe = ElectrolyserFluidRecipes.recipes.get(this.tanks[0].getTankType());
        if (recipe == null) {
            return false;
        }
        if (recipe.amount > this.tanks[0].getFill()) {
            return false;
        }
        if (recipe.output1.type == this.tanks[1].getTankType() && recipe.output1.fill + this.tanks[1].getFill() > this.tanks[1].getMaxFill()) {
            return false;
        }
        if (recipe.output2.type == this.tanks[2].getTankType() && recipe.output2.fill + this.tanks[2].getFill() > this.tanks[2].getMaxFill()) {
            return false;
        }
        if (recipe.byproduct != null) {
            for (int i = 0; i < recipe.byproduct.length; ++i) {
                ItemStack slot = this.slots[11 + i];
                ItemStack byproduct = recipe.byproduct[i];
                if (slot == null) continue;
                if (!slot.func_77969_a(byproduct)) {
                    return false;
                }
                if (slot.field_77994_a + byproduct.field_77994_a <= slot.func_77976_d()) continue;
                return false;
            }
        }
        return true;
    }

    public void processFluids() {
        ElectrolyserFluidRecipes.ElectrolysisRecipe recipe = ElectrolyserFluidRecipes.recipes.get(this.tanks[0].getTankType());
        this.tanks[0].setFill(this.tanks[0].getFill() - recipe.amount);
        this.tanks[1].setTankType(recipe.output1.type);
        this.tanks[2].setTankType(recipe.output2.type);
        this.tanks[1].setFill(this.tanks[1].getFill() + recipe.output1.fill);
        this.tanks[2].setFill(this.tanks[2].getFill() + recipe.output2.fill);
        if (recipe.byproduct != null) {
            for (int i = 0; i < recipe.byproduct.length; ++i) {
                ItemStack slot = this.slots[11 + i];
                ItemStack byproduct = recipe.byproduct[i];
                if (slot == null) {
                    this.slots[11 + i] = byproduct.func_77946_l();
                    continue;
                }
                this.slots[11 + i].field_77994_a += byproduct.field_77994_a;
            }
        }
    }

    public boolean canProcessMetal() {
        if (this.slots[14] == null) {
            return false;
        }
        if (this.power < (long)this.usageOre) {
            return false;
        }
        if (this.tanks[3].getFill() < 100) {
            return false;
        }
        ElectrolyserMetalRecipes.ElectrolysisMetalRecipe recipe = ElectrolyserMetalRecipes.getRecipe(this.slots[14]);
        if (recipe == null) {
            return false;
        }
        if (this.leftStack != null && recipe.output1 != null) {
            if (recipe.output1.material != this.leftStack.material) {
                return false;
            }
            if (recipe.output1.amount + this.leftStack.amount > this.maxMaterial) {
                return false;
            }
        }
        if (this.rightStack != null && recipe.output2 != null) {
            if (recipe.output2.material != this.rightStack.material) {
                return false;
            }
            if (recipe.output2.amount + this.rightStack.amount > this.maxMaterial) {
                return false;
            }
        }
        if (recipe.byproduct != null) {
            for (int i = 0; i < recipe.byproduct.length; ++i) {
                ItemStack slot = this.slots[15 + i];
                ItemStack byproduct = recipe.byproduct[i];
                if (slot == null) continue;
                if (!slot.func_77969_a(byproduct)) {
                    return false;
                }
                if (slot.field_77994_a + byproduct.field_77994_a <= slot.func_77976_d()) continue;
                return false;
            }
        }
        return true;
    }

    public void processMetal() {
        ElectrolyserMetalRecipes.ElectrolysisMetalRecipe recipe = ElectrolyserMetalRecipes.getRecipe(this.slots[14]);
        if (recipe.output1 != null) {
            if (this.leftStack == null) {
                this.leftStack = new Mats.MaterialStack(recipe.output1.material, recipe.output1.amount);
            } else {
                this.leftStack.amount += recipe.output1.amount;
            }
        }
        if (recipe.output2 != null) {
            if (this.rightStack == null) {
                this.rightStack = new Mats.MaterialStack(recipe.output2.material, recipe.output2.amount);
            } else {
                this.rightStack.amount += recipe.output2.amount;
            }
        }
        if (recipe.byproduct != null) {
            for (int i = 0; i < recipe.byproduct.length; ++i) {
                ItemStack slot = this.slots[15 + i];
                ItemStack byproduct = recipe.byproduct[i];
                if (slot == null) {
                    this.slots[15 + i] = byproduct.func_77946_l();
                    continue;
                }
                this.slots[15 + i].field_77994_a += byproduct.field_77994_a;
            }
        }
        this.tanks[3].setFill(this.tanks[3].getFill() - 100);
        this.func_70298_a(14, 1);
    }

    public int getDurationMetal() {
        ElectrolyserMetalRecipes.ElectrolysisMetalRecipe result = ElectrolyserMetalRecipes.getRecipe(this.slots[14]);
        int base = result != null ? result.duration : 600;
        int speed = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED) - Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER), 1);
        return (int)Math.ceil((double)base * Math.max((double)(1.0f - 0.25f * (float)speed), 0.2));
    }

    public int getDurationFluid() {
        ElectrolyserFluidRecipes.ElectrolysisRecipe result = ElectrolyserFluidRecipes.getRecipe(this.tanks[0].getTankType());
        int base = result != null ? result.duration : 100;
        int speed = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED) - Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER), 1);
        return (int)Math.ceil((double)base * Math.max((double)(1.0f - 0.25f * (float)speed), 0.2));
    }

    public int getCycleCount() {
        int speed = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.OVERDRIVE);
        return Math.min(1 + speed * 2, 7);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.progressFluid = nbt.func_74762_e("progressFluid");
        this.progressOre = nbt.func_74762_e("progressOre");
        this.processFluidTime = nbt.func_74762_e("processFluidTime");
        this.processOreTime = nbt.func_74762_e("processOreTime");
        this.leftStack = nbt.func_74764_b("leftType") ? new Mats.MaterialStack(Mats.matById.get(nbt.func_74762_e("leftType")), nbt.func_74762_e("leftAmount")) : null;
        this.rightStack = nbt.func_74764_b("rightType") ? new Mats.MaterialStack(Mats.matById.get(nbt.func_74762_e("rightType")), nbt.func_74762_e("rightAmount")) : null;
        for (int i = 0; i < 4; ++i) {
            this.tanks[i].readFromNBT(nbt, "t" + i);
        }
        this.lastSelectedGUI = nbt.func_74762_e("lastSelectedGUI");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74768_a("progressFluid", this.progressFluid);
        nbt.func_74768_a("progressOre", this.progressOre);
        nbt.func_74768_a("processFluidTime", this.getDurationFluid());
        nbt.func_74768_a("processOreTime", this.getDurationMetal());
        if (this.leftStack != null) {
            nbt.func_74768_a("leftType", this.leftStack.material.id);
            nbt.func_74768_a("leftAmount", this.leftStack.amount);
        }
        if (this.rightStack != null) {
            nbt.func_74768_a("rightType", this.rightStack.material.id);
            nbt.func_74768_a("rightAmount", this.rightStack.amount);
        }
        for (int i = 0; i < 4; ++i) {
            this.tanks[i].writeToNBT(nbt, "t" + i);
        }
        nbt.func_74768_a("lastSelectedGUI", this.lastSelectedGUI);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 5), (double)(this.field_145848_d - 0), (double)(this.field_145849_e - 5), (double)(this.field_145851_c + 6), (double)(this.field_145848_d + 4), (double)(this.field_145849_e + 6));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 20000000L;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[1], this.tanks[2]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0], this.tanks[3]};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID == -1) {
            ID = this.lastSelectedGUI;
        }
        if (ID == 0) {
            return new ContainerElectrolyserFluid(player.field_71071_by, this);
        }
        return new ContainerElectrolyserMetal(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID == -1) {
            ID = this.lastSelectedGUI;
        }
        if (ID == 0) {
            return new GUIElectrolyserFluid(player.field_71071_by, this);
        }
        return new GUIElectrolyserMetal(player.field_71071_by, this);
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
    }

    @Override
    public void receiveControl(EntityPlayer player, NBTTagCompound data) {
        if (data.func_74764_b("sgm")) {
            this.lastSelectedGUI = 1;
        }
        if (data.func_74764_b("sgf")) {
            this.lastSelectedGUI = 0;
        }
        FMLNetworkHandler.openGui((EntityPlayer)player, (Object)MainRegistry.instance, (int)this.lastSelectedGUI, (World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return this.func_70300_a(player);
    }

    @Override
    public boolean canProvideInfo(ItemMachineUpgrade.UpgradeType type, int level, boolean extendedInfo) {
        return type == ItemMachineUpgrade.UpgradeType.SPEED || type == ItemMachineUpgrade.UpgradeType.POWER || type == ItemMachineUpgrade.UpgradeType.OVERDRIVE;
    }

    @Override
    public void provideInfo(ItemMachineUpgrade.UpgradeType type, int level, List<String> info, boolean extendedInfo) {
        info.add(IUpgradeInfoProvider.getStandardLabel(ModBlocks.machine_electrolyser));
        if (type == ItemMachineUpgrade.UpgradeType.SPEED) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.delay", "-" + level * 25 + "%"));
            info.add(EnumChatFormatting.RED + I18nUtil.resolveKey("upgrade.consumption", "+" + level * 100 + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.POWER) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.consumption", "-" + level * 25 + "%"));
            info.add(EnumChatFormatting.RED + I18nUtil.resolveKey("upgrade.delay", "+25%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.OVERDRIVE) {
            info.add((BobMathUtil.getBlink() ? EnumChatFormatting.RED : EnumChatFormatting.DARK_GRAY) + "YES");
        }
    }

    @Override
    public HashMap<ItemMachineUpgrade.UpgradeType, Integer> getValidUpgrades() {
        HashMap<ItemMachineUpgrade.UpgradeType, Integer> upgrades = new HashMap<ItemMachineUpgrade.UpgradeType, Integer>();
        upgrades.put(ItemMachineUpgrade.UpgradeType.SPEED, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.POWER, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.OVERDRIVE, 3);
        return upgrades;
    }

    @Override
    public FluidTank getTankToPaste() {
        return this.tanks[0];
    }

    @Override
    public NBTTagCompound getSettings(World world, int x, int y, int z) {
        NBTTagCompound tag = new NBTTagCompound();
        if (this.getFluidIDToCopy().length > 0) {
            tag.func_74783_a("fluidID", this.getFluidIDToCopy());
        }
        if (this.getMatsToCopy().length > 0) {
            tag.func_74783_a("matFilter", this.getMatsToCopy());
        }
        return tag;
    }

    @Override
    public void pasteSettings(NBTTagCompound nbt, int index, World world, EntityPlayer player, int x, int y, int z) {
        IFluidCopiable.super.pasteSettings(nbt, index, world, player, x, y, z);
    }

    @Override
    public String[] infoForDisplay(World world, int x, int y, int z) {
        ArrayList<String> names = new ArrayList<String>();
        int[] fluidIDs = this.getFluidIDToCopy();
        int[] matIDs = this.getMatsToCopy();
        for (int fluidID : fluidIDs) {
            names.add(Fluids.fromID(fluidID).getUnlocalizedName());
        }
        for (int matID : matIDs) {
            names.add(Mats.matById.get(matID).getUnlocalizedName());
        }
        return names.toArray(new String[0]);
    }

    @Override
    public int[] getMatsToCopy() {
        ArrayList<Integer> types = new ArrayList<Integer>();
        if (this.leftStack != null) {
            types.add(this.leftStack.material.id);
        }
        if (this.rightStack != null) {
            types.add(this.rightStack.material.id);
        }
        return BobMathUtil.intCollectionToArray(types);
    }
}

