/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.fluid.IFluidStandardReceiver;
import com.hbm.handler.CompatHandler;
import com.hbm.inventory.container.ContainerCoreInjector;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUICoreInjector;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.TileEntityCore;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityCoreInjector
extends TileEntityMachineBase
implements IFluidStandardReceiver,
SimpleComponent,
IGUIProvider,
CompatHandler.OCComponent {
    public FluidTank[] tanks = new FluidTank[2];
    public static final int range = 15;
    public int beam;

    public TileEntityCoreInjector() {
        super(4);
        this.tanks[0] = new FluidTank(Fluids.DEUTERIUM, 128000);
        this.tanks[1] = new FluidTank(Fluids.TRITIUM, 128000);
    }

    @Override
    public String getName() {
        return "container.dfcInjector";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.subscribeToAllAround(this.tanks[0].getTankType(), this);
            this.subscribeToAllAround(this.tanks[1].getTankType(), this);
            this.tanks[0].setType(0, 1, this.slots);
            this.tanks[1].setType(2, 3, this.slots);
            this.beam = 0;
            ForgeDirection dir = ForgeDirection.getOrientation((int)this.func_145832_p());
            for (int i = 1; i <= 15; ++i) {
                int x = this.field_145851_c + dir.offsetX * i;
                int y = this.field_145848_d + dir.offsetY * i;
                int z = this.field_145849_e + dir.offsetZ * i;
                TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
                if (te instanceof TileEntityCore) {
                    TileEntityCore core = (TileEntityCore)te;
                    for (int t = 0; t < 2; ++t) {
                        int f;
                        if (core.tanks[t].getTankType() == this.tanks[t].getTankType()) {
                            f = Math.min(this.tanks[t].getFill(), core.tanks[t].getMaxFill() - core.tanks[t].getFill());
                            this.tanks[t].setFill(this.tanks[t].getFill() - f);
                            core.tanks[t].setFill(core.tanks[t].getFill() + f);
                            core.func_70296_d();
                            continue;
                        }
                        if (core.tanks[t].getFill() != 0) continue;
                        core.tanks[t].setTankType(this.tanks[t].getTankType());
                        f = Math.min(this.tanks[t].getFill(), core.tanks[t].getMaxFill() - core.tanks[t].getFill());
                        this.tanks[t].setFill(this.tanks[t].getFill() - f);
                        core.tanks[t].setFill(core.tanks[t].getFill() + f);
                        core.func_70296_d();
                    }
                    this.beam = i;
                    break;
                }
                if (!this.field_145850_b.func_147439_a(x, y, z).isAir((IBlockAccess)this.field_145850_b, x, y, z)) break;
            }
            this.func_70296_d();
            this.networkPackNT(250);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeInt(this.beam);
        this.tanks[0].serialize(buf);
        this.tanks[1].serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.beam = buf.readInt();
        this.tanks[0].deserialize(buf);
        this.tanks[1].deserialize(buf);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tanks[0].readFromNBT(nbt, "fuel1");
        this.tanks[1].readFromNBT(nbt, "fuel2");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tanks[0].writeToNBT(nbt, "fuel1");
        this.tanks[1].writeToNBT(nbt, "fuel2");
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0], this.tanks[1]};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "dfc_injector";
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getFuel(Context context, Arguments args) {
        return new Object[]{this.tanks[0].getFill(), this.tanks[1].getFill()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getTypes(Context context, Arguments args) {
        return new Object[]{this.tanks[0].getTankType().getName(), this.tanks[1].getTankType().getName()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getInfo(Context context, Arguments args) {
        return new Object[]{this.tanks[0].getFill(), this.tanks[0].getTankType().getName(), this.tanks[1].getFill(), this.tanks[1].getTankType().getName()};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerCoreInjector(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUICoreInjector(player.field_71071_by, this);
    }
}

