/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyProviderMK2;
import api.hbm.fluid.IFluidStandardTransceiver;
import api.hbm.tile.IInfoProviderEC;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.handler.CompatHandler;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Coolable;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.IBufPacketReceiver;
import com.hbm.tileentity.IConfigurableMachine;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Random;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityChungus
extends TileEntityLoadedBase
implements IEnergyProviderMK2,
IFluidStandardTransceiver,
SimpleComponent,
IInfoProviderEC,
CompatHandler.OCComponent,
IConfigurableMachine,
IBufPacketReceiver,
IFluidCopiable {
    public long power;
    private int turnTimer;
    public float rotor;
    public float lastRotor;
    public float fanAcceleration = 0.0f;
    public FluidTank[] tanks;
    protected double[] info = new double[3];
    private AudioWrapper audio;
    private float audioDesync;
    public static long maxPower = 100000000000L;
    public static int inputTankSize = 1000000000;
    public static int outputTankSize = 1000000000;
    public static double efficiency = 0.85;

    public TileEntityChungus() {
        this.tanks = new FluidTank[2];
        this.tanks[0] = new FluidTank(Fluids.STEAM, inputTankSize);
        this.tanks[1] = new FluidTank(Fluids.SPENTSTEAM, outputTankSize);
        Random rand = new Random();
        this.audioDesync = rand.nextFloat() * 0.05f;
    }

    @Override
    public String getConfigName() {
        return "steamturbineLeviathan";
    }

    @Override
    public void readIfPresent(JsonObject obj) {
        maxPower = IConfigurableMachine.grab(obj, "L:maxPower", maxPower);
        inputTankSize = IConfigurableMachine.grab(obj, "I:inputTankSize", inputTankSize);
        outputTankSize = IConfigurableMachine.grab(obj, "I:outputTankSize", outputTankSize);
        efficiency = IConfigurableMachine.grab(obj, "D:efficiency", efficiency);
    }

    @Override
    public void writeConfig(JsonWriter writer) throws IOException {
        writer.name("L:maxPower").value(maxPower);
        writer.name("INFO").value("leviathan steam turbine consumes all availible steam per tick");
        writer.name("I:inputTankSize").value((long)inputTankSize);
        writer.name("I:outputTankSize").value((long)outputTankSize);
        writer.name("D:efficiency").value(efficiency);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            FT_Coolable trait;
            double eff;
            this.power = (long)((double)this.power * 0.95);
            this.info = new double[3];
            boolean operational = false;
            FluidType in = this.tanks[0].getTankType();
            boolean valid = false;
            if (in.hasTrait(FT_Coolable.class) && (eff = (trait = in.getTrait(FT_Coolable.class)).getEfficiency(FT_Coolable.CoolingType.TURBINE) * efficiency) > 0.0) {
                this.tanks[1].setTankType(trait.coolsTo);
                int inputOps = this.tanks[0].getFill() / trait.amountReq;
                int outputOps = (this.tanks[1].getMaxFill() - this.tanks[1].getFill()) / trait.amountProduced;
                int ops = Math.min(inputOps, outputOps);
                this.tanks[0].setFill(this.tanks[0].getFill() - ops * trait.amountReq);
                this.tanks[1].setFill(this.tanks[1].getFill() + ops * trait.amountProduced);
                this.power = (long)((double)this.power + (double)(ops * trait.heatEnergy) * eff);
                this.info[0] = ops * trait.amountReq;
                this.info[1] = ops * trait.amountProduced;
                this.info[2] = (double)(ops * trait.heatEnergy) * eff;
                valid = true;
                boolean bl = operational = ops > 0;
            }
            if (!valid) {
                this.tanks[1].setTankType(Fluids.NONE);
            }
            if (this.power > maxPower) {
                this.power = maxPower;
            }
            ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
            this.tryProvide(this.field_145850_b, this.field_145851_c - dir.offsetX * 11, this.field_145848_d, this.field_145849_e - dir.offsetZ * 11, dir.getOpposite());
            for (DirPos pos : this.getConPos()) {
                this.sendFluid(this.tanks[1], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            if (this.power > maxPower) {
                this.power = maxPower;
            }
            --this.turnTimer;
            if (operational) {
                this.turnTimer = 25;
            }
            this.networkPackNT(150);
        } else {
            this.lastRotor = this.rotor;
            this.rotor += this.fanAcceleration;
            if (this.rotor >= 360.0f) {
                this.rotor -= 360.0f;
                this.lastRotor -= 360.0f;
            }
            if (this.turnTimer > 0) {
                this.fanAcceleration = Math.max(0.0f, Math.min(25.0f, this.fanAcceleration += 0.075f + this.audioDesync));
                Random rand = this.field_145850_b.field_73012_v;
                ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
                ForgeDirection side = dir.getRotation(ForgeDirection.UP);
                for (int i = 0; i < 10; ++i) {
                    this.field_145850_b.func_72869_a("cloud", (double)this.field_145851_c + 0.5 + (double)dir.offsetX * (rand.nextDouble() + 1.25) + rand.nextGaussian() * (double)side.offsetX * 0.65, (double)this.field_145848_d + 2.5 + rand.nextGaussian() * 0.65, (double)this.field_145849_e + 0.5 + (double)dir.offsetZ * (rand.nextDouble() + 1.25) + rand.nextGaussian() * (double)side.offsetZ * 0.65, (double)(-dir.offsetX) * 0.2, 0.0, (double)(-dir.offsetZ) * 0.2);
                }
                if (this.audio == null) {
                    this.audio = MainRegistry.proxy.getLoopedSound("hbm:block.chungusTurbineRunning", this.field_145851_c, this.field_145848_d, this.field_145849_e, 1.0f, 20.0f, 1.0f);
                    this.audio.startSound();
                }
                float turbineSpeed = this.fanAcceleration / 25.0f;
                this.audio.updateVolume(this.getVolume(0.5f * turbineSpeed));
                this.audio.updatePitch(0.25f + 0.75f * turbineSpeed);
            } else {
                this.fanAcceleration = Math.max(0.0f, Math.min(25.0f, this.fanAcceleration -= 0.1f));
                if (this.audio != null) {
                    if (this.fanAcceleration > 0.0f) {
                        float turbineSpeed = this.fanAcceleration / 25.0f;
                        this.audio.updateVolume(this.getVolume(0.5f * turbineSpeed));
                        this.audio.updatePitch(0.25f + 0.75f * turbineSpeed);
                    } else {
                        this.audio.stopSound();
                        this.audio = null;
                    }
                }
            }
        }
    }

    public void onLeverPull(FluidType previous) {
        for (DirPos pos : this.getConPos()) {
            this.tryUnsubscribe(previous, this.field_145850_b, pos.getX(), pos.getY(), pos.getZ());
        }
    }

    public DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c + dir.offsetX * 5, this.field_145848_d + 2, this.field_145849_e + dir.offsetZ * 5, dir), new DirPos(this.field_145851_c + rot.offsetX * 3, this.field_145848_d, this.field_145849_e + rot.offsetZ * 3, rot), new DirPos(this.field_145851_c - rot.offsetX * 3, this.field_145848_d, this.field_145849_e - rot.offsetZ * 3, rot.getOpposite())};
    }

    @Override
    public void serialize(ByteBuf buf) {
        buf.writeLong(this.power);
        buf.writeInt(this.turnTimer);
        this.tanks[0].serialize(buf);
        this.tanks[1].serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        this.power = buf.readLong();
        this.turnTimer = buf.readInt();
        this.tanks[0].deserialize(buf);
        this.tanks[1].deserialize(buf);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tanks[0].readFromNBT(nbt, "water");
        this.tanks[1].readFromNBT(nbt, "steam");
        this.power = nbt.func_74763_f("power");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tanks[0].writeToNBT(nbt, "water");
        this.tanks[1].writeToNBT(nbt, "steam");
        nbt.func_74772_a("power", this.power);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return dir != ForgeDirection.UP && dir != ForgeDirection.DOWN && dir != ForgeDirection.UNKNOWN;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return maxPower;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "ntm_turbine";
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    @Callback(direct=true, doc="function():table -- Gets current tanks state. The format is the following: <input tank amount>, <input tank capacity>, <output tank amount>, <output tank capacity>")
    @Optional.Method(modid="OpenComputers")
    public Object[] getFluid(Context context, Arguments args) {
        return new Object[]{this.tanks[0].getFill(), this.tanks[0].getMaxFill(), this.tanks[1].getFill(), this.tanks[1].getMaxFill()};
    }

    @Callback(direct=true, doc="function():number -- Gets the current input tank fluid type. 0 stands for steam, 1 for dense steam, 2 for super dense steam and 3 for ultra dense steam.")
    @Optional.Method(modid="OpenComputers")
    public Object[] getType(Context context, Arguments args) {
        return CompatHandler.steamTypeToInt(this.tanks[0].getTankType());
    }

    @Callback(direct=true, limit=4, doc="function(type:number) -- Sets the input tank fluid type. Refer getType() for the accepted values information.")
    @Optional.Method(modid="OpenComputers")
    public Object[] setType(Context context, Arguments args) {
        this.tanks[0].setTankType(CompatHandler.intToSteamType(args.checkInteger(0)));
        return new Object[0];
    }

    @Callback(direct=true, doc="function():number -- Gets the power buffer of the turbine.")
    @Optional.Method(modid="OpenComputers")
    public Object[] getPower(Context context, Arguments args) {
        return new Object[]{this.power};
    }

    @Callback(direct=true, doc="function():table -- Gets information about this turbine. The format is the following: <input tank amount>, <input tank capacity>, <output tank amount>, <output tank capacity>, <input tank fluid type>, <power>")
    @Optional.Method(modid="OpenComputers")
    public Object[] getInfo(Context context, Arguments args) {
        return new Object[]{this.tanks[0].getFill(), this.tanks[0].getMaxFill(), this.tanks[1].getFill(), this.tanks[1].getMaxFill(), CompatHandler.steamTypeToInt(this.tanks[0].getTankType())[0], this.power};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String[] methods() {
        return new String[]{"getFluid", "getType", "setType", "getPower", "getInfo"};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        switch (method) {
            case "getFluid": {
                return this.getFluid(context, args);
            }
            case "getType": {
                return this.getType(context, args);
            }
            case "setType": {
                return this.setType(context, args);
            }
            case "getPower": {
                return this.getPower(context, args);
            }
            case "getInfo": {
                return this.getInfo(context, args);
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[1]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0]};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public void provideExtraInfo(NBTTagCompound data) {
        data.func_74757_a("active", this.info[1] > 0.0);
        data.func_74780_a("consumption", this.info[0]);
        data.func_74780_a("outputmb", this.info[1]);
        data.func_74780_a("output", this.info[2]);
    }

    @Override
    public FluidTank getTankToPaste() {
        return null;
    }
}

