/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon;

import com.hbm.handler.MissileStruct;
import com.hbm.items.ModItems;
import com.hbm.items.weapon.ItemCustomMissilePart;
import com.hbm.util.i18n.I18nUtil;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

public class ItemCustomMissile
extends Item {
    public static ItemStack buildMissile(Item chip, Item warhead, Item fuselage, Item stability, Item thruster) {
        if (stability == null) {
            return ItemCustomMissile.buildMissile(new ItemStack(chip), new ItemStack(warhead), new ItemStack(fuselage), null, new ItemStack(thruster));
        }
        return ItemCustomMissile.buildMissile(new ItemStack(chip), new ItemStack(warhead), new ItemStack(fuselage), new ItemStack(stability), new ItemStack(thruster));
    }

    public static ItemStack buildMissile(ItemStack chip, ItemStack warhead, ItemStack fuselage, ItemStack stability, ItemStack thruster) {
        ItemStack missile = new ItemStack(ModItems.missile_custom);
        ItemCustomMissile.writeToNBT(missile, "chip", Item.func_150891_b((Item)chip.func_77973_b()));
        ItemCustomMissile.writeToNBT(missile, "warhead", Item.func_150891_b((Item)warhead.func_77973_b()));
        ItemCustomMissile.writeToNBT(missile, "fuselage", Item.func_150891_b((Item)fuselage.func_77973_b()));
        ItemCustomMissile.writeToNBT(missile, "thruster", Item.func_150891_b((Item)thruster.func_77973_b()));
        if (stability != null) {
            ItemCustomMissile.writeToNBT(missile, "stability", Item.func_150891_b((Item)stability.func_77973_b()));
        }
        return missile;
    }

    private static void writeToNBT(ItemStack stack, String key, int value) {
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74768_a(key, value);
    }

    public static int readFromNBT(ItemStack stack, String key) {
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        return stack.field_77990_d.func_74762_e(key);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        if (!stack.func_77942_o()) {
            return;
        }
        try {
            ItemCustomMissilePart chip = (ItemCustomMissilePart)Item.func_150899_d((int)ItemCustomMissile.readFromNBT(stack, "chip"));
            ItemCustomMissilePart warhead = (ItemCustomMissilePart)Item.func_150899_d((int)ItemCustomMissile.readFromNBT(stack, "warhead"));
            ItemCustomMissilePart fuselage = (ItemCustomMissilePart)Item.func_150899_d((int)ItemCustomMissile.readFromNBT(stack, "fuselage"));
            ItemCustomMissilePart stability = (ItemCustomMissilePart)Item.func_150899_d((int)ItemCustomMissile.readFromNBT(stack, "stability"));
            ItemCustomMissilePart thruster = (ItemCustomMissilePart)Item.func_150899_d((int)ItemCustomMissile.readFromNBT(stack, "thruster"));
            list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.desc.warhead", new Object[0]) + ": " + EnumChatFormatting.GRAY + warhead.getWarhead((ItemCustomMissilePart.WarheadType)((Object)warhead.attributes[0])));
            list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.desc.strength", new Object[0]) + ": " + EnumChatFormatting.GRAY + (Float)warhead.attributes[1]);
            list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.desc.fuelType", new Object[0]) + ": " + EnumChatFormatting.GRAY + fuselage.getFuel((ItemCustomMissilePart.FuelType)((Object)fuselage.attributes[0])));
            list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.desc.fuelAmount", new Object[0]) + ": " + EnumChatFormatting.GRAY + (Float)fuselage.attributes[1] + "l");
            list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.desc.chipInaccuracy", new Object[0]) + ": " + EnumChatFormatting.GRAY + ((Float)chip.attributes[0]).floatValue() * 100.0f + "%");
            if (stability != null) {
                list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.desc.finInaccuracy", new Object[0]) + ": " + EnumChatFormatting.GRAY + ((Float)stability.attributes[0]).floatValue() * 100.0f + "%");
            } else {
                list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.desc.finInaccuracy", new Object[0]) + ": " + EnumChatFormatting.GRAY + "100%");
            }
            list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.desc.size", new Object[0]) + ": " + EnumChatFormatting.GRAY + fuselage.getSize(fuselage.top) + "/" + fuselage.getSize(fuselage.bottom));
            float health = warhead.health + fuselage.health + thruster.health;
            if (stability != null) {
                health += stability.health;
            }
            list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.desc.health", new Object[0]) + ": " + EnumChatFormatting.GRAY + health + "HP");
        }
        catch (Exception ex) {
            list.add(EnumChatFormatting.RED + I18nUtil.resolveKey("error.generic", new Object[0]));
        }
    }

    public static MissileStruct getStruct(ItemStack stack) {
        if (stack == null || !(stack.func_77973_b() instanceof ItemCustomMissile)) {
            return null;
        }
        ItemCustomMissilePart warhead = (ItemCustomMissilePart)Item.func_150899_d((int)ItemCustomMissile.readFromNBT(stack, "warhead"));
        ItemCustomMissilePart fuselage = (ItemCustomMissilePart)Item.func_150899_d((int)ItemCustomMissile.readFromNBT(stack, "fuselage"));
        ItemCustomMissilePart stability = (ItemCustomMissilePart)Item.func_150899_d((int)ItemCustomMissile.readFromNBT(stack, "stability"));
        ItemCustomMissilePart thruster = (ItemCustomMissilePart)Item.func_150899_d((int)ItemCustomMissile.readFromNBT(stack, "thruster"));
        MissileStruct missile = new MissileStruct(warhead, fuselage, stability, thruster);
        return missile;
    }
}

