/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.radiation;

import com.hbm.handler.radiation.ChunkRadiationHandler;
import com.hbm.lib.Library;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;

public class ChunkRadiationHandlerPRISM
extends ChunkRadiationHandler {
    public Map<World, RadPerWorld> perWorld = new ConcurrentHashMap<World, RadPerWorld>();
    public static int cycles = 0;
    public static final float MAX_RADIATION = 1000000.0f;
    private static final String NBT_KEY_CHUNK_RADIATION = "hfr_prism_radiation_";
    private static final String NBT_KEY_CHUNK_RESISTANCE = "hfr_prism_resistance_";
    private static final String NBT_KEY_CHUNK_EXISTS = "hfr_prism_exists_";
    public static final Map<ChunkCoordIntPair, SubChunk[]> newAdditions = new HashMap<ChunkCoordIntPair, SubChunk[]>();

    @Override
    public float getRadiation(World world, int x, int y, int z) {
        RadPerWorld system = this.perWorld.get(world);
        if (system != null) {
            SubChunk rad;
            ChunkCoordIntPair coords = new ChunkCoordIntPair(x >> 4, z >> 4);
            int yReg = MathHelper.func_76125_a((int)(y >> 4), (int)0, (int)15);
            SubChunk[] subChunks = system.radiation.get(coords);
            if (subChunks != null && (rad = subChunks[yReg]) != null) {
                return rad.radiation;
            }
        }
        return 0.0f;
    }

    @Override
    public void setRadiation(World world, int x, int y, int z, float rad) {
        RadPerWorld system;
        if (Float.isNaN(rad)) {
            rad = 0.0f;
        }
        if ((system = this.perWorld.get(world)) != null) {
            ChunkCoordIntPair coords = new ChunkCoordIntPair(x >> 4, z >> 4);
            int yReg = MathHelper.func_76125_a((int)(y >> 4), (int)0, (int)15);
            SubChunk[] subChunks = system.radiation.get(coords);
            if (subChunks == null) {
                subChunks = new SubChunk[16];
                system.radiation.put(coords, subChunks);
            }
            if (subChunks[yReg] == null) {
                subChunks[yReg] = new SubChunk().rebuild(world, x, y, z);
            }
            subChunks[yReg].radiation = MathHelper.func_76131_a((float)rad, (float)0.0f, (float)1000000.0f);
            world.func_72938_d((int)x, (int)z).field_76643_l = true;
        }
    }

    @Override
    public void incrementRad(World world, int x, int y, int z, float rad) {
        this.setRadiation(world, x, y, z, this.getRadiation(world, x, y, z) + rad);
    }

    @Override
    public void decrementRad(World world, int x, int y, int z, float rad) {
        this.setRadiation(world, x, y, z, this.getRadiation(world, x, y, z) - rad);
    }

    @Override
    public void receiveWorldLoad(WorldEvent.Load event) {
        if (!event.world.field_72995_K) {
            this.perWorld.put(event.world, new RadPerWorld());
        }
    }

    @Override
    public void receiveWorldUnload(WorldEvent.Unload event) {
        if (!event.world.field_72995_K) {
            this.perWorld.remove(event.world);
        }
    }

    @Override
    public void receiveChunkLoad(ChunkDataEvent.Load event) {
        RadPerWorld radWorld;
        if (!event.world.field_72995_K && (radWorld = this.perWorld.get(event.world)) != null) {
            SubChunk[] chunk = new SubChunk[16];
            for (int i = 0; i < 16; ++i) {
                int j;
                SubChunk sub;
                if (!event.getData().func_74767_n(NBT_KEY_CHUNK_EXISTS + i)) {
                    chunk[i] = new SubChunk().rebuild(event.world, event.getChunk().field_76635_g << 4, i << 4, event.getChunk().field_76647_h << 4);
                    continue;
                }
                chunk[i] = sub = new SubChunk();
                sub.radiation = event.getData().func_74760_g(NBT_KEY_CHUNK_RADIATION + i);
                for (j = 0; j < 16; ++j) {
                    sub.xResist[j] = event.getData().func_74760_g("hfr_prism_resistance_x_" + j + "_" + i);
                }
                for (j = 0; j < 16; ++j) {
                    sub.yResist[j] = event.getData().func_74760_g("hfr_prism_resistance_y_" + j + "_" + i);
                }
                for (j = 0; j < 16; ++j) {
                    sub.zResist[j] = event.getData().func_74760_g("hfr_prism_resistance_z_" + j + "_" + i);
                }
            }
            radWorld.radiation.put(event.getChunk().func_76632_l(), chunk);
        }
    }

    @Override
    public void receiveChunkSave(ChunkDataEvent.Save event) {
        SubChunk[] chunk;
        RadPerWorld radWorld;
        if (!event.world.field_72995_K && (radWorld = this.perWorld.get(event.world)) != null && (chunk = radWorld.radiation.get(event.getChunk().func_76632_l())) != null) {
            for (int i = 0; i < 16; ++i) {
                int j;
                SubChunk sub = chunk[i];
                if (sub == null) continue;
                float rad = sub.radiation;
                event.getData().func_74776_a(NBT_KEY_CHUNK_RADIATION + i, rad);
                for (j = 0; j < 16; ++j) {
                    event.getData().func_74776_a("hfr_prism_resistance_x_" + j + "_" + i, sub.xResist[j]);
                }
                for (j = 0; j < 16; ++j) {
                    event.getData().func_74776_a("hfr_prism_resistance_y_" + j + "_" + i, sub.yResist[j]);
                }
                for (j = 0; j < 16; ++j) {
                    event.getData().func_74776_a("hfr_prism_resistance_z_" + j + "_" + i, sub.zResist[j]);
                }
                event.getData().func_74757_a(NBT_KEY_CHUNK_EXISTS + i, true);
            }
        }
    }

    @Override
    public void receiveChunkUnload(ChunkEvent.Unload event) {
        RadPerWorld radWorld;
        if (!event.world.field_72995_K && (radWorld = this.perWorld.get(event.world)) != null) {
            radWorld.radiation.remove(event.getChunk().func_76632_l());
        }
    }

    @Override
    public void updateSystem() {
        ++cycles;
        for (WorldServer world : DimensionManager.getWorlds()) {
            RadPerWorld system = this.perWorld.get(world);
            if (system == null) continue;
            int rebuildAllowance = 25;
            for (Map.Entry<ChunkCoordIntPair, SubChunk[]> chunk : system.radiation.entrySet()) {
                ChunkCoordIntPair coord = chunk.getKey();
                for (int i = 0; i < 16; ++i) {
                    SubChunk sub = chunk.getValue()[i];
                    boolean hasTriedRebuild = false;
                    if (sub == null) continue;
                    sub.prevRadiation = sub.radiation;
                    sub.radiation = 0.0f;
                    if (rebuildAllowance > 0 && sub.needsRebuild) {
                        sub.rebuild((World)world, coord.field_77276_a << 4, i << 4, coord.field_77275_b << 4);
                        if (!sub.needsRebuild) {
                            --rebuildAllowance;
                            hasTriedRebuild = true;
                        }
                    }
                    if (hasTriedRebuild || Math.abs(coord.field_77276_a * coord.field_77275_b) % 5 != cycles % 5 || !world.func_72863_F().func_73149_a(coord.field_77276_a, coord.field_77275_b)) continue;
                    Chunk c = world.func_72964_e(coord.field_77276_a, coord.field_77275_b);
                    ExtendedBlockStorage[] xbs = c.func_76587_i();
                    ExtendedBlockStorage subChunk = xbs[i];
                    int checksum = 0;
                    if (subChunk != null) {
                        for (int iX = 0; iX < 16; ++iX) {
                            for (int iY = 0; iY < 16; ++iY) {
                                for (int iZ = 0; iZ < 16; ++iZ) {
                                    checksum += subChunk.func_76658_g()[MathHelper.func_76125_a((int)(iY << 8 | iZ << 4 | iX), (int)0, (int)4095)];
                                }
                            }
                        }
                    }
                    if (checksum == sub.checksum) continue;
                    sub.rebuild((World)world, coord.field_77276_a << 4, i << 4, coord.field_77275_b << 4);
                }
            }
            for (Map.Entry<ChunkCoordIntPair, SubChunk[]> chunk : system.radiation.entrySet()) {
                if (ChunkRadiationHandlerPRISM.getPrevChunkRadiation(chunk.getValue()) <= 0.0f) continue;
                for (int i = 0; i < 16; ++i) {
                    SubChunk sub = chunk.getValue()[i];
                    if (sub == null || sub.prevRadiation <= 0.0f || Float.isNaN(sub.prevRadiation) || Float.isInfinite(sub.prevRadiation)) continue;
                    float radSpread = 0.0f;
                    for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                        radSpread += ChunkRadiationHandlerPRISM.spreadRadiation((World)world, sub, i, chunk.getKey(), chunk.getValue(), system.radiation, dir);
                    }
                    sub.radiation += (sub.prevRadiation - radSpread) * 0.95f;
                    sub.radiation -= 1.0f;
                    sub.radiation = MathHelper.func_76131_a((float)sub.radiation, (float)0.0f, (float)1000000.0f);
                }
            }
            system.radiation.putAll(newAdditions);
            newAdditions.clear();
        }
    }

    private static float spreadRadiation(World world, SubChunk source, int y, ChunkCoordIntPair origin, SubChunk[] chunk, Map<ChunkCoordIntPair, SubChunk[]> map, ForgeDirection dir) {
        float spread = 0.1f;
        float amount = source.prevRadiation * spread;
        if (amount <= 1.0f) {
            return 0.0f;
        }
        if (dir.offsetY != 0) {
            if (dir == Library.POS_Y && y == 15) {
                return amount;
            }
            if (dir == Library.NEG_Y && y == 0) {
                return amount;
            }
            if (chunk[y + dir.offsetY] == null) {
                chunk[y + dir.offsetY] = new SubChunk().rebuild(world, origin.field_77276_a << 4, y + dir.offsetY << 4, origin.field_77275_b << 4);
            }
            SubChunk to = chunk[y + dir.offsetY];
            return ChunkRadiationHandlerPRISM.spreadRadiationTo(source, to, amount, dir);
        }
        ChunkCoordIntPair newPos = new ChunkCoordIntPair(origin.field_77276_a + dir.offsetX, origin.field_77275_b + dir.offsetZ);
        if (!world.func_72863_F().func_73149_a(newPos.field_77276_a, newPos.field_77275_b)) {
            return amount;
        }
        SubChunk[] newChunk = map.get(newPos);
        if (newChunk == null) {
            newChunk = new SubChunk[16];
            newAdditions.put(newPos, newChunk);
        }
        if (newChunk[y] == null) {
            newChunk[y] = new SubChunk().rebuild(world, newPos.field_77276_a << 4, y << 4, newPos.field_77275_b << 4);
        }
        SubChunk to = newChunk[y];
        return ChunkRadiationHandlerPRISM.spreadRadiationTo(source, to, amount, dir);
    }

    private static float spreadRadiationTo(SubChunk from, SubChunk to, float amount, ForgeDirection movement) {
        float resistance = from.getResistanceValue(movement.getOpposite()) + to.getResistanceValue(movement);
        double fun = Math.pow(Math.E, (double)(-resistance) / 10000.0);
        float toMove = (float)Math.min((double)amount * fun, (double)amount);
        to.radiation += toMove;
        return toMove;
    }

    private static float getPrevChunkRadiation(SubChunk[] chunk) {
        float rad = 0.0f;
        for (SubChunk sub : chunk) {
            if (sub == null) continue;
            rad += sub.prevRadiation;
        }
        return rad;
    }

    @Override
    public void clearSystem(World world) {
        RadPerWorld system = this.perWorld.get(world);
        if (system != null) {
            system.radiation.clear();
        }
    }

    public static class SubChunk {
        public float prevRadiation;
        public float radiation;
        public float[] xResist = new float[16];
        public float[] yResist = new float[16];
        public float[] zResist = new float[16];
        public boolean needsRebuild = false;
        public int checksum = 0;

        @Deprecated
        public void updateBlock(World world, int x, int y, int z) {
            int cX = x >> 4;
            int cY = MathHelper.func_76125_a((int)(y >> 4), (int)0, (int)15);
            int cZ = z >> 4;
            if (!world.func_72863_F().func_73149_a(cX, cZ)) {
                return;
            }
            int tX = cX << 4;
            int tY = cY << 4;
            int tZ = cX << 4;
            int sX = MathHelper.func_76125_a((int)(x - tX), (int)0, (int)15);
            int sY = MathHelper.func_76125_a((int)(y - tY), (int)0, (int)15);
            int sZ = MathHelper.func_76125_a((int)(z - tZ), (int)0, (int)15);
            Chunk chunk = world.func_72964_e(cX, cZ);
            ExtendedBlockStorage[] xbs = chunk.func_76587_i();
            ExtendedBlockStorage subChunk = xbs[cY];
            this.zResist[sZ] = 0.0f;
            this.yResist[sY] = 0.0f;
            this.xResist[sX] = 0.0f;
            for (int iX = 0; iX < 16; ++iX) {
                for (int iY = 0; iY < 16; ++iY) {
                    for (int iZ = 0; iZ < 16; ++iZ) {
                        Block b;
                        if (iX != sX && iY != sY && iZ != sZ || (b = subChunk.func_150819_a(iX, iY, iZ)).func_149688_o() == Material.field_151579_a) continue;
                        float resistance = Math.min(b.getExplosionResistance(null, world, tX + iX, tY + iY, tZ + iZ, (double)x, (double)y, (double)z), 100.0f);
                        if (iX == sX) {
                            int n = iX;
                            this.xResist[n] = this.xResist[n] + resistance;
                        }
                        if (iY == sY) {
                            int n = iY;
                            this.yResist[n] = this.yResist[n] + resistance;
                        }
                        if (iZ != sZ) continue;
                        int n = iZ;
                        this.zResist[n] = this.zResist[n] + resistance;
                    }
                }
            }
        }

        public SubChunk rebuild(World world, int x, int y, int z) {
            this.needsRebuild = true;
            int cX = x >> 4;
            int cY = MathHelper.func_76125_a((int)(y >> 4), (int)0, (int)15);
            int cZ = z >> 4;
            if (!world.func_72863_F().func_73149_a(cX, cZ)) {
                return this;
            }
            int tX = cX << 4;
            int tY = cY << 4;
            int tZ = cX << 4;
            for (int i = 0; i < 16; ++i) {
                this.zResist[i] = 0.0f;
                this.yResist[i] = 0.0f;
                this.xResist[i] = 0.0f;
            }
            Chunk chunk = world.func_72964_e(cX, cZ);
            ExtendedBlockStorage[] xbs = chunk.func_76587_i();
            ExtendedBlockStorage subChunk = xbs[cY];
            this.checksum = 0;
            if (subChunk != null) {
                for (int iX = 0; iX < 16; ++iX) {
                    for (int iY = 0; iY < 16; ++iY) {
                        for (int iZ = 0; iZ < 16; ++iZ) {
                            Block b = subChunk.func_150819_a(iX, iY, iZ);
                            if (b.func_149688_o() == Material.field_151579_a) continue;
                            float resistance = Math.min(b.getExplosionResistance(null, world, tX + iX, tY + iY, tZ + iZ, (double)x, (double)y, (double)z), 100.0f);
                            int n = iX;
                            this.xResist[n] = this.xResist[n] + resistance;
                            int n2 = iY;
                            this.yResist[n2] = this.yResist[n2] + resistance;
                            int n3 = iZ;
                            this.zResist[n3] = this.zResist[n3] + resistance;
                            this.checksum += subChunk.func_76658_g()[MathHelper.func_76125_a((int)(iY << 8 | iZ << 4 | iX), (int)0, (int)4095)];
                        }
                    }
                }
            }
            this.needsRebuild = false;
            return this;
        }

        public float getResistanceValue(ForgeDirection movement) {
            if (movement == Library.POS_X) {
                return this.getResistanceFromArray(this.xResist, true);
            }
            if (movement == Library.NEG_X) {
                return this.getResistanceFromArray(this.xResist, false);
            }
            if (movement == Library.POS_Y) {
                return this.getResistanceFromArray(this.yResist, true);
            }
            if (movement == Library.NEG_Y) {
                return this.getResistanceFromArray(this.yResist, false);
            }
            if (movement == Library.POS_Z) {
                return this.getResistanceFromArray(this.zResist, true);
            }
            if (movement == Library.NEG_Z) {
                return this.getResistanceFromArray(this.zResist, false);
            }
            return 0.0f;
        }

        private float getResistanceFromArray(float[] resist, boolean reverse) {
            float res = 0.0f;
            for (int i = 1; i < 16; ++i) {
                int index = reverse ? 15 - i : i;
                res += resist[index] / 15.0f * (float)i;
            }
            return res;
        }
    }

    public static class RadPerWorld {
        public Map<ChunkCoordIntPair, SubChunk[]> radiation = new ConcurrentHashMap<ChunkCoordIntPair, SubChunk[]>();
    }
}

