#include "FXMath.h"
#ifdef USE_SYS_MATH
#include "math.h"
#endif


FX_DOUBLE FX_ATAN2_CPD_X[451] = {
	0.0000000000,0.1000000017,0.2000000139,0.3000000470,0.4000001113,0.5000002173,0.6000003755,0.7000005961,0.8000008896,0.9000012662,1.0000017363,1.1000023101,1.2000029979,1.3000038097,1.4000047558,1.5000058463,1.6000070911,1.7000085003,1.8000100837,1.9000118512,
	2.0000138126,2.1000159775,2.2000183556,2.3000209564,2.4000237894,2.5000268639,2.6000301893,2.7000337746,2.8000376291,2.9000417615,3.0000461809,3.1000508960,3.2000559154,3.3000612477,3.4000669012,3.5000728842,3.6000792048,3.7000858712,3.8000928911,3.9001002723,
	4.0001080224,4.1001161489,4.2001246590,4.3001335598,4.4001428585,4.5001525617,4.6001626761,4.7001732083,4.8001841645,4.9001955509,5.0002073735,5.1002196380,5.2002323501,5.3002455151,5.4002591383,5.5002732248,5.6002877792,5.7003028064,5.8003183106,5.9003342961,
	6.0003507670,6.1003677269,6.2003851796,6.3004031283,6.4004215762,6.5004405262,6.6004599810,6.7004799430,6.8005004145,6.9005213975,7.0005428937,7.1005649046,7.2005874314,7.3006104752,7.4006340368,7.5006581167,7.6006827151,7.7007078320,7.8007334672,7.9007596202,
	8.0007862901,8.1008134760,8.2008411765,8.3008693901,8.4008981148,8.5009273486,8.6009570891,8.7009873335,8.8010180789,8.9010493221,9.0010810595,9.1011132874,9.2011460015,9.3011791976,9.4012128709,9.5012470165,9.6012816291,9.7013167031,9.8013522327,9.9013882118,
	10.0014246339,10.1014614922,10.2014987797,10.3015364890,10.4015746126,10.5016131424,10.6016520701,10.7016913873,10.8017310851,10.9017711542,11.0018115853,11.1018523684,11.2018934937,11.3019349505,11.4019767283,11.5020188161,11.6020612024,11.7021038758,11.8021468243,11.9021900356,
	12.0022334972,12.1022771963,12.2023211198,12.3023652541,12.4024095855,12.5024541000,12.6024987833,12.7025436207,12.8025885972,12.9026336975,13.0026789063,13.1027242075,13.2027695852,13.3028150228,13.4028605037,13.5029060109,13.6029515272,13.7029970348,13.8030425162,13.9030879530,
	14.0031333270,14.1031786194,14.2032238114,14.3032688837,14.4033138170,14.5033585915,14.6034031872,14.7034475839,14.8034917611,14.9035356982,15.0035793741,15.1036227677,15.2036658576,15.3037086221,15.4037510393,15.5037930872,15.6038347434,15.7038759854,15.8039167906,15.9039571359,
	16.0039969983,16.1040363545,16.2040751810,16.3041134541,16.4041511500,16.5041882449,16.6042247144,16.7042605343,16.8042956802,16.9043301275,17.0043638515,17.1043968274,17.2044290303,17.3044604352,17.4044910168,17.5045207500,17.6045496095,17.7045775699,17.8046046057,17.9046306915,
	18.0046558017,18.1046799108,18.2047029932,18.3047250232,18.4047459752,18.5047658236,18.6047845428,18.7048021072,18.8048184913,18.9048336695,19.0048476165,19.1048603068,19.2048717152,19.3048818164,19.4048905855,19.5048979974,19.6049040272,19.7049086504,19.8049118422,19.9049135785,
	20.0049138350,20.1049125876,20.2049098127,20.3049054867,20.4048995863,20.5048920884,20.6048829702,20.7048722094,20.8048597836,20.9048456710,21.0048298501,21.1048122997,21.2047929989,21.3047719274,21.4047490651,21.5047243924,21.6046978901,21.7046695394,21.8046393222,21.9046072207,
	22.0045732176,22.1045372962,22.2044994403,22.3044596344,22.4044178633,22.5043741127,22.6043283689,22.7042806185,22.8042308493,22.9041790493,23.0041252076,23.1040693137,23.2040113582,23.3039513321,23.4038892274,23.5038250370,23.6037587545,23.7036903744,23.8036198921,23.9035473039,
	24.0034726071,24.1033957997,24.2033168811,24.3032358513,24.4031527117,24.5030674644,24.6029801129,24.7028906615,24.8027991158,24.9027054826,25.0026097698,25.1025119865,25.2024121430,25.3023102509,25.4022063231,25.5021003737,25.6019924183,25.7018824738,25.8017705584,25.9016566917,
	26.0015408949,26.1014231905,26.2013036025,26.3011821566,26.4010588797,26.5009338006,26.6008069496,26.7006783584,26.8005480606,26.9004160913,27.0002824875,27.1001472878,27.2000105323,27.2998722634,27.3997325248,27.4995913622,27.5994488232,27.6993049573,27.7991598156,27.8990134515,
	27.9988659200,28.0987172782,28.1985675853,28.2984169022,28.3982652921,28.4981128201,28.5979595532,28.6978055609,28.7976509144,28.8974956871,28.9973399546,29.0971837946,29.1970272870,29.2968705138,29.3967135592,29.4965565095,29.5963994533,29.6962424814,29.7960856869,29.8959291648,
	29.9957730127,30.0956173303,30.1954622193,30.2953077839,30.3951541304,30.4950013674,30.5948496056,30.6946989581,30.7945495399,30.8944014684,30.9942548631,31.0941098456,31.1939665397,31.2938250713,31.3936855684,31.4935481610,31.5934129810,31.6932801626,31.7931498416,31.8930221559,
	31.9928972453,32.0927752512,32.1926563170,32.2925405877,32.3924282099,32.4923193319,32.5922141032,32.6921126751,32.7920152001,32.8919218319,32.9918327254,33.0917480367,33.1916679228,33.2915925414,33.3915220513,33.4914566117,33.5913963822,33.6913415231,33.7912921947,33.8912485573,
	33.9912107715,34.0911789972,34.1911533942,34.2911341215,34.3911213375,34.4911151995,34.5911158634,34.6911234841,34.7911382145,34.8911602057,34.9911896067,35.0912265638,35.1912712211,35.2913237191,35.3913841955,35.4914527841,35.5915296148,35.6916148132,35.7917085002,35.8918107917,
	35.9919217981,36.0920416241,36.1921703678,36.2923081209,36.3924549676,36.4926109846,36.5927762403,36.6929507944,36.7931346974,36.8933279896,36.9935307014,37.0937428516,37.1939644476,37.2941954843,37.3944359434,37.4946857929,37.5949449863,37.6952134615,37.7954911403,37.8957779277,
	37.9960737103,38.0963783563,38.1966917140,38.2970136107,38.3973438522,38.4976822212,38.5980284765,38.6983823517,38.7987435542,38.8991117638,38.9994866312,39.0998677773,39.2002547910,39.3006472284,39.4010446111,39.5014464247,39.6018521168,39.7022610960,39.8026727296,39.9030863423,
	40.0035012138,40.1039165772,40.2043316172,40.3047454675,40.4051572091,40.5055658678,40.6059704121,40.7063697505,40.8067627295,40.9071481305,41.0075246676,41.1078909845,41.2082456519,41.3085871641,41.4089139366,41.5092243023,41.6095165086,41.7097887137,41.8100389832,41.9102652866,
	42.0104654931,42.1106373680,42.2107785686,42.3108866397,42.4109590096,42.5109929852,42.6109857478,42.7109343475,42.8108356991,42.9106865759,43.0104836053,43.1102232622,43.2099018640,43.3095155644,43.4090603468,43.5085320184,43.6079262033,43.7072383356,43.8064636523,43.9055971857,
	44.0046337563,44.1035679641,44.2023941811,44.3011065424,44.3996989373,44.4981650007,44.5964981032,44.6946913413,44.7927375276,44.8906291803,44.9883585120
};
FX_DOUBLE FX_ATAN2_CPD_C[451] =
{
	0.0000000000,-0.0000000017,-0.0000000139,-0.0000000470,-0.0000001113,-0.0000002173,-0.0000003755,-0.0000005961,-0.0000008896,-0.0000012662,-0.0000017363,-0.0000023101,-0.0000029979,-0.0000038097,-0.0000047558,-0.0000058463,-0.0000070911,-0.0000085003,-0.0000100837,-0.0000118512,
	-0.0000138126,-0.0000159775,-0.0000183556,-0.0000209564,-0.0000237894,-0.0000268639,-0.0000301893,-0.0000337746,-0.0000376291,-0.0000417615,-0.0000461809,-0.0000508960,-0.0000559154,-0.0000612477,-0.0000669012,-0.0000728842,-0.0000792048,-0.0000858712,-0.0000928911,-0.0001002723,
	-0.0001080224,-0.0001161489,-0.0001246590,-0.0001335598,-0.0001428585,-0.0001525617,-0.0001626761,-0.0001732083,-0.0001841645,-0.0001955509,-0.0002073735,-0.0002196380,-0.0002323501,-0.0002455151,-0.0002591383,-0.0002732248,-0.0002877792,-0.0003028064,-0.0003183106,-0.0003342961,
	-0.0003507670,-0.0003677269,-0.0003851796,-0.0004031283,-0.0004215762,-0.0004405262,-0.0004599810,-0.0004799430,-0.0005004145,-0.0005213975,-0.0005428937,-0.0005649046,-0.0005874314,-0.0006104752,-0.0006340368,-0.0006581167,-0.0006827151,-0.0007078320,-0.0007334672,-0.0007596202,
	-0.0007862901,-0.0008134760,-0.0008411765,-0.0008693901,-0.0008981148,-0.0009273486,-0.0009570891,-0.0009873335,-0.0010180789,-0.0010493221,-0.0010810595,-0.0011132874,-0.0011460015,-0.0011791976,-0.0012128709,-0.0012470165,-0.0012816291,-0.0013167031,-0.0013522327,-0.0013882118,
	-0.0014246339,-0.0014614922,-0.0014987797,-0.0015364890,-0.0015746126,-0.0016131424,-0.0016520701,-0.0016913873,-0.0017310851,-0.0017711542,-0.0018115853,-0.0018523684,-0.0018934937,-0.0019349505,-0.0019767283,-0.0020188161,-0.0020612024,-0.0021038758,-0.0021468243,-0.0021900356,
	-0.0022334972,-0.0022771963,-0.0023211198,-0.0023652541,-0.0024095855,-0.0024541000,-0.0024987833,-0.0025436207,-0.0025885972,-0.0026336975,-0.0026789063,-0.0027242075,-0.0027695852,-0.0028150228,-0.0028605037,-0.0029060109,-0.0029515272,-0.0029970348,-0.0030425162,-0.0030879530,
	-0.0031333270,-0.0031786194,-0.0032238114,-0.0032688837,-0.0033138170,-0.0033585915,-0.0034031872,-0.0034475839,-0.0034917611,-0.0035356982,-0.0035793741,-0.0036227677,-0.0036658576,-0.0037086221,-0.0037510393,-0.0037930872,-0.0038347434,-0.0038759854,-0.0039167906,-0.0039571359,
	-0.0039969983,-0.0040363545,-0.0040751810,-0.0041134541,-0.0041511500,-0.0041882449,-0.0042247144,-0.0042605343,-0.0042956802,-0.0043301275,-0.0043638515,-0.0043968274,-0.0044290303,-0.0044604352,-0.0044910168,-0.0045207500,-0.0045496095,-0.0045775699,-0.0046046057,-0.0046306915,
	-0.0046558017,-0.0046799108,-0.0047029932,-0.0047250232,-0.0047459752,-0.0047658236,-0.0047845428,-0.0048021072,-0.0048184913,-0.0048336695,-0.0048476165,-0.0048603068,-0.0048717152,-0.0048818164,-0.0048905855,-0.0048979974,-0.0049040272,-0.0049086504,-0.0049118422,-0.0049135785,
	-0.0049138350,-0.0049125876,-0.0049098127,-0.0049054867,-0.0048995863,-0.0048920884,-0.0048829702,-0.0048722094,-0.0048597836,-0.0048456710,-0.0048298501,-0.0048122997,-0.0047929989,-0.0047719274,-0.0047490651,-0.0047243924,-0.0046978901,-0.0046695394,-0.0046393222,-0.0046072207,
	-0.0045732176,-0.0045372962,-0.0044994403,-0.0044596344,-0.0044178633,-0.0043741127,-0.0043283689,-0.0042806185,-0.0042308493,-0.0041790493,-0.0041252076,-0.0040693137,-0.0040113582,-0.0039513321,-0.0038892274,-0.0038250370,-0.0037587545,-0.0036903744,-0.0036198921,-0.0035473039,
	-0.0034726071,-0.0033957997,-0.0033168811,-0.0032358513,-0.0031527117,-0.0030674644,-0.0029801129,-0.0028906615,-0.0027991158,-0.0027054826,-0.0026097698,-0.0025119865,-0.0024121430,-0.0023102509,-0.0022063231,-0.0021003737,-0.0019924183,-0.0018824738,-0.0017705584,-0.0016566917,
	-0.0015408949,-0.0014231905,-0.0013036025,-0.0011821566,-0.0010588797,-0.0009338006,-0.0008069496,-0.0006783584,-0.0005480606,-0.0004160913,-0.0002824875,-0.0001472878,-0.0000105323,0.0001277366,0.0002674752,0.0004086378,0.0005511768,0.0006950427,0.0008401844,0.0009865485,
	0.0011340800,0.0012827218,0.0014324147,0.0015830978,0.0017347079,0.0018871799,0.0020404468,0.0021944391,0.0023490856,0.0025043129,0.0026600454,0.0028162054,0.0029727130,0.0031294862,0.0032864408,0.0034434905,0.0036005467,0.0037575186,0.0039143131,0.0040708352,
	0.0042269873,0.0043826697,0.0045377807,0.0046922161,0.0048458696,0.0049986326,0.0051503944,0.0053010419,0.0054504601,0.0055985316,0.0057451369,0.0058901544,0.0060334603,0.0061749287,0.0063144316,0.0064518390,0.0065870190,0.0067198374,0.0068501584,0.0069778441,
	0.0071027547,0.0072247488,0.0073436830,0.0074594123,0.0075717901,0.0076806681,0.0077858968,0.0078873249,0.0079847999,0.0080781681,0.0081672746,0.0082519633,0.0083320772,0.0084074586,0.0084779487,0.0085433883,0.0086036178,0.0086584769,0.0087078053,0.0087514427,
	0.0087892285,0.0088210028,0.0088466058,0.0088658785,0.0088786625,0.0088848005,0.0088841366,0.0088765159,0.0088617855,0.0088397943,0.0088103933,0.0087734362,0.0087287789,0.0086762809,0.0086158045,0.0085472159,0.0084703852,0.0083851868,0.0082914998,0.0081892083,
	0.0080782019,0.0079583759,0.0078296322,0.0076918791,0.0075450324,0.0073890154,0.0072237597,0.0070492056,0.0068653026,0.0066720104,0.0064692986,0.0062571484,0.0060355524,0.0058045157,0.0055640566,0.0053142071,0.0050550137,0.0047865385,0.0045088597,0.0042220723,
	0.0039262897,0.0036216437,0.0033082860,0.0029863893,0.0026561478,0.0023177788,0.0019715235,0.0016176483,0.0012564458,0.0008882362,0.0005133688,0.0001322227,-0.0002547910,-0.0006472284,-0.0010446111,-0.0014464247,-0.0018521168,-0.0022610960,-0.0026727296,-0.0030863423,
	-0.0035012138,-0.0039165772,-0.0043316172,-0.0047454675,-0.0051572091,-0.0055658678,-0.0059704121,-0.0063697505,-0.0067627295,-0.0071481305,-0.0075246676,-0.0078909845,-0.0082456519,-0.0085871641,-0.0089139366,-0.0092243023,-0.0095165086,-0.0097887137,-0.0100389832,-0.0102652866,
	-0.0104654931,-0.0106373680,-0.0107785686,-0.0108866397,-0.0109590096,-0.0109929852,-0.0109857478,-0.0109343475,-0.0108356991,-0.0106865759,-0.0104836053,-0.0102232622,-0.0099018640,-0.0095155644,-0.0090603468,-0.0085320184,-0.0079262033,-0.0072383356,-0.0064636523,-0.0055971857,
	-0.0046337563,-0.0035679641,-0.0023941811,-0.0011065424,0.0003010627,0.0018349993,0.0035018968,0.0053086587,0.0072624724,0.0093708197,0.0116414881
};

FX_DOUBLE FX_SIN_CAL_DIV[20] = {
-0.1666666666666666574,0.0083333333333333332,-0.0001984126984126984,0.0000027557319223986,-0.0000000250521083854,0.0000000001605904384,-0.0000000000007647164,0.0000000000000028115,-0.0000000000000000082,0.0000000000000000000,
-0.0000000000000000000,0.0000000000000000000,-0.0000000000000000000,0.0000000000000000000,-0.0000000000000000000,0.0000000000000000000,-0.0000000000000000000,0.0000000000000000000,-0.0000000000000000000,0.0000000000000000000
};

FX_DOUBLE FX_Value_Sig(FX_DOUBLE x)
{
	if (x > 0)
	{
		return 1;
	}
	if (x < 0)
	{
		return -1;
	}
	return 0;
}

FX_DOUBLE FX_Fabs(FX_DOUBLE x)
{
#ifdef USE_SYS_MATH
	return fabs(x);
#else
	return x >= 0 ? x : -x;
#endif

}


FX_BOOL IsZero(FX_DOUBLE v)
{
	if (v <= FXARM_EPS && v >= -FXARM_EPS)
	{
		return FX_TRUE;
	}
	return FX_FALSE;
}


FX_BOOL IsZeroL(FX_DOUBLE v)
{
	if (v <= FXARM_EPS_L && v >= -FXARM_EPS_L)
	{
		return FX_TRUE;
}
	return FX_FALSE;
}


FX_DOUBLE FX_3Root(FX_DOUBLE ix)
{

#ifdef USE_SYS_MATH
	return pow(ix, 1.0 / 3.0);
#else

	FX_DOUBLE guess = ix / 3.0;
	while (1)
	{
		FX_DOUBLE error = guess * guess * guess - ix;
		if (error > -FXARM_TINYV && error < FXARM_TINYV)
		{
			return guess;
		}
		guess = guess - error / (3 * guess * guess);
	}
#endif
}

FX_DOUBLE FX_Sqrt(FX_DOUBLE x)
{
#ifdef USE_SYS_MATH
	return sqrt(x);
#else
	FX_DOUBLE a;
	FX_DOUBLE b;
	FX_DOUBLE err;
	FX_DOUBLE Factor = 1;
	FX_DOUBLE ix = x;

	if (ix < FXARM_EPS)
	{
		return 0;
	}


	while (ix>100)
	{
		Factor *= 10.0;
		ix *= 0.01;
	}


	while (ix<0.01)
	{
		Factor *= 0.1;
		ix *= 100.0;
	}




	a = ix / 2;
	b = (a + ix / a) / 2;
	err = a - b;
	while (err > FXARM_TINYV || err < -FXARM_TINYV)
	{
		a = b;
		b = 0.5 * (a + ix / a);
		err = a - b;
	}

	return b * Factor;

#endif
}


FX_DOUBLE FX_SIN_ARC(FX_DOUBLE ArcAngle)
{
#ifdef USE_SYS_MATH
	return sin(ArcAngle);
#else
	FX_DOUBLE X;
	FX_DOUBLE ITEM;
	FX_DOUBLE TSum;
	FX_DOUBLE TX;
	FX_DOUBLE TX2;
	FX_DOUBLE iAng = ArcAngle;
	FX_INT32  ItNum;
	while (iAng < -FXARM_PI)
	{
		iAng += FXARMD_2PI;
	}
	while (iAng > FXARM_PI)
	{
		iAng -= FXARMD_2PI;
	}
	X = iAng;
	ITEM = X;
	TSum = X;
	TX = X;
	TX2 = X * X;
	ItNum = 0;
	while ((ITEM > FXARM_EPS_L || ITEM < -FXARM_EPS_L) && ItNum < 20)
	{
		TX *= TX2;
		ITEM = (TX * FX_SIN_CAL_DIV[ItNum]);
		TSum += ITEM;
		ItNum ++;
	}
	return TSum;
#endif
}
FX_DOUBLE FX_COS_ARC(FX_DOUBLE ArcAngle)
{
	return FX_SIN_ARC(FXARM_HLFPI - ArcAngle);
}

FX_VOID FX_SIN_COS_ARC(FX_DOUBLE ArcAngle, FX_DOUBLE* retSin, FX_DOUBLE* retCos)
{
	*retSin = FX_SIN_ARC(ArcAngle);
	*retCos = FX_SIN_ARC(FXARM_HLFPI - ArcAngle);
}

FX_DOUBLE FX_SIN_DEG(FX_DOUBLE DegAngle)
{
	return FX_SIN_ARC(DegAngle * FXARM_D2R);
}

FX_DOUBLE FX_COS_DEG(FX_DOUBLE DegAngle)
{
	return FX_SIN_ARC(FXARM_HLFPI - DegAngle * FXARM_D2R);
}
FX_VOID FX_SIN_COS_DEG(FX_DOUBLE DegAngle, FX_DOUBLE* retSin, FX_DOUBLE* retCos)
{
	FX_DOUBLE tmpAngle = DegAngle * FXARM_D2R;
	*retSin = FX_SIN_ARC(tmpAngle);
	*retCos = FX_SIN_ARC(FXARM_HLFPI - tmpAngle);
}


FX_DOUBLE FX_ATan2(FX_DOUBLE dy, FX_DOUBLE dx)
{
#ifdef USE_SYS_MATH
	return atan2(dy, dx);
#else
	FX_DOUBLE ax;
	FX_DOUBLE ay;
	FX_DOUBLE a;
	FX_DOUBLE s;
	FX_DOUBLE minvv;
	FX_DOUBLE maxvv;
	FX_DOUBLE r;
	FX_DOUBLE tr;
	FX_INT32 ser_pos;
	
	FX_DOUBLE tdiff;
	FX_DOUBLE e1;
	FX_DOUBLE r2;
	FX_DOUBLE r1;
		
		
		
	if (dx < 0)
	{
		ax = -dx;
	}
	else
	{
		ax = dx;
	}

	if (dy < 0) {
		ay = -dy;
	}
	else {
		ay = dy;
	}

	if (ay > ax) {
		minvv = ax;
		maxvv = ay;
	}
	else {
		minvv = ay;
		maxvv = ax;
	}

	a = minvv / (maxvv + FXARM_EPS);
	s = a * a;
	r = ((-0.0464964749 * s + 0.15931422) * s - 0.327622764) * s * a + a;
	{
		tr = r * FXARM_R2D;
		ser_pos = tr * 10;
		while (FX_ATAN2_CPD_X[ser_pos] > tr)
		{
			ser_pos--;
		}

		while (FX_ATAN2_CPD_X[ser_pos + 1] < tr)
		{
			ser_pos++;
		}
		tdiff = FX_ATAN2_CPD_X[ser_pos + 1] - FX_ATAN2_CPD_X[ser_pos];
		e1 = tr - FX_ATAN2_CPD_X[ser_pos];
		r2 = e1 / tdiff;
		r1 = 1 - r2;
		tr += (FX_ATAN2_CPD_C[ser_pos] * r1 + FX_ATAN2_CPD_C[ser_pos + 1] * r2);
		r = tr * FXARM_D2R;
	}
	if (ay > ax) r = FXARM_HLFPI - r;
	if (dx < 0) r = FXARM_PI - r;
	if (dy < 0) r = -r;
	return r;

#endif
}


FX_DOUBLE FX_ACOS(FX_DOUBLE x)
{
	if (x < -0.999999)
	{
		x = -0.999999;
	}
	if (x > 0.999999)
	{
		x = 0.999999;
	}
#ifdef USE_SYS_MATH
	return acos(x);
#else
	return FX_ATan2(FX_Sqrt(1 - x * x), x);
#endif
}



FX_DOUBLE FX_MinDif_Circle(FX_DOUBLE refv, FX_DOUBLE* v)
{

	FX_DOUBLE diff = refv - *v;
	while (diff > 0)
	{

		diff -= 360;
	}
	while (diff < 0)
	{
		diff += 360;
	}

	if (diff > 180)
	{
		diff -= 360;
	}

	*v = refv - diff;

	if (diff > 0)
	{
		return diff;
	}
	return -diff;
}

FX_DOUBLE FX_Floor(FX_DOUBLE x)
{
	FX_INT32L longx = x;
	FX_DOUBLE fractional = x - longx;

	if (fractional == 0.0) 
	{
		return x;
	}
	else if (x > 0)
	{
		return x - fractional;
	}
	else 
	{
		return x - fractional - 1;
	}
}

