/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.TileEntities;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import vswe.stevescarts.Containers.ContainerBase;
import vswe.stevescarts.Containers.ContainerUpgrade;
import vswe.stevescarts.Helpers.ITankHolder;
import vswe.stevescarts.Helpers.NBTHelper;
import vswe.stevescarts.Helpers.Tank;
import vswe.stevescarts.Helpers.TransferHandler;
import vswe.stevescarts.Interfaces.GuiBase;
import vswe.stevescarts.Interfaces.GuiUpgrade;
import vswe.stevescarts.TileEntities.TileEntityBase;
import vswe.stevescarts.TileEntities.TileEntityCartAssembler;
import vswe.stevescarts.Upgrades.AssemblerUpgrade;
import vswe.stevescarts.Upgrades.InterfaceEffect;
import vswe.stevescarts.Upgrades.InventoryEffect;

public class TileEntityUpgrade
extends TileEntityBase
implements IInventory,
ISidedInventory,
IFluidHandler,
IFluidTank,
ITankHolder {
    public Tank tank;
    private TileEntityCartAssembler master;
    private int type;
    private boolean initialized;
    private NBTTagCompound comp;
    ItemStack[] inventoryStacks;
    private int[] slotsForSide;

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiBase getGui(InventoryPlayer inv) {
        return new GuiUpgrade(inv, this);
    }

    @Override
    public ContainerBase getContainer(InventoryPlayer inv) {
        return new ContainerUpgrade((IInventory)inv, this);
    }

    public void setMaster(TileEntityCartAssembler master) {
        if (this.field_145850_b.field_72995_K && this.master != master) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.master = master;
    }

    public TileEntityCartAssembler getMaster() {
        return this.master;
    }

    public void setType(int type) {
        this.type = type;
        if (!this.initialized) {
            this.initialized = true;
            AssemblerUpgrade upgrade = this.getUpgrade();
            if (upgrade != null) {
                this.comp = new NBTTagCompound();
                this.slotsForSide = new int[upgrade.getInventorySize()];
                upgrade.init(this);
                if (upgrade.getInventorySize() > 0) {
                    this.inventoryStacks = new ItemStack[upgrade.getInventorySize()];
                    for (int i = 0; i < this.slotsForSide.length; ++i) {
                        this.slotsForSide[i] = i;
                    }
                }
            } else {
                this.inventoryStacks = null;
            }
        }
    }

    public int getType() {
        return this.type;
    }

    public NBTTagCompound getCompound() {
        return this.comp;
    }

    public Packet func_145844_m() {
        NBTTagCompound var1 = new NBTTagCompound();
        this.func_145841_b(var1);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, var1);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public AssemblerUpgrade getUpgrade() {
        return AssemblerUpgrade.getUpgrade(this.type);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getTexture(boolean outside) {
        if (this.getUpgrade() == null) {
            return null;
        }
        return outside ? this.getUpgrade().getMainTexture() : this.getUpgrade().getSideTexture();
    }

    public boolean hasInventory() {
        return this.inventoryStacks != null;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.setType(tagCompound.func_74771_c("Type"));
        NBTTagList items = tagCompound.func_150295_c("Items", NBTHelper.COMPOUND.getId());
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            int slot = item.func_74771_c("Slot") & 0xFF;
            ItemStack iStack = ItemStack.func_77949_a((NBTTagCompound)item);
            if (slot < 0 || slot >= this.func_70302_i_()) continue;
            this.func_70299_a(slot, iStack);
        }
        AssemblerUpgrade upgrade = this.getUpgrade();
        if (upgrade != null) {
            upgrade.load(this, tagCompound);
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        NBTTagList items = new NBTTagList();
        if (this.inventoryStacks != null) {
            for (int i = 0; i < this.inventoryStacks.length; ++i) {
                ItemStack iStack = this.inventoryStacks[i];
                if (iStack == null) continue;
                NBTTagCompound item = new NBTTagCompound();
                item.func_74774_a("Slot", (byte)i);
                iStack.func_77955_b(item);
                items.func_74742_a((NBTBase)item);
            }
        }
        tagCompound.func_74782_a("Items", (NBTBase)items);
        tagCompound.func_74774_a("Type", (byte)this.type);
        AssemblerUpgrade upgrade = this.getUpgrade();
        if (upgrade != null) {
            upgrade.save(this, tagCompound);
        }
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_145845_h() {
        if (this.getUpgrade() != null && this.getMaster() != null) {
            this.getUpgrade().update(this);
        }
    }

    @Override
    public void initGuiData(Container con, ICrafting crafting) {
        InterfaceEffect gui;
        if (this.getUpgrade() != null && (gui = this.getUpgrade().getInterfaceEffect()) != null) {
            gui.checkGuiData(this, (ContainerUpgrade)con, crafting, true);
        }
    }

    @Override
    public void checkGuiData(Container con, ICrafting crafting) {
        InterfaceEffect gui;
        if (this.getUpgrade() != null && (gui = this.getUpgrade().getInterfaceEffect()) != null) {
            gui.checkGuiData(this, (ContainerUpgrade)con, crafting, false);
        }
    }

    @Override
    public void receiveGuiData(int id, short data) {
        InterfaceEffect gui;
        if (this.getUpgrade() != null && (gui = this.getUpgrade().getInterfaceEffect()) != null) {
            gui.receiveGuiData(this, id, data);
        }
    }

    public int func_70302_i_() {
        if (this.inventoryStacks == null) {
            if (this.master == null) {
                return 0;
            }
            return this.master.func_70302_i_();
        }
        return this.inventoryStacks.length;
    }

    public ItemStack func_70301_a(int i) {
        if (this.inventoryStacks == null) {
            if (this.master == null) {
                return null;
            }
            return this.master.func_70301_a(i);
        }
        if (i < 0 || i >= this.func_70302_i_()) {
            return null;
        }
        return this.inventoryStacks[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.inventoryStacks == null) {
            if (this.master == null) {
                return null;
            }
            return this.master.func_70298_a(i, j);
        }
        if (i < 0 || i >= this.func_70302_i_()) {
            return null;
        }
        if (this.inventoryStacks[i] != null) {
            if (this.inventoryStacks[i].field_77994_a <= j) {
                ItemStack itemstack = this.inventoryStacks[i];
                this.inventoryStacks[i] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack1 = this.inventoryStacks[i].func_77979_a(j);
            if (this.inventoryStacks[i].field_77994_a == 0) {
                this.inventoryStacks[i] = null;
            }
            this.func_70296_d();
            return itemstack1;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        if (this.inventoryStacks == null) {
            if (this.master != null) {
                this.master.func_70299_a(i, itemstack);
            }
        } else {
            if (i < 0 || i >= this.func_70302_i_()) {
                return;
            }
            this.inventoryStacks[i] = itemstack;
            if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
                itemstack.field_77994_a = this.func_70297_j_();
            }
            this.func_70296_d();
        }
    }

    public String func_145825_b() {
        return "container.assemblerupgrade";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70305_f() {
    }

    public void func_70295_k_() {
    }

    public ItemStack func_70304_b(int i) {
        if (this.inventoryStacks == null) {
            if (this.master == null) {
                return null;
            }
            return this.master.func_70304_b(i);
        }
        ItemStack item = this.func_70301_a(i);
        if (item != null) {
            this.func_70299_a(i, null);
            return item;
        }
        return null;
    }

    public void func_70296_d() {
        InventoryEffect inv;
        if (this.getUpgrade() != null && (inv = this.getUpgrade().getInventoryEffect()) != null) {
            inv.onInventoryChanged(this);
        }
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        InventoryEffect inv;
        if (this.getUpgrade() != null && (inv = this.getUpgrade().getInventoryEffect()) != null) {
            return inv.isItemValid(slot, item);
        }
        if (this.getMaster() != null) {
            return this.getMaster().func_94041_b(slot, item);
        }
        return false;
    }

    public int[] func_94128_d(int side) {
        InventoryEffect inv;
        if (this.getUpgrade() != null && (inv = this.getUpgrade().getInventoryEffect()) != null) {
            return this.slotsForSide;
        }
        if (this.getMaster() != null) {
            return this.getMaster().func_94128_d(side);
        }
        return new int[0];
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        InventoryEffect inv;
        if (this.getUpgrade() != null && (inv = this.getUpgrade().getInventoryEffect()) != null) {
            return this.func_94041_b(slot, item);
        }
        if (this.getMaster() != null) {
            return this.getMaster().func_102007_a(slot, item, side);
        }
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        InventoryEffect inv;
        if (this.getUpgrade() != null && (inv = this.getUpgrade().getInventoryEffect()) != null) {
            return true;
        }
        if (this.getMaster() != null) {
            return this.getMaster().func_102008_b(slot, item, side);
        }
        return false;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource != null && resource.isFluidEqual(this.getFluid())) {
            return this.drain(from, resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(maxDrain, doDrain);
    }

    public FluidStack getFluid() {
        if (this.tank == null) {
            return null;
        }
        return this.tank.getFluid();
    }

    public int getCapacity() {
        if (this.tank == null) {
            return 0;
        }
        return this.tank.getCapacity();
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.tank == null) {
            return 0;
        }
        int result = this.tank.fill(resource, doFill);
        return result;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.tank == null) {
            return null;
        }
        FluidStack result = this.tank.drain(maxDrain, doDrain);
        return result;
    }

    @Override
    public ItemStack getInputContainer(int tankid) {
        return this.func_70301_a(0);
    }

    @Override
    public void clearInputContainer(int tankid) {
        this.func_70299_a(0, null);
    }

    @Override
    public void addToOutputContainer(int tankid, ItemStack item) {
        TransferHandler.TransferItem(item, this, 1, 1, new ContainerUpgrade(null, this), Slot.class, null, -1);
    }

    @Override
    public void onFluidUpdated(int tankid) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawImage(int tankid, GuiBase gui, IIcon icon, int targetX, int targetY, int srcX, int srcY, int sizeX, int sizeY) {
        gui.drawIcon(icon, gui.getGuiLeft() + targetX, gui.getGuiTop() + targetY, (float)sizeX / 16.0f, (float)sizeY / 16.0f, (float)srcX / 16.0f, (float)srcY / 16.0f);
    }

    public int getFluidAmount() {
        return this.tank == null ? 0 : this.tank.getFluidAmount();
    }

    public FluidTankInfo getInfo() {
        return this.tank == null ? null : this.tank.getInfo();
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.getInfo()};
    }
}

