/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Modules.Workers.Tools;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import vswe.stevescarts.Carts.MinecartModular;
import vswe.stevescarts.Helpers.Localization;
import vswe.stevescarts.Interfaces.GuiMinecart;
import vswe.stevescarts.Modules.ICropModule;
import vswe.stevescarts.Modules.ISuppliesModule;
import vswe.stevescarts.Modules.ModuleBase;
import vswe.stevescarts.Modules.Workers.Tools.ModuleTool;
import vswe.stevescarts.Slots.SlotBase;
import vswe.stevescarts.Slots.SlotSeed;

public abstract class ModuleFarmer
extends ModuleTool
implements ISuppliesModule,
ICropModule {
    private ArrayList<ICropModule> plantModules;
    private int farming;
    private float farmAngle;
    private float rigAngle = -3.926991f;

    public ModuleFarmer(MinecartModular cart) {
        super(cart);
    }

    protected abstract int getRange();

    public int getExternalRange() {
        return this.getRange();
    }

    @Override
    public void init() {
        super.init();
        this.plantModules = new ArrayList();
        for (ModuleBase module : this.getCart().getModules()) {
            if (!(module instanceof ICropModule)) continue;
            this.plantModules.add((ICropModule)((Object)module));
        }
    }

    @Override
    public byte getWorkPriority() {
        return 80;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, Localization.MODULES.TOOLS.FARMER.translate(new String[0]), 8, 6, 0x404040);
    }

    @Override
    protected int getInventoryWidth() {
        return super.getInventoryWidth() + 3;
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        if (x == 0) {
            return super.getSlot(slotId, x, y);
        }
        return new SlotSeed(this.getCart(), this, slotId, 8 + --x * 18, 28 + y * 18);
    }

    @Override
    public boolean work() {
        Vec3 next = this.getNextblock();
        int x = (int)next.field_72450_a;
        int y = (int)next.field_72448_b;
        int z = (int)next.field_72449_c;
        for (int i = -this.getRange(); i <= this.getRange(); ++i) {
            for (int j = -this.getRange(); j <= this.getRange(); ++j) {
                int coordX = x + i;
                int coordY = y - 1;
                int coordZ = z + j;
                if (this.farm(coordX, coordY, coordZ)) {
                    return true;
                }
                if (this.till(coordX, coordY, coordZ)) {
                    return true;
                }
                if (!this.plant(coordX, coordY, coordZ)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean till(int x, int y, int z) {
        Block b = this.getCart().field_70170_p.func_147439_a(x, y, z);
        if (this.getCart().field_70170_p.func_147437_c(x, y + 1, z) && (b == Blocks.field_150349_c || b == Blocks.field_150346_d)) {
            if (this.doPreWork()) {
                this.startWorking(10);
                return true;
            }
            this.stopWorking();
            this.getCart().field_70170_p.func_147449_b(x, y, z, Blocks.field_150458_ak);
        }
        return false;
    }

    protected boolean plant(int x, int y, int z) {
        int hasSeeds = -1;
        Block soilblock = this.getCart().field_70170_p.func_147439_a(x, y, z);
        if (soilblock == null) {
            return false;
        }
        ICropModule workingModule = null;
        for (int i = 0; i < this.getInventorySize(); ++i) {
            if (this.getStack(i) == null) continue;
            workingModule = this.getModuleFromSeed(this.getStack(i));
            if (workingModule == null) {
                return false;
            }
            if (!workingModule.isSeedPlaceable(x, y + 1, z, this.getStack(i))) continue;
            hasSeeds = i;
            break;
        }
        if (hasSeeds == -1) {
            return false;
        }
        if (this.doPreWork()) {
            this.startWorking(25);
            return true;
        }
        this.stopWorking();
        workingModule.placeCrop(x, y + 1, z, this.getStack(hasSeeds));
        --this.getStack((int)hasSeeds).field_77994_a;
        if (this.getStack((int)hasSeeds).field_77994_a <= 0) {
            this.setStack(hasSeeds, null);
        }
        return false;
    }

    protected boolean farm(int x, int y, int z) {
        if (this.isBroken()) {
            return false;
        }
        ICropModule workingCropModule = this.getHarvestingModule(x, y + 1, z);
        if (workingCropModule == null) {
            return false;
        }
        if (this.doPreWork()) {
            int efficiency = this.enchanter != null ? this.enchanter.getEfficiencyLevel() : 0;
            int workingtime = (int)((double)this.getBaseFarmingTime() / Math.pow(1.3f, efficiency));
            this.setFarming(workingtime * 4);
            this.startWorking(workingtime);
            return true;
        }
        this.stopWorking();
        int fortune = this.enchanter != null ? this.enchanter.getFortuneLevel() : 0;
        List<ItemStack> stuff = workingCropModule.harvestCrop(x, y + 1, z, fortune);
        for (ItemStack iStack : stuff) {
            if ((double)this.getCart().field_70146_Z.nextFloat() <= 0.05 * (double)(this.getCart().getCurrentEngine().getEngineTier() + 1)) {
                iStack.field_77994_a *= 2;
            }
            this.getCart().addItemToChest(iStack);
            if (iStack.field_77994_a == 0) continue;
            EntityItem entityitem = new EntityItem(this.getCart().field_70170_p, this.getCart().field_70165_t, this.getCart().field_70163_u, this.getCart().field_70161_v, iStack);
            entityitem.field_70159_w = (float)(x - this.getCart().x()) / 10.0f;
            entityitem.field_70181_x = 0.15f;
            entityitem.field_70179_y = (float)(z - this.getCart().z()) / 10.0f;
            this.getCart().field_70170_p.func_72838_d((Entity)entityitem);
        }
        this.damageTool(3);
        return false;
    }

    protected int getBaseFarmingTime() {
        return 25;
    }

    public ICropModule getModuleFromSeed(ItemStack seed) {
        for (ICropModule module : this.plantModules) {
            if (!module.isSeedValid(seed)) continue;
            return module;
        }
        return null;
    }

    protected ICropModule getHarvestingModule(int x, int y, int z) {
        for (ICropModule module : this.plantModules) {
            if (!module.isReadyToHarvest(x, y, z)) continue;
            return module;
        }
        return null;
    }

    @Override
    public boolean isSeedValid(ItemStack seed) {
        return seed.func_77973_b() == Items.field_151014_N || seed.func_77973_b() == Items.field_151174_bG || seed.func_77973_b() == Items.field_151172_bF;
    }

    @Override
    public Block getCropFromSeed(ItemStack seed) {
        if (seed.func_77973_b() == Items.field_151172_bF) {
            return Blocks.field_150459_bM;
        }
        if (seed.func_77973_b() == Items.field_151174_bG) {
            return Blocks.field_150469_bN;
        }
        if (seed.func_77973_b() == Items.field_151014_N) {
            return Blocks.field_150464_aj;
        }
        return null;
    }

    @Override
    public boolean isReadyToHarvest(int x, int y, int z) {
        Block block = this.getCart().field_70170_p.func_147439_a(x, y, z);
        int m = this.getCart().field_70170_p.func_72805_g(x, y, z);
        return block instanceof BlockCrops && m == 7;
    }

    public float getFarmAngle() {
        return this.farmAngle;
    }

    public float getRigAngle() {
        return this.rigAngle;
    }

    @Override
    public void initDw() {
        this.addDw(0, 0);
    }

    @Override
    public int numberOfDataWatchers() {
        return 1;
    }

    private void setFarming(int val) {
        this.farming = val;
        this.updateDw(0, (byte)(val > 0 ? 1 : 0));
    }

    protected boolean isFarming() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getIsFarming();
        }
        return this.getCart().isEngineBurning() && this.getDw(0) != 0;
    }

    @Override
    public void update() {
        super.update();
        if (!this.getCart().field_70170_p.field_72995_K) {
            this.setFarming(this.farming - 1);
        } else {
            float up = -3.926991f;
            float down = (float)(-Math.PI);
            boolean flag = this.isFarming();
            if (flag) {
                if (this.rigAngle < down) {
                    this.rigAngle += 0.1f;
                    if (this.rigAngle > down) {
                        this.rigAngle = down;
                    }
                } else {
                    this.farmAngle = (float)((double)(this.farmAngle + 0.15f) % (Math.PI * 2));
                }
            } else if (this.rigAngle > up) {
                this.rigAngle -= 0.075f;
                if (this.rigAngle < up) {
                    this.rigAngle = up;
                }
            }
        }
    }

    @Override
    public boolean haveSupplies() {
        for (int i = 0; i < this.getInventorySize(); ++i) {
            ItemStack item = this.getStack(i);
            if (item == null || this.getModuleFromSeed(item) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public World getWorld() {
        return this.getCart().field_70170_p;
    }
}

