/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Modules.Workers;

import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockSapling;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import vswe.stevescarts.Carts.MinecartModular;
import vswe.stevescarts.Helpers.Localization;
import vswe.stevescarts.Helpers.ResourceHelper;
import vswe.stevescarts.Interfaces.GuiMinecart;
import vswe.stevescarts.Modules.ISuppliesModule;
import vswe.stevescarts.Modules.ModuleBase;
import vswe.stevescarts.Modules.Workers.ModuleWorker;
import vswe.stevescarts.Modules.Workers.Tools.ModuleFarmer;
import vswe.stevescarts.Slots.SlotBase;
import vswe.stevescarts.Slots.SlotFertilizer;

public class ModuleFertilizer
extends ModuleWorker
implements ISuppliesModule {
    private int tankPosX = this.guiWidth() - 21;
    private int tankPosY = 20;
    private int range = 1;
    private int fert = 0;
    private final int fertPerBonemeal = 4;
    private final int maxStacksOfBones = 1;

    public ModuleFertilizer(MinecartModular cart) {
        super(cart);
    }

    @Override
    public byte getWorkPriority() {
        return 127;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    protected int getInventoryWidth() {
        return 1;
    }

    @Override
    public void init() {
        super.init();
        for (ModuleBase module : this.getCart().getModules()) {
            if (!(module instanceof ModuleFarmer)) continue;
            this.range = ((ModuleFarmer)module).getExternalRange();
            break;
        }
    }

    @Override
    public void drawBackground(GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/fertilize.png");
        this.drawImage(gui, this.tankPosX, this.tankPosY, 0, 0, 18, 27);
        float percentage = (float)this.fert / (float)this.getMaxFert();
        int size = (int)(percentage * 23.0f);
        this.drawImage(gui, this.tankPosX + 2, this.tankPosY + 2 + (23 - size), 18, 23 - size, 14, size);
    }

    @Override
    public void drawMouseOver(GuiMinecart gui, int x, int y) {
        this.drawStringOnMouseOver(gui, Localization.MODULES.ATTACHMENTS.FERTILIZERS.translate(new String[0]) + ": " + this.fert + " / " + this.getMaxFert(), x, y, this.tankPosX, this.tankPosY, 18, 27);
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    public int guiWidth() {
        return super.guiWidth() + 25;
    }

    @Override
    public int guiHeight() {
        return Math.max(super.guiHeight(), 50);
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        return new SlotFertilizer(this.getCart(), slotId, 8 + x * 18, 23 + y * 18);
    }

    @Override
    public boolean work() {
        Vec3 next = this.getNextblock();
        int x = (int)next.field_72450_a;
        int y = (int)next.field_72448_b;
        int z = (int)next.field_72449_c;
        for (int i = -this.range; i <= this.range; ++i) {
            for (int j = -this.range; j <= this.range; ++j) {
                int coordX = x + i;
                int coordY = y - 1;
                int coordZ = z + j;
                this.fertilize(coordX, coordY, coordZ);
            }
        }
        return false;
    }

    private void fertilize(int x, int y, int z) {
        Block block = this.getCart().field_70170_p.func_147439_a(x, y + 1, z);
        int metadataOfBlockAbove = this.getCart().field_70170_p.func_72805_g(x, y + 1, z);
        int metadata = this.getCart().field_70170_p.func_72805_g(x, y, z);
        if (this.fert > 0) {
            if (block instanceof BlockCrops && metadataOfBlockAbove != 7) {
                if (metadata > 0 && this.getCart().field_70146_Z.nextInt(250) == 0 || metadata == 0 && this.getCart().field_70146_Z.nextInt(1000) == 0) {
                    this.getCart().field_70170_p.func_72921_c(x, y + 1, z, metadataOfBlockAbove + 1, 3);
                    --this.fert;
                }
            } else if (block instanceof BlockSapling && this.getCart().field_70170_p.func_72957_l(x, y + 2, z) >= 9 && this.getCart().field_70146_Z.nextInt(100) == 0) {
                if (this.getCart().field_70146_Z.nextInt(6) == 0) {
                    this.getCart().field_70170_p.func_72921_c(x, y + 1, z, metadataOfBlockAbove | 8, 3);
                    ((BlockSapling)Blocks.field_150345_g).func_149878_d(this.getCart().field_70170_p, x, y + 1, z, this.getCart().field_70146_Z);
                }
                --this.fert;
            }
        }
    }

    @Override
    public int numberOfGuiData() {
        return 1;
    }

    @Override
    protected void checkGuiData(Object[] info) {
        this.updateGuiData(info, 0, (short)this.fert);
    }

    @Override
    public void receiveGuiData(int id, short data) {
        if (id == 0) {
            this.fert = data;
        }
    }

    @Override
    public void update() {
        super.update();
        this.loadSupplies();
    }

    private void loadSupplies() {
        if (this.getCart().field_70170_p.field_72995_K) {
            return;
        }
        if (this.getStack(0) != null) {
            boolean isBoneMeal;
            boolean isBone = this.getStack(0).func_77973_b() == Items.field_151103_aS;
            boolean bl = isBoneMeal = this.getStack(0).func_77973_b() == Items.field_151100_aR && this.getStack(0).func_77960_j() == 15;
            if (isBone || isBoneMeal) {
                int amount = isBoneMeal ? 1 : 3;
                if (this.fert <= 4 * (192 - amount) && this.getStack((int)0).field_77994_a > 0) {
                    --this.getStack((int)0).field_77994_a;
                    this.fert += amount * 4;
                }
                if (this.getStack((int)0).field_77994_a == 0) {
                    this.setStack(0, null);
                }
            }
        }
    }

    private int getMaxFert() {
        return 768;
    }

    @Override
    protected void Save(NBTTagCompound tagCompound, int id) {
        tagCompound.func_74777_a(this.generateNBTName("Fert", id), (short)this.fert);
    }

    @Override
    protected void Load(NBTTagCompound tagCompound, int id) {
        this.fert = tagCompound.func_74765_d(this.generateNBTName("Fert", id));
    }

    @Override
    public boolean haveSupplies() {
        return this.fert > 0;
    }
}

