/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tabbedpane;

import com.github.weisj.darklaf.ui.tabbedpane.DarkTabbedPaneUI;
import com.github.weisj.darklaf.ui.tabbedpane.TabbedPaneHandler;
import com.github.weisj.darklaf.ui.tabbedpane.TabbedPaneUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;

public class DarkTabbedPaneHandler
extends TabbedPaneHandler {
    protected final DarkTabbedPaneUI ui;
    protected Point origin;
    protected Point tabOrigin;
    protected int pressedIndex;

    protected DarkTabbedPaneHandler(DarkTabbedPaneUI ui) {
        super(ui);
        this.ui = ui;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        String key = e.getPropertyName();
        if ("JTabbedPane.tabAreaInsets".equals(key)) {
            Object ins = e.getNewValue();
            if (ins instanceof Insets) {
                this.ui.tabAreaInsets = (Insets)ins;
            } else if (ins == null) {
                this.ui.tabAreaInsets = new Insets(0, 0, 0, 0);
            }
        } else if ("JTabbedPane.contentBorderInsets".equals(key)) {
            Object ins = e.getNewValue();
            if (ins instanceof Insets) {
                this.ui.contentBorderInsets = (Insets)ins;
            } else if (ins == null) {
                this.ui.contentBorderInsets = new Insets(0, 0, 0, 0);
            }
        } else if ("tabPlacement".equals(key)) {
            if (this.ui.scrollableTabLayoutEnabled()) {
                this.ui.currentShiftX = 0;
                this.ui.currentShiftY = 0;
                this.ui.scrollLayout.calculateTabRects(this.ui.tabPane.getTabPlacement(), this.ui.tabPane.getTabCount());
            }
        } else if ("JTabbedPane.showNewTabButton".equals(key)) {
            Object val = e.getNewValue();
            if (val instanceof Boolean && this.ui.scrollableTabLayoutEnabled()) {
                boolean show = (Boolean)val;
                if (show == this.ui.scrollableTabSupport.newTabButton.isVisible()) {
                    return;
                }
                this.ui.scrollableTabSupport.newTabButton.setVisible(show);
            }
            this.ui.tabPane.doLayout();
            this.ui.tabPane.repaint();
        } else if ("JTabbedPane.leadingComponent".equals(key)) {
            this.ui.tabPane.remove(this.ui.leadingComp);
            Object val = e.getNewValue();
            if (val instanceof Component) {
                this.ui.leadingComp = this.ui.wrapClientComponent((Component)val);
                this.ui.tabPane.add(this.ui.leadingComp);
            } else {
                this.ui.leadingComp = null;
            }
            this.ui.tabPane.doLayout();
        } else if ("JTabbedPane.trailingComponent".equals(key)) {
            this.ui.tabPane.remove(this.ui.trailingComp);
            Object val = e.getNewValue();
            if (val instanceof Component) {
                this.ui.trailingComp = this.ui.wrapClientComponent((Component)val);
                this.ui.tabPane.add(this.ui.trailingComp);
            } else {
                this.ui.trailingComp = null;
            }
            this.ui.tabPane.doLayout();
        } else if ("JTabbedPane.dndEnabled".equals(key)) {
            this.ui.dndEnabled = PropertyUtil.getBooleanProperty(this.ui.tabPane, "JTabbedPane.dndEnabled");
            DropTarget dropTarget = this.ui.tabPane.getDropTarget();
            if (dropTarget != null) {
                dropTarget.setActive(this.ui.dndEnabled);
            }
        } else if ("componentOrientation".equals(key)) {
            this.ui.tabPane.doLayout();
            this.ui.tabPane.repaint();
        } else if ("JTabbedPane.northComponent".equals(key)) {
            this.ui.tabPane.remove(this.ui.northComp);
            Object val = e.getNewValue();
            if (val instanceof Component) {
                this.ui.northComp = this.ui.wrapClientComponent((Component)val);
                this.ui.tabPane.add(this.ui.northComp);
            } else {
                this.ui.northComp = null;
            }
            this.ui.tabPane.doLayout();
        } else if ("JTabbedPane.southComponent".equals(key)) {
            this.ui.tabPane.remove(this.ui.southComp);
            Object val = e.getNewValue();
            if (val instanceof Component) {
                this.ui.southComp = this.ui.wrapClientComponent((Component)val);
                this.ui.tabPane.add(this.ui.southComp);
            } else {
                this.ui.southComp = null;
            }
            this.ui.tabPane.doLayout();
        } else if ("JTabbedPane.eastComponent".equals(key)) {
            this.ui.tabPane.remove(this.ui.eastComp);
            Object val = e.getNewValue();
            if (val instanceof Component) {
                this.ui.eastComp = this.ui.wrapClientComponent((Component)val);
                this.ui.tabPane.add(this.ui.eastComp);
            } else {
                this.ui.eastComp = null;
            }
            this.ui.tabPane.doLayout();
        } else if ("JTabbedPane.westComponent".equals(key)) {
            this.ui.tabPane.remove(this.ui.westComp);
            Object val = e.getNewValue();
            if (val instanceof Component) {
                this.ui.westComp = this.ui.wrapClientComponent((Component)val);
                this.ui.tabPane.add(this.ui.westComp);
            } else {
                this.ui.westComp = null;
            }
            this.ui.tabPane.doLayout();
        } else if ("JTabbedPane.centerTabs".endsWith(key)) {
            this.ui.tabPane.doLayout();
            this.ui.tabPane.repaint();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JTabbedPane tabPane = (JTabbedPane)e.getSource();
        this.ui.setFocusIndex(tabPane.getSelectedIndex(), true);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        this.ui.tabPane.requestFocusInWindow();
        this.origin = e.getPoint();
        this.pressedIndex = this.ui.tabForCoordinate(this.ui.tabPane, e.getX(), e.getY());
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        if (this.ui.dragging && this.ui.scrollableTabLayoutEnabled()) {
            this.stopDrag(e, true);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        boolean indexValid;
        super.mouseDragged(e);
        if (!this.ui.dndEnabled) {
            return;
        }
        if (this.origin == null) {
            this.origin = e.getPoint();
            this.pressedIndex = this.ui.tabForCoordinate(this.ui.tabPane, e.getX(), e.getY());
        }
        boolean bl = indexValid = this.pressedIndex >= 0 && this.pressedIndex < this.ui.tabPane.getTabCount();
        if (this.ui.scrollableTabLayoutEnabled()) {
            if (!this.ui.dragging && indexValid) {
                this.ui.dragRect.setBounds(this.ui.rects[this.pressedIndex]);
                this.tabOrigin = this.ui.rects[this.pressedIndex].getLocation();
                this.ui.dragging = true;
                this.ui.dropSourceIndex = this.pressedIndex;
                this.ui.dropTargetIndex = this.pressedIndex;
                this.ui.sourceEqualsTarget = true;
                this.ui.drawDropRect = true;
                this.ui.dropRect.setBounds(this.ui.rects[this.pressedIndex]);
                this.ui.dragRect.setBounds(this.ui.rects[this.pressedIndex]);
            } else if (this.ui.dragging && indexValid) {
                int max;
                Point margins = this.ui.scrollLayout.getMargins(this.ui.tabPane.getTabPlacement());
                int min = margins.x;
                if (this.ui.isHorizontalTabPlacement()) {
                    max = margins.y - this.ui.dropRect.width;
                    this.ui.dragRect.x = this.tabOrigin.x + e.getX() - this.origin.x;
                    this.ui.dragRect.x = Math.max(Math.min(this.ui.dragRect.x, max), min);
                } else {
                    max = margins.y - this.ui.dropRect.height;
                    this.ui.dragRect.y = this.tabOrigin.x + e.getY() - this.origin.y;
                    this.ui.dragRect.x = Math.max(Math.min(this.ui.dragRect.y, max), min);
                }
                Point p = this.getDragMousePos();
                int tab = TabbedPaneUtil.getDroppedTabIndex(this.ui.dropRect, this.ui.tabPane, this.ui, p);
                Rectangle rect = TabbedPaneUtil.getDropRect(this.ui, this.ui.tabPane, this.ui.tabPane, p, this.ui.dropRect, tab, this.ui.dropSourceIndex, this.ui.dropTargetIndex);
                this.ui.setDnDIndicatorRect(rect.x, rect.y, rect.width, rect.height, tab, true);
            }
        }
        if (indexValid) {
            Point p = e.getPoint();
            int dist = Math.abs(this.ui.isHorizontalTabPlacement() ? this.origin.y - p.y : this.origin.x - p.x);
            if (dist > Math.max(50, this.ui.maxTabHeight) || !this.ui.scrollableTabLayoutEnabled()) {
                this.stopDrag(e, false);
                TransferHandler handler = this.ui.tabPane.getTransferHandler();
                handler.exportAsDrag(this.ui.tabPane, e, 2);
            }
        }
    }

    protected Point getDragMousePos() {
        Point p = new Point(this.ui.dragRect.x + this.ui.dragRect.width / 2, this.ui.dragRect.y + this.ui.dragRect.height / 2);
        if (this.ui.scrollableTabLayoutEnabled()) {
            p.x += this.ui.scrollableTabSupport.viewport.getX();
            p.y += this.ui.scrollableTabSupport.viewport.getY();
        }
        return p;
    }

    protected void stopDrag(MouseEvent e, boolean changeTabs) {
        int tab = TabbedPaneUtil.getDroppedTabIndex(this.ui.dropRect, this.ui.tabPane, this.ui, this.getDragMousePos());
        if (changeTabs && tab >= 0 && tab <= this.ui.tabPane.getTabCount()) {
            TabbedPaneUtil.moveTabs(this.ui.tabPane, this.ui.tabPane, this.ui.dropSourceIndex, tab);
        }
        SwingUtilities.invokeLater(() -> this.ui.setRolloverTab(e.getX(), e.getY()));
        this.ui.dragging = false;
        this.ui.dropRect.setBounds(0, 0, 0, 0);
        this.pressedIndex = -1;
        this.ui.dropTargetIndex = -1;
        this.ui.dropSourceIndex = -1;
        this.origin = null;
        this.ui.drawDropRect = false;
        this.ui.tabPane.doLayout();
        this.ui.tabPane.repaint();
        if (this.ui.scrollableTabLayoutEnabled()) {
            this.ui.scrollableTabSupport.viewport.repaint();
        } else {
            this.ui.tabPane.repaint();
        }
    }
}

