/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.IdentityHashMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingEvent;
import tconstruct.gadgets.item.ItemSlimeBoots;

public class SlimeBounceHandler {
    public static final float SQRT_2 = SlimeBounceHandler.sqrt(2.0f);
    private static final double FRAC_BIAS;
    private static final double[] ASINE_TAB;
    private static final double[] COS_TAB;
    public static final IdentityHashMap<EntityLivingBase, BounceInfo> BOUNCING_ENTITIES;

    public static void addBounceHandler(EntityLivingBase entity) {
        SlimeBounceHandler.addBounceHandler(entity, 0.0);
    }

    public static void addBounceHandler(EntityLivingBase entity, double bounce) {
        if (entity instanceof FakePlayer) {
            return;
        }
        BounceInfo info = BOUNCING_ENTITIES.get(entity);
        if (SlimeBounceHandler.hasSlimeBoots(entity)) {
            if (info == null) {
                BOUNCING_ENTITIES.put(entity, new BounceInfo(entity, bounce));
            } else if (bounce != 0.0) {
                info.bounce = bounce;
                info.bounceTick = entity.field_70173_aa + 1;
                info.lastMagSq = entity.field_70159_w * entity.field_70159_w + entity.field_70179_y * entity.field_70179_y;
                info.lastAngle = SlimeBounceHandler.atan2(entity.field_70179_y, entity.field_70159_w);
            }
        }
    }

    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingUpdateEvent event) {
        BounceInfo info;
        EntityLivingBase entity = event.entityLiving;
        if (entity != null && (info = BOUNCING_ENTITIES.get(entity)) != null) {
            boolean isInAir;
            if (entity.field_70128_L || entity.field_70145_X) {
                BOUNCING_ENTITIES.remove(entity);
                return;
            }
            if (!SlimeBounceHandler.hasSlimeBoots(entity)) {
                BOUNCING_ENTITIES.remove(entity);
                return;
            }
            if (entity.field_70173_aa == info.bounceTick) {
                entity.field_70181_x = info.bounce;
                info.bounceTick = 0;
            }
            boolean bl = isInAir = !entity.field_70122_E && !entity.func_70090_H() && !entity.func_70617_f_();
            if (isInAir && info.lastMagSq > 0.0) {
                double motionSq = entity.field_70159_w * entity.field_70159_w + entity.field_70179_y * entity.field_70179_y;
                if (motionSq == 0.0) {
                    if (info.stopMagTick == 0) {
                        info.stopMagTick = entity.field_70173_aa + 5;
                    } else if (entity.field_70173_aa > info.stopMagTick) {
                        info.lastMagSq = 0.0;
                    }
                } else if (motionSq < info.lastMagSq) {
                    info.stopMagTick = 0;
                    double boost = Math.sqrt(info.lastMagSq / motionSq) * (double)0.95f;
                    if (boost > 1.0) {
                        entity.field_70159_w *= boost;
                        entity.field_70179_y *= boost;
                        entity.field_70160_al = true;
                        info.lastMagSq = info.lastMagSq * (double)0.95f * (double)0.95f;
                        double newAngle = SlimeBounceHandler.atan2(entity.field_70179_y, entity.field_70159_w);
                        if (Math.abs(newAngle - info.lastAngle) > 1.0) {
                            entity.func_85030_a("mob.slime.small", 1.0f, 1.0f);
                        }
                        info.lastAngle = newAngle;
                    } else {
                        info.lastMagSq = motionSq;
                        info.lastAngle = SlimeBounceHandler.atan2(entity.field_70179_y, entity.field_70159_w);
                    }
                }
            }
            if (info.wasInAir && !isInAir) {
                if (info.endHandler == 0) {
                    info.endHandler = entity.field_70173_aa + 5;
                } else if (entity.field_70173_aa > info.endHandler) {
                    BOUNCING_ENTITIES.remove(entity);
                }
            } else {
                info.endHandler = 0;
                info.wasInAir = true;
            }
        }
    }

    public static Vec3 getMotion(EntityLivingBase aEntity) {
        return Vec3.func_72443_a((double)aEntity.field_70159_w, (double)aEntity.field_70181_x, (double)aEntity.field_70179_y);
    }

    public static boolean hasSlimeBoots(EntityLivingBase entity) {
        if (entity != null) {
            for (int i = 1; i < 5; ++i) {
                ItemStack aBoots = entity.func_71124_b(i);
                if (aBoots == null || !(aBoots.func_77973_b() instanceof ItemSlimeBoots)) continue;
                return true;
            }
        }
        return false;
    }

    public static float sqrt(float value) {
        return (float)Math.sqrt(value);
    }

    public static double atan2(double aArg1, double aArg2) {
        boolean flag2;
        boolean flag1;
        boolean flag;
        double d0 = aArg2 * aArg2 + aArg1 * aArg1;
        if (Double.isNaN(d0)) {
            return Double.NaN;
        }
        boolean bl = flag = aArg1 < 0.0;
        if (flag) {
            aArg1 = -aArg1;
        }
        boolean bl2 = flag1 = aArg2 < 0.0;
        if (flag1) {
            aArg2 = -aArg2;
        }
        boolean bl3 = flag2 = aArg1 > aArg2;
        if (flag2) {
            double d1 = aArg2;
            aArg2 = aArg1;
            aArg1 = d1;
        }
        double d9 = SlimeBounceHandler.fastInvSqrt(d0);
        aArg2 *= d9;
        double d2 = FRAC_BIAS + (aArg1 *= d9);
        int i = (int)Double.doubleToRawLongBits(d2);
        double d3 = ASINE_TAB[i];
        double d4 = COS_TAB[i];
        double d5 = d2 - FRAC_BIAS;
        double d6 = aArg1 * d4 - aArg2 * d5;
        double d7 = (6.0 + d6 * d6) * d6 * 0.16666666666666666;
        double d8 = d3 + d7;
        if (flag2) {
            d8 = 1.5707963267948966 - d8;
        }
        if (flag1) {
            d8 = Math.PI - d8;
        }
        if (flag) {
            d8 = -d8;
        }
        return d8;
    }

    public static double fastInvSqrt(double aArg) {
        double d0 = 0.5 * aArg;
        long i = Double.doubleToRawLongBits(aArg);
        i = 6910469410427058090L - (i >> 1);
        aArg = Double.longBitsToDouble(i);
        aArg *= 1.5 - d0 * aArg * aArg;
        return aArg;
    }

    static {
        BOUNCING_ENTITIES = new IdentityHashMap();
        FRAC_BIAS = Double.longBitsToDouble(4805340802404319232L);
        ASINE_TAB = new double[257];
        COS_TAB = new double[257];
        for (int j = 0; j < 257; ++j) {
            double d0 = (double)j / 256.0;
            double d1 = Math.asin(d0);
            SlimeBounceHandler.COS_TAB[j] = Math.cos(d1);
            SlimeBounceHandler.ASINE_TAB[j] = d1;
        }
    }

    private static class BounceInfo {
        private double bounce;
        private int bounceTick;
        private int stopMagTick;
        private double lastMagSq;
        private boolean wasInAir = false;
        private int endHandler = 0;
        private double lastAngle;

        public BounceInfo(EntityLivingBase entity, double bounce) {
            this.bounce = bounce;
            this.bounceTick = bounce != 0.0 ? entity.field_70173_aa + 1 : 0;
            this.lastMagSq = entity.field_70159_w * entity.field_70159_w + entity.field_70179_y * entity.field_70179_y;
        }
    }
}

