/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.world.nether.dimension;

import cpw.mods.fml.common.eventhandler.Event;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.compat.ExternalContent;
import ganymedes01.etfuturum.compat.ModsList;
import ganymedes01.etfuturum.configuration.configs.ConfigMixins;
import ganymedes01.etfuturum.world.generate.decorate.WorldGenSoulFire;
import ganymedes01.etfuturum.world.generate.feature.WorldGenBasaltGlowstone;
import ganymedes01.etfuturum.world.nether.biome.NetherBiomeBase;
import ganymedes01.etfuturum.world.nether.biome.utils.NetherBiomeManager;
import ganymedes01.etfuturum.world.nether.dimension.gen.MapGenCavesHellModified;
import ganymedes01.etfuturum.world.nether.dimension.gen.MapGenRavineHell;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.feature.WorldGenFire;
import net.minecraft.world.gen.feature.WorldGenFlowers;
import net.minecraft.world.gen.feature.WorldGenGlowStone1;
import net.minecraft.world.gen.feature.WorldGenGlowStone2;
import net.minecraft.world.gen.feature.WorldGenHellLava;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.MapGenNetherBridge;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.ChunkProviderEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class NetherChunkProvider
implements IChunkProvider {
    private final Random hellRNG;
    private final NoiseGeneratorOctaves netherNoiseGen1;
    private final NoiseGeneratorOctaves netherNoiseGen2;
    private final NoiseGeneratorOctaves netherNoiseGen3;
    private final NoiseGeneratorOctaves slowsandGravelNoiseGen;
    private final NoiseGeneratorOctaves netherrackExculsivityNoiseGen;
    public NoiseGeneratorOctaves netherNoiseGen6;
    public NoiseGeneratorOctaves netherNoiseGen7;
    private final World worldObj;
    private double[] noiseField;
    public MapGenNetherBridge genNetherBridge = new MapGenNetherBridge();
    private double[] slowsandNoise = new double[256];
    private double[] gravelNoise = new double[256];
    private BiomeGenBase[] biomesForGeneration;
    private double[] netherrackExclusivityNoise = new double[256];
    private MapGenBase netherCaveGenerator = new MapGenCavesHellModified();
    private final MapGenBase netherRavineGenerator = new MapGenRavineHell();
    double[] noiseData1;
    double[] noiseData2;
    double[] noiseData3;
    double[] noiseData4;
    double[] noiseData5;
    private double[] soulSoilNoise;
    private final NoiseGeneratorOctaves soulSoilNoiseGen;
    private final WorldGenerator quartzOreGen;
    private final WorldGenerator redMushroomGen;
    private final WorldGenerator brownMushroomGen;
    private final WorldGenerator glowstone1Gen;
    private final WorldGenerator glowstone2Gen;
    private final WorldGenerator basaltGlowstoneGen;
    private final WorldGenerator fireGen;
    private final WorldGenerator soulFireGen;
    private final WorldGenerator lavaGen;

    public NetherChunkProvider(World par1World, long par2) {
        this.genNetherBridge = (MapGenNetherBridge)TerrainGen.getModdedMapGen((MapGenBase)this.genNetherBridge, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.NETHER_BRIDGE);
        this.netherCaveGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.netherCaveGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.NETHER_CAVE);
        this.soulSoilNoise = new double[256];
        this.quartzOreGen = new WorldGenMinable(Blocks.field_150449_bY, 13, Blocks.field_150424_aL);
        this.redMushroomGen = new WorldGenFlowers((Block)Blocks.field_150337_Q);
        this.brownMushroomGen = new WorldGenFlowers((Block)Blocks.field_150338_P);
        this.glowstone1Gen = new WorldGenGlowStone1();
        this.glowstone2Gen = new WorldGenGlowStone2();
        this.basaltGlowstoneGen = new WorldGenBasaltGlowstone();
        this.fireGen = new WorldGenFire();
        this.soulFireGen = new WorldGenSoulFire();
        this.lavaGen = new WorldGenHellLava((Block)Blocks.field_150356_k, false);
        this.worldObj = par1World;
        this.hellRNG = new Random(par2);
        this.netherNoiseGen1 = new NoiseGeneratorOctaves(this.hellRNG, 16);
        this.netherNoiseGen2 = new NoiseGeneratorOctaves(this.hellRNG, 16);
        this.netherNoiseGen3 = new NoiseGeneratorOctaves(this.hellRNG, 8);
        this.slowsandGravelNoiseGen = new NoiseGeneratorOctaves(this.hellRNG, 4);
        this.netherrackExculsivityNoiseGen = new NoiseGeneratorOctaves(this.hellRNG, 4);
        this.netherNoiseGen6 = new NoiseGeneratorOctaves(this.hellRNG, 10);
        this.netherNoiseGen7 = new NoiseGeneratorOctaves(this.hellRNG, 16);
        this.soulSoilNoiseGen = new NoiseGeneratorOctaves(this.hellRNG, 4);
    }

    public void generateNetherTerrain(int par1, int par2, Block[] blocks, byte[] abyte, BiomeGenBase[] biomesForGeneration) {
        int b0 = 4;
        int b1 = 32;
        int k = b0 + 1;
        int b2 = 17;
        int l = b0 + 1;
        BiomeGenBase biomegenbase = biomesForGeneration[l + k * 16];
        this.noiseField = this.initializeNoiseField(this.noiseField, par1 * b0, 0, par2 * b0, k, b2, l);
        for (int i1 = 0; i1 < b0; ++i1) {
            for (int j1 = 0; j1 < b0; ++j1) {
                for (int k1 = 0; k1 < 16; ++k1) {
                    double d0 = 0.125;
                    double d1 = this.noiseField[(i1 * l + j1) * b2 + k1];
                    int i = (i1 * l + j1 + 1) * b2;
                    int i3 = ((i1 + 1) * l + j1) * b2;
                    int i4 = ((i1 + 1) * l + j1 + 1) * b2;
                    double d2 = this.noiseField[i + k1];
                    double d3 = this.noiseField[i3 + k1];
                    double d4 = this.noiseField[i4 + k1];
                    double d5 = (this.noiseField[(i1 * l + j1) * b2 + k1 + 1] - d1) * d0;
                    double d6 = (this.noiseField[i + k1 + 1] - d2) * d0;
                    double d7 = (this.noiseField[i3 + k1 + 1] - d3) * d0;
                    double d8 = (this.noiseField[i4 + k1 + 1] - d4) * d0;
                    for (int l1 = 0; l1 < 8; ++l1) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int i2 = 0; i2 < 4; ++i2) {
                            int j2 = i2 + i1 * 4 << 11 | j1 * 4 << 7 | k1 * 8 + l1;
                            int short1 = 128;
                            double d14 = 0.25;
                            double d15 = d10;
                            double d16 = (d11 - d10) * d14;
                            for (int k2 = 0; k2 < 4; ++k2) {
                                Block l2 = Blocks.field_150350_a;
                                if (k1 * 8 + l1 < b1) {
                                    l2 = Blocks.field_150353_l;
                                }
                                if (d15 > 0.0) {
                                    l2 = Blocks.field_150424_aL;
                                }
                                if (ModsList.NATURA.isLoaded() && biomegenbase == BiomeGenBase.field_76778_j && d15 > 56.0) {
                                    l2 = ExternalContent.Blocks.NATURA_TAINTED_SOIL.get();
                                }
                                blocks[j2] = l2;
                                abyte[j2] = 0;
                                j2 += short1;
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void replaceBlocksForBiome(int x, int z, Block[] blocks, byte[] metas, BiomeGenBase[] par4ArrayOfBiomeGenBase) {
        ChunkProviderEvent.ReplaceBiomeBlocks event = new ChunkProviderEvent.ReplaceBiomeBlocks((IChunkProvider)this, x, z, blocks, par4ArrayOfBiomeGenBase);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return;
        }
        int b0 = 32;
        int a0 = 64;
        double d0 = 0.03125;
        this.slowsandNoise = this.slowsandGravelNoiseGen.func_76304_a(this.slowsandNoise, x * 16, z * 16, 0, 16, 16, 1, d0, d0, 1.0);
        this.gravelNoise = this.slowsandGravelNoiseGen.func_76304_a(this.gravelNoise, x * 16, 109, z * 16, 16, 1, 16, d0, 1.0, d0);
        this.netherrackExclusivityNoise = this.netherrackExculsivityNoiseGen.func_76304_a(this.netherrackExclusivityNoise, x * 16, z * 16, 0, 16, 16, 1, d0 * 2.0, d0 * 2.0, d0 * 2.0);
        this.soulSoilNoise = this.soulSoilNoiseGen.func_76305_a(this.soulSoilNoise, x * 16, z * 16, 16, 16, 0.0625, 0.0625, 1.0);
        for (int k = 0; k < 16; ++k) {
            for (int l = 0; l < 16; ++l) {
                Block topBlock;
                Block fillerBlock;
                double n;
                boolean gravelFlag;
                BiomeGenBase biomegenbase = par4ArrayOfBiomeGenBase[l + k * 16];
                boolean soulSandFlag = biomegenbase == BiomeGenBase.field_76778_j && this.slowsandNoise[k + l * 16] + this.hellRNG.nextDouble() * 0.2 > 0.0;
                boolean bl = gravelFlag = biomegenbase == BiomeGenBase.field_76778_j && this.gravelNoise[k + l * 16] + this.hellRNG.nextDouble() * 0.2 > 0.0;
                boolean soulSoilFlag = biomegenbase == NetherBiomeManager.soulSandValley && ModBlocks.SOUL_SOIL.isEnabled() ? (n = this.soulSoilNoise[k + l * 16] + this.hellRNG.nextDouble() * 0.05) > 1.5 || n < -0.5 : false;
                int i1 = (int)(this.netherrackExclusivityNoise[k + l * 16] / 3.0 + 3.0 + this.hellRNG.nextDouble() * 0.25);
                int j1 = -1;
                if (soulSoilFlag) {
                    topBlock = fillerBlock = ModBlocks.SOUL_SOIL.get();
                } else {
                    topBlock = biomegenbase.field_76752_A;
                    fillerBlock = biomegenbase.field_76753_B;
                }
                byte topMeta = (byte)biomegenbase.field_150604_aj;
                byte fillerMeta = (byte)biomegenbase.field_76754_C;
                if (biomegenbase == BiomeGenBase.field_76778_j && ModsList.NATURA.isLoaded()) {
                    fillerBlock = ExternalContent.Blocks.NATURA_TAINTED_SOIL.get();
                    fillerMeta = 0;
                }
                for (int k1 = 127; k1 >= 0; --k1) {
                    int l1 = (l * 16 + k) * 128 + k1;
                    if (k1 < 127 - this.hellRNG.nextInt(5) && k1 > this.hellRNG.nextInt(5)) {
                        Block b3 = blocks[l1];
                        if (b3 == Blocks.field_150350_a) {
                            j1 = -1;
                            if (blocks[l1 + 1] == Blocks.field_150424_aL) {
                                blocks[l1 + 1] = soulSoilFlag ? ModBlocks.SOUL_SOIL.get() : biomegenbase.field_76753_B;
                                metas[l1 + 1] = (byte)biomegenbase.field_76754_C;
                            }
                            if (blocks[l1 + 2] == Blocks.field_150424_aL) {
                                blocks[l1 + 2] = soulSoilFlag ? ModBlocks.SOUL_SOIL.get() : biomegenbase.field_76753_B;
                                metas[l1 + 2] = (byte)biomegenbase.field_76754_C;
                            }
                            if (blocks[l1 + 3] != Blocks.field_150424_aL) continue;
                            blocks[l1 + 3] = soulSoilFlag ? ModBlocks.SOUL_SOIL.get() : biomegenbase.field_76753_B;
                            metas[l1 + 3] = (byte)biomegenbase.field_76754_C;
                            continue;
                        }
                        if (b3 != Blocks.field_150424_aL) continue;
                        if (j1 == -1) {
                            if (i1 <= 0) {
                                topBlock = Blocks.field_150350_a;
                                fillerBlock = Blocks.field_150424_aL;
                                fillerMeta = 0;
                                topMeta = 0;
                            } else if (k1 >= a0 - 4 && k1 <= a0 + 1) {
                                if (soulSoilFlag) {
                                    fillerBlock = topBlock = ModBlocks.SOUL_SOIL.get();
                                } else {
                                    topBlock = biomegenbase.field_76752_A;
                                    fillerBlock = biomegenbase.field_76753_B;
                                }
                                topMeta = (byte)biomegenbase.field_150604_aj;
                                if (biomegenbase == BiomeGenBase.field_76778_j && ModsList.NATURA.isLoaded()) {
                                    fillerBlock = ExternalContent.Blocks.NATURA_TAINTED_SOIL.get();
                                    fillerMeta = 0;
                                } else {
                                    fillerMeta = (byte)biomegenbase.field_76754_C;
                                }
                                if (gravelFlag) {
                                    topBlock = Blocks.field_150351_n;
                                    topMeta = 0;
                                }
                                if (gravelFlag) {
                                    fillerBlock = Blocks.field_150424_aL;
                                    fillerMeta = 0;
                                }
                                if (soulSandFlag) {
                                    topBlock = Blocks.field_150425_aM;
                                    topMeta = 0;
                                }
                                if (soulSandFlag) {
                                    fillerBlock = ModsList.NATURA.isLoaded() ? ExternalContent.Blocks.NATURA_HEAT_SAND.get() : Blocks.field_150425_aM;
                                    fillerMeta = 0;
                                }
                            }
                            if (k1 < b0 && topBlock == Blocks.field_150350_a) {
                                topBlock = Blocks.field_150353_l;
                                topMeta = 0;
                            }
                            j1 = i1;
                            if (k1 >= b0 - 1) {
                                blocks[l1] = topBlock;
                                metas[l1] = topMeta;
                                continue;
                            }
                            blocks[l1] = fillerBlock;
                            metas[l1] = fillerMeta;
                            continue;
                        }
                        if (j1 <= 0) continue;
                        --j1;
                        blocks[l1] = fillerBlock;
                        metas[l1] = fillerMeta;
                        continue;
                    }
                    blocks[l1] = Blocks.field_150357_h;
                    metas[l1] = 0;
                }
            }
        }
    }

    public Chunk func_73158_c(int par1, int par2) {
        return this.func_73154_d(par1, par2);
    }

    public Chunk func_73154_d(int par1, int par2) {
        this.hellRNG.setSeed((long)par1 * 341873128712L + (long)par2 * 132897987541L);
        byte[] abyte = new byte[32768];
        Block[] blocks = new Block[32768];
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, par1 * 16, par2 * 16, 16, 16);
        this.generateNetherTerrain(par1, par2, blocks, abyte, this.biomesForGeneration);
        this.replaceBlocksForBiome(par1, par2, blocks, abyte, this.biomesForGeneration);
        this.netherCaveGenerator.func_151539_a((IChunkProvider)this, this.worldObj, par1, par2, blocks);
        this.netherRavineGenerator.func_151539_a((IChunkProvider)this, this.worldObj, par1, par2, blocks);
        this.genNetherBridge.func_151539_a((IChunkProvider)this, this.worldObj, par1, par2, blocks);
        Chunk chunk = new Chunk(this.worldObj, blocks, abyte, par1, par2);
        BiomeGenBase[] abiomegenbase = this.worldObj.func_72959_q().func_76933_b(null, par1 * 16, par2 * 16, 16, 16);
        byte[] abyte1 = chunk.func_76605_m();
        for (int k = 0; k < abyte1.length; ++k) {
            abyte1[k] = (byte)abiomegenbase[k].field_76756_M;
        }
        chunk.func_76613_n();
        return chunk;
    }

    private double[] initializeNoiseField(double[] par1ArrayOfDouble, int par2, int par3, int par4, int par5, int par6, int par7) {
        int i2;
        ChunkProviderEvent.InitNoiseField event = new ChunkProviderEvent.InitNoiseField((IChunkProvider)this, par1ArrayOfDouble, par2, par3, par4, par5, par6, par7);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return event.noisefield;
        }
        if (par1ArrayOfDouble == null) {
            par1ArrayOfDouble = new double[par5 * par6 * par7];
        }
        double d0 = 684.412;
        double d1 = 2053.236;
        this.noiseData4 = this.netherNoiseGen6.func_76304_a(this.noiseData4, par2, par3, par4, par5, 1, par7, 1.0, 0.0, 1.0);
        this.noiseData5 = this.netherNoiseGen7.func_76304_a(this.noiseData5, par2, par3, par4, par5, 1, par7, 100.0, 0.0, 100.0);
        this.noiseData1 = this.netherNoiseGen3.func_76304_a(this.noiseData1, par2, par3, par4, par5, par6, par7, d0 / 80.0, d1 / 60.0, d0 / 80.0);
        this.noiseData2 = this.netherNoiseGen1.func_76304_a(this.noiseData2, par2, par3, par4, par5, par6, par7, d0, d1, d0);
        this.noiseData3 = this.netherNoiseGen2.func_76304_a(this.noiseData3, par2, par3, par4, par5, par6, par7, d0, d1, d0);
        int k1 = 0;
        int l1 = 0;
        double[] adouble1 = new double[par6];
        for (i2 = 0; i2 < par6; ++i2) {
            adouble1[i2] = Math.cos((double)i2 * Math.PI * 6.0 / (double)par6) * 2.0;
            double d2 = i2;
            if (i2 > par6 / 2) {
                d2 = par6 - 1 - i2;
            }
            if (!(d2 < 4.0)) continue;
            d2 = 4.0 - d2;
            int n = i2;
            adouble1[n] = adouble1[n] - d2 * d2 * d2 * 10.0;
        }
        for (i2 = 0; i2 < par5; ++i2) {
            for (int j2 = 0; j2 < par7; ++j2) {
                double d5;
                double d3 = (this.noiseData4[l1] + 256.0) / 512.0;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                if ((d5 = this.noiseData5[l1] / 8000.0) < 0.0) {
                    d5 = -d5;
                }
                if ((d5 = d5 * 3.0 - 3.0) < 0.0) {
                    if ((d5 /= 2.0) < -1.0) {
                        d5 = -1.0;
                    }
                    d5 /= 1.4;
                    d5 /= 2.0;
                    d3 = 0.0;
                } else {
                    if (d5 > 1.0) {
                        d5 = 1.0;
                    }
                    d5 /= 6.0;
                }
                d3 += 0.5;
                d5 = d5 * (double)par6 / 16.0;
                ++l1;
                for (int k2 = 0; k2 < par6; ++k2) {
                    double d6 = 0.0;
                    double d7 = adouble1[k2];
                    double d8 = this.noiseData2[k1] / 512.0;
                    double d9 = this.noiseData3[k1] / 512.0;
                    double d10 = (this.noiseData1[k1] / 10.0 + 1.0) / 2.0;
                    d6 = d10 < 0.0 ? d8 : (d10 > 1.0 ? d9 : d8 + (d9 - d8) * d10);
                    d6 -= d7;
                    if (k2 > par6 - 4) {
                        double d11 = (float)(k2 - (par6 - 4)) / 3.0f;
                        d6 = d6 * (1.0 - d11) + -10.0 * d11;
                    }
                    par1ArrayOfDouble[k1] = d6;
                    ++k1;
                }
            }
        }
        return par1ArrayOfDouble;
    }

    public boolean func_73149_a(int par1, int par2) {
        return true;
    }

    public void func_73153_a(IChunkProvider par1IChunkProvider, int par2, int par3) {
        int i2;
        int l1;
        int k1;
        int j1;
        int i1;
        boolean doGen;
        BlockFalling.field_149832_M = true;
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(par1IChunkProvider, this.worldObj, this.hellRNG, par2, par3, false));
        int k = par2 * 16;
        int l = par3 * 16;
        BiomeGenBase biome = this.worldObj.func_72807_a(k + 16, l + 16);
        this.hellRNG.setSeed(this.worldObj.func_72905_C());
        long rand1 = this.hellRNG.nextLong() / 2L * 2L + 1L;
        long rand2 = this.hellRNG.nextLong() / 2L * 2L + 1L;
        this.hellRNG.setSeed((long)par2 * rand1 + (long)par3 * rand2 ^ this.worldObj.func_72905_C());
        this.genNetherBridge.func_75051_a(this.worldObj, this.hellRNG, par2, par3);
        if (biome instanceof NetherBiomeBase) {
            NetherBiomeBase Netherbiome = (NetherBiomeBase)biome;
            Netherbiome.populate(this.worldObj, this.hellRNG, par2 * 16, par3 * 16);
        }
        if (doGen = TerrainGen.populate((IChunkProvider)par1IChunkProvider, (World)this.worldObj, (Random)this.hellRNG, (int)par2, (int)par3, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.NETHER_LAVA)) {
            for (i1 = 0; i1 < 8; ++i1) {
                j1 = k + this.hellRNG.nextInt(16) + 8;
                k1 = this.hellRNG.nextInt(120) + 4;
                l1 = l + this.hellRNG.nextInt(16) + 8;
                this.lavaGen.func_76484_a(this.worldObj, this.hellRNG, j1, k1, l1);
            }
        }
        i1 = this.hellRNG.nextInt(this.hellRNG.nextInt(10) + 1) + 1;
        doGen = TerrainGen.populate((IChunkProvider)par1IChunkProvider, (World)this.worldObj, (Random)this.hellRNG, (int)par2, (int)par3, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.FIRE);
        if (doGen) {
            for (j1 = 0; j1 < i1; ++j1) {
                k1 = k + this.hellRNG.nextInt(16) + 8;
                l1 = this.hellRNG.nextInt(120) + 4;
                i2 = l + this.hellRNG.nextInt(16) + 8;
                (biome == NetherBiomeManager.soulSandValley && ConfigMixins.soulFire ? this.soulFireGen : this.fireGen).func_76484_a(this.worldObj, this.hellRNG, k1, l1, i2);
            }
        }
        i1 = this.hellRNG.nextInt(this.hellRNG.nextInt(10) + 1);
        doGen = TerrainGen.populate((IChunkProvider)par1IChunkProvider, (World)this.worldObj, (Random)this.hellRNG, (int)par2, (int)par3, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.GLOWSTONE);
        if (doGen) {
            for (j1 = 0; j1 < i1; ++j1) {
                k1 = k + this.hellRNG.nextInt(16) + 8;
                l1 = this.hellRNG.nextInt(120) + 4;
                i2 = l + this.hellRNG.nextInt(16) + 8;
                if (biome == NetherBiomeManager.basaltDeltas) {
                    this.basaltGlowstoneGen.func_76484_a(this.worldObj, this.hellRNG, k1, l1, i2);
                    continue;
                }
                this.glowstone1Gen.func_76484_a(this.worldObj, this.hellRNG, k1, l1, i2);
            }
            for (j1 = 0; j1 < 10; ++j1) {
                k1 = k + this.hellRNG.nextInt(16) + 8;
                l1 = this.hellRNG.nextInt(128);
                i2 = l + this.hellRNG.nextInt(16) + 8;
                if (biome == NetherBiomeManager.basaltDeltas) {
                    this.basaltGlowstoneGen.func_76484_a(this.worldObj, this.hellRNG, k1, l1, i2);
                    continue;
                }
                this.glowstone2Gen.func_76484_a(this.worldObj, this.hellRNG, k1, l1, i2);
            }
        }
        if (!ModsList.NATURA.isLoaded()) {
            MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(this.worldObj, this.hellRNG, k, l));
            doGen = TerrainGen.decorate((World)this.worldObj, (Random)this.hellRNG, (int)k, (int)l, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SHROOM);
            if (doGen) {
                this.hellRNG.nextInt(1);
                j1 = k + this.hellRNG.nextInt(16) + 8;
                k1 = this.hellRNG.nextInt(128);
                l1 = l + this.hellRNG.nextInt(16) + 8;
                if (k1 <= 124) {
                    this.brownMushroomGen.func_76484_a(this.worldObj, this.hellRNG, j1, k1, l1);
                }
                this.hellRNG.nextInt(1);
                j1 = k + this.hellRNG.nextInt(16) + 8;
                k1 = this.hellRNG.nextInt(128);
                l1 = l + this.hellRNG.nextInt(16) + 8;
                if (k1 <= 124) {
                    this.redMushroomGen.func_76484_a(this.worldObj, this.hellRNG, j1, k1, l1);
                }
            }
        }
        for (k1 = 0; k1 < 16; ++k1) {
            l1 = k + this.hellRNG.nextInt(16);
            i2 = this.hellRNG.nextInt(108) + 10;
            int j2 = l + this.hellRNG.nextInt(16);
            this.quartzOreGen.func_76484_a(this.worldObj, this.hellRNG, l1, i2, j2);
        }
        biome.func_76728_a(this.worldObj, this.hellRNG, k, l);
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(this.worldObj, this.hellRNG, k, l));
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(par1IChunkProvider, this.worldObj, this.hellRNG, par2, par3, false));
        BlockFalling.field_149832_M = false;
    }

    public boolean func_73151_a(boolean par1, IProgressUpdate par2IProgressUpdate) {
        return true;
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "HellRandomLevelSource";
    }

    public List<BiomeGenBase.SpawnListEntry> func_73155_a(EnumCreatureType par1EnumCreatureType, int par2, int par3, int par4) {
        if (par1EnumCreatureType == EnumCreatureType.monster && this.genNetherBridge.func_75048_a(par2, par3, par4)) {
            return this.genNetherBridge.func_75059_a();
        }
        BiomeGenBase biomegenbase = this.worldObj.func_72807_a(par2, par4);
        return biomegenbase == null ? null : biomegenbase.func_76747_a(par1EnumCreatureType);
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int par1, int par2) {
        this.genNetherBridge.func_151539_a((IChunkProvider)this, this.worldObj, par1, par2, null);
    }

    public void func_104112_b() {
    }

    public ChunkPosition func_147416_a(World par1World, String par2Str, int par3, int par4, int par5) {
        return null;
    }
}

