/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.util.ItemSearchDTO;
import appeng.client.render.highlighter.StoragePosHighlighter;
import appeng.core.localization.PlayerMessages;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public class PacketHighlightBlockStorage
extends AppEngPacket {
    List<ItemSearchDTO> coords;

    public PacketHighlightBlockStorage(ByteBuf stream) throws IOException {
        int size = stream.readInt();
        byte[] tagBytes = new byte[size];
        stream.readBytes(tagBytes);
        ByteArrayInputStream byteArray = new ByteArrayInputStream(tagBytes);
        NBTTagCompound nbt = CompressedStreamTools.func_74794_a((DataInputStream)new DataInputStream(byteArray));
        this.coords = ItemSearchDTO.readAsListFromNBT(nbt);
    }

    public PacketHighlightBlockStorage(List<ItemSearchDTO> coords) throws IOException {
        this.coords = coords;
        ByteBuf buffer = Unpooled.buffer();
        buffer.writeInt(this.getPacketID());
        NBTTagCompound tag = new NBTTagCompound();
        ItemSearchDTO.writeListToNBT(tag, coords);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        CompressedStreamTools.func_74800_a((NBTTagCompound)tag, (DataOutput)data);
        byte[] tagBytes = bytes.toByteArray();
        int size = tagBytes.length;
        buffer.writeInt(size);
        buffer.writeBytes(tagBytes);
        this.configureWrite(buffer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void clientPacketData(INetworkInfo network, AppEngPacket packet, EntityPlayer player) {
        try {
            if (Platform.isClient()) {
                StoragePosHighlighter.highlightStorage(player, this.coords, PlayerMessages.StorageHighlighted.getUnlocalized(), PlayerMessages.StorageInOtherDim.getUnlocalized());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

