/*
 * Decompiled with CFR 0.152.
 */
package kekztech.common.tileentities;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.AutoPlaceEnvironment;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizon.structurelib.util.ItemStackPredicate;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.NumericWidget;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchDynamo;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.metatileentity.implementations.MTEHatchMaintenance;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.IGTHatchAdder;
import gregtech.api.util.LongData;
import gregtech.api.util.LongRunningAverage;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.shutdown.ShutDownReason;
import gregtech.common.gui.modularui.widget.ShutDownReasonSyncer;
import gregtech.common.misc.GTStructureChannels;
import gregtech.common.misc.WirelessNetworkManager;
import gregtech.common.misc.spaceprojects.SpaceProjectManager;
import gregtech.common.tileentities.machines.multi.drone.MTEHatchDroneDownLink;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import kekztech.client.gui.KTUITextures;
import kekztech.common.Blocks;
import kekztech.common.itemBlocks.ItemBlockLapotronicEnergyUnit;
import kekztech.util.Util;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import tectech.thing.metaTileEntity.hatch.MTEHatchDynamoMulti;
import tectech.thing.metaTileEntity.hatch.MTEHatchDynamoTunnel;
import tectech.thing.metaTileEntity.hatch.MTEHatchEnergyMulti;
import tectech.thing.metaTileEntity.hatch.MTEHatchEnergyTunnel;

public class MTELapotronicSuperCapacitor
extends MTEEnhancedMultiBlockBase<MTELapotronicSuperCapacitor>
implements ISurvivalConstructable {
    private boolean canUseWireless = false;
    private boolean wireless_mode = false;
    private int counter = 1;
    private boolean balanced = false;
    private boolean warningReceived = false;
    private final LongRunningAverage energyInputValues1h = new LongRunningAverage(72000);
    private final LongRunningAverage energyOutputValues1h = new LongRunningAverage(72000);
    private final LongData energyInputValues = this.energyInputValues1h.view(100);
    private final LongData energyOutputValues = this.energyOutputValues1h.view(100);
    private final LongData energyInputValues5m = this.energyInputValues1h.view(6000);
    private final LongData energyOutputValues5m = this.energyOutputValues1h.view(6000);
    private final long max_passive_drain_eu_per_tick_per_uhv_cap = 1000000L;
    private final long max_passive_drain_eu_per_tick_per_uev_cap = 100000000L;
    private final long max_passive_drain_eu_per_tick_per_uiv_cap = (long)GTUtility.powInt(10.0, 10);
    private final long max_passive_drain_eu_per_tick_per_umv_cap = (long)GTUtility.powInt(10.0, 12);
    private final BigInteger guiCapacityStoredReformatLimit = BigInteger.valueOf(1000000000000L);
    private static final String STRUCTURE_PIECE_BASE = "base";
    private static final String STRUCTURE_PIECE_LAYER = "slice";
    private static final String STRUCTURE_PIECE_TOP = "top";
    private static final String STRUCTURE_PIECE_MID = "mid";
    private static final int GLASS_TIER_UNSET = -1;
    private static final Block LSC_PART = Blocks.lscLapotronicEnergyUnit;
    private static final Item LSC_PART_ITEM = Item.func_150898_a((Block)LSC_PART);
    private static final int CASING_META = 0;
    private static final int CASING_TEXTURE_ID = 5503;
    private static final int DURATION_AVERAGE_TICKS = 100;
    private static final int DEBUG_POWER_WINDOW_ID = 10;
    private static final int WIRELESS_WARNING_WINDOW_ID = 11;
    private static final BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    private static final IStructureDefinition<MTELapotronicSuperCapacitor> STRUCTURE_DEFINITION = IStructureDefinition.builder().addShape("base", StructureUtility.transpose((String[][])new String[][]{{"bbbbb", "bbbbb", "bbbbb", "bbbbb", "bbbbb"}, {"bb~bb", "bbbbb", "bbbbb", "bbbbb", "bbbbb"}})).addShape("slice", StructureUtility.transpose((String[][])new String[][]{{"ggggg", "gcccg", "gcccg", "gcccg", "ggggg"}})).addShape("top", StructureUtility.transpose((String[][])new String[][]{{"ggggg", "ggggg", "ggggg", "ggggg", "ggggg"}})).addShape("mid", StructureUtility.transpose((String[][])new String[][]{{"ggggg", "gCCCg", "gCCCg", "gCCCg", "ggggg"}})).addElement('b', GTStructureUtility.buildHatchAdder(MTELapotronicSuperCapacitor.class).atLeast(LSCHatchElement.Energy, LSCHatchElement.Dynamo, HatchElement.Maintenance).hatchItemFilterAnd((t, h) -> GTStructureChannels.BOROGLASS.getValue((ItemStack)h) < 6 ? GTStructureUtility.filterByMTEClass((List<? extends Class<? extends IMetaTileEntity>>)ImmutableList.of(MTEHatchEnergyTunnel.class, MTEHatchDynamoTunnel.class)).negate() : s -> true).casingIndex(5503).dot(1).buildAndChain(StructureUtility.onElementPass(te -> ++te.casingAmount, (IStructureElement)StructureUtility.ofBlock((Block)LSC_PART, (int)0)))).addElement('g', GTStructureUtility.chainAllGlasses(-1, (te, t) -> {
        te.glassTier = t;
    }, te -> te.glassTier)).addElement('c', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.onlyIf(te -> te.topState != TopState.NotTop, (IStructureElement)StructureUtility.onElementPass(te -> {
        te.topState = TopState.Top;
    }, GTStructureUtility.chainAllGlasses(-1, (te, t) -> {
        te.glassTier = t;
    }, te -> te.glassTier))), StructureUtility.onlyIf(te -> te.topState != TopState.Top, (IStructureElement)StructureUtility.onElementPass(te -> {
        te.topState = TopState.NotTop;
    }, (IStructureElement)CellElement.INSTANCE))})).addElement('C', GTStructureChannels.LSC_CAPACITOR.use(CellElement.INSTANCE)).build();
    private static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    private final Set<MTEHatchEnergyMulti> mEnergyHatchesTT = new HashSet<MTEHatchEnergyMulti>();
    private final Set<MTEHatchDynamoMulti> mDynamoHatchesTT = new HashSet<MTEHatchDynamoMulti>();
    private final Set<MTEHatchEnergyTunnel> mEnergyTunnelsTT = new HashSet<MTEHatchEnergyTunnel>();
    private final Set<MTEHatchDynamoTunnel> mDynamoTunnelsTT = new HashSet<MTEHatchDynamoTunnel>();
    private final int[] capacitors = new int[10];
    private BigInteger capacity = BigInteger.ZERO;
    private BigInteger stored = BigInteger.ZERO;
    private long passiveDischargeAmount = 0L;
    private long inputLastTick = 0L;
    private long outputLastTick = 0L;
    private int repairStatusCache = 0;
    private int glassTier = -1;
    private int casingAmount = 0;
    private TopState topState = TopState.MayBeTop;
    private long mMaxEUIn = 0L;
    private long mMaxEUOut = 0L;
    private UUID global_energy_user_uuid;
    protected String capacityCache = "";
    protected String storedEUCache = "";
    protected String usedPercentCache = "";
    protected String passiveDischargeAmountCache = "";
    protected String wirelessStoreCache = "";
    protected long avgInCache;
    protected long avgOutCache;
    protected String timeToCache = "";
    protected boolean isActiveCache;

    public MTELapotronicSuperCapacitor(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTELapotronicSuperCapacitor(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity var1) {
        return new MTELapotronicSuperCapacitor(this.mName);
    }

    @Override
    public IStructureDefinition<MTELapotronicSuperCapacitor> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    private void processInputHatch(MTEHatch aHatch, int aBaseCasingIndex) {
        this.mMaxEUIn += aHatch.maxEUInput() * aHatch.maxAmperesIn();
        aHatch.updateTexture(aBaseCasingIndex);
    }

    private void processOutputHatch(MTEHatch aHatch, int aBaseCasingIndex) {
        this.mMaxEUOut += aHatch.maxEUOutput() * aHatch.maxAmperesOut();
        aHatch.updateTexture(aBaseCasingIndex);
    }

    private boolean addBottomHatches(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null || aTileEntity.isDead()) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (!(aMetaTileEntity instanceof MTEHatch)) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchMaintenance) {
            MTEHatchMaintenance hatch = (MTEHatchMaintenance)aMetaTileEntity;
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            if (hatch instanceof MTEHatchDroneDownLink) {
                MTEHatchDroneDownLink droneDownLink = (MTEHatchDroneDownLink)hatch;
                droneDownLink.registerMachineController(this);
            }
            return this.mMaintenanceHatches.add(hatch);
        }
        if (aMetaTileEntity instanceof MTEHatchEnergy) {
            MTEHatchEnergy tHatch = (MTEHatchEnergy)aMetaTileEntity;
            this.processInputHatch(tHatch, aBaseCasingIndex);
            return this.mEnergyHatches.add(tHatch);
        }
        if (aMetaTileEntity instanceof MTEHatchEnergyTunnel) {
            MTEHatchEnergyTunnel tHatch = (MTEHatchEnergyTunnel)aMetaTileEntity;
            this.processInputHatch(tHatch, aBaseCasingIndex);
            return this.mEnergyTunnelsTT.add(tHatch);
        }
        if (aMetaTileEntity instanceof MTEHatchEnergyMulti) {
            MTEHatchEnergyMulti tHatch = (MTEHatchEnergyMulti)aMetaTileEntity;
            this.processInputHatch(tHatch, aBaseCasingIndex);
            return this.mEnergyHatchesTT.add(tHatch);
        }
        if (aMetaTileEntity instanceof MTEHatchDynamo) {
            MTEHatchDynamo tDynamo = (MTEHatchDynamo)aMetaTileEntity;
            this.processOutputHatch(tDynamo, aBaseCasingIndex);
            return this.mDynamoHatches.add(tDynamo);
        }
        if (aMetaTileEntity instanceof MTEHatchDynamoTunnel) {
            MTEHatchDynamoTunnel tDynamo = (MTEHatchDynamoTunnel)aMetaTileEntity;
            this.processOutputHatch(tDynamo, aBaseCasingIndex);
            return this.mDynamoTunnelsTT.add(tDynamo);
        }
        if (aMetaTileEntity instanceof MTEHatchDynamoMulti) {
            MTEHatchDynamoMulti tDynamo = (MTEHatchDynamoMulti)aMetaTileEntity;
            this.processOutputHatch(tDynamo, aBaseCasingIndex);
            return this.mDynamoHatchesTT.add(tDynamo);
        }
        return false;
    }

    private int getUHVCapacitorCount() {
        return this.capacitors[4];
    }

    private int getUEVCapacitorCount() {
        return this.capacitors[7];
    }

    private int getUIVCapacitorCount() {
        return this.capacitors[8];
    }

    private int getUMVCapacitorCount() {
        return this.capacitors[9];
    }

    private int wirelessCapableCapacitors() {
        return this.capacitors[4] + this.capacitors[7] + this.capacitors[8] + this.capacitors[9];
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Energy Storage, LSC").addInfo("Loses energy equal to 1% of the total capacity every 24 hours").addInfo("Capped at " + EnumChatFormatting.RED + GTUtility.formatNumbers(1000000L) + EnumChatFormatting.GRAY + " EU/t passive loss per " + GTValues.TIER_COLORS[9] + GTValues.VN[9] + EnumChatFormatting.GRAY + " capacitor").addInfo("The passive loss increases " + EnumChatFormatting.DARK_RED + "100" + EnumChatFormatting.GRAY + "-fold for every capacitor tier above").addInfo("Passive loss is multiplied by the number of maintenance issues present").addSeparator().addInfo("Glass shell has to be Tier - 3 of the highest capacitor tier").addTecTechHatchInfo().addMinGlassForLaser(8).addInfo("Add more or better capacitors to increase capacity").addSeparator().addInfo("Wireless mode can be enabled by right clicking with a screwdriver").addInfo("This mode can only be enabled if you have a " + GTValues.TIER_COLORS[9] + GTValues.VN[9] + EnumChatFormatting.GRAY + "+ capacitor in the multiblock.").addInfo("When enabled every " + EnumChatFormatting.BLUE + GTUtility.formatNumbers(ItemBlockLapotronicEnergyUnit.LSC_time_between_wireless_rebalance_in_ticks) + EnumChatFormatting.GRAY + " ticks the LSC will attempt to re-balance against your").addInfo("wireless EU network.").addInfo("If there is less than " + EnumChatFormatting.RED + GTUtility.formatNumbers(ItemBlockLapotronicEnergyUnit.LSC_wireless_eu_cap) + EnumChatFormatting.GRAY + "(" + GTValues.TIER_COLORS[9] + GTValues.VN[9] + EnumChatFormatting.GRAY + ") EU in the LSC").addInfo("it will withdraw from the network and add to the LSC.").addInfo("If there is more it will add " + EnumChatFormatting.DARK_RED + EnumChatFormatting.BOLD + EnumChatFormatting.UNDERLINE + "all excess" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY + " EU to the network, removing it from the LSC").addInfo("This can potentially brick your base, be careful").addInfo("The threshold increases " + EnumChatFormatting.DARK_RED + "100" + EnumChatFormatting.GRAY + "-fold for every capacitor tier above").beginVariableStructureBlock(5, 5, 4, 50, 5, 5, false).addStructureInfo("Modular height of 4-50 blocks.").addController("Front center bottom").addOtherStructurePart("Lapotronic Super Capacitor Casing", "5x2x5 base (at least 17x)").addOtherStructurePart("Lapotronic Capacitor (" + GTValues.TIER_COLORS[4] + GTValues.VN[4] + EnumChatFormatting.GRAY + "-" + GTValues.TIER_COLORS[8] + GTValues.VN[8] + EnumChatFormatting.GRAY + "), Ultimate Capacitor (" + GTValues.TIER_COLORS[9] + GTValues.VN[9] + EnumChatFormatting.GRAY + "-" + GTValues.TIER_COLORS[12] + GTValues.VN[12] + EnumChatFormatting.GRAY + ")", "Center 3x(1-47)x3 above base (9-423 blocks)").addStructureInfo("You can also use the Empty Capacitor to save materials if you use it for less than half the blocks").addCasingInfoRange("Any Tiered Glass", 41, 777, true).addEnergyHatch("Any casing").addDynamoHatch("Any casing").addOtherStructurePart("Laser Target/Source Hatches", "Any casing, must be using " + GTValues.TIER_COLORS[8] + GTValues.VN[8] + EnumChatFormatting.GRAY + "-tier glass").addStructureInfo("You can have several I/O Hatches").addSubChannelUsage(GTStructureChannels.BOROGLASS).addSubChannelUsage(GTStructureChannels.LSC_CAPACITOR, "Capacitor Tier if specified. Otherwise pick any acceptable capacitor.").addSubChannelUsage(GTStructureChannels.STRUCTURE_HEIGHT).addMaintenanceHatch("Any casing").toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection forgeDirectionacing, int colorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] sTexture = new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS, Dyes.getModulation(-1))};
        if (side == forgeDirectionacing && aActive) {
            sTexture = new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS_YELLOW, Dyes.getModulation(-1))};
        }
        return sTexture;
    }

    @Override
    public boolean supportsPowerPanel() {
        return false;
    }

    @Override
    public void onFirstTick(IGregTechTileEntity tileEntity) {
        super.onFirstTick(tileEntity);
        if (!tileEntity.isServerSide()) {
            return;
        }
        this.global_energy_user_uuid = tileEntity.getOwnerUuid();
        SpaceProjectManager.checkOrCreateTeam(this.global_energy_user_uuid);
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        this.mProgresstime = 1;
        this.mMaxProgresstime = 1;
        this.mEUt = 0;
        this.mEfficiencyIncrease = 10000;
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity thisController, ItemStack guiSlotItem) {
        block8: {
            Arrays.fill(this.capacitors, 0);
            this.mEnergyHatchesTT.clear();
            this.mDynamoHatchesTT.clear();
            this.mEnergyTunnelsTT.clear();
            this.mDynamoTunnelsTT.clear();
            this.mMaxEUIn = 0L;
            this.mMaxEUOut = 0L;
            this.glassTier = -1;
            this.casingAmount = 0;
            if (!this.checkPiece(STRUCTURE_PIECE_BASE, 2, 1, 0)) {
                return false;
            }
            if (this.casingAmount < 17) {
                return false;
            }
            this.topState = TopState.NotTop;
            int layer = 2;
            do {
                if (!this.checkPiece(STRUCTURE_PIECE_LAYER, 2, layer, 0)) {
                    return false;
                }
                ++layer;
                if (this.topState == TopState.Top) break block8;
                this.topState = TopState.MayBeTop;
            } while (layer <= 50);
            return false;
        }
        for (int highestGlassTier = this.capacitors.length - 1; highestGlassTier >= 0; --highestGlassTier) {
            int highestCapacitor = Capacitor.getIndexFromGlassTier(highestGlassTier);
            if (this.capacitors[highestCapacitor] <= 0) continue;
            if (Capacitor.VALUES[highestCapacitor].getMinimalGlassTier() <= this.glassTier) break;
            return false;
        }
        if (!(this.glassTier >= 8 || this.mEnergyTunnelsTT.isEmpty() && this.mDynamoTunnelsTT.isEmpty())) {
            return false;
        }
        if (this.capacitors[5] > this.capacitors[0] + this.capacitors[1] + this.capacitors[2] + this.capacitors[3] + this.getUHVCapacitorCount() + this.capacitors[6] + this.getUEVCapacitorCount() + this.getUIVCapacitorCount() + this.getUMVCapacitorCount()) {
            return false;
        }
        this.capacity = BigInteger.ZERO;
        for (int i = 0; i < this.capacitors.length; ++i) {
            int count = this.capacitors[i];
            this.capacity = this.capacity.add(Capacitor.VALUES[i].getProvidedCapacity().multiply(BigInteger.valueOf(count)));
        }
        this.passiveDischargeAmount = this.recalculateLossWithMaintenance(this.getRepairStatus());
        return this.mMaintenanceHatches.size() == 1;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        int layer = GTStructureChannels.STRUCTURE_HEIGHT.getValueClamped(stackSize, 4, 50);
        this.buildPiece(STRUCTURE_PIECE_BASE, stackSize, hintsOnly, 2, 1, 0);
        for (int i = 2; i < layer - 1; ++i) {
            this.buildPiece(STRUCTURE_PIECE_MID, stackSize, hintsOnly, 2, i, 0);
        }
        this.buildPiece(STRUCTURE_PIECE_TOP, stackSize, hintsOnly, 2, layer - 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int layer = GTStructureChannels.STRUCTURE_HEIGHT.getValueClamped(stackSize, 4, 50);
        int built = this.survivalBuildPiece(STRUCTURE_PIECE_BASE, stackSize, 2, 1, 0, elementBudget, env, false, true);
        if (built >= 0) {
            return built;
        }
        for (int i = 2; i < layer - 1; ++i) {
            built = this.survivalBuildPiece(STRUCTURE_PIECE_MID, stackSize, 2, i, 0, elementBudget, env, false, true);
        }
        if (built >= 0) {
            return built;
        }
        return this.survivalBuildPiece(STRUCTURE_PIECE_TOP, stackSize, 2, layer - 1, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean onRunningTick(ItemStack stack) {
        long power;
        long ttLaserWattage;
        long power2;
        this.inputLastTick = 0L;
        this.outputLastTick = 0L;
        long temp_stored = 0L;
        for (MTEHatchEnergy mTEHatchEnergy : this.mEnergyHatches) {
            if (mTEHatchEnergy == null || !mTEHatchEnergy.isValid()) continue;
            long power22 = this.getPowerToDraw(mTEHatchEnergy.maxEUInput() * mTEHatchEnergy.maxAmperesIn());
            if (mTEHatchEnergy.getEUVar() < power22) continue;
            mTEHatchEnergy.setEUVar(mTEHatchEnergy.getEUVar() - power22);
            temp_stored += power22;
            this.inputLastTick += power22;
        }
        for (MTEHatchDynamo mTEHatchDynamo : this.mDynamoHatches) {
            if (mTEHatchDynamo == null || !mTEHatchDynamo.isValid() || (power2 = this.getPowerToPush(mTEHatchDynamo.maxEUOutput() * mTEHatchDynamo.maxAmperesOut())) > mTEHatchDynamo.maxEUStore() - mTEHatchDynamo.getEUVar()) continue;
            mTEHatchDynamo.setEUVar(mTEHatchDynamo.getEUVar() + power2);
            temp_stored -= power2;
            this.outputLastTick += power2;
        }
        for (MTEHatchEnergyMulti mTEHatchEnergyMulti : this.mEnergyHatchesTT) {
            if (mTEHatchEnergyMulti == null || !mTEHatchEnergyMulti.isValid()) continue;
            power2 = this.getPowerToDraw(mTEHatchEnergyMulti.maxEUInput() * mTEHatchEnergyMulti.maxAmperesIn());
            if (mTEHatchEnergyMulti.getEUVar() < power2) continue;
            mTEHatchEnergyMulti.setEUVar(mTEHatchEnergyMulti.getEUVar() - power2);
            temp_stored += power2;
            this.inputLastTick += power2;
        }
        for (MTEHatchDynamoMulti mTEHatchDynamoMulti : this.mDynamoHatchesTT) {
            if (mTEHatchDynamoMulti == null || !mTEHatchDynamoMulti.isValid() || (power2 = this.getPowerToPush(mTEHatchDynamoMulti.maxEUOutput() * mTEHatchDynamoMulti.maxAmperesOut())) > mTEHatchDynamoMulti.maxEUStore() - mTEHatchDynamoMulti.getEUVar()) continue;
            mTEHatchDynamoMulti.setEUVar(mTEHatchDynamoMulti.getEUVar() + power2);
            temp_stored -= power2;
            this.outputLastTick += power2;
        }
        for (MTEHatchEnergyTunnel mTEHatchEnergyTunnel : this.mEnergyTunnelsTT) {
            if (mTEHatchEnergyTunnel == null || !mTEHatchEnergyTunnel.isValid()) continue;
            ttLaserWattage = mTEHatchEnergyTunnel.maxEUInput() * (long)mTEHatchEnergyTunnel.Amperes - (long)(mTEHatchEnergyTunnel.Amperes / 20);
            power = this.getPowerToDraw(ttLaserWattage);
            if (mTEHatchEnergyTunnel.getEUVar() < power) continue;
            mTEHatchEnergyTunnel.setEUVar(mTEHatchEnergyTunnel.getEUVar() - power);
            temp_stored += power;
            this.inputLastTick += power;
        }
        for (MTEHatchDynamoTunnel mTEHatchDynamoTunnel : this.mDynamoTunnelsTT) {
            if (mTEHatchDynamoTunnel == null || !mTEHatchDynamoTunnel.isValid() || (power = this.getPowerToPush(ttLaserWattage = mTEHatchDynamoTunnel.maxEUOutput() * (long)mTEHatchDynamoTunnel.Amperes - (long)(mTEHatchDynamoTunnel.Amperes / 20))) > mTEHatchDynamoTunnel.maxEUStore() - mTEHatchDynamoTunnel.getEUVar()) continue;
            mTEHatchDynamoTunnel.setEUVar(mTEHatchDynamoTunnel.getEUVar() + power);
            temp_stored -= power;
            this.outputLastTick += power;
        }
        if (this.wirelessCapableCapacitors() <= 0) {
            this.wireless_mode = false;
        }
        ++this.counter;
        if (this.wireless_mode && (long)this.counter >= ItemBlockLapotronicEnergyUnit.LSC_time_between_wireless_rebalance_in_ticks) {
            this.counter = this.rebalance();
        }
        if (super.getRepairStatus() != this.repairStatusCache) {
            this.passiveDischargeAmount = this.recalculateLossWithMaintenance(super.getRepairStatus());
        }
        this.stored = this.stored.add(BigInteger.valueOf(temp_stored -= this.passiveDischargeAmount));
        this.stored = this.stored.compareTo(BigInteger.ZERO) <= 0 ? BigInteger.ZERO : this.stored;
        IGregTechTileEntity tBMTE = this.getBaseMetaTileEntity();
        tBMTE.injectEnergyUnits(ForgeDirection.UNKNOWN, this.inputLastTick, 1L);
        tBMTE.drainEnergyUnits(ForgeDirection.UNKNOWN, this.outputLastTick, 1L);
        this.energyInputValues1h.update(this.inputLastTick);
        this.energyOutputValues1h.update(this.outputLastTick);
        return true;
    }

    private int rebalance() {
        this.balanced = true;
        BigInteger transferred_eu = this.stored.subtract(ItemBlockLapotronicEnergyUnit.LSC_wireless_eu_cap.multiply(BigInteger.valueOf(this.getUHVCapacitorCount())).add(ItemBlockLapotronicEnergyUnit.UEV_wireless_eu_cap.multiply(BigInteger.valueOf(this.getUEVCapacitorCount()))).add(ItemBlockLapotronicEnergyUnit.UIV_wireless_eu_cap.multiply(BigInteger.valueOf(this.getUIVCapacitorCount()))).add(ItemBlockLapotronicEnergyUnit.UMV_wireless_eu_cap.multiply(BigInteger.valueOf(this.getUMVCapacitorCount()))));
        if (transferred_eu.signum() == -1) {
            this.inputLastTick += Math.abs(transferred_eu.longValue());
        } else {
            this.outputLastTick += transferred_eu.longValue();
        }
        if (WirelessNetworkManager.addEUToGlobalEnergyMap(this.global_energy_user_uuid, transferred_eu)) {
            this.stored = ItemBlockLapotronicEnergyUnit.LSC_wireless_eu_cap.multiply(BigInteger.valueOf(this.getUHVCapacitorCount())).add(ItemBlockLapotronicEnergyUnit.UEV_wireless_eu_cap.multiply(BigInteger.valueOf(this.getUEVCapacitorCount())).add(ItemBlockLapotronicEnergyUnit.UIV_wireless_eu_cap.multiply(BigInteger.valueOf(this.getUIVCapacitorCount()))).add(ItemBlockLapotronicEnergyUnit.UMV_wireless_eu_cap.multiply(BigInteger.valueOf(this.getUMVCapacitorCount()))));
        }
        return 1;
    }

    private long recalculateLossWithMaintenance(int repairStatus) {
        this.repairStatusCache = repairStatus;
        long temp_capacity_divided = 0L;
        if (this.wirelessCapableCapacitors() == 0) {
            temp_capacity_divided = this.capacity.divide(BigInteger.valueOf(172800000L)).longValue();
        }
        if (this.wirelessCapableCapacitors() != 0) {
            temp_capacity_divided = (long)this.getUHVCapacitorCount() * 1000000L + (long)this.getUEVCapacitorCount() * 100000000L + (long)this.getUIVCapacitorCount() * this.max_passive_drain_eu_per_tick_per_uiv_cap + (long)this.getUMVCapacitorCount() * this.max_passive_drain_eu_per_tick_per_umv_cap;
        }
        return temp_capacity_divided * (long)(this.getIdealStatus() - repairStatus + 1);
    }

    private long getPowerToDraw(long hatchWatts) {
        if (this.stored.compareTo(this.capacity) >= 0) {
            return 0L;
        }
        BigInteger remcapActual = this.capacity.subtract(this.stored);
        BigInteger recampLimited = MAX_LONG.compareTo(remcapActual) > 0 ? remcapActual : MAX_LONG;
        return Math.min(hatchWatts, recampLimited.longValue());
    }

    private long getPowerToPush(long hatchWatts) {
        BigInteger remStoredLimited = MAX_LONG.compareTo(this.stored) > 0 ? this.stored : MAX_LONG;
        return Math.min(hatchWatts, remStoredLimited.longValue());
    }

    private String getTimeTo() {
        double avgIn = this.energyInputValues.avgLong();
        double avgOut = this.energyOutputValues.avgLong();
        double passLoss = this.passiveDischargeAmount;
        double cap = this.capacity.doubleValue();
        double sto = this.stored.doubleValue();
        if (avgIn >= avgOut + passLoss) {
            if (avgIn - passLoss > 0.0) {
                double timeToFull = (cap - sto) / (avgIn - (passLoss + avgOut)) / 20.0;
                return StatCollector.func_74837_a((String)"kekztech.infodata.lapotronic_super_capacitor.time_to.full", (Object[])new Object[]{this.formatTime(timeToFull, true)});
            }
            return StatCollector.func_74838_a((String)"kekztech.infodata.lapotronic_super_capacitor.time_to.sth");
        }
        double timeToEmpty = sto / (avgOut + passLoss - avgIn) / 20.0;
        return StatCollector.func_74837_a((String)"kekztech.infodata.lapotronic_super_capacitor.time_to.empty", (Object[])new Object[]{this.formatTime(timeToEmpty, false)});
    }

    private String getCapacityCache() {
        return this.capacity.compareTo(this.guiCapacityStoredReformatLimit) > 0 ? GTUtility.scientificFormat(this.capacity) : this.numberFormat.format((Object)this.capacity);
    }

    private String getStoredCache() {
        return this.stored.compareTo(this.guiCapacityStoredReformatLimit) > 0 ? GTUtility.scientificFormat(this.stored) : this.numberFormat.format((Object)this.stored);
    }

    private String getUsedPercentCache() {
        return Util.toPercentageFrom(this.stored, this.capacity);
    }

    private String getWirelessStoredCache() {
        return GTUtility.scientificFormat(WirelessNetworkManager.getUserEU(this.global_energy_user_uuid));
    }

    private boolean isActiveCache() {
        return this.getBaseMetaTileEntity().isActive();
    }

    private String getPassiveDischargeAmountCache() {
        return this.passiveDischargeAmount > 100000000000L ? GTUtility.scientificFormat(this.passiveDischargeAmount) : this.numberFormat.format(this.passiveDischargeAmount);
    }

    @Override
    public String[] getInfoData() {
        NumberFormat nf = NumberFormat.getNumberInstance();
        int secInterval = 5;
        ArrayList<String> ll = new ArrayList<String>();
        ll.add(EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"kekztech.infodata.operational_data") + EnumChatFormatting.RESET);
        ll.add(StatCollector.func_74837_a((String)"kekztech.infodata.lapotronic_super_capacitor.eu_stored", (Object[])new Object[]{nf.format(this.stored)}));
        ll.add(StatCollector.func_74837_a((String)"kekztech.infodata.lapotronic_super_capacitor.eu_stored", (Object[])new Object[]{Util.toStandardForm(this.stored)}));
        ll.add(StatCollector.func_74837_a((String)"kekztech.infodata.lapotronic_super_capacitor.used_capacity", (Object[])new Object[]{Util.toPercentageFrom(this.stored, this.capacity)}));
        ll.add(StatCollector.func_74837_a((String)"kekztech.infodata.lapotronic_super_capacitor.total_capacity", (Object[])new Object[]{nf.format(this.capacity)}));
        ll.add(StatCollector.func_74837_a((String)"kekztech.infodata.lapotronic_super_capacitor.total_capacity", (Object[])new Object[]{Util.toStandardForm(this.capacity)}));
        ll.add(StatCollector.func_74837_a((String)"kekztech.infodata.lapotronic_super_capacitor.passive_loss", (Object[])new Object[]{nf.format(this.passiveDischargeAmount)}));
        ll.add(StatCollector.func_74837_a((String)"kekztech.infodata.lapotronic_super_capacitor.eu_in", (Object[])new Object[]{GTUtility.formatNumbers(this.inputLastTick)}));
        ll.add(StatCollector.func_74837_a((String)"kekztech.infodata.lapotronic_super_capacitor.eu_out", (Object[])new Object[]{GTUtility.formatNumbers(this.outputLastTick)}));
        ll.add(StatCollector.func_74837_a((String)"kekztech.infodata.lapotronic_super_capacitor.avg_eu_in.sec", (Object[])new Object[]{nf.format(this.energyInputValues.avgLong()), secInterval}));
        ll.add(StatCollector.func_74837_a((String)"kekztech.infodata.lapotronic_super_capacitor.avg_eu_out.sec", (Object[])new Object[]{nf.format(this.energyOutputValues.avgLong()), secInterval}));
        ll.add(StatCollector.func_74837_a((String)"kekztech.infodata.lapotronic_super_capacitor.avg_eu_in.min5", (Object[])new Object[]{nf.format(this.energyInputValues5m.avgLong())}));
        ll.add(StatCollector.func_74837_a((String)"kekztech.infodata.lapotronic_super_capacitor.avg_eu_out.min5", (Object[])new Object[]{nf.format(this.energyOutputValues5m.avgLong())}));
        ll.add(StatCollector.func_74837_a((String)"kekztech.infodata.lapotronic_super_capacitor.avg_eu_in.hour1", (Object[])new Object[]{nf.format(this.energyInputValues1h.avgLong())}));
        ll.add(StatCollector.func_74837_a((String)"kekztech.infodata.lapotronic_super_capacitor.avg_eu_out.hour1", (Object[])new Object[]{nf.format(this.energyOutputValues1h.avgLong())}));
        ll.add(this.getTimeTo());
        ll.add(StatCollector.func_74837_a((String)"kekztech.infodata.multi.maintenance_status", (Object[])new Object[]{super.getRepairStatus() == super.getIdealStatus() ? EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"kekztech.infodata.multi.maintenance_status.ok") + EnumChatFormatting.RESET : EnumChatFormatting.RED + StatCollector.func_74838_a((String)"kekztech.infodata.multi.maintenance_status.bad") + EnumChatFormatting.RESET}));
        ll.add(StatCollector.func_74837_a((String)"kekztech.infodata.lapotronic_super_capacitor.wireless_mode", (Object[])new Object[]{this.wireless_mode ? EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"kekztech.infodata.lapotronic_super_capacitor.wireless_mode.enabled") + EnumChatFormatting.RESET : EnumChatFormatting.RED + StatCollector.func_74838_a((String)"kekztech.infodata.lapotronic_super_capacitor.wireless_mode.disabled") + EnumChatFormatting.RESET}));
        ll.add(StatCollector.func_74837_a((String)"kekztech.infodata.lapotronic_super_capacitor.capacitors", (Object[])new Object[]{GTValues.TIER_COLORS[9] + GTValues.VN[9] + EnumChatFormatting.RESET, this.getUHVCapacitorCount()}));
        ll.add(StatCollector.func_74837_a((String)"kekztech.infodata.lapotronic_super_capacitor.capacitors", (Object[])new Object[]{GTValues.TIER_COLORS[10] + GTValues.VN[10] + EnumChatFormatting.RESET, this.getUEVCapacitorCount()}));
        ll.add(StatCollector.func_74837_a((String)"kekztech.infodata.lapotronic_super_capacitor.capacitors", (Object[])new Object[]{GTValues.TIER_COLORS[11] + GTValues.VN[11] + EnumChatFormatting.RESET, this.getUIVCapacitorCount()}));
        ll.add(StatCollector.func_74837_a((String)"kekztech.infodata.lapotronic_super_capacitor.capacitors", (Object[])new Object[]{GTValues.TIER_COLORS[12] + GTValues.VN[12] + EnumChatFormatting.RESET, this.getUMVCapacitorCount()}));
        ll.add(StatCollector.func_74837_a((String)"kekztech.infodata.lapotronic_super_capacitor.wireless_eu", (Object[])new Object[]{EnumChatFormatting.RED + nf.format(WirelessNetworkManager.getUserEU(this.global_energy_user_uuid))}));
        ll.add(StatCollector.func_74837_a((String)"kekztech.infodata.lapotronic_super_capacitor.wireless_eu", (Object[])new Object[]{EnumChatFormatting.RED + Util.toStandardForm(WirelessNetworkManager.getUserEU(this.global_energy_user_uuid))}));
        String[] a = new String[ll.size()];
        return ll.toArray(a);
    }

    @Override
    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        screenElements.setSynced(false).setSpace(0);
        ((Column)screenElements.widget(new TextWidget(GTUtility.trans("132", "Pipe is loose. (Wrench)")).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mWrench))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mWrench, val -> {
            this.mWrench = val;
        }));
        ((Column)screenElements.widget(new TextWidget(GTUtility.trans("133", "Screws are loose. (Screwdriver)")).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mScrewdriver))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mScrewdriver, val -> {
            this.mScrewdriver = val;
        }));
        ((Column)screenElements.widget(new TextWidget(GTUtility.trans("134", "Something is stuck. (Soft Mallet)")).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mSoftMallet))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mSoftMallet, val -> {
            this.mSoftMallet = val;
        }));
        ((Column)screenElements.widget(new TextWidget(GTUtility.trans("135", "Platings are dented. (Hammer)")).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mHardHammer))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mHardHammer, val -> {
            this.mHardHammer = val;
        }));
        ((Column)screenElements.widget(new TextWidget(GTUtility.trans("136", "Circuitry burned out. (Soldering)")).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mSolderingTool))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mSolderingTool, val -> {
            this.mSolderingTool = val;
        }));
        ((Column)screenElements.widget(new TextWidget(GTUtility.trans("137", "That doesn't belong there. (Crowbar)")).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mCrowbar))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mCrowbar, val -> {
            this.mCrowbar = val;
        }));
        ((Column)screenElements.widget(new TextWidget(StatCollector.func_74838_a((String)"gt.interact.desc.mb.incomplete")).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mMachine))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mMachine, val -> {
            this.mMachine = val;
        }));
        ((Column)((Column)screenElements.widget(new TextWidget(StatCollector.func_74838_a((String)"gt.interact.desc.mb.idle.1")).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getErrorDisplayID() == 0 && !this.getBaseMetaTileEntity().isActive()))).widget((Widget)new FakeSyncWidget.IntegerSyncer(this::getErrorDisplayID, this::setErrorDisplayID))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.getBaseMetaTileEntity().isActive(), val -> this.getBaseMetaTileEntity().setActive((boolean)val)));
        screenElements.widget(new TextWidget(StatCollector.func_74838_a((String)"gt.interact.desc.mb.idle.2")).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getErrorDisplayID() == 0 && !this.getBaseMetaTileEntity().isActive()));
        screenElements.widget(new TextWidget(StatCollector.func_74838_a((String)"gt.interact.desc.mb.idle.3")).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getErrorDisplayID() == 0 && !this.getBaseMetaTileEntity().isActive()));
        ((Column)((Column)screenElements.widget(TextWidget.dynamicString(() -> {
            Duration time = Duration.ofSeconds((this.mTotalRunTime - this.mLastWorkingTick) / 20L);
            return StatCollector.func_74837_a((String)"GT5U.gui.text.shutdown_duration", (Object[])new Object[]{time.toHours(), time.toMinutes() % 60L, time.getSeconds() % 60L});
        }).setSynced(false).setTextAlignment(Alignment.CenterLeft).setEnabled(widget -> this.shouldDisplayShutDownReason() && !this.getBaseMetaTileEntity().isActive() && this.getBaseMetaTileEntity().wasShutdown()))).widget((Widget)new FakeSyncWidget.LongSyncer(() -> this.mTotalRunTime, time -> {
            this.mTotalRunTime = time;
        }))).widget((Widget)new FakeSyncWidget.LongSyncer(() -> this.mLastWorkingTick, time -> {
            this.mLastWorkingTick = time;
        }));
        ((Column)((Column)screenElements.widget(TextWidget.dynamicString(() -> this.getBaseMetaTileEntity().getLastShutDownReason().getDisplayString()).setSynced(false).setTextAlignment(Alignment.CenterLeft).setEnabled(widget -> this.shouldDisplayShutDownReason() && !this.getBaseMetaTileEntity().isActive() && GTUtility.isStringValid(this.getBaseMetaTileEntity().getLastShutDownReason().getDisplayString()) && this.getBaseMetaTileEntity().wasShutdown()))).widget((Widget)new ShutDownReasonSyncer(() -> this.getBaseMetaTileEntity().getLastShutDownReason(), reason -> this.getBaseMetaTileEntity().setShutDownReason((ShutDownReason)reason)))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.getBaseMetaTileEntity().wasShutdown(), wasShutDown -> this.getBaseMetaTileEntity().setShutdownStatus((boolean)wasShutDown)));
        ((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)screenElements.widget(new TextWidget().setStringSupplier(() -> StatCollector.func_74837_a((String)"kekztech.infodata.lapotronic_super_capacitor.total_capacity", (Object[])new Object[]{EnumChatFormatting.BLUE + this.capacityCache + EnumChatFormatting.WHITE})).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.isActiveCache))).widget((Widget)new FakeSyncWidget.StringSyncer(this::getCapacityCache, val -> {
            this.capacityCache = val;
        }))).widget(new TextWidget().setStringSupplier(() -> StatCollector.func_74837_a((String)"kekztech.gui.lapotronic_super_capacitor.text.stored", (Object[])new Object[]{EnumChatFormatting.RED + this.storedEUCache + EnumChatFormatting.WHITE})).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.isActiveCache))).widget((Widget)new FakeSyncWidget.StringSyncer(this::getStoredCache, val -> {
            this.storedEUCache = val;
        }))).widget(new TextWidget().setStringSupplier(() -> StatCollector.func_74837_a((String)"kekztech.infodata.lapotronic_super_capacitor.used_capacity", (Object[])new Object[]{EnumChatFormatting.RED + this.usedPercentCache})).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.isActiveCache))).widget((Widget)new FakeSyncWidget.StringSyncer(this::getUsedPercentCache, val -> {
            this.usedPercentCache = val;
        }))).widget(new TextWidget().setStringSupplier(() -> StatCollector.func_74837_a((String)"kekztech.infodata.lapotronic_super_capacitor.passive_loss", (Object[])new Object[]{EnumChatFormatting.RED + this.passiveDischargeAmountCache + EnumChatFormatting.WHITE})).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.isActiveCache))).widget((Widget)new FakeSyncWidget.StringSyncer(this::getPassiveDischargeAmountCache, val -> {
            this.passiveDischargeAmountCache = val;
        }))).widget(new TextWidget().setStringSupplier(() -> StatCollector.func_74837_a((String)"kekztech.gui.lapotronic_super_capacitor.text.avg_eu_in", (Object[])new Object[]{EnumChatFormatting.GREEN + (this.avgInCache > 100000000000L ? GTUtility.scientificFormat(this.avgInCache) : this.numberFormat.format(this.avgInCache)) + EnumChatFormatting.WHITE})).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.isActiveCache))).widget((Widget)new FakeSyncWidget.LongSyncer(this.energyInputValues::avgLong, val -> {
            this.avgInCache = val;
        }))).widget(new TextWidget().setStringSupplier(() -> StatCollector.func_74837_a((String)"kekztech.gui.lapotronic_super_capacitor.text.avg_eu_out", (Object[])new Object[]{EnumChatFormatting.RED + (this.avgOutCache > 100000000000L ? GTUtility.scientificFormat(this.avgOutCache) : this.numberFormat.format(this.avgOutCache)) + EnumChatFormatting.WHITE})).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.isActiveCache))).widget((Widget)new FakeSyncWidget.LongSyncer(this.energyOutputValues::avgLong, val -> {
            this.avgOutCache = val;
        }))).widget(new TextWidget().setStringSupplier(() -> EnumChatFormatting.WHITE + this.timeToCache).setTextAlignment(Alignment.CenterLeft).setEnabled(widget -> this.isActiveCache))).widget((Widget)new FakeSyncWidget.StringSyncer(this::getTimeTo, val -> {
            this.timeToCache = val;
        }))).widget(new TextWidget().setStringSupplier(() -> StatCollector.func_74837_a((String)"kekztech.infodata.lapotronic_super_capacitor.wireless_eu", (Object[])new Object[]{EnumChatFormatting.BLUE + this.wirelessStoreCache + EnumChatFormatting.WHITE})).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.isActiveCache))).widget((Widget)new FakeSyncWidget.StringSyncer(this::getWirelessStoredCache, val -> {
            this.wirelessStoreCache = val;
        }))).widget((Widget)new FakeSyncWidget.BooleanSyncer(this::isActiveCache, val -> {
            this.isActiveCache = val;
        }));
    }

    private String formatTime(double time, boolean fill) {
        if (time < 1.0) {
            return "Completely " + (fill ? "full" : "empty");
        }
        if (time < 60.0) {
            return String.format("%.2f seconds", time);
        }
        if (time < 3600.0) {
            return String.format("%.2f minutes", time / 60.0);
        }
        if (time < 86400.0) {
            return String.format("%.2f hours", time / 3600.0);
        }
        if (time < 3.1536E7) {
            return String.format("%.2f days", time / 86400.0);
        }
        double y = time / 3.1536E7;
        return y < 9000.0 ? String.format("%.2f years", y) : "Over9000 years";
    }

    @Override
    public void saveNBTData(NBTTagCompound nbt) {
        nbt = nbt == null ? new NBTTagCompound() : nbt;
        nbt.func_74773_a("capacity", this.capacity.toByteArray());
        nbt.func_74773_a("stored", this.stored.toByteArray());
        nbt.func_74757_a("wireless_mode", this.wireless_mode);
        nbt.func_74768_a("wireless_mode_cooldown", this.counter);
        nbt.func_74757_a("warningReceived", this.warningReceived);
        super.saveNBTData(nbt);
    }

    @Override
    public void loadNBTData(NBTTagCompound nbt) {
        nbt = nbt == null ? new NBTTagCompound() : nbt;
        this.capacity = new BigInteger(nbt.func_74770_j("capacity"));
        this.stored = new BigInteger(nbt.func_74770_j("stored"));
        this.wireless_mode = nbt.func_74767_n("wireless_mode");
        this.counter = nbt.func_74762_e("wireless_mode_cooldown");
        this.warningReceived = nbt.func_74767_n("warningReceived");
        super.loadNBTData(nbt);
    }

    @Override
    public long maxEUStore() {
        return this.capacity.compareTo(LONG_MAX) > 0 ? Long.MAX_VALUE : this.capacity.longValue();
    }

    @Override
    public long getEUVar() {
        return this.stored.longValue();
    }

    @Override
    public long maxEUInput() {
        if (this.wireless_mode) {
            return Long.MAX_VALUE;
        }
        return this.mMaxEUIn;
    }

    @Override
    public long maxAmperesIn() {
        return 1L;
    }

    @Override
    public long maxEUOutput() {
        if (this.wireless_mode) {
            return Long.MAX_VALUE;
        }
        return this.mMaxEUOut;
    }

    @Override
    public long maxAmperesOut() {
        return 1L;
    }

    @Override
    public boolean isEnetInput() {
        return true;
    }

    @Override
    public boolean isEnetOutput() {
        return true;
    }

    protected boolean canUseWireless() {
        return this.wirelessCapableCapacitors() != 0;
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (this.canUseWireless()) {
            this.wireless_mode = !this.wireless_mode;
            GTUtility.sendChatToPlayer(aPlayer, "Wireless network mode " + (this.wireless_mode ? "enabled." : "disabled."));
        } else {
            GTUtility.sendChatToPlayer(aPlayer, "Wireless mode cannot be enabled without at least 1 " + GTValues.TIER_COLORS[9] + GTValues.VN[9] + EnumChatFormatting.RESET + "+ capacitor.");
            this.wireless_mode = false;
        }
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        buildContext.addSyncedWindow(10, this::createPowerWindow);
        buildContext.addSyncedWindow(11, this::createWarningWindow);
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!widget.isClient()) {
                this.canUseWireless = this.canUseWireless();
            }
            if (this.canUseWireless) {
                if (!this.warningReceived) {
                    this.warningReceived = true;
                    widget.getContext().openSyncedWindow(11);
                } else {
                    this.wireless_mode = !this.wireless_mode;
                }
            }
        }).setPlayClickSound(true).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            ret.add(GTUITextures.BUTTON_STANDARD);
            if (this.canUseWireless) {
                if (this.wireless_mode) {
                    ret.add(KTUITextures.OVERLAY_BUTTON_WIRELESS_ON);
                } else {
                    ret.add(KTUITextures.OVERLAY_BUTTON_WIRELESS_OFF);
                }
            } else {
                ret.add(KTUITextures.OVERLAY_BUTTON_WIRELESS_OFF_DISABLED);
            }
            return ret.toArray(new IDrawable[0]);
        }).setPos(80, 91).setSize(16, 16).addTooltip(StatCollector.func_74838_a((String)"gui.kekztech_lapotronicenergyunit.wireless")).setTooltipShowUpDelay(5))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.wireless_mode, val -> {
            this.wireless_mode = val;
        }))).widget((Widget)new FakeSyncWidget.BooleanSyncer(this::canUseWireless, val -> {
            this.canUseWireless = val;
        }))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.warningReceived, val -> {
            this.warningReceived = val;
        }))).widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (this.mMachine && this.wireless_mode && this.canUseWireless && !this.balanced) {
                this.counter = this.rebalance();
            }
        }).setPlayClickSound(true).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            ret.add(GTUITextures.BUTTON_STANDARD);
            ret.add(KTUITextures.OVERLAY_BUTTON_WIRELESS_REBALANCE);
            return ret.toArray(new IDrawable[0]);
        }).setPos(98, 91).setSize(16, 16).setEnabled(widget -> this.wireless_mode && this.canUseWireless && !this.balanced).addTooltip(StatCollector.func_74838_a((String)"gui.kekztech_lapotronicenergyunit.wireless_rebalance")).setTooltipShowUpDelay(5));
        builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!widget.isClient()) {
                widget.getContext().openSyncedWindow(10);
            }
        }).setPlayClickSound(true).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            ret.add(GTUITextures.BUTTON_STANDARD);
            ret.add(GTUITextures.OVERLAY_BUTTON_EMIT_ENERGY);
            return ret.toArray(new IDrawable[0]);
        }).addTooltip(StatCollector.func_74838_a((String)"GT5U.multiblock.energy")).setTooltipShowUpDelay(5).setEnabled($ -> buildContext.getPlayer().field_71075_bZ.field_75098_d).setPos(174, 112).setSize(16, 16));
    }

    protected ModularWindow createPowerWindow(EntityPlayer player) {
        int WIDTH = 158;
        int HEIGHT = 52;
        int PARENT_WIDTH = this.getGUIWidth();
        int PARENT_HEIGHT = this.getGUIHeight();
        ModularWindow.Builder builder = ModularWindow.builder((int)158, (int)52);
        builder.setBackground(new IDrawable[]{GTUITextures.BACKGROUND_SINGLEBLOCK_DEFAULT});
        builder.setGuiTint(this.getGUIColorization());
        builder.setDraggable(true);
        builder.setPos((size, window) -> Alignment.Center.getAlignedPos(size, new Size(PARENT_WIDTH, PARENT_HEIGHT)).add(Alignment.BottomRight.getAlignedPos(new Size(PARENT_WIDTH, PARENT_HEIGHT), new Size(158, 52)).add(155, 0).subtract(0, 10)));
        ((ModularWindow.Builder)builder.widget(TextWidget.localised((String)"GT5U.multiblock.energy", (Object[])new Object[0]).setPos(3, 4).setSize(150, 20))).widget(new NumericWidget().setSetter(val -> {
            this.stored = BigDecimal.valueOf(val).toBigInteger();
        }).setGetter(() -> this.stored.doubleValue()).setIntegerOnly(false).setBounds(0.0, this.capacity.doubleValue()).setDefaultValue(this.stored.doubleValue()).setTextAlignment(Alignment.Center).setTextColor(Color.WHITE.normal).setSize(150, 18).setPos(4, 25).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD}).attachSyncer((FakeSyncWidget)new FakeSyncWidget.DoubleSyncer(() -> this.capacity.doubleValue(), val -> {
            this.capacity = BigDecimal.valueOf(val).toBigInteger();
        }), (IWidgetBuilder)builder).attachSyncer((FakeSyncWidget)new FakeSyncWidget.DoubleSyncer(() -> this.stored.doubleValue(), val -> {
            this.stored = BigDecimal.valueOf(val).toBigInteger();
        }), (IWidgetBuilder)builder));
        return builder.build();
    }

    protected ModularWindow createWarningWindow(EntityPlayer player) {
        int WIDTH = 180;
        int HEIGHT = 75;
        ModularWindow.Builder builder = ModularWindow.builder((int)180, (int)75);
        builder.setBackground(new IDrawable[]{GTUITextures.BACKGROUND_SINGLEBLOCK_DEFAULT});
        builder.setGuiTint(this.getGUIColorization());
        builder.setDraggable(true);
        ((ModularWindow.Builder)builder.widget(new TextWidget(EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"gui.kekztech_lapotronicenergyunit.warning.header")).setDefaultColor(0xFF0000).setScale(1.2f).setTextAlignment(Alignment.Center).setPos(0, 7).setSize(180, 15))).widget(TextWidget.localised((String)"gui.kekztech_lapotronicenergyunit.warning.text", (Object[])new Object[0]).setTextAlignment(Alignment.CenterLeft).setPos(5, 20).setSize(170, 50));
        builder.widget(ButtonWidget.closeWindowButton((boolean)true).setPos(164, 4));
        return builder.build();
    }

    private static enum TopState {
        MayBeTop,
        Top,
        NotTop;

    }

    public static enum Capacitor {
        IV(2, BigInteger.valueOf(ItemBlockLapotronicEnergyUnit.IV_cap_storage)),
        LuV(3, BigInteger.valueOf(ItemBlockLapotronicEnergyUnit.LuV_cap_storage)),
        ZPM(4, BigInteger.valueOf(ItemBlockLapotronicEnergyUnit.ZPM_cap_storage)),
        UV(5, BigInteger.valueOf(ItemBlockLapotronicEnergyUnit.UV_cap_storage)),
        UHV(6, BigInteger.valueOf(ItemBlockLapotronicEnergyUnit.UHV_cap_storage)),
        None(0, BigInteger.ZERO),
        EV(1, BigInteger.valueOf(ItemBlockLapotronicEnergyUnit.EV_cap_storage)),
        UEV(7, BigInteger.valueOf(ItemBlockLapotronicEnergyUnit.UEV_cap_storage)),
        UIV(8, BigInteger.valueOf(ItemBlockLapotronicEnergyUnit.UIV_cap_storage)),
        UMV(9, ItemBlockLapotronicEnergyUnit.UMV_cap_storage);

        private final int minimalGlassTier;
        private final BigInteger providedCapacity;
        public static final Capacitor[] VALUES;
        public static final Capacitor[] VALUES_BY_TIER;

        private Capacitor(int minimalGlassTier, BigInteger providedCapacity) {
            this.minimalGlassTier = minimalGlassTier;
            this.providedCapacity = providedCapacity;
        }

        public int getMinimalGlassTier() {
            return this.minimalGlassTier;
        }

        public BigInteger getProvidedCapacity() {
            return this.providedCapacity;
        }

        public static int getIndexFromGlassTier(int glassTier) {
            for (int index = 0; index < VALUES.length; ++index) {
                if (VALUES[index].getMinimalGlassTier() != glassTier) continue;
                return index;
            }
            return -1;
        }

        static {
            VALUES = Capacitor.values();
            VALUES_BY_TIER = (Capacitor[])Arrays.stream(Capacitor.values()).sorted(Comparator.comparingInt(Capacitor::getMinimalGlassTier)).toArray(Capacitor[]::new);
        }
    }

    private static enum LSCHatchElement implements IHatchElement<MTELapotronicSuperCapacitor>
    {
        Energy(new Class[]{MTEHatchEnergyMulti.class, MTEHatchEnergy.class}){

            @Override
            public long count(MTELapotronicSuperCapacitor t) {
                return t.mEnergyHatches.size() + t.mEnergyHatchesTT.size() + t.mEnergyTunnelsTT.size();
            }
        }
        ,
        Dynamo(new Class[]{MTEHatchDynamoMulti.class, MTEHatchDynamo.class}){

            @Override
            public long count(MTELapotronicSuperCapacitor t) {
                return t.mDynamoHatches.size() + t.mDynamoHatchesTT.size() + t.mDynamoTunnelsTT.size();
            }
        };

        private final List<? extends Class<? extends IMetaTileEntity>> mteClasses;

        @SafeVarargs
        private LSCHatchElement(Class<? extends IMetaTileEntity> ... mteClasses) {
            this.mteClasses = Arrays.asList(mteClasses);
        }

        @Override
        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return this.mteClasses;
        }

        @Override
        public IGTHatchAdder<? super MTELapotronicSuperCapacitor> adder() {
            return (rec$, x$0, x$1) -> ((MTELapotronicSuperCapacitor)rec$).addBottomHatches(x$0, x$1);
        }
    }

    private static enum CellElement implements IStructureElement<MTELapotronicSuperCapacitor>
    {
        INSTANCE;


        public boolean check(MTELapotronicSuperCapacitor t, World world, int x, int y, int z) {
            Block worldBlock = world.func_147439_a(x, y, z);
            int meta = worldBlock.func_149643_k(world, x, y, z);
            if (LSC_PART != worldBlock || meta == 0) {
                return false;
            }
            int[] nArray = t.capacitors;
            int n = meta - 1;
            nArray[n] = nArray[n] + 1;
            return true;
        }

        public boolean couldBeValid(MTELapotronicSuperCapacitor mteLapotronicSuperCapacitor, World world, int x, int y, int z, ItemStack trigger) {
            Block worldBlock = world.func_147439_a(x, y, z);
            int meta = worldBlock.func_149643_k(world, x, y, z);
            return LSC_PART == worldBlock && meta != 0;
        }

        private int getHint(ItemStack stack) {
            int n;
            switch (Capacitor.VALUES_BY_TIER[GTStructureChannels.LSC_CAPACITOR.getValueClamped(stack, 1, Capacitor.VALUES_BY_TIER.length) - 1].getMinimalGlassTier() + 1) {
                case 2: {
                    n = 7;
                    break;
                }
                case 3: {
                    n = 1;
                    break;
                }
                case 4: {
                    n = 2;
                    break;
                }
                case 5: {
                    n = 3;
                    break;
                }
                case 6: {
                    n = 4;
                    break;
                }
                case 7: {
                    n = 5;
                    break;
                }
                case 8: {
                    n = 8;
                    break;
                }
                case 9: {
                    n = 9;
                    break;
                }
                case 10: {
                    n = 10;
                    break;
                }
                default: {
                    n = 6;
                }
            }
            return n;
        }

        public boolean spawnHint(MTELapotronicSuperCapacitor t, World world, int x, int y, int z, ItemStack trigger) {
            StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)LSC_PART, (int)this.getHint(trigger));
            return true;
        }

        public IStructureElement.BlocksToPlace getBlocksToPlace(MTELapotronicSuperCapacitor mteLapotronicSuperCapacitor, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
            return IStructureElement.BlocksToPlace.create((ItemStack)new ItemStack(LSC_PART_ITEM, 1, GTStructureChannels.LSC_CAPACITOR.getValueClamped(trigger, 1, Capacitor.VALUES_BY_TIER.length)));
        }

        public boolean placeBlock(MTELapotronicSuperCapacitor t, World world, int x, int y, int z, ItemStack trigger) {
            world.func_147465_d(x, y, z, LSC_PART, this.getHint(trigger), 3);
            return true;
        }

        public IStructureElement.PlaceResult survivalPlaceBlock(MTELapotronicSuperCapacitor t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
            ItemStack targetStack;
            if (this.check(t, world, x, y, z)) {
                return IStructureElement.PlaceResult.SKIP;
            }
            int glassTier = GTStructureChannels.BOROGLASS.getValue(trigger) + 2;
            if (GTStructureChannels.LSC_CAPACITOR.hasValue(trigger)) {
                int capacitorTier = GTStructureChannels.LSC_CAPACITOR.getValueClamped(trigger, 1, Capacitor.VALUES_BY_TIER.length);
                if (Capacitor.VALUES_BY_TIER[capacitorTier - 1].getMinimalGlassTier() > glassTier) {
                    env.getChatter().accept(new ChatComponentTranslation("kekztech.structure.glass_incompatible", new Object[0]));
                    return IStructureElement.PlaceResult.REJECT;
                }
                targetStack = new ItemStack(LSC_PART_ITEM, 1, Capacitor.VALUES_BY_TIER[capacitorTier - 1].ordinal() + 1);
                if (!env.getSource().takeOne(targetStack, true)) {
                    return IStructureElement.PlaceResult.REJECT;
                }
            } else {
                targetStack = env.getSource().takeOne(s -> s != null && s.field_77994_a >= 0 && s.func_77973_b() == LSC_PART_ITEM && s.func_77960_j() != 0 && glassTier >= Capacitor.VALUES[Math.min(s.func_77960_j(), Capacitor.VALUES.length) - 1].getMinimalGlassTier(), true);
            }
            if (targetStack == null) {
                return IStructureElement.PlaceResult.REJECT;
            }
            return StructureUtility.survivalPlaceBlock((ItemStack)targetStack, (ItemStackPredicate.NBTMode)ItemStackPredicate.NBTMode.EXACT, (NBTTagCompound)targetStack.field_77990_d, (boolean)true, (World)world, (int)x, (int)y, (int)z, (IItemSource)env.getSource(), (EntityPlayer)env.getActor(), (Consumer)env.getChatter());
        }
    }
}

