/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TierEU;
import gregtech.api.enums.ToolDictNames;
import gregtech.api.interfaces.IOreRecipeRegistrator;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import net.minecraft.item.ItemStack;

public class ProcessingPipe
implements IOreRecipeRegistrator {
    public ProcessingPipe() {
        OrePrefixes.pipeHuge.add(this);
        OrePrefixes.pipeLarge.add(this);
        OrePrefixes.pipeMedium.add(this);
        OrePrefixes.pipeSmall.add(this);
        OrePrefixes.pipeTiny.add(this);
        OrePrefixes.pipeRestrictiveHuge.add(this);
        OrePrefixes.pipeRestrictiveLarge.add(this);
        OrePrefixes.pipeRestrictiveMedium.add(this);
        OrePrefixes.pipeRestrictiveSmall.add(this);
        OrePrefixes.pipeRestrictiveTiny.add(this);
        OrePrefixes.pipeQuadruple.add(this);
        OrePrefixes.pipeNonuple.add(this);
    }

    @Override
    public void registerOre(OrePrefixes aPrefix, Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        switch (aPrefix) {
            case pipeHuge: 
            case pipeLarge: 
            case pipeMedium: 
            case pipeSmall: 
            case pipeTiny: {
                if ((long)aMaterial.getProcessingMaterialTierEU() >= TierEU.IV) break;
                GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.pipeTiny, aMaterial, 8L), GTModHandler.RecipeBits.BUFFERED, new Object[]{"PPP", "h w", "PPP", Character.valueOf('P'), OrePrefixes.plate.get(aMaterial)});
                GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.pipeSmall, aMaterial, 6L), GTModHandler.RecipeBits.BUFFERED, new Object[]{"PWP", "P P", "PHP", Character.valueOf('P'), aMaterial == Materials.Wood ? OrePrefixes.plank.get(aMaterial) : OrePrefixes.plate.get(aMaterial), Character.valueOf('H'), aMaterial.contains(SubTag.WOOD) ? ToolDictNames.craftingToolSoftMallet : ToolDictNames.craftingToolHardHammer, Character.valueOf('W'), aMaterial.contains(SubTag.WOOD) ? ToolDictNames.craftingToolSaw : ToolDictNames.craftingToolWrench});
                GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.pipeMedium, aMaterial, 2L), GTModHandler.RecipeBits.BUFFERED, new Object[]{"PPP", "W H", "PPP", Character.valueOf('P'), aMaterial == Materials.Wood ? OrePrefixes.plank.get(aMaterial) : OrePrefixes.plate.get(aMaterial), Character.valueOf('H'), aMaterial.contains(SubTag.WOOD) ? ToolDictNames.craftingToolSoftMallet : ToolDictNames.craftingToolHardHammer, Character.valueOf('W'), aMaterial.contains(SubTag.WOOD) ? ToolDictNames.craftingToolSaw : ToolDictNames.craftingToolWrench});
                GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.pipeLarge, aMaterial, 1L), GTModHandler.RecipeBits.BUFFERED, new Object[]{"PHP", "P P", "PWP", Character.valueOf('P'), aMaterial == Materials.Wood ? OrePrefixes.plank.get(aMaterial) : OrePrefixes.plate.get(aMaterial), Character.valueOf('H'), aMaterial.contains(SubTag.WOOD) ? ToolDictNames.craftingToolSoftMallet : ToolDictNames.craftingToolHardHammer, Character.valueOf('W'), aMaterial.contains(SubTag.WOOD) ? ToolDictNames.craftingToolSaw : ToolDictNames.craftingToolWrench});
                GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.pipeHuge, aMaterial, 1L), GTModHandler.RecipeBits.BUFFERED, new Object[]{"DhD", "D D", "DwD", Character.valueOf('D'), OrePrefixes.plateDouble.get(aMaterial)});
                break;
            }
            case pipeRestrictiveHuge: 
            case pipeRestrictiveLarge: 
            case pipeRestrictiveMedium: 
            case pipeRestrictiveSmall: 
            case pipeRestrictiveTiny: {
                GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.ring, Materials.Steel, aPrefix.mSecondaryMaterial.mAmount / OrePrefixes.ring.mMaterialAmount), GTOreDictUnificator.get(aOreDictName.replaceFirst("Restrictive", ""), null, 1L, false, true)).itemOutputs(GTUtility.copyAmount(1, aStack)).duration((int)(aPrefix.mSecondaryMaterial.mAmount * 400L / OrePrefixes.ring.mMaterialAmount) * 1).eut(4).addTo(RecipeMaps.assemblerRecipes);
                break;
            }
            case pipeQuadruple: {
                if ((long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV) {
                    GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.pipeQuadruple, aMaterial, 1L), GTModHandler.RecipeBits.REVERSIBLE | GTModHandler.RecipeBits.BUFFERED, new Object[]{"MM ", "MM ", "   ", Character.valueOf('M'), GTOreDictUnificator.get(OrePrefixes.pipeMedium, aMaterial, 1L)});
                }
                GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.pipeMedium, aMaterial, 4L), GTUtility.getIntegratedCircuit(9)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.pipeQuadruple, aMaterial, 1L)).duration(60).eut(GTUtility.calculateRecipeEU(aMaterial, 4)).addTo(RecipeMaps.assemblerRecipes);
                break;
            }
            case pipeNonuple: {
                if ((long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV) {
                    GTModHandler.addCraftingRecipe(GTUtility.copyAmount(1, aStack), GTModHandler.RecipeBits.REVERSIBLE | GTModHandler.RecipeBits.BUFFERED, new Object[]{"PPP", "PPP", "PPP", Character.valueOf('P'), GTOreDictUnificator.get(aOreDictName.replaceFirst("Nonuple", "Small"), null, 1L, false, true)});
                }
                GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.pipeSmall, aMaterial, 9L), GTUtility.getIntegratedCircuit(9)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.pipeNonuple, aMaterial, 1L)).duration(60).eut(GTUtility.calculateRecipeEU(aMaterial, 8)).addTo(RecipeMaps.assemblerRecipes);
                break;
            }
        }
    }
}

