/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TCAspects;
import gregtech.api.interfaces.IFoodStat;
import gregtech.api.interfaces.IGT_ItemWithMaterialRenderer;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.IItemBehaviour;
import gregtech.api.interfaces.IItemContainer;
import gregtech.api.items.MetaBaseItem;
import gregtech.api.objects.ItemData;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTConfig;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gregtech.common.render.items.GeneratedMaterialRenderer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import squeek.applecore.api.food.FoodValues;
import squeek.applecore.api.food.IEdible;
import squeek.applecore.api.food.ItemFoodProxy;

@Optional.Interface(iface="squeek.applecore.api.food.IEdible", modid="AppleCore")
public abstract class MetaGeneratedItem
extends MetaBaseItem
implements IGT_ItemWithMaterialRenderer,
IEdible {
    public static final ConcurrentHashMap<String, MetaGeneratedItem> sInstances = new ConcurrentHashMap();
    public final short mOffset;
    public final short mItemAmount;
    public final BitSet mEnabledItems;
    public final BitSet mVisibleItems;
    public final IIcon[][] mIconList;
    public final ConcurrentHashMap<Short, IFoodStat> mFoodStats = new ConcurrentHashMap();
    public final ConcurrentHashMap<Short, Long[]> mElectricStats = new ConcurrentHashMap();
    public final ConcurrentHashMap<Short, Long[]> mFluidContainerStats = new ConcurrentHashMap();
    public final ConcurrentHashMap<Short, Short> mBurnValues = new ConcurrentHashMap();

    public MetaGeneratedItem(String aUnlocalized, short aOffset, short aItemAmount) {
        super(aUnlocalized);
        this.func_77637_a(GregTechAPI.TAB_GREGTECH_MATERIALS);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.mEnabledItems = new BitSet(aItemAmount);
        this.mVisibleItems = new BitSet(aItemAmount);
        this.mOffset = (short)Math.min(32766, aOffset);
        this.mItemAmount = (short)Math.min(aItemAmount, 32766 - this.mOffset);
        this.mIconList = new IIcon[aItemAmount][1];
        sInstances.put(this.func_77658_a(), this);
    }

    public final ItemStack addItem(int aID, String aEnglish, String aToolTip, Object ... aRandomData) {
        if (aToolTip == null) {
            aToolTip = "";
        }
        if (aID >= 0 && aID < this.mItemAmount) {
            ItemStack rStack = new ItemStack((Item)this, 1, this.mOffset + aID);
            if (this.mEnabledItems.get(aID)) {
                throw new IllegalArgumentException(String.format("ID %s is already reserved for %s!", aID, rStack.func_82833_r()));
            }
            this.mEnabledItems.set(aID);
            this.mVisibleItems.set(aID);
            GTLanguageManager.addStringLocalization(this.func_77667_c(rStack) + ".name", aEnglish);
            GTLanguageManager.addStringLocalization(this.func_77667_c(rStack) + ".tooltip", aToolTip);
            ArrayList<TCAspects.TC_AspectStack> tAspects = new ArrayList<TCAspects.TC_AspectStack>();
            for (Object tRandomData : aRandomData) {
                if (!(tRandomData instanceof SubTag)) continue;
                if (tRandomData == SubTag.INVISIBLE) {
                    this.mVisibleItems.set(aID, false);
                    continue;
                }
                if (tRandomData != SubTag.NO_UNIFICATION) continue;
                GTOreDictUnificator.addToBlacklist(rStack);
            }
            for (Object tRandomData : aRandomData) {
                if (tRandomData == null) continue;
                boolean tUseOreDict = true;
                if (tRandomData instanceof IFoodStat) {
                    int tFoodValue;
                    this.setFoodBehavior(this.mOffset + aID, (IFoodStat)tRandomData);
                    if (((IFoodStat)tRandomData).getFoodAction(this, rStack) == EnumAction.eat && (tFoodValue = ((IFoodStat)tRandomData).getFoodLevel(this, rStack, null)) > 0) {
                        GTValues.RA.stdBuilder().itemInputs(rStack, ItemList.IC2_Food_Can_Empty.get(tFoodValue, new Object[0])).itemOutputs(((IFoodStat)tRandomData).isRotten(this, rStack, null) ? ItemList.IC2_Food_Can_Spoiled.get(tFoodValue, new Object[0]) : ItemList.IC2_Food_Can_Filled.get(tFoodValue, new Object[0])).duration(tFoodValue * 5 * 20).eut(1).addTo(RecipeMaps.cannerRecipes);
                    }
                    tUseOreDict = false;
                }
                if (tRandomData instanceof IItemBehaviour) {
                    this.addItemBehavior(this.mOffset + aID, (IItemBehaviour)tRandomData);
                    tUseOreDict = false;
                }
                if (tRandomData instanceof IItemContainer) {
                    ((IItemContainer)tRandomData).set(rStack);
                    tUseOreDict = false;
                }
                if (tRandomData instanceof SubTag) continue;
                if (tRandomData instanceof TCAspects.TC_AspectStack) {
                    ((TCAspects.TC_AspectStack)tRandomData).addToAspectList(tAspects);
                    continue;
                }
                if (tRandomData instanceof ItemData) {
                    if (GTUtility.isStringValid(tRandomData)) {
                        GTOreDictUnificator.registerOre(tRandomData, rStack);
                        continue;
                    }
                    GTOreDictUnificator.addItemData(rStack, (ItemData)tRandomData);
                    continue;
                }
                if (!tUseOreDict) continue;
                GTOreDictUnificator.registerOre(tRandomData, rStack);
            }
            if (GregTechAPI.sThaumcraftCompat != null) {
                GregTechAPI.sThaumcraftCompat.registerThaumcraftAspectsToItem(rStack, tAspects, false);
            }
            return rStack;
        }
        return null;
    }

    public final MetaGeneratedItem setFoodBehavior(int aMetaValue, IFoodStat aFoodBehavior) {
        if (aMetaValue < 0 || aMetaValue >= this.mOffset + this.mEnabledItems.length()) {
            return this;
        }
        if (aFoodBehavior == null) {
            this.mFoodStats.remove((short)aMetaValue);
        } else {
            this.mFoodStats.put((short)aMetaValue, aFoodBehavior);
        }
        return this;
    }

    public final MetaGeneratedItem setBurnValue(int aMetaValue, int aValue) {
        if (aMetaValue < 0 || aMetaValue >= this.mOffset + this.mEnabledItems.length() || aValue < 0) {
            return this;
        }
        if (aValue == 0) {
            this.mBurnValues.remove((short)aMetaValue);
        } else {
            this.mBurnValues.put((short)aMetaValue, (short)(aValue > Short.MAX_VALUE ? Short.MAX_VALUE : (short)aValue));
        }
        return this;
    }

    public final MetaGeneratedItem setElectricStats(int aMetaValue, long aMaxCharge, long aTransferLimit, long aTier, long aSpecialData, boolean aUseAnimations) {
        if (aMetaValue < 0 || aMetaValue >= this.mOffset + this.mEnabledItems.length()) {
            return this;
        }
        if (aMaxCharge == 0L) {
            this.mElectricStats.remove((short)aMetaValue);
        } else {
            this.mElectricStats.put((short)aMetaValue, new Long[]{aMaxCharge, Math.max(0L, aTransferLimit), Math.max(-1L, aTier), aSpecialData});
            if (aMetaValue >= this.mOffset && aUseAnimations) {
                this.mIconList[aMetaValue - this.mOffset] = Arrays.copyOf(this.mIconList[aMetaValue - this.mOffset], Math.max(9, this.mIconList[aMetaValue - this.mOffset].length));
            }
        }
        return this;
    }

    public final MetaGeneratedItem setSubIcons(int metaValue, int length) {
        this.mIconList[metaValue] = Arrays.copyOf(this.mIconList[metaValue], length + 1);
        return this;
    }

    public final MetaGeneratedItem setFluidContainerStats(int aMetaValue, long aCapacity, long aStacksize) {
        if (aMetaValue < 0 || aMetaValue >= this.mOffset + this.mEnabledItems.length()) {
            return this;
        }
        if (aCapacity < 0L) {
            this.mElectricStats.remove((short)aMetaValue);
        } else {
            this.mFluidContainerStats.put((short)aMetaValue, new Long[]{aCapacity, Math.max(1L, aStacksize)});
        }
        return this;
    }

    public boolean useStandardMetaItemRenderer() {
        return true;
    }

    @Override
    public short[] getRGBa(ItemStack aStack) {
        return Materials._NULL.getRGBA();
    }

    public IIconContainer getIconContainer(int aMetaData) {
        return null;
    }

    @Override
    public IIcon getIcon(int aMetaData, int pass) {
        IIconContainer iconContainer = this.getIconContainer(aMetaData);
        return iconContainer != null ? iconContainer.getIcon() : null;
    }

    @Override
    public IIcon getOverlayIcon(int aMetaData, int pass) {
        IIconContainer iconContainer = this.getIconContainer(aMetaData);
        return iconContainer != null ? iconContainer.getOverlayIcon() : null;
    }

    @Override
    public boolean shouldUseCustomRenderer(int aMetaData) {
        return true;
    }

    @Override
    public GeneratedMaterialRenderer getMaterialRenderer(int aMetaData) {
        return null;
    }

    @Override
    public boolean allowMaterialRenderer(int aMetaData) {
        return aMetaData < this.mOffset;
    }

    @Override
    public ItemStack func_77659_a(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        IFoodStat tStat = this.mFoodStats.get((short)this.getDamage(aStack));
        if (tStat != null && aPlayer.func_71043_e(tStat.alwaysEdible(this, aStack, aPlayer))) {
            aPlayer.func_71008_a(aStack, 32);
        }
        return super.func_77659_a(aStack, aWorld, aPlayer);
    }

    public int func_77626_a(ItemStack aStack) {
        return this.mFoodStats.get((short)this.getDamage(aStack)) == null ? 0 : 32;
    }

    public EnumAction func_77661_b(ItemStack aStack) {
        IFoodStat tStat = this.mFoodStats.get((short)this.getDamage(aStack));
        return tStat == null ? EnumAction.none : tStat.getFoodAction(this, aStack);
    }

    public final ItemStack func_77654_b(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        IFoodStat tStat = this.mFoodStats.get((short)this.getDamage(aStack));
        if (tStat != null) {
            if (Mods.AppleCore.isModLoaded()) {
                aPlayer.func_71024_bL().func_151686_a(MetaGeneratedItem.getFoodProxy(this), aStack);
            } else {
                aPlayer.func_71024_bL().func_75122_a(tStat.getFoodLevel(this, aStack, aPlayer), tStat.getSaturation(this, aStack, aPlayer));
            }
            tStat.onEaten(this, aStack, aPlayer);
        }
        return aStack;
    }

    @Optional.Method(modid="AppleCore")
    private static ItemFood getFoodProxy(Object edible) {
        return new ItemFoodProxy((IEdible)edible);
    }

    @Optional.Method(modid="AppleCore")
    public FoodValues getFoodValues(ItemStack aStack) {
        IFoodStat tStat = this.mFoodStats.get((short)this.getDamage(aStack));
        return tStat == null ? null : new FoodValues(tStat.getFoodLevel(this, aStack, null), tStat.getSaturation(this, aStack, null));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item aItem, CreativeTabs aCreativeTab, List<ItemStack> aList) {
        int j = this.mEnabledItems.length();
        for (int i = 0; i < j; ++i) {
            ItemStack tStack;
            if (!this.mVisibleItems.get(i) && (!GTValues.D1 || !this.mEnabledItems.get(i))) continue;
            Long[] tStats = this.mElectricStats.get((short)(this.mOffset + i));
            if (tStats != null && tStats[3] < 0L) {
                tStack = new ItemStack((Item)this, 1, this.mOffset + i);
                this.setCharge(tStack, Math.abs(tStats[0]));
                this.isItemStackUsable(tStack);
                aList.add(tStack);
            }
            if (tStats != null && tStats[3] == -2L) continue;
            tStack = new ItemStack((Item)this, 1, this.mOffset + i);
            this.isItemStackUsable(tStack);
            aList.add(tStack);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public final void func_94581_a(IIconRegister aIconRegister) {
        short j = (short)this.mEnabledItems.length();
        for (short i = 0; i < j; i = (short)(i + 1)) {
            if (!this.mEnabledItems.get(i)) continue;
            for (int k = 1; k < this.mIconList[i].length; k = (int)((byte)(k + 1))) {
                this.mIconList[i][k] = aIconRegister.func_94245_a(Mods.GregTech.getResourcePath(GTConfig.troll ? "troll" : this.func_77658_a() + "/" + i + "/" + k));
            }
            this.mIconList[i][0] = aIconRegister.func_94245_a(Mods.GregTech.getResourcePath(GTConfig.troll ? "troll" : this.func_77658_a() + "/" + i));
        }
    }

    @Override
    public final Long[] getElectricStats(ItemStack aStack) {
        return this.mElectricStats.get((short)aStack.func_77960_j());
    }

    @Override
    public final Long[] getFluidContainerStats(ItemStack aStack) {
        return this.mFluidContainerStats.get((short)aStack.func_77960_j());
    }
}

