/*
 * Decompiled with CFR 0.152.
 */
package bartworks.system.material.werkstoff_loaders.recipe;

import bartworks.system.material.Werkstoff;
import bartworks.system.material.werkstoff_loaders.IWerkstoffRunnable;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.common.items.IDMetaTool01;
import gregtech.common.items.MetaGeneratedTool01;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;

public class ToolLoader
implements IWerkstoffRunnable {
    public static final short SCREWDRIVER_MV = 152;
    public static final short SCREWDRIVER_HV = 154;
    public static final short SOLDERING_IRON_MV = 162;
    public static final short SOLDERING_IRON_HV = 164;

    @Override
    public void run(Werkstoff werkstoff) {
        if (werkstoff.getBridgeMaterial().mDurability == 0) {
            return;
        }
        if (werkstoff.hasItemType(OrePrefixes.gem)) {
            if (!werkstoff.getGenerationFeatures().isExtension()) {
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.HARDHAMMER.ID, 1, werkstoff.getBridgeMaterial(), werkstoff.getBridgeMaterial().mHandleMaterial, null), GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"XX ", "XXS", "XX ", Character.valueOf('X'), OrePrefixes.gem.get(werkstoff.getBridgeMaterial()), Character.valueOf('S'), OrePrefixes.stick.get(werkstoff.getBridgeMaterial().mHandleMaterial)});
            }
            GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.toolHeadSaw, werkstoff.getBridgeMaterial(), 1L), GTModHandler.RecipeBits.BITS_STD, new Object[]{"GGf", Character.valueOf('G'), OrePrefixes.gem.get(werkstoff.getBridgeMaterial())});
        }
        if (!werkstoff.hasItemType(OrePrefixes.plate)) {
            return;
        }
        if (!werkstoff.getGenerationFeatures().isExtension()) {
            GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.SCREWDRIVER.ID, 1, werkstoff.getBridgeMaterial(), werkstoff.getBridgeMaterial().mHandleMaterial, null), GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{" fS", " Sh", "W  ", Character.valueOf('S'), OrePrefixes.stick.get(werkstoff.getBridgeMaterial()), Character.valueOf('W'), OrePrefixes.stick.get(werkstoff.getBridgeMaterial().mHandleMaterial)});
            GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.toolHeadWrench, werkstoff.getBridgeMaterial(), 1L), GTModHandler.RecipeBits.BITS_STD, new Object[]{"hXW", "XRX", "WXd", Character.valueOf('X'), OrePrefixes.plate.get(werkstoff.getBridgeMaterial()), Character.valueOf('S'), OrePrefixes.plate.get(werkstoff.getBridgeMaterial().mHandleMaterial), Character.valueOf('R'), OrePrefixes.ring.get(werkstoff.getBridgeMaterial().mHandleMaterial), Character.valueOf('W'), OrePrefixes.screw.get(werkstoff.getBridgeMaterial().mHandleMaterial)});
            GTModHandler.addShapelessCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.HARDHAMMER.ID, 1, werkstoff.getBridgeMaterial(), werkstoff.getBridgeMaterial().mHandleMaterial, null), GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{OrePrefixes.toolHeadHammer.get(werkstoff.getBridgeMaterial()), OrePrefixes.stick.get(werkstoff.getBridgeMaterial().mHandleMaterial)});
            GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.FILE.ID, 1, werkstoff.getBridgeMaterial(), werkstoff.getBridgeMaterial().mHandleMaterial, null), GTModHandler.RecipeBits.MIRRORED | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"P", "P", "S", Character.valueOf('P'), OrePrefixes.plate.get(werkstoff.getBridgeMaterial()), Character.valueOf('S'), OrePrefixes.stick.get(werkstoff.getBridgeMaterial().mHandleMaterial)});
            GTModHandler.addShapelessCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.SAW.ID, 1, werkstoff.getBridgeMaterial(), werkstoff.getBridgeMaterial().mHandleMaterial, null), new Object[]{OrePrefixes.toolHeadSaw.get(werkstoff.getBridgeMaterial()), OrePrefixes.stick.get(werkstoff.getBridgeMaterial().mHandleMaterial)});
            GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.SOLDERING_IRON_LV.ID, 1, werkstoff.getBridgeMaterial(), Materials.Rubber, new long[]{100000L, 32L, 1L, -1L}), GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"LBf", "Sd ", "P  ", Character.valueOf('B'), OrePrefixes.bolt.get(werkstoff.getBridgeMaterial()), Character.valueOf('P'), OrePrefixes.plate.get(Materials.AnyRubber), Character.valueOf('S'), OrePrefixes.stick.get(werkstoff.getBridgeMaterial().mHandleMaterial), Character.valueOf('L'), ItemList.Battery_RE_LV_Lithium.get(1L, new Object[0])});
            GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(162, 1, werkstoff.getBridgeMaterial(), Materials.Rubber, new long[]{400000L, 128L, 2L, -1L}), GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"LBf", "Sd ", "P  ", Character.valueOf('B'), OrePrefixes.bolt.get(werkstoff.getBridgeMaterial()), Character.valueOf('P'), OrePrefixes.plate.get(Materials.AnyRubber), Character.valueOf('S'), OrePrefixes.stick.get(werkstoff.getBridgeMaterial().mHandleMaterial), Character.valueOf('L'), ItemList.Battery_RE_MV_Lithium.get(1L, new Object[0])});
            GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(164, 1, werkstoff.getBridgeMaterial(), Materials.StyreneButadieneRubber, new long[]{1600000L, 512L, 3L, -1L}), GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"LBf", "Sd ", "P  ", Character.valueOf('B'), OrePrefixes.bolt.get(werkstoff.getBridgeMaterial()), Character.valueOf('P'), OrePrefixes.plate.get(Materials.StyreneButadieneRubber), Character.valueOf('S'), OrePrefixes.stick.get(werkstoff.getBridgeMaterial().mHandleMaterial), Character.valueOf('L'), ItemList.Battery_RE_HV_Lithium.get(1L, new Object[0])});
            if (!werkstoff.hasItemType(OrePrefixes.gem)) {
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.HARDHAMMER.ID, 1, werkstoff.getBridgeMaterial(), werkstoff.getBridgeMaterial().mHandleMaterial, null), GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"XX ", "XXS", "XX ", Character.valueOf('X'), OrePrefixes.ingot.get(werkstoff.getBridgeMaterial()), Character.valueOf('S'), OrePrefixes.stick.get(werkstoff.getBridgeMaterial().mHandleMaterial)});
            }
        }
        GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.PLUNGER.ID, 1, werkstoff.getBridgeMaterial(), werkstoff.getBridgeMaterial(), null), GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"xRR", " SR", "S f", Character.valueOf('S'), OrePrefixes.stick.get(werkstoff.getBridgeMaterial()), Character.valueOf('R'), OrePrefixes.plate.get(Materials.AnyRubber)});
        GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.WRENCH.ID, 1, werkstoff.getBridgeMaterial(), werkstoff.getBridgeMaterial(), null), GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"IhI", "III", " I ", Character.valueOf('I'), OrePrefixes.ingot.get(werkstoff.getBridgeMaterial())});
        GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.CROWBAR.ID, 1, werkstoff.getBridgeMaterial(), werkstoff.getBridgeMaterial(), null), GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"hDS", "DSD", "SDf", Character.valueOf('S'), OrePrefixes.stick.get(werkstoff.getBridgeMaterial()), Character.valueOf('D'), Dyes.dyeBlue});
        GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.WIRECUTTER.ID, 1, werkstoff.getBridgeMaterial(), werkstoff.getBridgeMaterial(), null), GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"PfP", "hPd", "STS", Character.valueOf('S'), OrePrefixes.stick.get(werkstoff.getBridgeMaterial()), Character.valueOf('P'), OrePrefixes.plate.get(werkstoff.getBridgeMaterial()), Character.valueOf('T'), OrePrefixes.screw.get(werkstoff.getBridgeMaterial())});
        GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.SCOOP.ID, 1, werkstoff.getBridgeMaterial(), werkstoff.getBridgeMaterial(), null), GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SWS", "SSS", "xSh", Character.valueOf('S'), OrePrefixes.stick.get(werkstoff.getBridgeMaterial()), Character.valueOf('W'), new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE)});
        GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.BRANCHCUTTER.ID, 1, werkstoff.getBridgeMaterial(), werkstoff.getBridgeMaterial(), null), GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"PfP", "PdP", "STS", Character.valueOf('S'), OrePrefixes.stick.get(werkstoff.getBridgeMaterial()), Character.valueOf('P'), OrePrefixes.plate.get(werkstoff.getBridgeMaterial()), Character.valueOf('T'), OrePrefixes.screw.get(werkstoff.getBridgeMaterial())});
        GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.KNIFE.ID, 1, werkstoff.getBridgeMaterial(), werkstoff.getBridgeMaterial(), null), GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"fPh", " S ", Character.valueOf('S'), OrePrefixes.stick.get(werkstoff.getBridgeMaterial()), Character.valueOf('P'), OrePrefixes.plate.get(werkstoff.getBridgeMaterial())});
        GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.BUTCHERYKNIFE.ID, 1, werkstoff.getBridgeMaterial(), werkstoff.getBridgeMaterial(), null), GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"PPf", "PP ", "Sh ", Character.valueOf('S'), OrePrefixes.stick.get(werkstoff.getBridgeMaterial()), Character.valueOf('P'), OrePrefixes.plate.get(werkstoff.getBridgeMaterial())});
        GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.WRENCH_LV.ID, 1, werkstoff.getBridgeMaterial(), Materials.Steel, new long[]{100000L, 32L, 1L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), OrePrefixes.toolHeadWrench.get(werkstoff.getBridgeMaterial()), Character.valueOf('M'), ItemList.Electric_Motor_LV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Steel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Steel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Steel), Character.valueOf('B'), ItemList.Battery_RE_LV_Lithium.get(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.WRENCH_LV.ID, 1, werkstoff.getBridgeMaterial(), Materials.Steel, new long[]{75000L, 32L, 1L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), OrePrefixes.toolHeadWrench.get(werkstoff.getBridgeMaterial()), Character.valueOf('M'), ItemList.Electric_Motor_LV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Steel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Steel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Steel), Character.valueOf('B'), ItemList.Battery_RE_LV_Cadmium.get(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.WRENCH_LV.ID, 1, werkstoff.getBridgeMaterial(), Materials.Steel, new long[]{50000L, 32L, 1L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), OrePrefixes.toolHeadWrench.get(werkstoff.getBridgeMaterial()), Character.valueOf('M'), ItemList.Electric_Motor_LV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Steel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Steel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Steel), Character.valueOf('B'), ItemList.Battery_RE_LV_Sodium.get(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.WRENCH_MV.ID, 1, werkstoff.getBridgeMaterial(), Materials.Aluminium, new long[]{400000L, 128L, 2L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), OrePrefixes.toolHeadWrench.get(werkstoff.getBridgeMaterial()), Character.valueOf('M'), ItemList.Electric_Motor_MV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Aluminium), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Aluminium), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Aluminium), Character.valueOf('B'), ItemList.Battery_RE_MV_Lithium.get(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.WRENCH_MV.ID, 1, werkstoff.getBridgeMaterial(), Materials.Aluminium, new long[]{300000L, 128L, 2L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), OrePrefixes.toolHeadWrench.get(werkstoff.getBridgeMaterial()), Character.valueOf('M'), ItemList.Electric_Motor_MV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Aluminium), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Aluminium), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Aluminium), Character.valueOf('B'), ItemList.Battery_RE_MV_Cadmium.get(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.WRENCH_MV.ID, 1, werkstoff.getBridgeMaterial(), Materials.Aluminium, new long[]{200000L, 128L, 2L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), OrePrefixes.toolHeadWrench.get(werkstoff.getBridgeMaterial()), Character.valueOf('M'), ItemList.Electric_Motor_MV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Aluminium), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Aluminium), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Aluminium), Character.valueOf('B'), ItemList.Battery_RE_MV_Sodium.get(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.WRENCH_HV.ID, 1, werkstoff.getBridgeMaterial(), Materials.StainlessSteel, new long[]{1600000L, 512L, 3L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), OrePrefixes.toolHeadWrench.get(werkstoff.getBridgeMaterial()), Character.valueOf('M'), ItemList.Electric_Motor_HV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.StainlessSteel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.StainlessSteel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.StainlessSteel), Character.valueOf('B'), ItemList.Battery_RE_HV_Lithium.get(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.WRENCH_HV.ID, 1, werkstoff.getBridgeMaterial(), Materials.StainlessSteel, new long[]{1200000L, 512L, 3L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), OrePrefixes.toolHeadWrench.get(werkstoff.getBridgeMaterial()), Character.valueOf('M'), ItemList.Electric_Motor_HV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.StainlessSteel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.StainlessSteel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.StainlessSteel), Character.valueOf('B'), ItemList.Battery_RE_HV_Cadmium.get(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.WRENCH_HV.ID, 1, werkstoff.getBridgeMaterial(), Materials.StainlessSteel, new long[]{800000L, 512L, 3L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), OrePrefixes.toolHeadWrench.get(werkstoff.getBridgeMaterial()), Character.valueOf('M'), ItemList.Electric_Motor_HV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.StainlessSteel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.StainlessSteel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.StainlessSteel), Character.valueOf('B'), ItemList.Battery_RE_HV_Sodium.get(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.SCREWDRIVER_LV.ID, 1, werkstoff.getBridgeMaterial(), Materials.Steel, new long[]{100000L, 32L, 1L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"PdX", "MGS", "GBP", Character.valueOf('X'), OrePrefixes.stickLong.get(werkstoff.getBridgeMaterial()), Character.valueOf('M'), ItemList.Electric_Motor_LV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Steel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Steel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Steel), Character.valueOf('B'), ItemList.Battery_RE_LV_Lithium.get(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.SCREWDRIVER_LV.ID, 1, werkstoff.getBridgeMaterial(), Materials.Steel, new long[]{75000L, 32L, 1L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"PdX", "MGS", "GBP", Character.valueOf('X'), OrePrefixes.stickLong.get(werkstoff.getBridgeMaterial()), Character.valueOf('M'), ItemList.Electric_Motor_LV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Steel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Steel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Steel), Character.valueOf('B'), ItemList.Battery_RE_LV_Cadmium.get(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.SCREWDRIVER_LV.ID, 1, werkstoff.getBridgeMaterial(), Materials.Steel, new long[]{50000L, 32L, 1L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"PdX", "MGS", "GBP", Character.valueOf('X'), OrePrefixes.stickLong.get(werkstoff.getBridgeMaterial()), Character.valueOf('M'), ItemList.Electric_Motor_LV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Steel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Steel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Steel), Character.valueOf('B'), ItemList.Battery_RE_LV_Sodium.get(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.toolHeadHammer, werkstoff.getBridgeMaterial(), 1L), GTModHandler.RecipeBits.BITS_STD, new Object[]{"II ", "IIh", "II ", Character.valueOf('P'), OrePrefixes.plate.get(werkstoff.getBridgeMaterial()), Character.valueOf('I'), OrePrefixes.ingot.get(werkstoff.getBridgeMaterial())});
        if (werkstoff.hasItemType(OrePrefixes.plateDouble) && werkstoff.hasItemType(OrePrefixes.cellMolten)) {
            GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.turbineBlade, werkstoff.getBridgeMaterial(), 1L), GTModHandler.RecipeBits.BITS_STD, new Object[]{"fPd", "SPS", " P ", Character.valueOf('P'), OrePrefixes.plateDouble.get(werkstoff.getBridgeMaterial()), Character.valueOf('S'), OrePrefixes.screw.get(werkstoff.getBridgeMaterial())});
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.ingot, 6), ItemList.Shape_Extruder_Turbine_Blade.get(0L, new Object[0])).itemOutputs(werkstoff.get(OrePrefixes.turbineBlade, 1)).duration((int)werkstoff.getStats().getMass() / 2 * 20).eut(TierEU.RECIPE_MV).addTo(RecipeMaps.extruderRecipes);
            GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Turbine_Blade.get(0L, new Object[0])).itemOutputs(werkstoff.get(OrePrefixes.turbineBlade, 1)).fluidInputs(werkstoff.getMolten(864)).duration((int)werkstoff.getStats().getMass() * 20).eut(TierEU.RECIPE_MV).addTo(RecipeMaps.fluidSolidifierRecipes);
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.plateDouble, 3), werkstoff.get(OrePrefixes.screw, 2)).itemOutputs(werkstoff.get(OrePrefixes.turbineBlade, 1)).duration(werkstoff.getStats().getMass() / 4L * 20L).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.formingPressRecipes);
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.turbineBlade, 4), GTOreDictUnificator.get(OrePrefixes.stickLong, Materials.Magnalium, 1L)).itemOutputs(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.TURBINE_SMALL.ID, 1, werkstoff.getBridgeMaterial(), Materials.Magnalium, null)).duration(160).eut(100).addTo(RecipeMaps.assemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.turbineBlade, 8), GTOreDictUnificator.get(OrePrefixes.stickLong, Materials.Titanium, 1L)).itemOutputs(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.TURBINE.ID, 1, werkstoff.getBridgeMaterial(), Materials.Titanium, null)).duration(320).eut(400).addTo(RecipeMaps.assemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.turbineBlade, 12), GTOreDictUnificator.get(OrePrefixes.stickLong, Materials.TungstenSteel, 1L)).itemOutputs(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.TURBINE_LARGE.ID, 1, werkstoff.getBridgeMaterial(), Materials.TungstenSteel, null)).duration(640).eut(1600).addTo(RecipeMaps.assemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.turbineBlade, 16), GTOreDictUnificator.get(OrePrefixes.stickLong, Materials.Americium, 1L)).itemOutputs(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.TURBINE_HUGE.ID, 1, werkstoff.getBridgeMaterial(), Materials.Americium, null)).duration(1280).eut(6400).addTo(RecipeMaps.assemblerRecipes);
        }
        if (!werkstoff.hasItemType(OrePrefixes.gem)) {
            GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.toolHeadSaw, werkstoff.getBridgeMaterial(), 1L), GTModHandler.RecipeBits.BITS_STD, new Object[]{"PP ", "fh ", Character.valueOf('P'), OrePrefixes.plate.get(werkstoff.getBridgeMaterial()), Character.valueOf('I'), OrePrefixes.ingot.get(werkstoff.getBridgeMaterial())});
        }
        GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(152, 1, werkstoff.getBridgeMaterial(), Materials.Aluminium, new long[]{400000L, 128L, 2L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"PdX", "MGS", "GBP", Character.valueOf('X'), OrePrefixes.stickLong.get(werkstoff.getBridgeMaterial()), Character.valueOf('M'), ItemList.Electric_Motor_MV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Aluminium), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Aluminium), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Aluminium), Character.valueOf('B'), ItemList.Battery_RE_MV_Lithium.get(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(152, 1, werkstoff.getBridgeMaterial(), Materials.Aluminium, new long[]{300000L, 128L, 2L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"PdX", "MGS", "GBP", Character.valueOf('X'), OrePrefixes.stickLong.get(werkstoff.getBridgeMaterial()), Character.valueOf('M'), ItemList.Electric_Motor_MV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Aluminium), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Aluminium), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Aluminium), Character.valueOf('B'), ItemList.Battery_RE_MV_Cadmium.get(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(152, 1, werkstoff.getBridgeMaterial(), Materials.Aluminium, new long[]{200000L, 128L, 2L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"PdX", "MGS", "GBP", Character.valueOf('X'), OrePrefixes.stickLong.get(werkstoff.getBridgeMaterial()), Character.valueOf('M'), ItemList.Electric_Motor_MV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Aluminium), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Aluminium), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Aluminium), Character.valueOf('B'), ItemList.Battery_RE_MV_Sodium.get(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(154, 1, werkstoff.getBridgeMaterial(), Materials.StainlessSteel, new long[]{1600000L, 512L, 3L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"PdX", "MGS", "GBP", Character.valueOf('X'), OrePrefixes.stickLong.get(werkstoff.getBridgeMaterial()), Character.valueOf('M'), ItemList.Electric_Motor_HV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.StainlessSteel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.StainlessSteel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.StainlessSteel), Character.valueOf('B'), ItemList.Battery_RE_HV_Lithium.get(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(154, 1, werkstoff.getBridgeMaterial(), Materials.StainlessSteel, new long[]{1200000L, 512L, 3L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"PdX", "MGS", "GBP", Character.valueOf('X'), OrePrefixes.stickLong.get(werkstoff.getBridgeMaterial()), Character.valueOf('M'), ItemList.Electric_Motor_HV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.StainlessSteel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.StainlessSteel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.StainlessSteel), Character.valueOf('B'), ItemList.Battery_RE_HV_Cadmium.get(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(154, 1, werkstoff.getBridgeMaterial(), Materials.StainlessSteel, new long[]{800000L, 512L, 3L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"PdX", "MGS", "GBP", Character.valueOf('X'), OrePrefixes.stickLong.get(werkstoff.getBridgeMaterial()), Character.valueOf('M'), ItemList.Electric_Motor_HV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.StainlessSteel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.StainlessSteel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.StainlessSteel), Character.valueOf('B'), ItemList.Battery_RE_HV_Sodium.get(1L, new Object[0])});
    }
}

