/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.decor;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockMushroom;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.crafting.IInfusionStabiliser;
import vazkii.botania.api.item.IHornHarvestable;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.client.core.helper.IconHelper;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.BotaniaCreativeTab;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.integration.coloredlights.ColoredLightHelper;
import vazkii.botania.common.item.block.ItemBlockWithMetadataAndName;
import vazkii.botania.common.lexicon.LexiconData;

@Optional.Interface(modid="Thaumcraft", iface="thaumcraft.api.crafting.IInfusionStabiliser", striprefs=true)
public class BlockModMushroom
extends BlockMushroom
implements IInfusionStabiliser,
IHornHarvestable,
ILexiconable {
    public static IIcon[] icons;
    public int originalLight;

    public BlockModMushroom() {
        this.func_149663_c("mushroom");
        this.func_149715_a(0.2f);
        this.func_149711_c(0.0f);
        this.func_149672_a(field_149779_h);
        this.func_149676_a(0.3f, 0.0f, 0.3f, 0.8f, 1.0f, 0.8f);
        this.func_149675_a(false);
        this.func_149647_a(BotaniaCreativeTab.INSTANCE);
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        if (y >= 0 && y < 256) {
            Block block = world.func_147439_a(x, y - 1, z);
            return block == Blocks.field_150391_bh || block == Blocks.field_150346_d && world.func_72805_g(x, y - 1, z) == 2 || block.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this);
        }
        return false;
    }

    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < 16; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public Block func_149663_c(String name) {
        GameRegistry.registerBlock((Block)this, ItemBlockWithMetadataAndName.class, (String)name);
        return super.func_149663_c(name);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        icons = new IIcon[16];
        for (int i = 0; i < icons.length; ++i) {
            BlockModMushroom.icons[i] = IconHelper.forBlock(register, (Block)this, i);
        }
    }

    public Block func_149715_a(float value) {
        this.originalLight = (int)(value * 15.0f);
        return super.func_149715_a(value);
    }

    @Optional.Method(modid="easycoloredlights")
    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return ColoredLightHelper.getPackedColor(world.func_72805_g(x, y, z), this.originalLight);
    }

    public IIcon func_149691_a(int side, int meta) {
        return icons[meta];
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public void func_149734_b(World world, int x, int y, int z, Random random) {
        int meta = world.func_72805_g(x, y, z);
        float[] color = EntitySheep.field_70898_d[meta];
        if (random.nextDouble() < ConfigHandler.flowerParticleFrequency * 0.25) {
            Botania.proxy.sparkleFX(world, (double)x + 0.3 + (double)random.nextFloat() * 0.5, (double)y + 0.5 + (double)random.nextFloat() * 0.5, (double)z + 0.3 + (double)random.nextFloat() * 0.5, color[0], color[1], color[2], random.nextFloat(), 5);
        }
    }

    public boolean canStabaliseInfusion(World world, int x, int y, int z) {
        return ConfigHandler.enableThaumcraftStablizers;
    }

    @Override
    public LexiconEntry getEntry(World world, int x, int y, int z, EntityPlayer player, ItemStack lexicon) {
        return LexiconData.mushrooms;
    }

    @Override
    public boolean canHornHarvest(World world, int x, int y, int z, ItemStack stack, IHornHarvestable.EnumHornType hornType) {
        return false;
    }

    @Override
    public boolean hasSpecialHornHarvest(World world, int x, int y, int z, ItemStack stack, IHornHarvestable.EnumHornType hornType) {
        return false;
    }

    @Override
    public void harvestByHorn(World world, int x, int y, int z, ItemStack stack, IHornHarvestable.EnumHornType hornType) {
    }
}

